/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.io.RegexFileFilter;

public class RecurciveSearchFile
extends File
implements Serializable {
    private static final long serialVersionUID = 4549749658684567046L;
    public static final int SEARCH_TYPE_FILE = 0;
    public static final int SEARCH_TYPE_DIR = 1;
    public static final int SEARCH_TYPE_ALL = 2;
    private static final String REGEX_ESCAPE_ESCAPE = Character.toString('\u0000');

    public RecurciveSearchFile(String pathname) {
        super(pathname);
    }

    public RecurciveSearchFile(File file) {
        super(file.getPath());
    }

    public RecurciveSearchFile(File parent, String child) {
        super(parent, child);
    }

    public RecurciveSearchFile(String parent, String child) {
        super(parent, child);
    }

    public String[] listAllTree() {
        return this.listAllTree(0);
    }

    public String[] listAllTree(int searchType) {
        if (!this.isDirectory()) {
            return null;
        }
        ArrayList<RecurciveSearchFile> dirList = new ArrayList<RecurciveSearchFile>();
        dirList.add(this);
        List fileList = this.recurciveSerach(dirList, searchType);
        String[] ret = new String[fileList.size()];
        for (int cnt = 0; cnt < ret.length; ++cnt) {
            File tmp = (File)fileList.get(cnt);
            ret[cnt] = tmp.getAbsolutePath();
        }
        return ret;
    }

    public String[] listAllTree(FilenameFilter filter) {
        return this.listAllTree(filter, 0);
    }

    public String[] listAllTree(FilenameFilter filter, int searchType) {
        if (!this.isDirectory()) {
            return null;
        }
        FilenameFilter[] filters = new FilenameFilter[]{filter};
        return this.listAllTree(filters, searchType);
    }

    public String[] listAllTree(FilenameFilter[] filter) {
        return this.listAllTree(filter, 0);
    }

    public String[] listAllTree(FilenameFilter[] filter, int searchType) {
        if (!this.isDirectory()) {
            return null;
        }
        ArrayList<RecurciveSearchFile> dirList = new ArrayList<RecurciveSearchFile>();
        dirList.add(this);
        List fileList = this.filteringRecurciveSerach(dirList, filter, searchType);
        String[] ret = new String[fileList.size()];
        for (int cnt = 0; cnt < ret.length; ++cnt) {
            File tmp = (File)fileList.get(cnt);
            ret[cnt] = tmp.getAbsolutePath();
        }
        return ret;
    }

    public File[] listAllTreeFiles() {
        return this.listAllTreeFiles(0);
    }

    public File[] listAllTreeFiles(int searchType) {
        if (!this.isDirectory()) {
            return null;
        }
        ArrayList<RecurciveSearchFile> dirList = new ArrayList<RecurciveSearchFile>();
        dirList.add(this);
        List fileList = this.recurciveSerach(dirList, searchType);
        File[] ret = new File[fileList.size()];
        for (int cnt = 0; cnt < ret.length; ++cnt) {
            ret[cnt] = (File)fileList.get(cnt);
        }
        return ret;
    }

    public File[] listAllTreeFiles(FilenameFilter filter) {
        return this.listAllTreeFiles(filter, 0);
    }

    public File[] listAllTreeFiles(FilenameFilter filter, int searchType) {
        if (!this.isDirectory()) {
            return null;
        }
        ArrayList<RecurciveSearchFile> dirList = new ArrayList<RecurciveSearchFile>();
        dirList.add(this);
        FilenameFilter[] filters = new FilenameFilter[]{filter};
        List fileList = this.filteringRecurciveSerach(dirList, filters, searchType);
        File[] ret = new File[fileList.size()];
        for (int cnt = 0; cnt < ret.length; ++cnt) {
            ret[cnt] = (File)fileList.get(cnt);
        }
        return ret;
    }

    public File[] listAllTreeFiles(FilenameFilter[] filter) {
        return this.listAllTreeFiles(filter, 0);
    }

    public File[] listAllTreeFiles(FilenameFilter[] filter, int searchType) {
        if (!this.isDirectory()) {
            return null;
        }
        ArrayList<RecurciveSearchFile> dirList = new ArrayList<RecurciveSearchFile>();
        dirList.add(this);
        List fileList = this.filteringRecurciveSerach(dirList, filter, searchType);
        File[] ret = new File[fileList.size()];
        for (int cnt = 0; cnt < ret.length; ++cnt) {
            ret[cnt] = (File)fileList.get(cnt);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    protected List recurciveSerach(List dirList, int searchType) {
        fileList = new ArrayList<File>();
        while (dirList.size() > 0) {
            dir = (File)dirList.remove(0);
            list = dir.listFiles();
            if (list == null) continue;
            block5: for (cnt = 0; cnt < list.length; ++cnt) {
                tmp = list[cnt];
                isDir = tmp.isDirectory();
                isFile = tmp.isFile();
                if (!isDir && !isFile) continue;
                if (isDir) {
                    dirList.add(tmp);
                }
                switch (searchType) {
                    case 0: {
                        if (isDir) {
                            continue block5;
                        }
                        ** GOTO lbl21
                    }
                    case 1: {
                        if (isFile) continue block5;
                    }
lbl21:
                    // 3 sources

                    default: {
                        fileList.add(tmp);
                    }
                }
            }
        }
        return fileList;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List filteringRecurciveSerach(List dirList, FilenameFilter[] filter, int searchType) {
        ArrayList<File> fileList = new ArrayList<File>();
        block4: while (dirList.size() > 0) {
            File dir = (File)dirList.remove(0);
            File[] list = dir.listFiles();
            int cnt = 0;
            while (true) {
                block10: {
                    if (cnt >= list.length) continue block4;
                    File tmp = list[cnt];
                    boolean isDir = tmp.isDirectory();
                    boolean isFile = tmp.isFile();
                    if (!isDir && !isFile) break block10;
                    if (isDir) {
                        dirList.add(tmp);
                    }
                    switch (searchType) {
                        case 0: {
                            if (!isDir) break;
                            break block10;
                        }
                        case 1: {
                            if (isFile) break block10;
                        }
                    }
                    boolean check = true;
                    for (int fcnt = 0; fcnt < filter.length; ++fcnt) {
                        if (filter[fcnt].accept(tmp.getParentFile(), tmp.getName())) continue;
                        check = false;
                        break;
                    }
                    if (check) {
                        fileList.add(tmp);
                    }
                }
                ++cnt;
            }
            break;
        }
        return fileList;
    }

    public String[] listAllTree(String regexPath) {
        return this.listAllTree(regexPath, 0);
    }

    public String[] listAllTree(String regexPath, int searchType) {
        File[] files = this.listAllTreeFiles(regexPath, searchType);
        String[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getAbsolutePath();
        }
        return result;
    }

    public File[] listAllTreeFiles(String regexPath) {
        return this.listAllTreeFiles(regexPath, 0);
    }

    public File[] listAllTreeFiles(String regexPath, int searchType) {
        regexPath = regexPath.replaceAll("\\\\\\\\", REGEX_ESCAPE_ESCAPE);
        List result = this.filteringRecurciveSerachByRegEx(this.getPath().length() == 0 ? new File(regexPath) : new File(this, regexPath), searchType, new ArrayList());
        return result.toArray(new File[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List filteringRecurciveSerachByRegEx(File file, int searchType, List result) {
        if (file.exists()) {
            switch (searchType) {
                case 0: {
                    if (!file.isDirectory()) break;
                    return result;
                }
                case 1: {
                    if (!file.isFile()) break;
                    return result;
                }
            }
            result.add(file);
            return result;
        }
        ArrayList<String> pathList = new ArrayList<String>();
        File f = file;
        String name = null;
        do {
            name = f.getName();
            f = f.getParentFile();
            pathList.add(0, name.length() == 0 ? "/" : name);
        } while (f != null);
        File allDir = null;
        int imax = pathList.size();
        for (int i = 0; i < imax; ++i) {
            String path;
            int j;
            File[] dirs;
            block24: {
                int j2;
                File[] files;
                block23: {
                    int j3;
                    File rootDir;
                    block22: {
                        name = (String)pathList.get(i);
                        f = new File(f, name);
                        if ("**".equals(name)) {
                            if (allDir == null && (allDir = f.getParentFile()) == null) {
                                allDir = new File(".");
                            }
                            if (i != imax - 1) continue;
                            name = ".*";
                        }
                        if (allDir != null) {
                            rootDir = new RecurciveSearchFile(allDir.getPath());
                            if (i == imax - 1) {
                                files = ((RecurciveSearchFile)rootDir).listAllTreeFiles(new RegexFileFilter(name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")), searchType);
                                if (files == null) continue;
                                for (j2 = 0; j2 < files.length; ++j2) {
                                    result.add(files[j2]);
                                }
                                continue;
                            }
                            dirs = ((RecurciveSearchFile)rootDir).listAllTreeFiles(new RegexFileFilter(name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")), 1);
                            if (dirs == null) return result;
                            StringBuffer buf = new StringBuffer();
                            for (j3 = i + 1; j3 < imax; ++j3) {
                                buf.append((String)pathList.get(j3));
                                if (j3 == imax - 1) continue;
                                buf.append('/');
                            }
                            String path2 = buf.toString();
                            for (j = 0; j < dirs.length; ++j) {
                                dirs[j] = new File(dirs[j], path2);
                                result = this.filteringRecurciveSerachByRegEx(dirs[j], searchType, result);
                            }
                            return result;
                        }
                        if (f.exists()) continue;
                        rootDir = f.getParentFile();
                        if (rootDir == null) {
                            rootDir = new File(".");
                        }
                        if (i != imax - 1) break block22;
                        files = rootDir.listFiles(new RegexFileFilter(name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")));
                        if (files == null) continue;
                        break block23;
                    }
                    dirs = rootDir.listFiles(new RegexFileFilter(name.replaceAll(REGEX_ESCAPE_ESCAPE, "\\\\")));
                    if (dirs == null) return result;
                    StringBuffer buf = new StringBuffer();
                    for (j3 = i + 1; j3 < imax; ++j3) {
                        buf.append((String)pathList.get(j3));
                        if (j3 == imax - 1) continue;
                        buf.append('/');
                    }
                    path = buf.toString();
                    break block24;
                }
                block14: for (j2 = 0; j2 < files.length; ++j2) {
                    boolean isDir = files[j2].isDirectory();
                    boolean isFile = files[j2].isFile();
                    if (!isDir && !isFile) continue;
                    switch (searchType) {
                        case 0: {
                            if (!isDir) break;
                            continue block14;
                        }
                        case 1: {
                            if (isFile) continue block14;
                        }
                    }
                    result.add(files[j2]);
                }
                continue;
            }
            for (j = 0; j < dirs.length; ++j) {
                if (!dirs[j].isDirectory()) continue;
                dirs[j] = new File(dirs[j], path);
                result = this.filteringRecurciveSerachByRegEx(dirs[j], searchType, result);
            }
            return result;
        }
        return result;
    }

    public boolean deleteAllTree() {
        return RecurciveSearchFile.deleteAllTree(this);
    }

    public boolean deleteAllTree(boolean containsOwn) {
        return RecurciveSearchFile.deleteAllTree(this, containsOwn);
    }

    public static boolean deleteAllTree(File file) {
        return RecurciveSearchFile.deleteAllTree(file, true);
    }

    public static boolean deleteAllTree(File file, boolean containsOwn) {
        if (!file.exists()) {
            return true;
        }
        boolean result = true;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                result &= RecurciveSearchFile.deleteAllTree(files[i]);
            }
            if (containsOwn) {
                result &= file.delete();
            }
        } else if (file.isFile() && containsOwn) {
            result &= file.delete();
        }
        return result;
    }

    public boolean copyAllTree(File file) throws IOException {
        return RecurciveSearchFile.copyAllTree(this, file, null);
    }

    public boolean copyAllTree(File file, FilenameFilter filter) throws IOException {
        return RecurciveSearchFile.copyAllTree(this, file, filter);
    }

    public static boolean copyAllTree(File fromFile, File toFile) throws IOException {
        return RecurciveSearchFile.copyAllTree(fromFile, toFile, null);
    }

    public static boolean copyAllTree(File fromFile, File toFile, FilenameFilter filter) throws IOException {
        if (!fromFile.exists()) {
            return true;
        }
        boolean result = true;
        File[] files = null;
        files = filter != null ? fromFile.listFiles(filter) : fromFile.listFiles();
        if (files == null) {
            return false;
        }
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (file.isDirectory()) {
                result &= RecurciveSearchFile.createDirectory(toFile, file, filter);
                continue;
            }
            if (!file.isFile()) continue;
            File copyFile = new File(toFile.getAbsolutePath() + "/" + file.getName());
            RecurciveSearchFile.dataCopy(file, copyFile);
        }
        return result;
    }

    private static boolean createDirectory(File copyDir, File dir, FilenameFilter filter) throws IOException {
        File newDir = new File(copyDir.getAbsolutePath() + "/" + dir.getName());
        newDir.mkdir();
        boolean result = true;
        File[] files = null;
        files = filter != null ? dir.listFiles(filter) : dir.listFiles();
        for (int index = 0; index < files.length; ++index) {
            File file = files[index];
            if (file.isDirectory()) {
                result &= RecurciveSearchFile.createDirectory(newDir, file, filter);
                continue;
            }
            if (!file.isFile()) continue;
            File copyFile = new File(newDir.getAbsolutePath() + "/" + file.getName());
            RecurciveSearchFile.dataCopy(file, copyFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dataCopy(File fromFile, File toFile) throws IOException {
        FileInputStream fis = new FileInputStream(fromFile);
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void deleteOnExitAllTree() {
        RecurciveSearchFile.deleteOnExitAllTree(this);
    }

    public static void deleteOnExitAllTree(File file) {
        file.deleteOnExit();
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                RecurciveSearchFile.deleteOnExitAllTree(files[i]);
            }
        }
    }
}

