/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc.ejb;

import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.log.Logger;

public abstract class BeanFlowClient {
    private Logger mLogger = null;
    private InterceptorChainInvokerFactory mIciFactory = null;
    private InterceptorChainFactory mIcFactory = null;
    private BeanFlowInvokerFactory mBfFactory = null;

    protected BeanFlowInvokerFactory getBfFactory() {
        return this.mBfFactory;
    }

    protected InterceptorChainInvokerFactory getIciFactory() {
        return this.mIciFactory;
    }

    protected InterceptorChainFactory getIcFactory() {
        return this.mIcFactory;
    }

    protected Logger getLogger() {
        return this.mLogger;
    }

    public void init(Logger logger, InterceptorChainInvokerFactory iciFactory, InterceptorChainFactory icFactory, BeanFlowInvokerFactory bfFactory) {
        this.mLogger = logger;
        this.mIciFactory = iciFactory;
        this.mIcFactory = icFactory;
        this.mBfFactory = bfFactory;
    }

    public Object invokeBeanFlow(Command input) throws Exception {
        if (this.mLogger != null) {
            this.mLogger.write("IOC__00013", (Object)input.getFlowKey());
        }
        BeanFlowInvoker flow = this.mBfFactory.createFlow(input.getFlowKey());
        if (this.mLogger != null && flow == null) {
            this.mLogger.write("IOC__00014");
        }
        return flow.invokeFlow(input.getInputObject());
    }

    protected abstract InvocationContext createInvocationContext(Object var1);
}

