/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChainFactoryServiceMBean;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChainList;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InterceptorChainList;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.interceptor.MetricsInfo;
import jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService;
import jp.ossc.nimbus.service.cache.CacheMap;

public class DefaultInterceptorChainFactoryService
extends ServiceBase
implements InterceptorChainFactory,
DefaultInterceptorChainFactoryServiceMBean {
    private static final long serialVersionUID = 8047982449933936760L;
    private static final Comparator COMP = new MetricsInfoComparator();
    private static final String LINE_SEP = System.getProperty("line.separator");
    private Map interceptorChainListMapping;
    private Map keyAndChainListMap;
    private Map interceptorMapping;
    private Map keyAndInterceptorMap;
    private Map invokerMapping;
    private Map keyAndInvokerMap;
    private ServiceName defaultInterceptorChainListServiceName;
    private InterceptorChainList defaultInterceptorChainList;
    private ServiceName defaultInvokerServiceName;
    private Invoker defaultInvoker;
    private boolean isRegexEnabled;
    private int regexMatchFlag;
    private ServiceName interceptorChainCacheMapServiceName;
    private CacheMap chainCache;
    private boolean isUseThreadLocalInterceptorChain = true;
    private boolean isGetMetrics;
    private Map metricsInfos;
    private boolean isCalculateOnlyNormal;
    private String dateFormat = "HH:mm:ss.SSS";
    private boolean isOutputTimestamp = false;
    private boolean isOutputCount = true;
    private boolean isOutputExceptionCount = false;
    private boolean isOutputErrorCount = false;
    private boolean isOutputLastTime = false;
    private boolean isOutputLastExceptionTime = false;
    private boolean isOutputLastErrorTime = false;
    private boolean isOutputBestPerformance = true;
    private boolean isOutputBestPerformanceTime = false;
    private boolean isOutputWorstPerformance = true;
    private boolean isOutputWorstPerformanceTime = false;
    private boolean isOutputAveragePerformance = true;

    @Override
    public void setInterceptorChainListMapping(Map mapping) {
        this.interceptorChainListMapping = mapping;
    }

    @Override
    public Map getInterceptorChainListMapping() {
        return this.interceptorChainListMapping;
    }

    @Override
    public void setInterceptorMapping(Map mapping) {
        this.interceptorMapping = mapping;
    }

    @Override
    public Map getInterceptorMapping() {
        return this.interceptorMapping;
    }

    @Override
    public void setDefaultInterceptorChainListServiceName(ServiceName name) {
        this.defaultInterceptorChainListServiceName = name;
    }

    @Override
    public ServiceName getDefaultInterceptorChainListServiceName() {
        return this.defaultInterceptorChainListServiceName;
    }

    @Override
    public void setInvokerMapping(Map mapping) {
        this.invokerMapping = mapping;
    }

    @Override
    public Map getInvokerMapping() {
        return this.invokerMapping;
    }

    @Override
    public void setDefaultInvokerServiceName(ServiceName name) {
        this.defaultInvokerServiceName = name;
    }

    @Override
    public ServiceName getDefaultInvokerServiceName() {
        return this.defaultInvokerServiceName;
    }

    @Override
    public void setRegexEnabled(boolean isEnable) {
        this.isRegexEnabled = isEnable;
    }

    @Override
    public boolean isRegexEnabled() {
        return this.isRegexEnabled;
    }

    @Override
    public void setRegexMatchFlag(int flag) {
        this.regexMatchFlag = flag;
    }

    @Override
    public int getRegexMatchFlag() {
        return this.regexMatchFlag;
    }

    @Override
    public void setInterceptorChainCacheMapServiceName(ServiceName name) {
        this.interceptorChainCacheMapServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainCacheMapServiceName() {
        return this.interceptorChainCacheMapServiceName;
    }

    @Override
    public void setUseThreadLocalInterceptorChain(boolean isUse) {
        this.isUseThreadLocalInterceptorChain = isUse;
    }

    @Override
    public boolean isUseThreadLocalInterceptorChain() {
        return this.isUseThreadLocalInterceptorChain;
    }

    @Override
    public void setGetMetrics(boolean isGet) {
        this.isGetMetrics = isGet;
    }

    @Override
    public boolean isGetMetrics() {
        return this.isGetMetrics;
    }

    @Override
    public void setCalculateOnlyNormal(boolean isCalc) {
        this.isCalculateOnlyNormal = isCalc;
    }

    @Override
    public boolean isCalculateOnlyNormal() {
        return this.isCalculateOnlyNormal;
    }

    @Override
    public void setOutputTimestamp(boolean isOutput) {
        this.isOutputTimestamp = isOutput;
    }

    @Override
    public boolean isOutputTimestamp() {
        return this.isOutputTimestamp;
    }

    @Override
    public void setOutputCount(boolean isOutput) {
        this.isOutputCount = isOutput;
    }

    @Override
    public boolean isOutputCount() {
        return this.isOutputCount;
    }

    @Override
    public void setOutputExceptionCount(boolean isOutput) {
        this.isOutputExceptionCount = isOutput;
    }

    @Override
    public boolean isOutputExceptionCount() {
        return this.isOutputExceptionCount;
    }

    @Override
    public void setOutputErrorCount(boolean isOutput) {
        this.isOutputErrorCount = isOutput;
    }

    @Override
    public boolean isOutputErrorCount() {
        return this.isOutputErrorCount;
    }

    @Override
    public void setOutputLastTime(boolean isOutput) {
        this.isOutputLastTime = isOutput;
    }

    @Override
    public boolean isOutputLastTime() {
        return this.isOutputLastTime;
    }

    @Override
    public void setOutputLastExceptionTime(boolean isOutput) {
        this.isOutputLastExceptionTime = isOutput;
    }

    @Override
    public boolean isOutputLastExceptionTime() {
        return this.isOutputLastExceptionTime;
    }

    @Override
    public void setOutputLastErrorTime(boolean isOutput) {
        this.isOutputLastErrorTime = isOutput;
    }

    @Override
    public boolean isOutputLastErrorTime() {
        return this.isOutputLastErrorTime;
    }

    @Override
    public void setOutputBestPerformance(boolean isOutput) {
        this.isOutputBestPerformance = isOutput;
    }

    @Override
    public boolean isOutputBestPerformance() {
        return this.isOutputBestPerformance;
    }

    @Override
    public void setOutputBestPerformanceTime(boolean isOutput) {
        this.isOutputBestPerformanceTime = isOutput;
    }

    @Override
    public boolean isOutputBestPerformanceTime() {
        return this.isOutputBestPerformanceTime;
    }

    @Override
    public void setOutputWorstPerformance(boolean isOutput) {
        this.isOutputWorstPerformance = isOutput;
    }

    @Override
    public boolean isOutputWorstPerformance() {
        return this.isOutputWorstPerformance;
    }

    @Override
    public void setOutputWorstPerformanceTime(boolean isOutput) {
        this.isOutputWorstPerformanceTime = isOutput;
    }

    @Override
    public boolean isOutputWorstPerformanceTime() {
        return this.isOutputWorstPerformanceTime;
    }

    @Override
    public void setOutputAveragePerformance(boolean isOutput) {
        this.isOutputAveragePerformance = isOutput;
    }

    @Override
    public boolean isOutputAveragePerformance() {
        return this.isOutputAveragePerformance;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String displayMetricsInfo() {
        MetricsInfo[] infos = this.metricsInfos.values().toArray(new MetricsInfo[this.metricsInfos.size()]);
        Arrays.sort(infos, COMP);
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        StringBuffer buf = new StringBuffer();
        buf.append("\"No.\"");
        if (this.isOutputCount) {
            buf.append(",\"Count\"");
        }
        if (this.isOutputExceptionCount) {
            buf.append(",\"ExceptionCount\"");
        }
        if (this.isOutputErrorCount) {
            buf.append(",\"ErrorCount\"");
        }
        if (this.isOutputLastTime) {
            buf.append(",\"LastTime\"");
        }
        if (this.isOutputLastExceptionTime) {
            buf.append(",\"LastExceptionTime\"");
        }
        if (this.isOutputLastErrorTime) {
            buf.append(",\"LastErrorTime\"");
        }
        if (this.isOutputBestPerformance) {
            buf.append(",\"Best performance[ms]\"");
        }
        if (this.isOutputBestPerformanceTime) {
            buf.append(",\"Best performance time\"");
        }
        if (this.isOutputWorstPerformance) {
            buf.append(",\"Worst performance[ms]\"");
        }
        if (this.isOutputWorstPerformanceTime) {
            buf.append(",\"Worst performance time\"");
        }
        if (this.isOutputAveragePerformance) {
            buf.append(",\"Average performance[ms]\"");
        }
        buf.append(",\"Method\"");
        buf.append(LINE_SEP);
        for (int i = 0; i < infos.length; ++i) {
            buf.append('\"').append(i + 1).append('\"');
            if (this.isOutputCount) {
                buf.append(',').append('\"').append(infos[i].getCount()).append('\"');
            }
            if (this.isOutputExceptionCount) {
                buf.append(',').append('\"').append(infos[i].getExceptionCount()).append('\"');
            }
            if (this.isOutputErrorCount) {
                buf.append(',').append('\"').append(infos[i].getErrorCount()).append('\"');
            }
            if (this.isOutputLastTime) {
                if (infos[i].getLastTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getLastTime()))).append('\"');
                }
            }
            if (this.isOutputLastExceptionTime) {
                if (infos[i].getLastExceptionTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getLastExceptionTime()))).append('\"');
                }
            }
            if (this.isOutputLastErrorTime) {
                if (infos[i].getLastErrorTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append('\"').append(',').append(format.format(new Date(infos[i].getLastErrorTime()))).append('\"');
                }
            }
            if (this.isOutputBestPerformance) {
                buf.append(',').append('\"').append(infos[i].getBestPerformance()).append('\"');
            }
            if (this.isOutputBestPerformanceTime) {
                if (infos[i].getBestPerformanceTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getBestPerformanceTime()))).append('\"');
                }
            }
            if (this.isOutputWorstPerformance) {
                buf.append(',').append('\"').append(infos[i].getWorstPerformance()).append('\"');
            }
            if (this.isOutputWorstPerformanceTime) {
                if (infos[i].getWorstPerformanceTime() == 0L) {
                    buf.append(",\"\"");
                } else {
                    buf.append(',').append('\"').append(format.format(new Date(infos[i].getWorstPerformanceTime()))).append('\"');
                }
            }
            if (this.isOutputAveragePerformance) {
                buf.append(',').append('\"').append(infos[i].getAveragePerformance()).append('\"');
            }
            buf.append(',').append('\"').append(infos[i].getKey()).append('\"');
            buf.append(LINE_SEP);
        }
        if (this.isOutputTimestamp) {
            buf.append(format.format(new Date())).append(LINE_SEP);
        }
        return buf.toString();
    }

    @Override
    public void reset() {
        this.metricsInfos.clear();
    }

    @Override
    public void createService() throws Exception {
        this.keyAndChainListMap = new LinkedHashMap();
        this.keyAndInterceptorMap = new LinkedHashMap();
        this.keyAndInvokerMap = new LinkedHashMap();
        this.metricsInfos = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        ServiceName name;
        String nameStr;
        Object key;
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        if (this.interceptorChainListMapping != null) {
            for (String keyStr : this.interceptorChainListMapping.keySet()) {
                key = keyStr;
                if (this.isRegexEnabled) {
                    key = Pattern.compile(keyStr, this.regexMatchFlag);
                }
                nameStr = (String)this.interceptorChainListMapping.get(keyStr);
                editor.setAsText(nameStr);
                name = (ServiceName)editor.getValue();
                InterceptorChainList chainList = (InterceptorChainList)ServiceManagerFactory.getServiceObject(name);
                this.keyAndChainListMap.put(key, chainList);
            }
        }
        if (this.interceptorMapping != null) {
            for (String keyStr : this.interceptorMapping.keySet()) {
                key = keyStr;
                if (this.isRegexEnabled) {
                    key = Pattern.compile(keyStr, this.regexMatchFlag);
                }
                nameStr = (String)this.interceptorMapping.get(keyStr);
                editor.setAsText(nameStr);
                name = (ServiceName)editor.getValue();
                this.keyAndInterceptorMap.put(key, name);
            }
        }
        if (this.invokerMapping != null) {
            for (String keyStr : this.invokerMapping.keySet()) {
                key = keyStr;
                if (this.isRegexEnabled) {
                    key = Pattern.compile(keyStr, this.regexMatchFlag);
                }
                nameStr = (String)this.invokerMapping.get(keyStr);
                editor.setAsText(nameStr);
                name = (ServiceName)editor.getValue();
                this.keyAndInvokerMap.put(key, name);
            }
        }
        if (this.defaultInterceptorChainListServiceName != null) {
            this.defaultInterceptorChainList = (InterceptorChainList)ServiceManagerFactory.getServiceObject(this.defaultInterceptorChainListServiceName);
        }
        if (this.defaultInvokerServiceName == null) {
            MethodReflectionCallInvokerService invoker = new MethodReflectionCallInvokerService();
            invoker.create();
            invoker.start();
            this.defaultInvoker = invoker;
        } else {
            this.defaultInvoker = (Invoker)ServiceManagerFactory.getServiceObject(this.defaultInvokerServiceName);
        }
        if (this.interceptorChainCacheMapServiceName != null) {
            this.chainCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.interceptorChainCacheMapServiceName);
        }
    }

    @Override
    public void stopService() throws Exception {
        this.keyAndChainListMap.clear();
        this.keyAndInterceptorMap.clear();
        this.keyAndInvokerMap.clear();
        if (this.chainCache != null) {
            this.chainCache.clear();
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.keyAndChainListMap = null;
        this.keyAndInterceptorMap = null;
        this.keyAndInvokerMap = null;
        this.metricsInfos = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterceptorChain getInterceptorChain(Object key) {
        DefaultInterceptorChain chain;
        String keyStr;
        String string = keyStr = key == null ? null : key.toString();
        if (this.chainCache != null) {
            CacheMap cacheMap = this.chainCache;
            synchronized (cacheMap) {
                if (this.chainCache.containsKey(keyStr)) {
                    return (InterceptorChain)this.chainCache.get(keyStr);
                }
            }
        }
        InterceptorChainList chainList = null;
        Invoker invoker = null;
        if (keyStr == null) {
            chainList = this.defaultInterceptorChainList;
            invoker = this.defaultInvoker;
        } else if (this.isRegexEnabled) {
            if (this.keyAndChainListMap.size() != 0) {
                for (Pattern pattern : this.keyAndChainListMap.keySet()) {
                    if (!pattern.matcher(keyStr).matches()) continue;
                    chainList = (InterceptorChainList)this.keyAndChainListMap.get(pattern);
                    break;
                }
            }
            if (chainList == null && this.keyAndInterceptorMap.size() != 0) {
                for (Pattern pattern : this.keyAndInterceptorMap.keySet()) {
                    if (!pattern.matcher(keyStr).matches()) continue;
                    if (chainList == null) {
                        chainList = new DefaultInterceptorChainList();
                    }
                    ServiceName name = (ServiceName)this.keyAndInterceptorMap.get(pattern);
                    Interceptor interceptor = (Interceptor)ServiceManagerFactory.getServiceObject(name);
                    ((DefaultInterceptorChainList)chainList).addInterceptor(interceptor);
                    break;
                }
            }
            if (this.keyAndInvokerMap.size() != 0) {
                for (Pattern pattern : this.keyAndInvokerMap.keySet()) {
                    if (!pattern.matcher(keyStr).matches()) continue;
                    invoker = (Invoker)this.keyAndInvokerMap.get(pattern);
                    break;
                }
            }
        } else {
            if (this.keyAndChainListMap.size() != 0) {
                chainList = (InterceptorChainList)this.keyAndChainListMap.get(keyStr);
            }
            if (this.keyAndInvokerMap.size() != 0) {
                invoker = (Invoker)this.keyAndInvokerMap.get(keyStr);
            }
        }
        if (chainList == null) {
            chainList = this.defaultInterceptorChainList;
        }
        if (invoker == null) {
            invoker = this.defaultInvoker;
        }
        if (chainList == null && invoker == null) {
            return null;
        }
        DefaultInterceptorChain defaultInterceptorChain = chain = this.isUseThreadLocalInterceptorChain ? new DefaultThreadLocalInterceptorChain(chainList, invoker) : new DefaultInterceptorChain(chainList, invoker);
        if (this.isGetMetrics) {
            ((DefaultInterceptorChain)chain).setMetricsInfoMap(this.metricsInfos);
            ((DefaultInterceptorChain)chain).setCalculateOnlyNormal(this.isCalculateOnlyNormal);
        }
        if (this.chainCache != null && this.isUseThreadLocalInterceptorChain) {
            CacheMap cacheMap = this.chainCache;
            synchronized (cacheMap) {
                if (this.chainCache.containsKey(keyStr)) {
                    return (InterceptorChain)this.chainCache.get(keyStr);
                }
                this.chainCache.put(keyStr, chain);
            }
        }
        return chain;
    }

    @Override
    public InterceptorChainList getInterceptorChainList(Object key) {
        String keyStr = key == null ? null : key.toString();
        InterceptorChainList chainList = null;
        if (keyStr == null) {
            chainList = this.defaultInterceptorChainList;
        } else if (this.isRegexEnabled) {
            if (this.keyAndChainListMap.size() != 0) {
                for (Pattern pattern : this.keyAndChainListMap.keySet()) {
                    if (!pattern.matcher(keyStr).matches()) continue;
                    chainList = (InterceptorChainList)this.keyAndChainListMap.get(pattern);
                    break;
                }
            }
            if (chainList == null && this.keyAndInterceptorMap.size() != 0) {
                for (Pattern pattern : this.keyAndInterceptorMap.keySet()) {
                    if (!pattern.matcher(keyStr).matches()) continue;
                    if (chainList == null) {
                        chainList = new DefaultInterceptorChainList();
                    }
                    ServiceName name = (ServiceName)this.keyAndInterceptorMap.get(pattern);
                    Interceptor interceptor = (Interceptor)ServiceManagerFactory.getServiceObject(name);
                    ((DefaultInterceptorChainList)chainList).addInterceptor(interceptor);
                    break;
                }
            }
        } else if (this.keyAndChainListMap.size() != 0) {
            chainList = (InterceptorChainList)this.keyAndChainListMap.get(keyStr);
        }
        if (chainList == null) {
            chainList = this.defaultInterceptorChainList;
        }
        return chainList;
    }

    @Override
    public Invoker getInvoker(Object key) {
        String keyStr = key == null ? null : key.toString();
        Invoker invoker = null;
        if (keyStr == null) {
            invoker = this.defaultInvoker;
        } else if (this.isRegexEnabled) {
            if (this.keyAndInvokerMap.size() != 0) {
                for (Pattern pattern : this.keyAndInvokerMap.keySet()) {
                    if (!pattern.matcher(keyStr).matches()) continue;
                    invoker = (Invoker)this.keyAndInvokerMap.get(pattern);
                    break;
                }
            }
        } else if (this.keyAndInvokerMap.size() != 0) {
            invoker = (Invoker)this.keyAndInvokerMap.get(keyStr);
        }
        if (invoker == null) {
            invoker = this.defaultInvoker;
        }
        return invoker;
    }

    private static class MetricsInfoComparator
    implements Comparator {
        private MetricsInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            long sortKey2;
            MetricsInfo info1 = (MetricsInfo)o1;
            MetricsInfo info2 = (MetricsInfo)o2;
            long sortKey1 = info1.getAveragePerformance() * info1.getCount();
            if (sortKey1 > (sortKey2 = info2.getAveragePerformance() * info2.getCount())) {
                return -1;
            }
            if (sortKey1 < sortKey2) {
                return 1;
            }
            return 0;
        }
    }
}

