/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.PerformanceRecordInterceptorServiceMBean;
import jp.ossc.nimbus.service.performance.PerformanceRecorder;

public class PerformanceRecordInterceptorService
extends ServiceBase
implements Interceptor,
PerformanceRecordInterceptorServiceMBean {
    private static final long serialVersionUID = -3489905667343158982L;
    private boolean isEnabled = true;
    private ServiceName performanceRecorderServiceName;
    private PerformanceRecorder performanceRecorder;

    @Override
    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setPerformanceRecorderServiceName(ServiceName name) {
        this.performanceRecorderServiceName = name;
    }

    @Override
    public ServiceName getPerformanceRecorderServiceName() {
        return this.performanceRecorderServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.performanceRecorderServiceName == null) {
            throw new IllegalArgumentException("PerformanceRecorderServiceName is null.");
        }
        this.performanceRecorder = (PerformanceRecorder)ServiceManagerFactory.getServiceObject(this.performanceRecorderServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        boolean isRecord;
        long start = 0L;
        boolean bl = isRecord = this.getState() == 3 && this.isEnabled();
        if (isRecord) {
            start = System.currentTimeMillis();
        }
        try {
            Object object = chain.invokeNext(context);
            return object;
        }
        finally {
            if (isRecord) {
                long end = System.currentTimeMillis();
                this.performanceRecorder.record(start, end);
            }
        }
    }
}

