/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.RequestProcessCheckInterceptorServiceMBean;
import jp.ossc.nimbus.service.log.Logger;

public class RequestProcessCheckInterceptorService
extends ServiceBase
implements Interceptor,
DaemonRunnable,
Serializable,
RequestProcessCheckInterceptorServiceMBean {
    private static final long serialVersionUID = -3680171846086643525L;
    protected ServiceName reportingLoggerServiceName;
    protected Logger reportingLogger;
    protected Map thresholdMap;
    protected List reportList;
    protected transient Set requests;
    protected long checkInterval = 1000L;
    protected transient Daemon checker;

    @Override
    public void setReportingLoggerServiceName(ServiceName name) {
        this.reportingLoggerServiceName = name;
    }

    @Override
    public ServiceName getReportingLoggerServiceName() {
        return this.reportingLoggerServiceName;
    }

    @Override
    public void setThreshold(Map threshold) {
        this.thresholdMap = threshold;
    }

    @Override
    public Map getThreshold() {
        return this.thresholdMap;
    }

    @Override
    public void setCheckInterval(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("CheckInterval must be larger than 0.");
        }
        this.checkInterval = interval;
    }

    @Override
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public String displayCurrentReport() {
        StringWriter buf = new StringWriter();
        PrintWriter pw = new PrintWriter(buf);
        long now = System.currentTimeMillis();
        for (Request request : this.requests) {
            if (request.isEnd) continue;
            pw.println('{');
            Object[] reports = this.createReport(request, now - request.time);
            pw.print("startTime=");
            pw.println(reports[0]);
            pw.print("processTime=");
            pw.println(reports[1]);
            pw.print("thread=");
            pw.println(reports[2]);
            pw.print("context=");
            pw.println(reports[3]);
            pw.print("stacktrace=");
            pw.println(reports[4]);
            pw.println('}');
        }
        pw.flush();
        return buf.toString();
    }

    @Override
    public void suspendChecker() {
        if (this.checker != null) {
            this.checker.suspend();
        }
    }

    @Override
    public void resumeChecker() {
        if (this.checker != null) {
            this.checker.resume();
        }
    }

    @Override
    public boolean interruptRequest(String groupName, String threadName) {
        boolean isInterrupt = false;
        for (Request request : this.requests) {
            if (request.isEnd || request.thread == null || !groupName.equals(request.thread.getThreadGroup().getName()) || !threadName.equals(request.thread.getName()) || request.isEnd) continue;
            request.thread.interrupt();
            isInterrupt = true;
        }
        return isInterrupt;
    }

    @Override
    public boolean removeRequest(String groupName, String threadName) {
        boolean isRemove = false;
        Iterator itr = this.requests.iterator();
        while (itr.hasNext()) {
            Request request = (Request)itr.next();
            if (request.isEnd || request.thread == null || !groupName.equals(request.thread.getThreadGroup().getName()) || !threadName.equals(request.thread.getName())) continue;
            itr.remove();
            isRemove = true;
        }
        return isRemove;
    }

    @Override
    public void clearRequest() {
        this.requests.clear();
    }

    @Override
    public int getRequestCount() {
        return this.requests == null ? 0 : this.requests.size();
    }

    @Override
    public void startService() throws Exception {
        this.requests = new ConcurrentSkipListSet();
        if (this.thresholdMap != null) {
            ArrayList<Report> list = new ArrayList<Report>();
            for (Map.Entry entry : this.thresholdMap.entrySet()) {
                long threshold = -1L;
                try {
                    threshold = Long.parseLong(entry.getKey().toString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (threshold < 0L) {
                    throw new IllegalArgumentException("Threshold must be 'threshold performance[ms]=MessageId' : " + entry.getKey());
                }
                list.add(new Report(threshold, entry.getValue().toString().trim()));
            }
            Collections.sort(list);
            this.reportList = list;
            this.checker = new Daemon(this);
            this.checker.setName("Nimbus PerformanceCheckInterceptorDaemon " + this.getServiceNameObject());
            this.checker.setDaemon(true);
            this.checker.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.checker != null) {
            this.checker.stop();
            this.checker = null;
        }
    }

    public void setReportingLogger(Logger log) {
        this.reportingLogger = this.logger;
    }

    public Logger getReportingLogger() {
        if (this.reportingLogger != null) {
            return this.reportingLogger;
        }
        if (this.reportingLoggerServiceName != null) {
            try {
                return (Logger)ServiceManagerFactory.getServiceObject(this.reportingLoggerServiceName);
            }
            catch (ServiceNotFoundException e) {
                return super.getLogger();
            }
        }
        return super.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        Request request = new Request(context);
        try {
            this.requests.add(request);
            Object object = chain.invokeNext(context);
            return object;
        }
        finally {
            request.isEnd = true;
            this.requests.remove(request);
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) throws Throwable {
        ctrl.sleep(this.checkInterval, true);
        return this.requests.size() == 0 ? null : this.requests;
    }

    @Override
    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        Set requestSet = (Set)paramObj;
        if (requestSet == null || requestSet.size() == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator itr = requestSet.iterator();
        boolean isTimeout = false;
        while (itr.hasNext()) {
            Request request = (Request)itr.next();
            if (request.isEnd) continue;
            int i = this.reportList.size();
            while (--i >= 0) {
                Report report = (Report)this.reportList.get(i);
                if (now - request.time <= report.threshold) continue;
                isTimeout = true;
                long reportTime = request.getReportTime(report);
                if (request.isEnd || reportTime != -1L && (report.reportInterval < 0L || reportTime + report.reportInterval > now)) continue;
                this.getReportingLogger().write(report.messageId, this.createReport(request, now - request.time));
                request.report(report);
                break;
            }
            if (isTimeout) continue;
            break;
        }
    }

    protected Object[] createReport(Request request, long performance) {
        String stackTrace = null;
        if (request.thread != null) {
            try {
                StackTraceElement[] elements = (StackTraceElement[])Thread.class.getMethod("getStackTrace", null).invoke((Object)request.thread, (Object[])null);
                StringWriter buf = new StringWriter();
                PrintWriter pw = new PrintWriter(buf);
                for (int i = 0; i < elements.length; ++i) {
                    pw.println(elements[i]);
                }
                pw.flush();
                stackTrace = buf.toString();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return new Object[]{new Date(request.time), new Long(performance), request.thread, request.context, stackTrace};
    }

    @Override
    public void garbage() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.requests = new ConcurrentSkipListSet();
        this.checker = new Daemon(this);
        this.checker.setName("Nimbus PerformanceCheckInterceptorDaemon " + this.getServiceNameObject());
        this.checker.setDaemon(true);
        this.checker.start();
    }

    protected static class Report
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 8777262126828754237L;
        public long threshold;
        public final String messageId;
        public long reportInterval = 0L;

        public Report(long threshold, String report) throws Exception {
            this.threshold = threshold;
            String[] args = report.split(",");
            this.messageId = args[0].trim();
            if (args.length > 1) {
                this.reportInterval = Long.parseLong(args[1].trim());
            }
        }

        public int compareTo(Object o) {
            Report r = (Report)o;
            long diff = this.threshold - r.threshold;
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
    }

    protected static class Request
    implements Comparable {
        public final Thread thread;
        public final InvocationContext context;
        public final long time;
        public boolean isEnd = false;
        protected Map reports;

        public Request(InvocationContext context) {
            this.context = context;
            this.thread = Thread.currentThread();
            this.time = System.currentTimeMillis();
        }

        public int compareTo(Object o) {
            Request r = (Request)o;
            long diff = this.time - r.time;
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }

        public void report(Report report) {
            if (this.reports == null) {
                this.reports = new HashMap();
            }
            this.reports.put(report, new Long(System.currentTimeMillis()));
        }

        public long getReportTime(Report report) {
            return this.reports == null ? -1L : (this.reports.containsKey(report) ? (Long)this.reports.get(report) : -1L);
        }
    }
}

