/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.interceptor.servlet.DefaultExceptionHandlerServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandler;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;

public class DefaultExceptionHandlerService
extends ServiceBase
implements DefaultExceptionHandlerServiceMBean,
ExceptionHandler {
    private static final long serialVersionUID = -7679217558033186068L;
    public static final String REQUEST_ATTIBUTE_EXCEPTION_KEY = DefaultExceptionHandlerService.class.getName().replace('.', '_') + "_EXCEPTION";
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected String logMessageCode;
    protected String[] logMessageArguments;
    protected boolean isOutputStackTraceLog = true;
    protected String exceptionJournalKey = "Exception";
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected int httpResponseStatus = -1;
    protected String httpResponseStatusMessage;
    protected String forwardPath;
    protected String redirectPath;
    protected boolean isThrowException;
    protected String responseObjectAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;
    protected Object responseObject;
    protected ServiceName responseObjectServiceName;
    protected Map exceptionAndResponseObjectPropertyMapping;
    protected PropertyAccess propertyAccess;

    @Override
    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    @Override
    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    @Override
    public void setLogMessageCode(String code) {
        this.logMessageCode = code;
    }

    @Override
    public String getLogMessageCode() {
        return this.logMessageCode;
    }

    @Override
    public void setLogMessageArguments(String[] args) {
        this.logMessageArguments = args;
    }

    @Override
    public String[] getLogMessageArguments() {
        return this.logMessageArguments;
    }

    @Override
    public void setOutputStackTraceLog(boolean isOutput) {
        this.isOutputStackTraceLog = isOutput;
    }

    @Override
    public boolean isOutputStackTraceLog() {
        return this.isOutputStackTraceLog;
    }

    @Override
    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    @Override
    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    @Override
    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    @Override
    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    @Override
    public void setHttpResponseStatus(int status) {
        this.httpResponseStatus = status;
    }

    @Override
    public int getHttpResponseStatus() {
        return this.httpResponseStatus;
    }

    @Override
    public void setHttpResponseStatusMessage(String message) {
        this.httpResponseStatusMessage = message;
    }

    @Override
    public String getHttpResponseStatusMessage() {
        return this.httpResponseStatusMessage;
    }

    @Override
    public void setForwardPath(String path) {
        this.forwardPath = path;
    }

    @Override
    public String getForwardPath() {
        return this.forwardPath;
    }

    @Override
    public void setRedirectPath(String path) {
        this.redirectPath = path;
    }

    @Override
    public String getRedirectPath() {
        return this.redirectPath;
    }

    @Override
    public void setThrowException(boolean isThrow) {
        this.isThrowException = isThrow;
    }

    @Override
    public boolean isThrowException() {
        return this.isThrowException;
    }

    @Override
    public void setResponseObjectAttributeName(String name) {
        this.responseObjectAttributeName = name;
    }

    @Override
    public String getResponseObjectAttributeName() {
        return this.responseObjectAttributeName;
    }

    @Override
    public void setResponseObject(Object obj) {
        this.responseObject = obj;
    }

    @Override
    public Object getResponseObject() {
        return this.responseObject;
    }

    @Override
    public void setResponseObjectServiceName(ServiceName name) {
        this.responseObjectServiceName = name;
    }

    @Override
    public ServiceName getResponseObjectServiceName() {
        return this.responseObjectServiceName;
    }

    @Override
    public void setExceptionAndResponseObjectPropertyMapping(Map mapping) {
        this.exceptionAndResponseObjectPropertyMapping = mapping;
    }

    @Override
    public Map getExceptionAndResponseObjectPropertyMapping() {
        return this.exceptionAndResponseObjectPropertyMapping;
    }

    @Override
    public void createService() throws Exception {
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(true);
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.propertyAccess = null;
    }

    @Override
    public void handleException(Throwable th, ServletRequest request, ServletResponse response) throws Throwable {
        if (this.logMessageCode != null) {
            Logger log = super.getLogger();
            if (this.isOutputStackTraceLog) {
                log.write(this.logMessageCode, this.logMessageArguments, th);
            } else {
                log.write(this.logMessageCode, this.logMessageArguments);
            }
        }
        if (this.journal != null) {
            this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
        }
        if (this.httpResponseStatus != -1 && response instanceof HttpServletResponse) {
            if (this.httpResponseStatusMessage == null) {
                ((HttpServletResponse)response).setStatus(this.httpResponseStatus);
            } else {
                ((HttpServletResponse)response).sendError(this.httpResponseStatus, this.httpResponseStatusMessage);
            }
        }
        if (this.responseObject != null || this.responseObjectServiceName != null) {
            Object resObj = this.responseObject;
            if (this.responseObjectServiceName != null) {
                resObj = ServiceManagerFactory.getServiceObject(this.responseObjectServiceName);
            }
            if (this.exceptionAndResponseObjectPropertyMapping != null) {
                for (Map.Entry entry : this.exceptionAndResponseObjectPropertyMapping.entrySet()) {
                    try {
                        Object val = this.propertyAccess.get(th, (String)entry.getKey());
                        if (val == null) continue;
                        this.propertyAccess.set(resObj, (String)entry.getValue(), val);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NoSuchPropertyException noSuchPropertyException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            }
            request.setAttribute(this.responseObjectAttributeName, resObj);
        }
        if (this.isThrowException) {
            throw th;
        }
        if (this.forwardPath != null) {
            RequestDispatcher rd = request.getRequestDispatcher(this.forwardPath);
            if (rd != null) {
                request.setAttribute(REQUEST_ATTIBUTE_EXCEPTION_KEY, (Object)th);
                rd.forward(request, response);
            }
        } else if (this.redirectPath != null && response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).sendRedirect(((HttpServletResponse)response).encodeRedirectURL(this.redirectPath));
        }
    }
}

