/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.DefaultOverflowControllerServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowAction;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;
import jp.ossc.nimbus.service.cache.OverflowController;
import jp.ossc.nimbus.service.cache.OverflowValidator;
import jp.ossc.nimbus.service.cache.RemoveOverflowActionService;
import jp.ossc.nimbus.service.queue.Queue;

public class DefaultOverflowControllerService
extends ServiceBase
implements OverflowController,
DaemonRunnable,
DefaultOverflowControllerServiceMBean {
    private static final long serialVersionUID = 304577650295674609L;
    protected ServiceName validatorServiceName;
    protected OverflowValidator validator;
    protected ServiceName algorithmServiceName;
    protected OverflowAlgorithm algorithm;
    protected ServiceName actionServiceName;
    protected OverflowAction action;
    protected RemoveOverflowActionService defaultAction;
    protected ServiceName queueServiceName;
    protected Queue queue;
    protected Daemon daemon;
    protected Object lock = "lock";
    protected long periodicOverflowIntervalTime;
    protected long periodicOverflowInterval;
    protected boolean isOverflowByAdding = true;
    protected boolean isValidateByOverflow = true;
    protected boolean isOverflowNewAdding = false;

    @Override
    public void setOverflowValidatorServiceName(ServiceName name) {
        this.validatorServiceName = name;
    }

    @Override
    public ServiceName getOverflowValidatorServiceName() {
        return this.validatorServiceName;
    }

    @Override
    public void setOverflowAlgorithmServiceName(ServiceName name) {
        this.algorithmServiceName = name;
    }

    @Override
    public ServiceName getOverflowAlgorithmServiceName() {
        return this.algorithmServiceName;
    }

    @Override
    public void setOverflowActionServiceName(ServiceName name) {
        this.actionServiceName = name;
    }

    @Override
    public ServiceName getOverflowActionServiceName() {
        return this.actionServiceName;
    }

    @Override
    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    @Override
    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    @Override
    public void setPeriodicOverflowIntervalTime(long time) {
        this.periodicOverflowIntervalTime = time;
    }

    @Override
    public long getPeriodicOverflowIntervalTime() {
        return this.periodicOverflowIntervalTime;
    }

    @Override
    public void setOverflowByAdding(boolean isOverflow) {
        this.isOverflowByAdding = isOverflow;
    }

    @Override
    public boolean isOverflowByAdding() {
        return this.isOverflowByAdding;
    }

    @Override
    public void setValidateByOverflow(boolean isValidate) {
        this.isValidateByOverflow = isValidate;
    }

    @Override
    public boolean isValidateByOverflow() {
        return this.isValidateByOverflow;
    }

    @Override
    public void setOverflowNewAdding(boolean isOverflow) {
        this.isOverflowNewAdding = isOverflow;
    }

    @Override
    public boolean isOverflowNewAdding() {
        return this.isOverflowNewAdding;
    }

    public void setOverflowAction(OverflowAction action) {
        this.action = action;
    }

    public void setOverflowAlgorithm(OverflowAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public void setOverflowValidator(OverflowValidator validator) {
        this.validator = validator;
    }

    @Override
    public void createService() throws Exception {
        this.daemon = new Daemon(this);
        this.daemon.setName("Nimbus OverflowControllerDaemon " + this.getServiceNameObject());
    }

    @Override
    public void startService() throws Exception {
        if (this.validatorServiceName != null) {
            this.validator = (OverflowValidator)ServiceManagerFactory.getServiceObject(this.validatorServiceName);
        }
        if (this.algorithmServiceName != null) {
            this.algorithm = (OverflowAlgorithm)ServiceManagerFactory.getServiceObject(this.algorithmServiceName);
        }
        if (this.validator != null && this.algorithm == null) {
            throw new IllegalArgumentException("OverflowAlgorithm must specify when OverflowValidator is specified.");
        }
        this.action = this.actionServiceName != null ? (OverflowAction)ServiceManagerFactory.getServiceObject(this.actionServiceName) : this.getDefaultOverflowActionService();
        this.action.setOverflowController(this);
        if (this.queueServiceName != null) {
            this.queue = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName);
        }
        if (this.periodicOverflowIntervalTime > 0L) {
            this.periodicOverflowInterval = this.periodicOverflowIntervalTime;
        }
        if (this.queue != null || this.periodicOverflowInterval > 0L) {
            if (this.queue != null) {
                this.queue.accept();
            }
            this.daemon.start();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.queue != null || this.periodicOverflowInterval > 0L) {
            this.daemon.stop();
            if (this.queue != null) {
                this.queue.release();
            }
        }
        this.validator = null;
        this.algorithm = null;
        if (this.defaultAction != null && this.action == this.defaultAction) {
            this.defaultAction.stop();
        }
        this.action = null;
        this.queue = null;
    }

    @Override
    public void destroyService() throws Exception {
        if (this.defaultAction != null) {
            this.defaultAction.destroy();
            this.defaultAction = null;
        }
        this.daemon = null;
    }

    protected OverflowAction getDefaultOverflowActionService() throws Exception {
        if (this.defaultAction == null) {
            RemoveOverflowActionService act = new RemoveOverflowActionService();
            act.create();
            act.start();
            this.defaultAction = act;
        } else if (this.defaultAction.getState() != 3) {
            this.defaultAction.start();
        }
        return this.defaultAction;
    }

    @Override
    public void control(CachedReference ref) {
        if (this.getState() != 3) {
            return;
        }
        if (this.queue == null) {
            this.consume(ref, this.daemon);
        } else {
            this.queue.push(ref);
        }
    }

    @Override
    public void reset() {
        if (this.validator != null) {
            this.validator.reset();
        }
        if (this.algorithm != null) {
            this.algorithm.reset();
        }
        if (this.action != null) {
            this.action.reset();
        }
    }

    @Override
    public boolean onStart() {
        return true;
    }

    @Override
    public boolean onStop() {
        return true;
    }

    @Override
    public boolean onSuspend() {
        return true;
    }

    @Override
    public boolean onResume() {
        return true;
    }

    @Override
    public Object provide(DaemonControl ctrl) {
        if (this.getState() != 3) {
            return null;
        }
        CachedReference ref = null;
        if (this.queue == null) {
            try {
                ctrl.sleep(this.periodicOverflowInterval, true);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            ref = this.periodicOverflowInterval > 0L ? (CachedReference)this.queue.get(this.periodicOverflowInterval) : (CachedReference)this.queue.get();
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(Object dequeued, DaemonControl ctrl) {
        if (this.validator == null || this.getState() != 3) {
            return;
        }
        CachedReference ref = (CachedReference)dequeued;
        if (ref != null && !ref.isRemoved() && this.validator != null) {
            this.validator.add(ref);
        }
        if (this.isOverflowNewAdding && ref != null && !ref.isRemoved() && this.algorithm != null) {
            this.algorithm.add(ref);
        }
        int overflowSize = 0;
        if (ref == null || this.isOverflowByAdding) {
            overflowSize = this.validator.validate();
        }
        if (overflowSize > 0) {
            if (!this.isValidateByOverflow) {
                Object object = this.lock;
                synchronized (object) {
                    overflowSize = this.validator.validate();
                    if (overflowSize > 0) {
                        CachedReference[] overflowRefs = null;
                        if (this.algorithm != null) {
                            overflowRefs = this.algorithm.overflow(overflowSize);
                        }
                        if (overflowRefs != null) {
                            for (int i = 0; i < overflowRefs.length; ++i) {
                                CachedReference overflowRef = overflowRefs[i];
                                if (overflowRef == null || overflowRef.isRemoved() || overflowRef == null || this.action == null || overflowRef.isRemoved()) continue;
                                this.action.action(this.validator, this.algorithm, overflowRef);
                            }
                        }
                    }
                }
            } else {
                CachedReference prevOverflowRef = null;
                while (overflowSize > 0) {
                    CachedReference overflowRef = null;
                    if (this.algorithm != null) {
                        overflowRef = this.algorithm.overflow();
                    }
                    if (prevOverflowRef != null && prevOverflowRef == overflowRef || overflowRef == null) break;
                    if (!overflowRef.isRemoved() && overflowRef != null && this.action != null && !overflowRef.isRemoved()) {
                        this.action.action(this.validator, this.algorithm, overflowRef);
                    }
                    overflowSize = this.validator != null ? this.validator.validate() : 0;
                    prevOverflowRef = overflowRef;
                }
            }
        }
        if (!this.isOverflowNewAdding && ref != null && !ref.isRemoved() && this.algorithm != null) {
            this.algorithm.add(ref);
        }
    }

    @Override
    public void garbage() {
        if (this.queue != null) {
            while (this.queue.size() > 0) {
                this.consume(this.queue.get(0L), this.daemon);
            }
        }
    }
}

