/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheMapService;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.PersistableCache;
import jp.ossc.nimbus.service.cache.SerializeKeyCachedReference;
import jp.ossc.nimbus.service.cache.SerializedMemoryCacheMapServiceMBean;
import jp.ossc.nimbus.service.io.Externalizer;

public class SerializedMemoryCacheMapService
extends AbstractCacheMapService
implements Serializable,
PersistableCache,
SerializedMemoryCacheMapServiceMBean {
    private static final long serialVersionUID = 3483316909396633967L;
    private ServiceName externalizerServiceName;
    private Externalizer externalizer;
    private ServiceName persistCacheMapServiceName;
    private boolean isLoadOnStart = true;
    private boolean isSaveOnStop = true;

    @Override
    public void setPersistCacheMapServiceName(ServiceName name) {
        this.persistCacheMapServiceName = name;
    }

    @Override
    public ServiceName getPersistCacheMapServiceName() {
        return this.persistCacheMapServiceName;
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    @Override
    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    @Override
    public void setSaveOnStop(boolean isSave) {
        this.isSaveOnStop = isSave;
    }

    @Override
    public boolean isSaveOnStop() {
        return this.isSaveOnStop;
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        this.externalizerServiceName = name;
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        return this.externalizerServiceName;
    }

    public void setExternalizer(Externalizer ext) {
        this.externalizer = ext;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    @Override
    public void startService() throws Exception {
        if (this.externalizerServiceName != null) {
            this.externalizer = (Externalizer)ServiceManagerFactory.getServiceObject(this.externalizerServiceName);
        }
        if (this.isLoadOnStart) {
            this.load();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isSaveOnStop) {
            this.save();
        }
    }

    @Override
    protected KeyCachedReference createKeyCachedReference(Object key, Object obj) {
        try {
            return this.externalizer == null ? new SerializeKeyCachedReference(key, obj) : new SerializeKeyCachedReference(key, obj, this.externalizer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public synchronized void load() throws Exception {
        if (this.persistCacheMapServiceName != null) {
            CacheMap persistCacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.persistCacheMapServiceName);
            this.clear();
            this.putAll((Map)persistCacheMap);
        }
    }

    @Override
    public synchronized void save() throws Exception {
        if (this.persistCacheMapServiceName != null) {
            CacheMap persistCacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.persistCacheMapServiceName);
            persistCacheMap.clear();
            persistCacheMap.putAll((Map)this);
        }
    }
}

