/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ejb;

import java.lang.reflect.InvocationTargetException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.service.ejb.InvocationEJBFactoryService;
import jp.ossc.nimbus.service.ejb.UnitEJBFactoryServiceMBean;

public class UnitEJBFactoryService
extends InvocationEJBFactoryService
implements UnitEJBFactoryServiceMBean {
    private static final long serialVersionUID = 7479531378907664537L;
    private static final Class DEFAULT_HOME_CLASS = EJBHome.class;
    private static final Class DEFAULT_LOCAL_HOME_CLASS = EJBLocalHome.class;
    private static final Class DEFAULT_REMOTE_CLASS = EJBObject.class;
    private static final Class DEFAULT_LOCAL_CLASS = EJBLocalObject.class;
    private String homeClassName;
    private String localHomeClassName;
    private String remoteClassName;
    private String localClassName;
    private String[] createMethodParamTypes;
    private Class homeClass = DEFAULT_HOME_CLASS;
    private Class localHomeClass = DEFAULT_LOCAL_HOME_CLASS;
    private Class remoteClass = DEFAULT_REMOTE_CLASS;
    private Class localClass = DEFAULT_LOCAL_CLASS;
    private Class[] paramTypes;

    @Override
    public String getHomeType() {
        return this.homeClassName;
    }

    @Override
    public void setHomeType(String className) {
        this.homeClassName = className;
    }

    @Override
    public String getLocalHomeType() {
        return this.localHomeClassName;
    }

    @Override
    public void setLocalHomeType(String className) {
        this.localHomeClassName = className;
    }

    @Override
    public String getRemoteType() {
        return this.remoteClassName;
    }

    @Override
    public void setRemoteType(String className) {
        this.remoteClassName = className;
    }

    @Override
    public String getLocalType() {
        return this.localClassName;
    }

    @Override
    public void setLocalType(String className) {
        this.localClassName = className;
    }

    @Override
    public String[] getCreateMethodParamTypes() {
        return this.createMethodParamTypes;
    }

    @Override
    public void setCreateMethodParamTypes(String[] params) {
        this.createMethodParamTypes = params;
    }

    @Override
    public void startService() throws Exception {
        super.startService();
        if (this.homeClassName == null && this.localHomeClassName == null) {
            throw new Exception("HomeType is null");
        }
        if (this.homeClassName != null) {
            this.homeClass = Class.forName(this.homeClassName, true, NimbusClassLoader.getInstance());
        }
        if (this.localHomeClassName != null) {
            this.localHomeClass = Class.forName(this.localHomeClassName, true, NimbusClassLoader.getInstance());
        }
        if (this.remoteClassName != null) {
            this.remoteClass = Class.forName(this.remoteClassName, true, NimbusClassLoader.getInstance());
        }
        if (this.localClassName != null) {
            this.localClass = Class.forName(this.localClassName, true, NimbusClassLoader.getInstance());
        }
        if (this.createMethodParamTypes != null && this.createMethodParamTypes.length != 0) {
            Class[] params = new Class[this.createMethodParamTypes.length];
            for (int i = 0; i < this.createMethodParamTypes.length; ++i) {
                params[i] = Class.forName(this.createMethodParamTypes[i], true, NimbusClassLoader.getInstance());
            }
            this.paramTypes = params;
        }
    }

    @Override
    public EJBObject get(String name) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.get(name, this.homeClass, this.remoteClass, null, null);
    }

    @Override
    public EJBLocalObject getLocal(String name) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.getLocal(name, this.localHomeClass, this.localClass, null, null);
    }

    @Override
    public EJBObject get(String name, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.get(name, this.homeClass, this.remoteClass, this.paramTypes, params);
    }

    @Override
    public EJBLocalObject getLocal(String name, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.getLocal(name, this.localHomeClass, this.localClass, this.paramTypes, params);
    }
}

