/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import jp.ossc.nimbus.service.ga.ConvergenceCondition;
import jp.ossc.nimbus.service.ga.Generation;
import jp.ossc.nimbus.service.ga.Genom;
import jp.ossc.nimbus.service.ga.Seed;
import jp.ossc.nimbus.service.ga.SeedMatchMaker;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;

public class DefaultGeneration
implements Generation {
    protected int generationNo = 1;
    protected Seed[] seeds;
    protected QueueHandlerContainer queueHandlerContainer;
    protected ConvergenceCondition convergenceCondition;
    protected ConvergenceCondition.ConvergenceConditionResult convergenceConditionResult;
    protected boolean fitnessOrder = false;
    protected boolean isSeedSelection;

    @Override
    public void setConvergenceCondition(ConvergenceCondition condition) {
        this.convergenceCondition = condition;
    }

    @Override
    public void setQueueHandlerContainer(QueueHandlerContainer qhc) {
        this.queueHandlerContainer = qhc;
    }

    @Override
    public QueueHandlerContainer getQueueHandlerContainer() {
        return this.queueHandlerContainer;
    }

    @Override
    public void setFitnessOrder(boolean isAsc) {
        this.fitnessOrder = isAsc;
    }

    @Override
    public boolean getFitnessOrder() {
        return this.fitnessOrder;
    }

    @Override
    public int getGenerationNo() {
        return this.generationNo;
    }

    public void setSeedSelection(boolean isSelection) {
        this.isSeedSelection = isSelection;
    }

    public boolean isSeedSelection() {
        return this.isSeedSelection;
    }

    @Override
    public void init(Random random, Seed seed, int num) {
        this.seeds = new Seed[num];
        for (int i = 0; i < num; ++i) {
            this.seeds[i] = seed.cloneSeed();
            Genom genom = this.seeds[i].getGenom();
            genom.random(random);
        }
    }

    @Override
    public void setSeeds(Seed[] seeds) {
        this.seeds = seeds;
    }

    @Override
    public Seed[] getSeeds() {
        return this.seeds;
    }

    @Override
    public void compete() throws Exception {
        this.compete(1, -1L);
    }

    @Override
    public void compete(int threadNum, long timeout) throws Exception {
        if (this.queueHandlerContainer == null && threadNum < 2) {
            for (int i = 0; i < this.seeds.length; ++i) {
                if (this.seeds[i].getFitness() != null) continue;
                this.seeds[i].fit(this);
            }
        } else {
            int i;
            long start = System.currentTimeMillis();
            QueueHandlerContainer qhc = this.queueHandlerContainer;
            if (qhc == null) {
                QueueHandlerContainerService service = new QueueHandlerContainerService();
                service.create();
                service.setQueueHandler(new FitHandler());
                service.setQueueHandlerSize(threadNum);
                service.setQueueHandlerNowaitOnStop(true);
                service.setReleaseQueue(false);
                service.setIgnoreNullElement(true);
                service.setWaitTimeout(1000L);
                service.setQueueHandlerNowaitOnStop(true);
                service.start();
                qhc = service;
            } else if (qhc.getQueueHandler() == null) {
                qhc.setQueueHandler(new FitHandler());
            }
            DefaultQueueService responseQueue = new DefaultQueueService();
            responseQueue.create();
            responseQueue.start();
            for (i = 0; i < this.seeds.length; ++i) {
                qhc.push(new AsynchContext(new Object[]{this, this.seeds[i]}, responseQueue));
            }
            for (i = 0; i < this.seeds.length; ++i) {
                long currentTimeout;
                long l = currentTimeout = timeout > 0L ? timeout - (System.currentTimeMillis() - start) : timeout;
                if (timeout > 0L && currentTimeout <= 0L) {
                    throw new Exception("Compete timeout. timeout=" + timeout);
                }
                AsynchContext ctx = (AsynchContext)responseQueue.get(currentTimeout);
                if (ctx == null) {
                    throw new Exception("Compete timeout. timeout=" + timeout);
                }
                try {
                    ctx.checkError();
                    continue;
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw (Error)th;
                }
            }
            if (this.queueHandlerContainer == null) {
                ((QueueHandlerContainerService)qhc).stop();
                ((QueueHandlerContainerService)qhc).destroy();
            }
        }
        Arrays.sort(this.seeds, new SeedComparator(this.fitnessOrder));
    }

    @Override
    public Generation next(Random random, SeedMatchMaker matchMaker) {
        Seed[] pair;
        this.convergenceConditionResult = this.convergenceCondition.checkConvergence(this, this.convergenceConditionResult);
        if (this.convergenceConditionResult.isConverged()) {
            return null;
        }
        DefaultGeneration generation = new DefaultGeneration();
        generation.queueHandlerContainer = this.queueHandlerContainer;
        generation.convergenceCondition = this.convergenceCondition;
        generation.convergenceConditionResult = this.convergenceConditionResult;
        generation.fitnessOrder = this.fitnessOrder;
        generation.generationNo = this.generationNo + 1;
        Seed[] newSeeds = new Seed[this.seeds.length];
        SeedMatchMaker.MatchMakeResult mmResult = null;
        for (int i = 0; i < this.seeds.length && (pair = (mmResult = matchMaker.matchMake(random, this, i, mmResult)).getPair()) != null; ++i) {
            if (pair[1] != null) {
                newSeeds[i] = pair[0].cloneSeed();
                newSeeds[i].getGenom().crossover(random, pair[1].getGenom());
                continue;
            }
            newSeeds[i] = pair[0];
        }
        if (this.isSeedSelection) {
            HashSet<Genom> genomSet = new HashSet<Genom>();
            for (int i = 0; i < newSeeds.length && newSeeds[i] != null; ++i) {
                if (genomSet.contains(newSeeds[i].getGenom())) {
                    newSeeds[i].getGenom().random(random);
                }
                genomSet.add(newSeeds[i].getGenom());
            }
        }
        generation.setSeeds(newSeeds);
        return generation;
    }

    @Override
    public Seed getSurvivor() {
        return this.seeds == null || this.seeds.length == 0 ? null : this.seeds[0];
    }

    protected static class SeedComparator
    implements Comparator {
        protected boolean isAsc;

        public SeedComparator(boolean isAsc) {
            this.isAsc = isAsc;
        }

        public int compare(Object o1, Object o2) {
            Seed seed1 = (Seed)o1;
            Seed seed2 = (Seed)o2;
            Comparable comp1 = (Comparable)((Object)seed1.getFitness());
            Comparable comp2 = (Comparable)((Object)seed2.getFitness());
            if (comp1 == null && comp2 == null) {
                return 0;
            }
            if (comp1 == null) {
                return 1;
            }
            if (comp2 == null) {
                return -1;
            }
            int comp = comp1.compareTo(comp2);
            return this.isAsc ? comp : -comp;
        }
    }

    protected static class FitHandler
    implements QueueHandler {
        protected FitHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            AsynchContext ctx = (AsynchContext)obj;
            Object[] param = (Object[])ctx.getInput();
            Generation generation = (Generation)param[0];
            Seed seed = (Seed)param[1];
            if (seed.getFitness() == null) {
                seed.fit(generation);
            }
            ctx.getResponseQueue().push(ctx);
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return true;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext ctx = (AsynchContext)obj;
            ctx.setThrowable(th);
            ctx.getResponseQueue().push(ctx);
        }
    }
}

