/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;

public class JournalServletResponseWrapper
extends ServletResponseWrapper
implements Serializable {
    private static final long serialVersionUID = -2223120537296890432L;
    private static final String EMPTY = "";
    private StringWriter bufferWriter = new StringWriter();
    private PrintWriter dummyWriter = new PrintWriter(this.bufferWriter);
    private PrintWriterWrapper writerWrapper;
    private ServletOutputStreamWrapper outputStreamWrapper;
    private int contentLength = -1;
    private boolean isBufferedOutput;

    public JournalServletResponseWrapper(ServletResponse response) {
        super(response);
    }

    private final ServletOutputStreamWrapper createServletOutputStreamWrapper() throws IOException {
        if (this.outputStreamWrapper == null) {
            ServletOutputStream sos = this.getResponse().getOutputStream();
            this.outputStreamWrapper = new ServletOutputStreamWrapper(sos);
        }
        return this.outputStreamWrapper;
    }

    private final PrintWriterWrapper createPrintWriterWrapper() throws IOException {
        if (this.writerWrapper == null) {
            PrintWriter pw = this.getResponse().getWriter();
            this.writerWrapper = new PrintWriterWrapper(pw);
        }
        return this.writerWrapper;
    }

    public void setBufferedOutput(boolean isBuffered) {
        this.isBufferedOutput = isBuffered;
    }

    public PrintWriter getWriter() throws IOException {
        return this.createPrintWriterWrapper();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.createServletOutputStreamWrapper();
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
        if (this.isCommitted()) {
            return;
        }
        this.contentLength = len;
    }

    public int getContentLength() {
        if (this.contentLength != -1) {
            return this.contentLength;
        }
        String content = this.getContent();
        int len = 0;
        String enc = this.getCharacterEncoding();
        if (content != null && content.length() != 0 && enc != null) {
            try {
                len = content.getBytes(enc).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (this.outputStreamWrapper != null) {
            len += this.outputStreamWrapper.getLength();
        }
        return len;
    }

    public String getContent() {
        if (this.writerWrapper == null) {
            return EMPTY;
        }
        return this.writerWrapper.getContent();
    }

    public void flush() throws IOException {
        ServletResponse response;
        if (this.writerWrapper != null) {
            this.writerWrapper.flushBuffer();
        }
        if (this.outputStreamWrapper != null) {
            this.outputStreamWrapper.flushBuffer();
        }
        if ((response = this.getResponse()) instanceof JournalServletResponseWrapper) {
            ((JournalServletResponseWrapper)response).flush();
        }
    }

    private class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private int length;
        private ServletOutputStream sos;
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public ServletOutputStreamWrapper(ServletOutputStream real) {
            this.sos = real;
        }

        public void write(int b) throws IOException {
            if (JournalServletResponseWrapper.this.isBufferedOutput) {
                this.baos.write(b);
            } else {
                this.sos.write(b);
            }
            ++this.length;
        }

        public void write(byte[] b) throws IOException {
            if (JournalServletResponseWrapper.this.isBufferedOutput) {
                this.baos.write(b);
            } else {
                this.sos.write(b);
            }
            this.length += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (JournalServletResponseWrapper.this.isBufferedOutput) {
                this.baos.write(b, off, len);
            } else {
                this.sos.write(b, off, len);
            }
            this.length += len;
        }

        public void print(String s) throws IOException {
            this.sos.print(s);
        }

        public void print(boolean b) throws IOException {
            this.sos.print(b);
        }

        public void print(char c) throws IOException {
            this.sos.print(c);
        }

        public void print(int i) throws IOException {
            this.sos.print(i);
        }

        public void print(long l) throws IOException {
            this.sos.print(l);
        }

        public void print(float f) throws IOException {
            this.sos.print(f);
        }

        public void print(double d) throws IOException {
            this.sos.print(d);
        }

        public void println() throws IOException {
            this.sos.println();
        }

        public void println(String s) throws IOException {
            this.sos.println(s);
        }

        public void println(boolean b) throws IOException {
            this.sos.println(b);
        }

        public void println(char c) throws IOException {
            this.sos.println(c);
        }

        public void println(int i) throws IOException {
            this.sos.println(i);
        }

        public void println(long l) throws IOException {
            this.sos.println(l);
        }

        public void println(float f) throws IOException {
            this.sos.println(f);
        }

        public void println(double d) throws IOException {
            this.sos.println(d);
        }

        public int getLength() {
            return this.length;
        }

        public void flushBuffer() throws IOException {
            if (JournalServletResponseWrapper.this.isBufferedOutput) {
                this.baos.writeTo((OutputStream)this.sos);
                this.baos.reset();
            }
        }

        public void flush() throws IOException {
            this.sos.flush();
        }
    }

    private class PrintWriterWrapper
    extends PrintWriter {
        private PrintWriter pw;

        public PrintWriterWrapper(PrintWriter real) {
            super(JournalServletResponseWrapper.this.dummyWriter);
            this.pw = real;
        }

        @Override
        public void print(boolean b) {
            super.print(b);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(b);
            }
        }

        @Override
        public void print(char c) {
            super.print(c);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(c);
            }
        }

        @Override
        public void print(char[] s) {
            super.print(s);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(s);
            }
        }

        @Override
        public void print(double d) {
            super.print(d);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(d);
            }
        }

        @Override
        public void print(float f) {
            super.print(f);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(f);
            }
        }

        @Override
        public void print(int i) {
            super.print(i);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(i);
            }
        }

        @Override
        public void print(long l) {
            super.print(l);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(l);
            }
        }

        @Override
        public void print(Object obj) {
            super.print(obj);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(obj);
            }
        }

        @Override
        public void print(String s) {
            super.print(s);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(s);
            }
        }

        @Override
        public void println() {
            super.println();
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println();
            }
        }

        @Override
        public void println(boolean x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(char x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(char[] x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(double x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(float x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(int x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(long x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(Object x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void println(String x) {
            super.println(x);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.println(x);
            }
        }

        @Override
        public void write(char[] buf) {
            super.write(buf);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(buf);
            }
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(buf, off, len);
            }
        }

        @Override
        public void write(int c) {
            super.write(c);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(c);
            }
        }

        @Override
        public void write(String s) {
            super.write(s);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(s);
            }
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            if (!JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.write(s, off, len);
            }
        }

        public String getContent() {
            return JournalServletResponseWrapper.this.bufferWriter.toString();
        }

        public void flushBuffer() {
            if (JournalServletResponseWrapper.this.isBufferedOutput) {
                this.pw.print(this.getContent());
                JournalServletResponseWrapper.this.bufferWriter = new StringWriter();
            }
        }

        @Override
        public void flush() {
            this.pw.flush();
        }
    }
}

