/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterServiceMBean;
import jp.ossc.nimbus.service.keepalive.DefaultClusterListenerService;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class ClusterService
extends ServiceBase
implements ClusterServiceMBean {
    private static final long serialVersionUID = 4503189967951662029L;
    protected static final int MESSAGE_ID_ADD_REQ = 1;
    protected static final int MESSAGE_ID_MEMBER_CHANGE_REQ = 2;
    protected static final int MESSAGE_ID_MEMBER_MERGE_REQ = 3;
    protected static final int MESSAGE_ID_MEMBER_MERGE_RES = 4;
    protected static final int MESSAGE_ID_MAIN_HELLO_REQ = 5;
    protected static final int MESSAGE_ID_MAIN_REQ = 6;
    protected static final int MESSAGE_ID_MAIN_RES = 7;
    protected static final int MESSAGE_ID_HELLO_REQ = 8;
    protected static final int MESSAGE_ID_HELLO_RES = 9;
    protected static final int MESSAGE_ID_BYE_REQ = 10;
    protected static final int MESSAGE_ID_MEMBER_CHANGE_REQ_REQ = 11;
    protected static final int MESSAGE_ID_ADD_REQ_REQ = 12;
    protected ServiceName targetServiceName;
    protected ServiceName[] clusterListenerServiceNames;
    protected List listeners;
    protected String multicastGroupAddress;
    protected int multicastPort = 1500;
    protected int timeToLive = -1;
    protected String localAddress;
    protected String bindAddress;
    protected String[] networkInterfaceNames;
    protected NetworkInterface[] networkInterfaces;
    protected String[] unicastMemberAddresses;
    protected int unicastPort = 1500;
    protected boolean isAnonymousUnicastPort = false;
    protected int socketReceiveBufferSize = -1;
    protected int socketSendBufferSize = -1;
    protected int receiveBufferSize = 1024;
    protected long heartBeatInterval = 1000L;
    protected long heartBeatResponseTimeout = 500L;
    protected int heartBeatRetryCount = 1;
    protected long addMemberResponseTimeout = 500L;
    protected int addMemberRetryCount = 0;
    protected boolean isClient;
    protected long lostTimeout = 500L;
    protected transient GlobalUID uid;
    protected transient GlobalUID uidWithOption;
    protected transient InetAddress group;
    protected transient DatagramSocket socket;
    protected transient DatagramSocket unicastSocket;
    protected transient Daemon clusterMessageReceiver;
    protected transient Daemon unicastClusterMessageReceiver;
    protected transient Daemon heartBeater;
    protected transient Daemon eventHandler;
    protected transient Queue eventQueue;
    protected transient boolean isMain;
    protected transient boolean isMainDoubt;
    protected transient List members;
    protected transient Set memberAddresses;
    protected transient Map clientMembers;
    protected transient List unicastMembers;
    protected final SynchronizeMonitor addMonitor = new WaitSynchronizeMonitor();
    protected transient boolean isMainRequesting;
    protected transient long mainRequestingTime;
    protected transient Set mainReqMembers;
    protected final SynchronizeMonitor helloMonitor = new WaitSynchronizeMonitor();
    protected transient GlobalUID helloTarget;
    protected transient Serializable option;
    protected transient Map optionMap;
    protected transient boolean isJoinOnStart = true;
    protected transient boolean isJoin;
    protected transient boolean isJoining;
    protected final String sequenceLock = "SEQUENCE";
    protected transient int currentSequence;
    protected transient int maxWindowCount;
    protected int threadPriority = -1;
    protected final Object lockObj = "LOCK";
    protected transient long lastReceiveTime = -1L;
    protected transient GlobalUID lastReceiveUID;
    protected final Object lastReceiveUIDLockObj = "LOCK_LAST_RECEIVE";

    @Override
    public void setTargetServiceName(ServiceName name) {
        this.targetServiceName = name;
    }

    @Override
    public ServiceName getTargetServiceName() {
        return this.targetServiceName;
    }

    @Override
    public void setClusterListenerServiceNames(ServiceName[] names) {
        this.clusterListenerServiceNames = names;
    }

    @Override
    public ServiceName[] getClusterListenerServiceNames() {
        return this.clusterListenerServiceNames;
    }

    @Override
    public void setMulticastGroupAddress(String ip) {
        this.multicastGroupAddress = ip;
    }

    @Override
    public String getMulticastGroupAddress() {
        return this.multicastGroupAddress;
    }

    @Override
    public void setMulticastPort(int port) {
        this.multicastPort = port;
    }

    @Override
    public int getMulticastPort() {
        return this.multicastPort;
    }

    @Override
    public void setUnicastMemberAddresses(String[] addresses) {
        this.unicastMemberAddresses = addresses;
    }

    @Override
    public String[] getUnicastMemberAddresses() {
        return this.unicastMemberAddresses;
    }

    @Override
    public void setUnicastPort(int port) {
        this.unicastPort = port;
    }

    @Override
    public int getUnicastPort() {
        return this.unicastPort;
    }

    @Override
    public void setAnonymousUnicastPort(boolean isAnonymous) {
        this.isAnonymousUnicastPort = isAnonymous;
    }

    @Override
    public boolean isAnonymousUnicastPort() {
        return this.isAnonymousUnicastPort;
    }

    @Override
    public void setSocketReceiveBufferSize(int size) {
        this.socketReceiveBufferSize = size;
    }

    @Override
    public int getSocketReceiveBufferSize() {
        return this.socketReceiveBufferSize;
    }

    @Override
    public void setSocketSendBufferSize(int size) {
        this.socketSendBufferSize = size;
    }

    @Override
    public int getSocketSendBufferSize() {
        return this.socketSendBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setTimeToLive(int ttl) {
        this.timeToLive = ttl;
    }

    @Override
    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setLocalAddress(String ip) {
        this.localAddress = ip;
    }

    @Override
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void setBindAddress(String ip) {
        this.bindAddress = ip;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void setNetworkInterfaces(String[] names) {
        this.networkInterfaceNames = names;
    }

    @Override
    public String[] getNetworkInterfaces() {
        return this.networkInterfaceNames;
    }

    @Override
    public void setOption(Serializable opt) {
        this.option = opt;
        if (this.uidWithOption != null) {
            this.uidWithOption.setOption(opt);
        }
    }

    @Override
    public Serializable getOption() {
        return this.option;
    }

    @Override
    public void setOption(String key, Serializable opt) {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        this.optionMap.put(key, opt);
        if (this.uidWithOption != null) {
            this.uidWithOption.setOption(key, opt);
        }
    }

    @Override
    public Serializable getOption(String key) {
        return this.optionMap == null ? null : (Serializable)this.optionMap.get(key);
    }

    @Override
    public void setHeartBeatInterval(long interval) {
        this.heartBeatInterval = interval;
    }

    @Override
    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public void setHeartBeatResponseTimeout(long timeout) {
        this.heartBeatResponseTimeout = timeout;
    }

    @Override
    public long getHeartBeatResponseTimeout() {
        return this.heartBeatResponseTimeout;
    }

    @Override
    public void setHeartBeatRetryCount(int count) {
        this.heartBeatRetryCount = count;
    }

    @Override
    public int getHeartBeatRetryCount() {
        return this.heartBeatRetryCount;
    }

    @Override
    public void setAddMemberResponseTimeout(long timeout) {
        this.addMemberResponseTimeout = timeout;
    }

    @Override
    public long getAddMemberResponseTimeout() {
        return this.addMemberResponseTimeout;
    }

    @Override
    public void setAddMemberRetryCount(int count) {
        this.addMemberRetryCount = count;
    }

    @Override
    public int getAddMemberRetryCount() {
        return this.addMemberRetryCount;
    }

    @Override
    public void setLostTimeout(long timeout) {
        this.lostTimeout = timeout;
    }

    @Override
    public long getLostTimeout() {
        return this.lostTimeout;
    }

    @Override
    public void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public void setJoinOnStart(boolean isJoin) {
        this.isJoinOnStart = isJoin;
    }

    @Override
    public boolean isJoinOnStart() {
        return this.isJoinOnStart;
    }

    @Override
    public void setThreadPriority(int priority) {
        this.threadPriority = priority;
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    public boolean isMain() {
        return this.isMain;
    }

    @Override
    public boolean isMainDoubt() {
        return this.isMainDoubt;
    }

    @Override
    public void setMainDoubt(boolean isMainDoubt) {
        this.isMainDoubt = isMainDoubt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMembers() {
        if (this.members == null) {
            return null;
        }
        List list = this.members;
        synchronized (list) {
            return new ArrayList(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClientMembers() {
        if (this.clientMembers == null) {
            return null;
        }
        Map map = this.clientMembers;
        synchronized (map) {
            return new HashSet(this.clientMembers.values());
        }
    }

    @Override
    public Object getUID() {
        return this.uid;
    }

    @Override
    public boolean isJoin() {
        return this.isJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterListener(ClusterListener listener) {
        if (this.getState() == 3) {
            List list;
            if (this.isJoin()) {
                list = this.members;
                synchronized (list) {
                    try {
                        listener.memberInit(this.isClient ? null : this.uidWithOption, new ArrayList(this.members));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.isMain) {
                            listener.changeMain();
                        } else {
                            listener.changeSub();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            list = this.listeners;
            synchronized (list) {
                ArrayList<ClusterListener> tmp = new ArrayList<ClusterListener>(this.listeners);
                tmp.add(listener);
                this.listeners = tmp;
            }
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterListener(ClusterListener listener) {
        if (this.getState() == 3) {
            List list = this.listeners;
            synchronized (list) {
                ArrayList tmp = new ArrayList(this.listeners);
                tmp.remove(listener);
                this.listeners = tmp;
            }
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public int getMaxWindowCount() {
        return this.maxWindowCount;
    }

    @Override
    public void createService() throws Exception {
        this.members = Collections.synchronizedList(new ArrayList());
        this.memberAddresses = Collections.synchronizedSet(new HashSet());
        this.clientMembers = Collections.synchronizedMap(new HashMap());
        this.mainReqMembers = Collections.synchronizedSet(new HashSet());
        this.listeners = new ArrayList();
        this.unicastMembers = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService() throws Exception {
        if (this.clusterListenerServiceNames != null) {
            for (int i = 0; i < this.clusterListenerServiceNames.length; ++i) {
                this.listeners.add((ClusterListener)ServiceManagerFactory.getServiceObject(this.clusterListenerServiceNames[i]));
            }
        }
        if (this.targetServiceName != null) {
            DefaultClusterListenerService listener = new DefaultClusterListenerService();
            listener.setTargetServiceName(this.targetServiceName);
            listener.setClusterService(this);
            listener.create();
            listener.start();
            this.listeners.add(listener);
        }
        this.uidWithOption = new GlobalUID(this.localAddress, this.optionMap == null || this.optionMap.size() == 0 ? this.option : (Serializable)((Object)this.optionMap));
        this.uidWithOption.setClient(this.isClient);
        this.uid = (GlobalUID)this.uidWithOption.clone();
        this.uid.setOption(null);
        if (this.multicastGroupAddress == null && (this.unicastMemberAddresses == null || this.unicastMemberAddresses.length == 0)) {
            throw new IllegalArgumentException("MulticastGroupAddress and UnicastMemberAddresses is null.");
        }
        this.eventQueue = new DefaultQueueService();
        ((Service)((Object)this.eventQueue)).create();
        ((Service)((Object)this.eventQueue)).start();
        this.eventQueue.accept();
        this.connect();
        if (!this.isClient) {
            List list = this.members;
            synchronized (list) {
                this.members.clear();
                this.members.add(this.uidWithOption);
                if (this.multicastGroupAddress == null) {
                    this.memberAddresses.add(new InetSocketAddress(this.uidWithOption.getAddress(), this.uidWithOption.getUnicastPort()));
                }
            }
        }
        this.eventHandler = new Daemon(new EventHandler());
        this.eventHandler.setName("Nimbus Cluster EventHandler " + this.getServiceNameObject());
        if (this.threadPriority >= 0) {
            this.eventHandler.setPriority(this.threadPriority);
        }
        this.eventHandler.start();
        this.clusterMessageReceiver = new Daemon(new MessageReceiver(this.socket));
        this.clusterMessageReceiver.setName("Nimbus Cluster MessageReceiver " + this.getServiceNameObject());
        if (this.threadPriority >= 0) {
            this.clusterMessageReceiver.setPriority(this.threadPriority);
        }
        this.clusterMessageReceiver.start();
        if (this.unicastSocket != null) {
            this.unicastClusterMessageReceiver = new Daemon(new MessageReceiver(this.unicastSocket));
            this.unicastClusterMessageReceiver.setName("Nimbus Cluster Unicast MessageReceiver " + this.getServiceNameObject());
            if (this.threadPriority >= 0) {
                this.unicastClusterMessageReceiver.setPriority(this.threadPriority);
            }
            this.unicastClusterMessageReceiver.start();
        }
        this.heartBeater = new Daemon(new HeartBeater());
        if (this.threadPriority >= 0) {
            this.heartBeater.setPriority(this.threadPriority);
        }
        this.heartBeater.setName("Nimbus Cluster HeartBeater " + this.getServiceNameObject());
        this.heartBeater.suspend();
        this.heartBeater.start();
        if (this.isJoinOnStart) {
            this.join();
        }
    }

    @Override
    public void stopService() throws Exception {
        this.heartBeater.stop(100L);
        this.heartBeater = null;
        this.clusterMessageReceiver.stop(100L);
        this.clusterMessageReceiver = null;
        if (this.unicastClusterMessageReceiver != null) {
            this.unicastClusterMessageReceiver.stop(100L);
            this.unicastClusterMessageReceiver = null;
        }
        this.eventHandler.stop(100L);
        this.eventHandler = null;
        this.eventQueue.release();
        this.leave();
        if (this.socket != null) {
            if (this.group != null && this.group.isMulticastAddress()) {
                try {
                    ((MulticastSocket)this.socket).leaveGroup(this.group);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket.close();
        }
        this.isMain = false;
        this.isMainDoubt = false;
        this.group = null;
        this.members.clear();
        this.memberAddresses.clear();
        this.clientMembers.clear();
        this.mainReqMembers.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.uid = null;
        this.uidWithOption = null;
        this.members = null;
        this.memberAddresses = null;
        this.clientMembers = null;
        this.mainReqMembers = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws IOException {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.unicastSocket != null) {
                this.unicastSocket.close();
            }
            if (this.multicastGroupAddress != null) {
                this.group = InetAddress.getByName(this.multicastGroupAddress);
                if (this.bindAddress == null) {
                    this.socket = this.group.isMulticastAddress() ? new MulticastSocket(this.multicastPort) : new DatagramSocket(this.multicastPort);
                    this.unicastSocket = new DatagramSocket(new InetSocketAddress(this.isAnonymousUnicastPort ? 0 : this.unicastPort));
                } else {
                    InetSocketAddress address = new InetSocketAddress(this.bindAddress, this.multicastPort);
                    this.socket = this.group.isMulticastAddress() ? new MulticastSocket(address) : new DatagramSocket(address);
                    this.unicastSocket = new DatagramSocket(new InetSocketAddress(this.bindAddress, this.isAnonymousUnicastPort ? 0 : this.unicastPort));
                }
                if (this.socketReceiveBufferSize > 0) {
                    this.socket.setReceiveBufferSize(this.socketReceiveBufferSize);
                    this.unicastSocket.setReceiveBufferSize(this.socketReceiveBufferSize);
                }
                if (this.socketSendBufferSize > 0) {
                    this.socket.setSendBufferSize(this.socketSendBufferSize);
                    this.unicastSocket.setSendBufferSize(this.socketSendBufferSize);
                }
                this.uid.setUnicastPort(this.unicastSocket.getLocalPort());
                this.uidWithOption.setUnicastPort(this.unicastSocket.getLocalPort());
                if (this.group.isMulticastAddress() && this.timeToLive >= 0) {
                    ((MulticastSocket)this.socket).setTimeToLive(this.timeToLive);
                }
                if (this.group.isMulticastAddress() && this.networkInterfaceNames != null) {
                    this.networkInterfaces = new NetworkInterface[this.networkInterfaceNames.length];
                    for (int i = 0; i < this.networkInterfaceNames.length; ++i) {
                        this.networkInterfaces[i] = NetworkInterface.getByName(this.networkInterfaceNames[i]);
                    }
                }
                if (this.group.isMulticastAddress()) {
                    if (this.networkInterfaces == null) {
                        ((MulticastSocket)this.socket).joinGroup(this.group);
                    } else {
                        for (int i = 0; i < this.networkInterfaces.length; ++i) {
                            ((MulticastSocket)this.socket).joinGroup(new InetSocketAddress(this.group, this.multicastPort), this.networkInterfaces[i]);
                        }
                    }
                }
            } else {
                this.unicastMembers.clear();
                for (int i = 0; i < this.unicastMemberAddresses.length; ++i) {
                    int index = this.unicastMemberAddresses[i].indexOf(58);
                    InetSocketAddress unicastMemberAddress = null;
                    unicastMemberAddress = index == -1 ? new InetSocketAddress(InetAddress.getByName(this.unicastMemberAddresses[i]), this.unicastPort) : new InetSocketAddress(InetAddress.getByName(this.unicastMemberAddresses[i].substring(0, index)), Integer.parseInt(this.unicastMemberAddresses[i].substring(index + 1)));
                    this.unicastMembers.add(unicastMemberAddress);
                }
                this.socket = new DatagramSocket(new InetSocketAddress(this.uid.getAddress(), this.isClient && this.isAnonymousUnicastPort ? 0 : this.unicastPort));
                if (this.socketReceiveBufferSize > 0) {
                    this.socket.setReceiveBufferSize(this.socketReceiveBufferSize);
                }
                if (this.socketSendBufferSize > 0) {
                    this.socket.setSendBufferSize(this.socketSendBufferSize);
                }
                this.uid.setUnicastPort(this.socket.getLocalPort());
                this.uidWithOption.setUnicastPort(this.socket.getLocalPort());
                this.unicastMembers.remove(this.socket.getLocalSocketAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws Exception {
        Object object = this.lockObj;
        synchronized (object) {
            block32: {
                if (this.isJoin) {
                    return;
                }
                this.isJoining = true;
                try {
                    Object object2 = this.addMonitor;
                    synchronized (object2) {
                        for (int i = 0; i <= this.addMemberRetryCount; ++i) {
                            this.addMonitor.initMonitor();
                            this.sendMessage(1);
                            if (this.addMonitor.waitMonitor(this.addMemberResponseTimeout)) break;
                        }
                    }
                    if (this.members.size() == 0 || this.members.get(0).equals(this.uid)) {
                        if (!this.isClient && !this.members.contains(this.uid)) {
                            object2 = this.members;
                            synchronized (object2) {
                                this.members.add(this.uidWithOption);
                                if (this.multicastGroupAddress == null) {
                                    this.memberAddresses.add(new InetSocketAddress(this.uidWithOption.getAddress(), this.uidWithOption.getUnicastPort()));
                                }
                            }
                        }
                        this.processMemberInit(this.members);
                        if (this.isClient) break block32;
                        try {
                            object2 = this.members;
                            synchronized (object2) {
                                this.isMain = true;
                                this.isMainDoubt = false;
                                this.isMainRequesting = false;
                                Map map = this.clientMembers;
                                synchronized (map) {
                                    this.clientMembers.clear();
                                }
                                this.getLogger().write("CLST_00001", this.getServiceNameObject());
                            }
                            this.processChangeMain();
                            break block32;
                        }
                        catch (Exception e) {
                            this.isMain = false;
                            this.processChangeSub();
                            this.sendMessage(10);
                            this.clusterMessageReceiver.stop(100L);
                            if (this.unicastClusterMessageReceiver != null) {
                                this.unicastClusterMessageReceiver.stop(100L);
                            }
                            if (this.socket != null) {
                                if (this.group != null && this.group.isMulticastAddress()) {
                                    try {
                                        ((MulticastSocket)this.socket).leaveGroup(this.group);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                this.socket.close();
                            }
                            if (this.unicastSocket != null) {
                                this.unicastSocket.close();
                            }
                            this.isJoin = false;
                            throw e;
                        }
                    }
                    this.processMemberInit(this.members);
                    if (!this.isClient) {
                        this.processChangeSub();
                        this.getLogger().write("CLST_00002", this.getServiceNameObject());
                    }
                }
                finally {
                    this.isJoining = false;
                }
            }
            this.isJoin = true;
            this.heartBeater.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leave() {
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.isJoin) {
                return;
            }
            this.isJoin = false;
            if (this.heartBeater != null) {
                this.heartBeater.suspend();
            }
            try {
                this.sendMessage(10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList tmpOldMembers = null;
            ArrayList<GlobalUID> tmpNewMembers = null;
            List list = this.members;
            synchronized (list) {
                tmpOldMembers = new ArrayList(this.members);
                tmpNewMembers = new ArrayList<GlobalUID>();
                if (!this.isClient) {
                    tmpNewMembers.add(this.uidWithOption);
                }
                this.members = Collections.synchronizedList(tmpNewMembers);
                if (!this.isClient && this.multicastGroupAddress == null) {
                    this.memberAddresses.clear();
                    this.memberAddresses.add(new InetSocketAddress(this.uidWithOption.getAddress(), this.uidWithOption.getUnicastPort()));
                }
            }
            this.processMemberChange(tmpOldMembers, tmpNewMembers);
            if (!this.isClient) {
                this.isMain = false;
                this.isMainDoubt = false;
                this.isMainRequesting = false;
                this.processChangeSub();
                this.getLogger().write("CLST_00002", this.getServiceNameObject());
            }
        }
    }

    public ClusterService createClient() {
        ClusterService client = new ClusterService();
        client.multicastGroupAddress = this.multicastGroupAddress;
        client.multicastPort = this.multicastPort;
        client.timeToLive = this.timeToLive;
        client.unicastMemberAddresses = this.unicastMemberAddresses;
        client.unicastPort = this.unicastPort;
        client.isAnonymousUnicastPort = this.isAnonymousUnicastPort;
        client.receiveBufferSize = this.receiveBufferSize;
        client.heartBeatInterval = this.heartBeatInterval;
        client.heartBeatResponseTimeout = this.heartBeatResponseTimeout;
        client.heartBeatRetryCount = this.heartBeatRetryCount;
        client.addMemberResponseTimeout = this.addMemberResponseTimeout;
        client.lostTimeout = this.lostTimeout;
        client.isClient = true;
        return client;
    }

    protected void sendMessage(int messageId) throws IOException {
        this.sendMessage(messageId, null);
    }

    protected void sendMessage(int messageId, GlobalUID toUID) throws IOException {
        this.sendMessage(messageId, null, toUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void sendMessage(int messageId, GlobalUID agentUID, GlobalUID toUID) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            List windows;
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                oos.writeInt(messageId);
                                oos.writeObject(agentUID);
                                Object[] memberArray = null;
                                switch (messageId) {
                                    case 9: 
                                    case 10: 
                                    case 11: {
                                        break;
                                    }
                                    case 5: 
                                    case 8: 
                                    case 12: {
                                        oos.writeInt(this.members.size());
                                        break;
                                    }
                                    case 1: {
                                        if (this.isClient) {
                                            oos.writeObject(this.uid);
                                            break;
                                        }
                                        oos.writeObject(this.uidWithOption);
                                        break;
                                    }
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        List list = this.members;
                                        // MONITORENTER : list
                                        memberArray = this.members.toArray();
                                        // MONITOREXIT : list
                                        oos.writeInt(memberArray.length);
                                        int imax = memberArray.length;
                                        for (int i = 0; i < imax; ++i) {
                                            oos.writeObject(memberArray[i]);
                                        }
                                        break;
                                    }
                                    case 7: {
                                        oos.writeBoolean(!this.isMain);
                                        break;
                                    }
                                }
                                oos.close();
                                byte[] bytes = baos.toByteArray();
                                if (bytes.length <= 0) {
                                    return;
                                }
                                Window window = new Window();
                                window.uid = this.uid;
                                String string = "SEQUENCE";
                                // MONITORENTER : "SEQUENCE"
                                window.sequence = this.currentSequence++;
                                // MONITOREXIT : string
                                window.data = bytes;
                                windows = window.divide(this.receiveBufferSize);
                                this.maxWindowCount = Math.max(this.maxWindowCount, windows.size());
                                if (this.group != null) break block39;
                                if (toUID == null) break block40;
                                break block41;
                            }
                            if (toUID == null) break block42;
                            break block43;
                        }
                        LinkedHashSet toMembers = new LinkedHashSet();
                        toMembers.addAll(this.unicastMembers);
                        List list = this.members;
                        // MONITORENTER : list
                        toMembers.addAll(this.memberAddresses);
                        // MONITOREXIT : list
                        InetSocketAddress[] toAddresses = toMembers.toArray(new InetSocketAddress[toMembers.size()]);
                        GlobalUID[] clients = null;
                        Map map = this.clientMembers;
                        // MONITORENTER : map
                        clients = this.clientMembers.size() == 0 ? null : this.clientMembers.values().toArray(new GlobalUID[this.clientMembers.size()]);
                        // MONITOREXIT : map
                        int i = 0;
                        while (i < windows.size()) {
                            int j;
                            byte[] windowData = (byte[])windows.get(i);
                            for (j = 0; j < toAddresses.length; ++j) {
                                this.socket.send(new DatagramPacket(windowData, windowData.length, toAddresses[j].getAddress(), toAddresses[j].getPort()));
                            }
                            if (clients != null) {
                                switch (messageId) {
                                    case 10: {
                                        if (this.isClient) break;
                                    }
                                    case 2: 
                                    case 4: {
                                        for (j = 0; j < clients.length; ++j) {
                                            this.socket.send(new DatagramPacket(windowData, windowData.length, clients[j].getAddress(), clients[j].getUnicastPort() == 0 ? this.unicastPort : clients[j].getUnicastPort()));
                                        }
                                        break;
                                    }
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                    int i = 0;
                    while (i < windows.size()) {
                        byte[] windowData = (byte[])windows.get(i);
                        this.socket.send(new DatagramPacket(windowData, windowData.length, toUID.getAddress(), toUID.getUnicastPort() == 0 ? this.unicastPort : toUID.getUnicastPort()));
                        ++i;
                    }
                    return;
                }
                int i = 0;
                while (i < windows.size()) {
                    byte[] windowData = (byte[])windows.get(i);
                    DatagramPacket packet = new DatagramPacket(windowData, windowData.length, this.group, this.multicastPort);
                    if (this.networkInterfaces == null) {
                        this.socket.send(packet);
                    } else {
                        NetworkInterface[] networkInterfaceArray = this.networkInterfaces;
                        // MONITORENTER : this.networkInterfaces
                        for (int j = 0; j < this.networkInterfaces.length; ++j) {
                            ((MulticastSocket)this.socket).setNetworkInterface(this.networkInterfaces[j]);
                            this.socket.send(packet);
                        }
                        // MONITOREXIT : networkInterfaceArray
                    }
                    ++i;
                }
                return;
            }
            int i = 0;
            while (i < windows.size()) {
                byte[] windowData = (byte[])windows.get(i);
                this.unicastSocket.send(new DatagramPacket(windowData, windowData.length, toUID.getAddress(), toUID.getUnicastPort() == 0 ? this.unicastPort : toUID.getUnicastPort()));
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void handleMessage(GlobalUID fromUID, InputStream is) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            int messageId = ois.readInt();
            GlobalUID agentFromUID = (GlobalUID)ois.readObject();
            if (agentFromUID != null) {
                fromUID = agentFromUID;
            }
            if (this.uid.equals(fromUID)) {
                return;
            }
            int memberSize = 0;
            ArrayList<Object> newMembers = null;
            boolean isMemberChange = false;
            ArrayList tmpOldMembers = null;
            ArrayList tmpNewMembers = null;
            switch (messageId) {
                case 1: {
                    if (!this.isMain) return;
                    if (this.isMainDoubt) {
                        return;
                    }
                    GlobalUID newUID = (GlobalUID)ois.readObject();
                    if (fromUID.isClient()) {
                        Map map = this.clientMembers;
                        // MONITORENTER : map
                        if (fromUID.getUnicastPort() != 0) {
                            Iterator itr = this.clientMembers.keySet().iterator();
                            while (itr.hasNext()) {
                                GlobalUID clientId = (GlobalUID)itr.next();
                                if (fromUID.equals(clientId) || clientId.getUnicastPort() == 0 || !clientId.getAddress().equals(fromUID.getAddress()) || clientId.getUnicastPort() != fromUID.getUnicastPort()) continue;
                                itr.remove();
                            }
                        }
                        if (this.clientMembers.put(fromUID, fromUID) == null) {
                            this.getLogger().write("CLST_00008", new Object[]{this.getServiceNameObject(), fromUID});
                        }
                        // MONITOREXIT : map
                        this.sendMessage(2, newUID);
                        return;
                    }
                    List list = this.members;
                    // MONITORENTER : list
                    if (newUID.getUnicastPort() != 0 && !this.members.contains(newUID)) {
                        tmpOldMembers = new ArrayList(this.members);
                        if (this.members.size() != 0) {
                            Iterator itr = this.members.iterator();
                            while (itr.hasNext()) {
                                GlobalUID memberId = (GlobalUID)itr.next();
                                if (memberId.getUnicastPort() == 0 || !memberId.getAddress().equals(newUID.getAddress()) || memberId.getUnicastPort() != newUID.getUnicastPort()) continue;
                                itr.remove();
                                if (this.multicastGroupAddress != null) continue;
                                this.memberAddresses.remove(new InetSocketAddress(memberId.getAddress(), memberId.getUnicastPort()));
                            }
                        }
                        this.members.add(newUID);
                        if (this.multicastGroupAddress == null) {
                            this.memberAddresses.add(new InetSocketAddress(newUID.getAddress(), newUID.getUnicastPort()));
                        }
                        tmpNewMembers = new ArrayList(this.members);
                        isMemberChange = true;
                    }
                    // MONITOREXIT : list
                    this.sendMessage(2);
                    if (!isMemberChange) return;
                    this.getLogger().write("CLST_00005", new Object[]{this.getServiceNameObject(), fromUID});
                    this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    return;
                }
                case 11: {
                    if (!this.isMain) return;
                    if (this.isMainDoubt) return;
                    this.sendMessage(2);
                    return;
                }
                case 2: {
                    if (this.isMain && !this.isMainDoubt) {
                        return;
                    }
                    memberSize = ois.readInt();
                    newMembers = new ArrayList<Object>();
                    if (memberSize > 0) {
                        for (int i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    List i = this.members;
                    // MONITORENTER : i
                    if (!this.members.equals(newMembers) && (this.isJoining || this.members.size() == 0 || this.members.get(0).equals(newMembers.get(0))) && (this.isClient || newMembers.contains(this.uid))) {
                        tmpOldMembers = new ArrayList(this.members);
                        tmpNewMembers = new ArrayList(newMembers);
                        this.members = Collections.synchronizedList(newMembers);
                        if (this.multicastGroupAddress == null) {
                            this.memberAddresses.clear();
                            for (int i2 = 0; i2 < newMembers.size(); ++i2) {
                                GlobalUID newMember = (GlobalUID)newMembers.get(i2);
                                this.memberAddresses.add(new InetSocketAddress(newMember.getAddress(), newMember.getUnicastPort()));
                            }
                        }
                        isMemberChange = true;
                    }
                    // MONITOREXIT : i
                    if (!isMemberChange) return;
                    if (!this.isJoining) {
                        this.getLogger().write("CLST_00007", new Object[]{this.getServiceNameObject(), tmpOldMembers, tmpNewMembers});
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                        return;
                    }
                    if (!this.addMonitor.isWait()) return;
                    this.addMonitor.notifyAllMonitor();
                    return;
                }
                case 3: {
                    if (!this.isMain) return;
                    if (this.isMainDoubt) {
                        return;
                    }
                    memberSize = ois.readInt();
                    newMembers = new ArrayList();
                    if (memberSize > 0) {
                        for (int i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    List i = this.members;
                    // MONITORENTER : i
                    newMembers.removeAll(this.members);
                    if (newMembers.size() != 0) {
                        tmpOldMembers = new ArrayList(this.members);
                        this.members.addAll(newMembers);
                        tmpNewMembers = new ArrayList(this.members);
                        if (this.multicastGroupAddress == null) {
                            for (int i3 = 0; i3 < newMembers.size(); ++i3) {
                                GlobalUID newMember = (GlobalUID)newMembers.get(i3);
                                this.memberAddresses.add(new InetSocketAddress(newMember.getAddress(), newMember.getUnicastPort()));
                            }
                        }
                        isMemberChange = true;
                    }
                    // MONITOREXIT : i
                    this.sendMessage(4);
                    if (!isMemberChange) return;
                    this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    return;
                }
                case 4: {
                    if (this.isMain && !this.isMainDoubt) {
                        return;
                    }
                    this.isMainDoubt = false;
                    memberSize = ois.readInt();
                    newMembers = new ArrayList();
                    if (memberSize > 0) {
                        for (int i = 0; i < memberSize; ++i) {
                            newMembers.add(ois.readObject());
                        }
                    }
                    if (!this.isClient && this.isMain && newMembers.indexOf(this.uid) != 0) {
                        this.eventQueue.push(new ClusterEvent(2));
                        this.isMain = false;
                        Set i = this.mainReqMembers;
                        // MONITORENTER : i
                        this.isMainRequesting = false;
                        // MONITOREXIT : i
                        this.getLogger().write("CLST_00002", this.getServiceNameObject());
                    }
                    List i = this.members;
                    // MONITORENTER : i
                    if ((this.isClient || newMembers.contains(this.uid)) && !this.members.equals(newMembers)) {
                        tmpOldMembers = new ArrayList(this.members);
                        tmpNewMembers = new ArrayList(newMembers);
                        this.members = Collections.synchronizedList(newMembers);
                        if (this.multicastGroupAddress == null) {
                            this.memberAddresses.clear();
                            for (int i4 = 0; i4 < newMembers.size(); ++i4) {
                                GlobalUID newMember = (GlobalUID)newMembers.get(i4);
                                this.memberAddresses.add(new InetSocketAddress(newMember.getAddress(), newMember.getUnicastPort()));
                            }
                        }
                        isMemberChange = true;
                    }
                    // MONITOREXIT : i
                    if (!isMemberChange) return;
                    this.getLogger().write("CLST_00010", new Object[]{this.getServiceNameObject(), tmpOldMembers, tmpNewMembers});
                    this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    return;
                }
                case 5: {
                    if (this.isClient) {
                        return;
                    }
                    memberSize = ois.readInt();
                    if (!this.isMain) {
                        if (this.members.size() != 1) return;
                        if (this.addMonitor.isWait()) return;
                        this.sendMessage(1, fromUID);
                        return;
                    }
                    if (this.isMainDoubt) {
                        if (memberSize >= this.members.size()) {
                            if (memberSize != this.members.size()) return;
                            if (this.uid.compareTo(fromUID) >= 0) return;
                        }
                        this.isMainDoubt = false;
                        return;
                    }
                    if (memberSize <= this.members.size()) {
                        if (memberSize != this.members.size()) return;
                        if (this.uid.compareTo(fromUID) <= 0) return;
                    }
                    this.isMainDoubt = true;
                    this.sendMessage(3, fromUID);
                    return;
                }
                case 6: {
                    if (this.isClient) return;
                    this.sendMessage(7, fromUID);
                    return;
                }
                case 7: {
                    if (this.isClient) {
                        return;
                    }
                    if (!this.isMainRequesting) return;
                    if (!ois.readBoolean()) {
                        Set i = this.mainReqMembers;
                        // MONITORENTER : i
                        this.isMainRequesting = false;
                        this.mainReqMembers.clear();
                        // MONITOREXIT : i
                        return;
                    }
                    Set i = this.mainReqMembers;
                    // MONITORENTER : i
                    this.mainReqMembers.remove(fromUID);
                    if (this.mainReqMembers.size() == 0) {
                        try {
                            this.isMain = true;
                            this.isMainRequesting = false;
                            Map i4 = this.clientMembers;
                            // MONITORENTER : i4
                            this.clientMembers.clear();
                            // MONITOREXIT : i4
                            this.getLogger().write("CLST_00001", this.getServiceNameObject());
                            this.eventQueue.push(new ClusterEvent(1));
                            this.sendMessage(4);
                            return;
                        }
                        catch (Exception e) {
                            this.getLogger().write("CLST_00003", this.getServiceNameObject(), (Throwable)e);
                            this.stop();
                        }
                    }
                    // MONITOREXIT : i
                    return;
                }
                case 8: {
                    if (fromUID.isClient()) {
                        if (!this.isMain) return;
                        if (this.isMainDoubt) return;
                        this.sendMessage(9, fromUID);
                        Map i = this.clientMembers;
                        // MONITORENTER : i
                        if (fromUID.getUnicastPort() != 0) {
                            Iterator itr = this.clientMembers.keySet().iterator();
                            while (itr.hasNext()) {
                                GlobalUID clientId = (GlobalUID)itr.next();
                                if (fromUID.equals(clientId) || clientId.getUnicastPort() == 0 || !clientId.getAddress().equals(fromUID.getAddress()) || clientId.getUnicastPort() != fromUID.getUnicastPort()) continue;
                                itr.remove();
                            }
                        }
                        if (this.clientMembers.put(fromUID, fromUID) == null) {
                            this.getLogger().write("CLST_00008", new Object[]{this.getServiceNameObject(), fromUID});
                        }
                        // MONITOREXIT : i
                        if (ois.readInt() == this.members.size()) return;
                        this.sendMessage(2, fromUID);
                        return;
                    }
                    this.sendMessage(9, fromUID);
                    if (this.members.contains(fromUID)) {
                        int myIndex = -1;
                        int targetIndex = -1;
                        Object object = this.members;
                        // MONITORENTER : object
                        memberSize = this.members.size();
                        myIndex = this.members.indexOf(this.uid);
                        targetIndex = myIndex == 0 ? memberSize - 1 : myIndex - 1;
                        // MONITOREXIT : object
                        if (this.members.indexOf(fromUID) == targetIndex && ois.readInt() == memberSize) {
                            if (this.members.indexOf(fromUID) != targetIndex) return;
                            object = this.lastReceiveUIDLockObj;
                            // MONITORENTER : object
                            this.lastReceiveTime = System.currentTimeMillis();
                            this.lastReceiveUID = fromUID;
                            // MONITOREXIT : object
                            return;
                        }
                        if (this.isMain && !this.isMainDoubt) {
                            this.sendMessage(2, fromUID);
                            return;
                        }
                        this.sendMessage(11);
                        return;
                    }
                    if (!this.isMain) return;
                    if (this.isMainDoubt) {
                        this.sendMessage(3);
                        return;
                    }
                    this.sendMessage(12, fromUID);
                    return;
                }
                case 9: {
                    SynchronizeMonitor synchronizeMonitor = this.helloMonitor;
                    // MONITORENTER : synchronizeMonitor
                    if (this.helloTarget != null && this.helloTarget.equals(fromUID)) {
                        this.helloMonitor.notifyMonitor();
                    }
                    // MONITOREXIT : synchronizeMonitor
                    return;
                }
                case 12: {
                    if (!this.isMain) {
                        this.sendMessage(1, fromUID);
                        return;
                    }
                    memberSize = ois.readInt();
                    if (memberSize <= this.members.size()) {
                        if (memberSize != this.members.size()) return;
                        if (this.uid.compareTo(fromUID) <= 0) return;
                    }
                    this.isMainDoubt = true;
                    this.sendMessage(3, fromUID);
                    return;
                }
                case 10: {
                    if (this.isClient) {
                        if (fromUID.isClient()) return;
                        List list = this.members;
                        // MONITORENTER : list
                        if (this.members.contains(fromUID)) {
                            tmpOldMembers = new ArrayList(this.members);
                            this.members.remove(fromUID);
                            if (this.multicastGroupAddress == null) {
                                this.memberAddresses.remove(new InetSocketAddress(fromUID.getAddress(), fromUID.getUnicastPort()));
                            }
                            tmpNewMembers = new ArrayList(this.members);
                            isMemberChange = true;
                        }
                        // MONITOREXIT : list
                        if (!isMemberChange) return;
                        this.getLogger().write("CLST_00006", new Object[]{this.getServiceNameObject(), fromUID});
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                        return;
                    }
                    if (this.isMain && !this.isMainDoubt) {
                        if (fromUID.isClient()) {
                            Map map = this.clientMembers;
                            // MONITORENTER : map
                            this.clientMembers.remove(fromUID);
                            // MONITOREXIT : map
                            this.getLogger().write("CLST_00009", new Object[]{this.getServiceNameObject(), fromUID});
                            return;
                        }
                        List list = this.members;
                        // MONITORENTER : list
                        if (this.members.contains(fromUID) && !this.uid.equals(fromUID)) {
                            tmpOldMembers = new ArrayList(this.members);
                            this.members.remove(fromUID);
                            if (this.multicastGroupAddress == null) {
                                this.memberAddresses.remove(new InetSocketAddress(fromUID.getAddress(), fromUID.getUnicastPort()));
                            }
                            tmpNewMembers = new ArrayList(this.members);
                            isMemberChange = true;
                        }
                        // MONITOREXIT : list
                        if (!isMemberChange) return;
                        this.getLogger().write("CLST_00006", new Object[]{this.getServiceNameObject(), fromUID});
                        this.sendMessage(2);
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                        return;
                    }
                    if (fromUID.isClient()) return;
                    Object object = this.members;
                    // MONITORENTER : object
                    if (this.members.contains(fromUID) && !this.uid.equals(fromUID)) {
                        tmpOldMembers = new ArrayList(this.members);
                        this.members.remove(fromUID);
                        if (this.multicastGroupAddress == null) {
                            this.memberAddresses.remove(new InetSocketAddress(fromUID.getAddress(), fromUID.getUnicastPort()));
                        }
                        tmpNewMembers = new ArrayList(this.members);
                        this.getLogger().write("CLST_00006", new Object[]{this.getServiceNameObject(), fromUID});
                        this.eventQueue.push(new ClusterEvent(4, tmpOldMembers, tmpNewMembers));
                    }
                    // MONITOREXIT : object
                    if (this.isMainRequesting) {
                        object = this.mainReqMembers;
                        // MONITORENTER : object
                        this.mainReqMembers.remove(fromUID);
                        if (this.mainReqMembers.size() == 0) {
                            try {
                                this.isMain = true;
                                this.isMainRequesting = false;
                                Map targetIndex = this.clientMembers;
                                // MONITORENTER : targetIndex
                                this.clientMembers.clear();
                                // MONITOREXIT : targetIndex
                                this.getLogger().write("CLST_00001", this.getServiceNameObject());
                                this.eventQueue.push(new ClusterEvent(1));
                                this.sendMessage(4);
                                return;
                            }
                            catch (Exception e) {
                                this.getLogger().write("CLST_00003", this.getServiceNameObject(), (Throwable)e);
                                this.stop();
                            }
                        }
                        // MONITOREXIT : object
                        return;
                    }
                    if (this.members.indexOf(this.uid) != 0) return;
                    if (!this.isClient && this.members.size() == 1) {
                        this.isMain = true;
                        object = this.mainReqMembers;
                        // MONITORENTER : object
                        this.isMainRequesting = false;
                        // MONITOREXIT : object
                        object = this.clientMembers;
                        // MONITORENTER : object
                        this.clientMembers.clear();
                        // MONITOREXIT : object
                        this.getLogger().write("CLST_00001", this.getServiceNameObject());
                        this.eventQueue.push(new ClusterEvent(1));
                        return;
                    }
                    object = this.mainReqMembers;
                    // MONITORENTER : object
                    if (!this.isMainRequesting) {
                        this.mainReqMembers.clear();
                        this.mainReqMembers.addAll(this.members);
                        this.mainReqMembers.remove(this.uid);
                        this.mainRequestingTime = System.currentTimeMillis();
                        this.isMainRequesting = true;
                    }
                    // MONITOREXIT : object
                    if (!this.isMainRequesting) return;
                    this.sendMessage(6);
                    return;
                }
            }
            return;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().write("CLST_00004", this.getServiceNameObject(), (Throwable)e);
            return;
        }
        catch (IOException e) {
            this.getLogger().write("CLST_00004", this.getServiceNameObject(), (Throwable)e);
            return;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMemberInit(List members) {
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            try {
                ArrayList initMembers = null;
                List list = members;
                synchronized (list) {
                    initMembers = new ArrayList(members);
                }
                listener.memberInit(this.isClient ? null : this.uidWithOption, initMembers);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processMemberChange(List oldMembers, List newMembers) {
        if (oldMembers.equals(newMembers)) {
            return;
        }
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            try {
                listener.memberChange(new ArrayList(oldMembers), new ArrayList(newMembers));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processChangeMain() throws Exception {
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            listener.changeMain();
        }
    }

    protected void processChangeSub() {
        Object[] tmpListeners = this.listeners.toArray();
        for (int i = 0; i < tmpListeners.length; ++i) {
            ClusterListener listener = (ClusterListener)tmpListeners[i];
            listener.changeSub();
        }
    }

    protected static class Window
    implements Comparable {
        private static final int HEADER_LENGTH = 12;
        public GlobalUID uid;
        public int sequence;
        public short windowCount;
        public short windowNo;
        public long receiveTime;
        public byte[] data;
        private List windows;

        protected Window() {
        }

        public List divide(int windowSize) throws IOException {
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.uid);
            oos.close();
            int uidLength = baos.size();
            if (this.data == null || this.data.length <= windowSize - 12 - uidLength) {
                dos.writeInt(this.sequence);
                dos.writeShort(1);
                dos.writeShort(0);
                dos.writeInt(this.data == null ? 0 : this.data.length);
                if (this.data != null && this.data.length != 0) {
                    dos.write(this.data, 0, this.data.length);
                }
                dos.flush();
                result.add(baos.toByteArray());
            } else {
                int offset = 0;
                short tmpWindowCount = (short)Math.ceil((double)this.data.length / (double)(windowSize - 12 - uidLength));
                for (short count = 0; count < tmpWindowCount; count = (short)(count + 1)) {
                    dos.writeInt(this.sequence);
                    dos.writeShort(tmpWindowCount);
                    dos.writeShort(count);
                    int dataLength = Math.min(windowSize - 12 - uidLength, this.data.length - offset);
                    dos.writeInt(dataLength);
                    if (dataLength != 0) {
                        dos.write(this.data, offset, dataLength);
                    }
                    dos.flush();
                    result.add(baos.toByteArray());
                    offset += dataLength;
                    if (count == tmpWindowCount - 1) continue;
                    baos.reset();
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(this.uid);
                    oos.close();
                }
            }
            return result;
        }

        public boolean addWindow(Window window) {
            if (this.isComplete()) {
                return true;
            }
            if (this.windows == null) {
                this.windows = new ArrayList(this.windowCount);
            }
            if (this.windows.size() == 0) {
                this.windows.add(this);
            }
            this.windows.add(window);
            if (this.windowCount <= this.windows.size()) {
                Collections.sort(this.windows);
                return true;
            }
            return false;
        }

        public byte[] getData() throws IOException {
            if (!this.isComplete()) {
                return null;
            }
            if (this.windows == null) {
                return this.data;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int imax = this.windows.size();
            for (int i = 0; i < imax; ++i) {
                Window w = (Window)this.windows.get(i);
                baos.write(w.data);
            }
            return baos.toByteArray();
        }

        public boolean isComplete() {
            return this.windowCount == 1 || this.windows != null && this.windowCount <= this.windows.size();
        }

        public void read(DataInputStream in) throws IOException, ClassNotFoundException {
            this.uid = (GlobalUID)new ObjectInputStream(in).readObject();
            this.sequence = in.readInt();
            this.windowCount = in.readShort();
            this.windowNo = in.readShort();
            int length = in.readInt();
            this.data = new byte[length];
            in.readFully(this.data, 0, length);
            this.receiveTime = System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Window)) {
                return false;
            }
            Window cmp = (Window)o;
            if (this.uid == null && cmp.uid != null || this.uid != null && !this.uid.equals(cmp.uid)) {
                return false;
            }
            return this.sequence == cmp.sequence;
        }

        public int hashCode() {
            return (this.uid == null ? 0 : this.uid.hashCode()) + this.sequence;
        }

        public int compareTo(Object o) {
            Window cmp = (Window)o;
            if (this.windowNo == cmp.windowNo) {
                return 0;
            }
            return this.windowNo > cmp.windowNo ? 1 : -1;
        }
    }

    protected static class ClusterEvent {
        public static final int EVENT_CHANGE_MAIN = 1;
        public static final int EVENT_CHANGE_SUB = 2;
        public static final int EVENT_MEMBER_INIT = 3;
        public static final int EVENT_MEMBER_CHANGE = 4;
        public final int event;
        public final List oldMembers;
        public final List newMembers;

        public ClusterEvent(int event) {
            this.event = event;
            this.oldMembers = null;
            this.newMembers = null;
        }

        public ClusterEvent(int event, List members) {
            this.event = event;
            this.oldMembers = null;
            this.newMembers = members;
        }

        public ClusterEvent(int event, List oldMembers, List newMembers) {
            this.event = event;
            this.oldMembers = oldMembers;
            this.newMembers = newMembers;
        }
    }

    protected class EventHandler
    implements DaemonRunnable {
        protected EventHandler() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            return ClusterService.this.eventQueue.get(1000L);
        }

        @Override
        public void consume(Object event, DaemonControl ctrl) {
            if (event == null) {
                return;
            }
            ClusterEvent clusterEvent = (ClusterEvent)event;
            switch (clusterEvent.event) {
                case 1: {
                    try {
                        ClusterService.this.processChangeMain();
                    }
                    catch (Exception e) {
                        ClusterService.this.getLogger().write("CLST_00003", ClusterService.this.getServiceNameObject(), (Throwable)e);
                    }
                    break;
                }
                case 2: {
                    ClusterService.this.processChangeSub();
                    break;
                }
                case 3: {
                    ClusterService.this.processMemberInit(clusterEvent.newMembers);
                    break;
                }
                case 4: {
                    ClusterService.this.processMemberChange(clusterEvent.oldMembers, clusterEvent.newMembers);
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class HeartBeater
    implements DaemonRunnable {
        protected long lastSendTime = -1L;
        protected int heartBeatFailedCount;
        protected GlobalUID targetMember;

        protected HeartBeater() {
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            ctrl.sleep(ClusterService.this.heartBeatInterval, false);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(Object received, DaemonControl ctrl) throws Throwable {
            block100: {
                Object object;
                if (!ClusterService.this.isJoin) {
                    return;
                }
                this.lastSendTime = System.currentTimeMillis();
                GlobalUID[] clients = null;
                if (ClusterService.this.isMain) {
                    ClusterService.this.sendMessage(5);
                    object = ClusterService.this.clientMembers;
                    synchronized (object) {
                        GlobalUID[] globalUIDArray = clients = ClusterService.this.clientMembers.size() == 0 ? null : ClusterService.this.clientMembers.values().toArray(new GlobalUID[ClusterService.this.clientMembers.size()]);
                        if (clients != null) {
                            for (int i = 0; i < clients.length; ++i) {
                                if (this.lastSendTime - ClusterService.this.heartBeatInterval * (long)ClusterService.this.heartBeatRetryCount <= clients[i].lastHeartBeatTime) continue;
                                ClusterService.this.clientMembers.remove(clients[i]);
                                ClusterService.this.getLogger().write("CLST_00009", new Object[]{ClusterService.this.getServiceNameObject(), clients[i]});
                            }
                        }
                    }
                }
                if (ClusterService.this.isMainRequesting && ClusterService.this.mainRequestingTime < this.lastSendTime - ClusterService.this.heartBeatInterval * (long)ClusterService.this.heartBeatRetryCount) {
                    object = ClusterService.this.mainReqMembers;
                    synchronized (object) {
                        if (ClusterService.this.isMainRequesting) {
                            ClusterService.this.mainRequestingTime = System.currentTimeMillis();
                        }
                    }
                    if (ClusterService.this.isMainRequesting) {
                        ClusterService.this.sendMessage(6);
                    }
                }
                GlobalUID member = null;
                Object i = ClusterService.this.members;
                synchronized (i) {
                    if (ClusterService.this.isClient) {
                        if (ClusterService.this.members.size() > 0) {
                            member = (GlobalUID)ClusterService.this.members.get(0);
                        }
                    } else if (ClusterService.this.members.size() > 1) {
                        int index = ClusterService.this.members.indexOf(ClusterService.this.uid);
                        if (index == -1) {
                            return;
                        }
                        index = index == ClusterService.this.members.size() - 1 ? 0 : ++index;
                        member = (GlobalUID)ClusterService.this.members.get(index);
                        if (!member.equals(this.targetMember)) {
                            this.heartBeatFailedCount = 0;
                        }
                    }
                }
                if (ClusterService.this.isClient && member == null) {
                    i = ClusterService.this.addMonitor;
                    synchronized (i) {
                        ClusterService.this.addMonitor.initMonitor();
                        ClusterService.this.sendMessage(1);
                        try {
                            ClusterService.this.addMonitor.waitMonitor(ClusterService.this.addMemberResponseTimeout);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                if (member != null && !member.equals(ClusterService.this.uid)) {
                    Object tmpOldMembers;
                    GlobalUID tmpLastReceiveUID = null;
                    long tmpLastReceiveTime = 0L;
                    Object object2 = ClusterService.this.lastReceiveUIDLockObj;
                    synchronized (object2) {
                        tmpLastReceiveUID = ClusterService.this.lastReceiveUID;
                        tmpLastReceiveTime = ClusterService.this.lastReceiveTime;
                    }
                    if (!ClusterService.this.isClient && tmpLastReceiveUID != null && tmpLastReceiveTime < this.lastSendTime - ClusterService.this.heartBeatInterval * (long)ClusterService.this.heartBeatRetryCount) {
                        object2 = ClusterService.this.lastReceiveUIDLockObj;
                        synchronized (object2) {
                            ClusterService.this.lastReceiveUID = null;
                            ClusterService.this.lastReceiveTime = -1L;
                        }
                        if (ClusterService.this.isMainRequesting) {
                            object2 = ClusterService.this.mainReqMembers;
                            synchronized (object2) {
                                ClusterService.this.mainReqMembers.remove(tmpLastReceiveUID);
                            }
                        }
                        boolean isMemberChange = false;
                        tmpOldMembers = null;
                        ArrayList tmpNewMembers = null;
                        Object object3 = ClusterService.this.members;
                        synchronized (object3) {
                            if (ClusterService.this.members.contains(tmpLastReceiveUID)) {
                                tmpOldMembers = new ArrayList(ClusterService.this.members);
                                ClusterService.this.members.remove(tmpLastReceiveUID);
                                if (ClusterService.this.multicastGroupAddress == null) {
                                    ClusterService.this.memberAddresses.remove(new InetSocketAddress(tmpLastReceiveUID.getAddress(), tmpLastReceiveUID.getUnicastPort()));
                                }
                                tmpNewMembers = new ArrayList(ClusterService.this.members);
                                isMemberChange = true;
                            }
                        }
                        if (isMemberChange) {
                            if (ClusterService.this.isMain && !ClusterService.this.isMainDoubt) {
                                ClusterService.this.getLogger().write("CLST_00006", new Object[]{ClusterService.this.getServiceNameObject(), tmpLastReceiveUID});
                                ClusterService.this.sendMessage(2);
                            } else if (!ClusterService.this.isClient) {
                                ClusterService.this.sendMessage(10, tmpLastReceiveUID, null);
                                if (ClusterService.this.members.indexOf(ClusterService.this.uid) == 0) {
                                    if (ClusterService.this.members.size() == 1) {
                                        ClusterService.this.isMain = true;
                                        ClusterService.this.isMainDoubt = false;
                                        object3 = ClusterService.this.mainReqMembers;
                                        synchronized (object3) {
                                            ClusterService.this.isMainRequesting = false;
                                        }
                                        object3 = ClusterService.this.clientMembers;
                                        synchronized (object3) {
                                            ClusterService.this.clientMembers.clear();
                                        }
                                        ClusterService.this.getLogger().write("CLST_00001", ClusterService.this.getServiceNameObject());
                                        ClusterService.this.eventQueue.push(new ClusterEvent(1));
                                    } else if (!ClusterService.this.isMainRequesting) {
                                        object3 = ClusterService.this.mainReqMembers;
                                        synchronized (object3) {
                                            if (!ClusterService.this.isMainRequesting) {
                                                ClusterService.this.mainReqMembers.clear();
                                                ClusterService.this.mainReqMembers.addAll(ClusterService.this.members);
                                                ClusterService.this.mainReqMembers.remove(ClusterService.this.uid);
                                                ClusterService.this.mainRequestingTime = System.currentTimeMillis();
                                                ClusterService.this.isMainRequesting = true;
                                            }
                                        }
                                        if (ClusterService.this.isMainRequesting) {
                                            ClusterService.this.sendMessage(6);
                                        }
                                    }
                                }
                            }
                            ClusterService.this.eventQueue.push(new ClusterEvent(4, (List)tmpOldMembers, tmpNewMembers));
                        }
                    }
                    this.targetMember = member;
                    try {
                        ArrayList tmpNewMembers;
                        ArrayList tmpOldMembers2;
                        boolean isNotify = false;
                        tmpOldMembers = ClusterService.this.helloMonitor;
                        synchronized (tmpOldMembers) {
                            ClusterService.this.helloTarget = member;
                            ClusterService.this.helloMonitor.initMonitor();
                            ClusterService.this.sendMessage(8, ClusterService.this.helloTarget);
                            try {
                                isNotify = ClusterService.this.helloMonitor.waitMonitor(ClusterService.this.heartBeatResponseTimeout);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        if (isNotify) {
                            this.heartBeatFailedCount = 0;
                            break block100;
                        }
                        ++this.heartBeatFailedCount;
                        if (this.heartBeatFailedCount - 1 < ClusterService.this.heartBeatRetryCount) break block100;
                        this.heartBeatFailedCount = 0;
                        if (ClusterService.this.isClient) {
                            isNotify = false;
                            tmpOldMembers = ClusterService.this.addMonitor;
                            synchronized (tmpOldMembers) {
                                ClusterService.this.addMonitor.initMonitor();
                                ClusterService.this.sendMessage(1);
                                try {
                                    isNotify = ClusterService.this.addMonitor.waitMonitor(ClusterService.this.addMemberResponseTimeout);
                                }
                                catch (InterruptedException e) {
                                    return;
                                }
                            }
                            if (isNotify) break block100;
                            boolean isMemberChange = false;
                            tmpOldMembers2 = null;
                            tmpNewMembers = null;
                            List list = ClusterService.this.members;
                            synchronized (list) {
                                if (ClusterService.this.members.size() != 0) {
                                    tmpOldMembers2 = new ArrayList(ClusterService.this.members);
                                    ClusterService.this.members.clear();
                                    ClusterService.this.memberAddresses.clear();
                                    tmpNewMembers = new ArrayList(ClusterService.this.members);
                                    isMemberChange = true;
                                }
                            }
                            if (isMemberChange) {
                                ClusterService.this.eventQueue.push(new ClusterEvent(4, tmpOldMembers2, tmpNewMembers));
                            }
                            break block100;
                        }
                        if (ClusterService.this.isMainRequesting) {
                            Set isMemberChange = ClusterService.this.mainReqMembers;
                            synchronized (isMemberChange) {
                                ClusterService.this.mainReqMembers.remove(member);
                            }
                        }
                        boolean isMemberChange = false;
                        tmpOldMembers2 = null;
                        tmpNewMembers = null;
                        List list = ClusterService.this.members;
                        synchronized (list) {
                            if (ClusterService.this.members.contains(member)) {
                                tmpOldMembers2 = new ArrayList(ClusterService.this.members);
                                ClusterService.this.members.remove(member);
                                if (ClusterService.this.multicastGroupAddress == null) {
                                    ClusterService.this.memberAddresses.remove(new InetSocketAddress(member.getAddress(), member.getUnicastPort()));
                                }
                                tmpNewMembers = new ArrayList(ClusterService.this.members);
                                isMemberChange = true;
                            }
                        }
                        if (isMemberChange) {
                            if (ClusterService.this.isMain && !ClusterService.this.isMainDoubt) {
                                ClusterService.this.getLogger().write("CLST_00006", new Object[]{ClusterService.this.getServiceNameObject(), member});
                                ClusterService.this.sendMessage(2);
                            } else if (!ClusterService.this.isClient) {
                                ClusterService.this.sendMessage(10, member, null);
                            }
                            ClusterService.this.eventQueue.push(new ClusterEvent(4, tmpOldMembers2, tmpNewMembers));
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    Object object4 = ClusterService.this.lastReceiveUIDLockObj;
                    synchronized (object4) {
                        ClusterService.this.lastReceiveUID = null;
                        ClusterService.this.lastReceiveTime = -1L;
                    }
                }
            }
        }

        @Override
        public void garbage() {
        }
    }

    protected class MessageReceiver
    implements DaemonRunnable {
        private Map windowMap = new LinkedHashMap();
        private DatagramSocket socket;

        public MessageReceiver(DatagramSocket socket) {
            this.socket = socket;
        }

        @Override
        public boolean onStart() {
            return true;
        }

        @Override
        public boolean onStop() {
            return true;
        }

        @Override
        public boolean onSuspend() {
            return true;
        }

        @Override
        public boolean onResume() {
            return true;
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            DatagramPacket packet = new DatagramPacket(new byte[ClusterService.this.receiveBufferSize], ClusterService.this.receiveBufferSize);
            try {
                this.socket.receive(packet);
                if (this.windowMap.size() != 0) {
                    long currentTime = System.currentTimeMillis();
                    Iterator itr = this.windowMap.values().iterator();
                    while (itr.hasNext()) {
                        Window window = (Window)itr.next();
                        if (currentTime - window.receiveTime <= ClusterService.this.lostTimeout) break;
                        itr.remove();
                    }
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(packet.getData(), 0, packet.getLength());
                DataInputStream dis = new DataInputStream(bais);
                Window window = new Window();
                window.read(dis);
                if (window.uid.isClient() && (ClusterService.this.isClient || !ClusterService.this.isMain || ClusterService.this.isMainDoubt)) {
                    return null;
                }
                if (window.isComplete()) {
                    return window;
                }
                Window tmp = (Window)this.windowMap.get(window);
                if (tmp == null) {
                    this.windowMap.put(window, window);
                    return null;
                }
                if (tmp.addWindow(window)) {
                    return this.windowMap.remove(tmp);
                }
                return null;
            }
            catch (SocketException e) {
                try {
                    ClusterService.this.connect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                ClusterService.this.getLogger().write("CLST_00004", ClusterService.this.getServiceNameObject(), (Throwable)e);
                return null;
            }
            catch (IOException e) {
                ClusterService.this.getLogger().write("CLST_00004", ClusterService.this.getServiceNameObject(), (Throwable)e);
                return null;
            }
        }

        @Override
        public void consume(Object received, DaemonControl ctrl) throws Throwable {
            Window window = (Window)received;
            if (window == null || !ClusterService.this.isJoin && !ClusterService.this.isJoining) {
                return;
            }
            ClusterService.this.handleMessage(window.uid, new ByteArrayInputStream(window.getData()));
        }

        @Override
        public void garbage() {
        }
    }

    public static class GlobalUID
    extends jp.ossc.nimbus.util.net.GlobalUID {
        private static final long serialVersionUID = 2185113122895103559L;
        protected Serializable option;
        protected int unicastPort = 0;
        protected boolean isClient;
        protected transient long lastHeartBeatTime;

        public GlobalUID() throws UnknownHostException {
        }

        public GlobalUID(String localAddress, Serializable option) throws UnknownHostException {
            super(localAddress);
            this.option = option;
        }

        public void setClient(boolean isClient) {
            this.isClient = isClient;
        }

        public boolean isClient() {
            return this.isClient;
        }

        public void setUnicastPort(int port) {
            this.unicastPort = port;
        }

        public int getUnicastPort() {
            return this.unicastPort;
        }

        public Object getOption() {
            return this.option;
        }

        public void setOption(Object opt) {
            this.option = (Serializable)opt;
        }

        public Object getOption(String key) {
            return this.option == null ? null : ((Map)((Object)this.option)).get(key);
        }

        public void setOption(String key, Object opt) {
            if (this.option == null) {
                this.option = new HashMap();
            }
            ((Map)((Object)this.option)).put(key, (Serializable)opt);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            GlobalUID cmp = (GlobalUID)obj;
            return this.unicastPort == cmp.unicastPort;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.unicastPort;
        }

        @Override
        public int compareTo(Object obj) {
            int result = super.compareTo(obj);
            if (result != 0) {
                return result;
            }
            GlobalUID cmp = (GlobalUID)obj;
            return this.unicastPort - cmp.unicastPort;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.option);
            out.writeInt(this.unicastPort);
            out.writeBoolean(this.isClient);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.option = (Serializable)in.readObject();
            this.unicastPort = in.readInt();
            this.isClient = in.readBoolean();
            this.lastHeartBeatTime = System.currentTimeMillis();
        }
    }
}

