/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive.tcp;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.keepalive.AbstractKeepAliveCheckerService;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.tcp.TcpKeepAliveCheckerServiceMBean;
import jp.ossc.nimbus.service.system.HostResolver;

public class TcpKeepAliveCheckerService
extends AbstractKeepAliveCheckerService
implements KeepAliveChecker,
TcpKeepAliveCheckerServiceMBean {
    private static final long serialVersionUID = 1L;
    protected HostResolver hostResolver;
    protected ServiceName hostResolverServiceName;
    protected String checkTargetAddress;
    protected int checkTargetPort = -1;
    protected int connectTimeOut = 1000;
    protected byte[] requestBytes;
    protected byte[] assertBytes;
    protected boolean isReturnCheckTargetTcpAddress = true;
    protected int responsePort = -1;
    protected InetSocketAddress socketAddress;

    @Override
    public ServiceName getHostResolverServiceName() {
        return this.hostResolverServiceName;
    }

    @Override
    public void setHostResolverServiceName(ServiceName serviceName) {
        this.hostResolverServiceName = serviceName;
    }

    @Override
    public HostResolver getHostResolver() {
        return this.hostResolver;
    }

    @Override
    public void setHostResolver(HostResolver resolver) {
        this.hostResolver = resolver;
    }

    @Override
    public String getCheckTargetAddress() {
        return this.checkTargetAddress;
    }

    @Override
    public void setCheckTargetAddress(String address) {
        this.checkTargetAddress = address;
    }

    @Override
    public int getCheckTargetPort() {
        return this.checkTargetPort;
    }

    @Override
    public void setCheckTargetPort(int port) {
        this.checkTargetPort = port;
    }

    @Override
    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    @Override
    public void setConnectTimeOut(int timeOut) {
        this.connectTimeOut = timeOut;
    }

    @Override
    public byte[] getRequestBytes() {
        return this.requestBytes;
    }

    @Override
    public void setRequestBytes(byte[] bytes) {
        this.requestBytes = bytes;
    }

    @Override
    public byte[] getAssertBytes() {
        return this.assertBytes;
    }

    @Override
    public void setAssertBytes(byte[] bytes) {
        this.assertBytes = bytes;
    }

    @Override
    public int getResponsePort() {
        return this.responsePort;
    }

    @Override
    public void setResponsePort(int port) {
        this.responsePort = port;
    }

    @Override
    public boolean isReturnCheckTargetTcpAddress() {
        return this.isReturnCheckTargetTcpAddress;
    }

    @Override
    public void setReturnCheckTargetTcpAddress(boolean isReturn) {
        this.isReturnCheckTargetTcpAddress = isReturn;
    }

    @Override
    public void startService() throws Exception {
        if (this.hostResolverServiceName != null) {
            this.hostResolver = (HostResolver)ServiceManagerFactory.getServiceObject(this.hostResolverServiceName);
        }
        if (this.checkTargetPort == -1) {
            throw new IllegalArgumentException("CheckTargetPort must be specified.");
        }
        InetSocketAddress inetSocketAddress = this.socketAddress = this.checkTargetAddress == null ? new InetSocketAddress(this.checkTargetPort) : new InetSocketAddress(this.checkTargetAddress, this.checkTargetPort);
        if (this.responsePort == -1) {
            this.responsePort = this.checkTargetPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAlive() throws Exception {
        Socket socket = new Socket();
        FilterOutputStream dos = null;
        FilterInputStream dis = null;
        try {
            socket.connect(this.socketAddress, this.connectTimeOut);
            if (this.requestBytes != null) {
                dos = new DataOutputStream(socket.getOutputStream());
            }
            if (this.assertBytes != null) {
                dis = new DataInputStream(socket.getInputStream());
            }
            if (dos != null) {
                dos.write(this.assertBytes);
            }
            if (dis != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                int length = 0;
                while ((length = ((DataInputStream)dis).read(bytes, 0, 1024)) != -1) {
                    baos.write(bytes, 0, length);
                }
                boolean bl = Arrays.equals(this.assertBytes, baos.toByteArray());
                return bl;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dos != null) {
                dos.close();
                dos = null;
            }
            if (dis != null) {
                dis.close();
                dis = null;
            }
            if (socket != null && socket.isConnected()) {
                socket.close();
                socket = null;
            }
        }
        return true;
    }

    @Override
    public Object getHostInfo() throws Exception {
        if (this.hostResolver == null) {
            return this.isReturnCheckTargetTcpAddress ? this.socketAddress : null;
        }
        InetAddress localAddress = this.hostResolver.getLocalHost();
        if (localAddress == null) {
            return this.isReturnCheckTargetTcpAddress ? this.socketAddress : null;
        }
        return new InetSocketAddress(localAddress.getHostAddress(), this.responsePort);
    }
}

