/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.performance;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnableAdaptor;
import jp.ossc.nimbus.service.performance.DefaultPerformanceRecorderServiceMBean;
import jp.ossc.nimbus.service.performance.PerformanceRecorder;
import jp.ossc.nimbus.service.writer.Category;
import jp.ossc.nimbus.service.writer.MessageWriteException;

public class DefaultPerformanceRecorderService
extends ServiceBase
implements PerformanceRecorder,
DefaultPerformanceRecorderServiceMBean {
    private static final long serialVersionUID = 2850022611534286801L;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private int initialCapacity = 10;
    private int maxThread = -1;
    private ServiceName categoryServiceName;
    private long resetInterval = 60000L;
    private boolean isOutputNoAccessTime = true;
    private boolean isOutputTimestamp = true;
    private boolean isOutputCount = true;
    private boolean isOutputBestPerformance = true;
    private boolean isOutputWorstPerformance = true;
    private boolean isOutputAveragePerformance = true;
    private boolean isOutputMedianPerformance = true;
    private boolean isOutputFirstTimestamp = true;
    private boolean isOutputLastTimestamp = true;
    private Category category;
    private ThreadLocal threadLocal;
    private Set performanceSet;
    private Daemon resetDaemon;

    @Override
    public void setResetInterval(long millis) {
        if (millis <= 0L) {
            throw new IllegalArgumentException("ResetInterval must be greater than 0. interval=" + millis);
        }
        this.resetInterval = millis;
    }

    @Override
    public long getResetInterval() {
        return this.resetInterval;
    }

    @Override
    public void setInitialCapacity(int capa) {
        if (capa <= 0) {
            throw new IllegalArgumentException("InitialCapacity must be greater than 0. interval=" + capa);
        }
        this.initialCapacity = capa;
    }

    @Override
    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public void setMaxThread(int max) {
        this.maxThread = max;
    }

    @Override
    public int getMaxThread() {
        return this.maxThread;
    }

    @Override
    public void setCategoryServiceName(ServiceName name) {
        this.categoryServiceName = name;
    }

    @Override
    public ServiceName getCategoryServiceName() {
        return this.categoryServiceName;
    }

    @Override
    public void setOutputNoAccessTime(boolean isOutput) {
        this.isOutputNoAccessTime = isOutput;
    }

    @Override
    public boolean isOutputNoAccessTime() {
        return this.isOutputNoAccessTime;
    }

    @Override
    public void setOutputTimestamp(boolean isOutput) {
        this.isOutputTimestamp = isOutput;
    }

    @Override
    public boolean isOutputTimestamp() {
        return this.isOutputTimestamp;
    }

    @Override
    public void setOutputCount(boolean isOutput) {
        this.isOutputCount = isOutput;
    }

    @Override
    public boolean isOutputCount() {
        return this.isOutputCount;
    }

    @Override
    public void setOutputBestPerformance(boolean isOutput) {
        this.isOutputBestPerformance = isOutput;
    }

    @Override
    public boolean isOutputBestPerformance() {
        return this.isOutputBestPerformance;
    }

    @Override
    public void setOutputWorstPerformance(boolean isOutput) {
        this.isOutputWorstPerformance = isOutput;
    }

    @Override
    public boolean isOutputWorstPerformance() {
        return this.isOutputWorstPerformance;
    }

    @Override
    public void setOutputAveragePerformance(boolean isOutput) {
        this.isOutputAveragePerformance = isOutput;
    }

    @Override
    public boolean isOutputAveragePerformance() {
        return this.isOutputAveragePerformance;
    }

    @Override
    public void setOutputMedianPerformance(boolean isOutput) {
        this.isOutputMedianPerformance = isOutput;
    }

    @Override
    public boolean isOutputMedianPerformance() {
        return this.isOutputMedianPerformance;
    }

    @Override
    public void setOutputFirstTimestamp(boolean isOutput) {
        this.isOutputFirstTimestamp = isOutput;
    }

    @Override
    public boolean isOutputFirstTimestamp() {
        return this.isOutputFirstTimestamp;
    }

    @Override
    public void setOutputLastTimestamp(boolean isOutput) {
        this.isOutputLastTimestamp = isOutput;
    }

    @Override
    public boolean isOutputLastTimestamp() {
        return this.isOutputLastTimestamp;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public void createService() throws Exception {
        this.performanceSet = Collections.synchronizedSet(new LinkedHashSet());
    }

    @Override
    public void startService() throws Exception {
        if (this.categoryServiceName != null) {
            this.category = (Category)ServiceManagerFactory.getServiceObject(this.categoryServiceName);
        }
        this.threadLocal = new ThreadLocal(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object initialValue() {
                Performance performance = new Performance();
                Set set = DefaultPerformanceRecorderService.this.performanceSet;
                synchronized (set) {
                    DefaultPerformanceRecorderService.this.performanceSet.add(performance);
                    if (DefaultPerformanceRecorderService.this.maxThread > 0 && DefaultPerformanceRecorderService.this.performanceSet.size() > DefaultPerformanceRecorderService.this.maxThread) {
                        Iterator itr = DefaultPerformanceRecorderService.this.performanceSet.iterator();
                        itr.next();
                        itr.remove();
                    }
                }
                return performance;
            }
        };
        this.resetDaemon = new Daemon(new ResetDaemonRunnable());
        this.resetDaemon.setName("Nimbus PerformanceRecorderWriter " + this.getServiceNameObject());
        this.resetDaemon.start();
    }

    @Override
    public void stopService() throws Exception {
        this.resetDaemon.stop();
        this.threadLocal = null;
        this.performanceSet.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.performanceSet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String display() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Performance[] performances = null;
        Set set = this.performanceSet;
        synchronized (set) {
            performances = this.performanceSet.toArray(new Performance[this.performanceSet.size()]);
        }
        Performance merged = new Performance();
        for (int i = 0; i < performances.length; ++i) {
            Performance committed = performances[i].commit();
            committed.reset(merged);
        }
        merged.calculate();
        pw.print("Count");
        pw.print("=");
        pw.println(merged.count);
        pw.print("Best");
        pw.print("=");
        pw.println(merged.minPerformance);
        pw.print("Worst");
        pw.print("=");
        pw.println(merged.maxPerformance);
        pw.print("Average");
        pw.print("=");
        pw.println(merged.averagePerformance);
        pw.print("Median");
        pw.print("=");
        pw.println(merged.medianPerformance);
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        pw.print("FirstTimestamp");
        pw.print("=");
        pw.println(merged.firstTime == -1L ? "-" : format.format(new Date(merged.firstTime)));
        pw.print("LastTimestamp");
        pw.print("=");
        pw.println(merged.lastTime == -1L ? "-" : format.format(new Date(merged.lastTime)));
        pw.flush();
        return sw.toString();
    }

    @Override
    public void record(long startTime, long endTime) {
        if (this.getState() != 3) {
            return;
        }
        if (this.threadLocal != null) {
            Performance p = (Performance)this.threadLocal.get();
            p.record(startTime, endTime);
        }
    }

    @Override
    public void recordValue(long timestamp, long value) {
        if (this.getState() != 3) {
            return;
        }
        if (this.threadLocal != null) {
            Performance p = (Performance)this.threadLocal.get();
            p.recordValue(timestamp, value);
        }
    }

    private class Performance
    implements Cloneable {
        private long[] performances;
        private int index;
        public long firstTime = -1L;
        public long lastTime = -1L;
        public double averagePerformance;
        public long medianPerformance;
        public long maxPerformance;
        public long minPerformance;
        public long count;

        public Performance() {
            this.performances = new long[DefaultPerformanceRecorderService.this.initialCapacity];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void record(long startTime, long endTime) {
            Performance performance = this;
            synchronized (performance) {
                if (this.performances.length <= this.index) {
                    this.grow(this.performances.length + 1);
                }
                this.performances[this.index++] = endTime - startTime;
                if (this.firstTime == -1L) {
                    this.firstTime = startTime;
                }
                this.lastTime = startTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordValue(long timestamp, long value) {
            Performance performance = this;
            synchronized (performance) {
                if (this.performances.length <= this.index) {
                    this.grow(this.performances.length + 1);
                }
                this.performances[this.index++] = value;
                if (this.firstTime == -1L) {
                    this.firstTime = timestamp;
                }
                this.lastTime = timestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void record(long performance) {
            Performance performance2 = this;
            synchronized (performance2) {
                if (this.performances.length <= this.index) {
                    this.grow(this.performances.length + 1);
                }
                this.performances[this.index++] = performance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(Performance merged) {
            int tmpIndex = 0;
            long[] tmpPerformances = null;
            Performance performance = this;
            synchronized (performance) {
                if (this.index == 0) {
                    return;
                }
                if (merged != null) {
                    if (merged.firstTime == -1L) {
                        merged.firstTime = this.firstTime;
                        merged.lastTime = this.lastTime;
                    } else {
                        merged.firstTime = Math.min(merged.firstTime, this.firstTime);
                        merged.lastTime = Math.max(merged.lastTime, this.lastTime);
                    }
                }
                tmpPerformances = this.performances;
                this.performances = new long[Math.max(DefaultPerformanceRecorderService.this.initialCapacity, this.index)];
                tmpIndex = this.index;
                this.index = 0;
                this.firstTime = -1L;
                this.lastTime = -1L;
            }
            if (merged != null) {
                for (int i = 0; i < tmpIndex; ++i) {
                    merged.record(tmpPerformances[i]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Performance commit() {
            Performance result = null;
            try {
                result = (Performance)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            Performance performance = this;
            synchronized (performance) {
                result.performances = new long[this.index];
                System.arraycopy(this.performances, 0, result.performances, 0, this.index);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calculate() {
            this.averagePerformance = 0.0;
            this.medianPerformance = 0L;
            this.maxPerformance = 0L;
            this.minPerformance = 0L;
            this.count = 0L;
            Performance performance = this;
            synchronized (performance) {
                if (this.index == 0) {
                    return;
                }
                long total = 0L;
                for (int i = 0; i < this.index; ++i) {
                    total += this.performances[i];
                    this.maxPerformance = Math.max(this.maxPerformance, this.performances[i]);
                    this.minPerformance = this.minPerformance == 0L ? this.performances[i] : Math.min(this.minPerformance, this.performances[i]);
                }
                this.count = this.index;
                this.averagePerformance = (double)total / (double)this.count;
                if (this.index == 1) {
                    this.medianPerformance = this.performances[0];
                } else {
                    Arrays.sort(this.performances, 0, this.index);
                    this.medianPerformance = this.performances[Math.round((float)this.index / 2.0f)];
                }
            }
        }

        private void grow(int minCapacity) {
            int oldCapacity = this.performances.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = this.hugeCapacity(minCapacity);
            }
            long[] newPerformances = new long[newCapacity];
            System.arraycopy(this.performances, 0, newPerformances, 0, this.performances.length);
            this.performances = newPerformances;
        }

        private int hugeCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }
    }

    private class ResetDaemonRunnable
    extends DaemonRunnableAdaptor {
        private long recordStartTime = -1L;

        private ResetDaemonRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            this.recordStartTime = System.currentTimeMillis();
            ctrl.sleep(DefaultPerformanceRecorderService.this.resetInterval, true);
            Set set = DefaultPerformanceRecorderService.this.performanceSet;
            synchronized (set) {
                return DefaultPerformanceRecorderService.this.performanceSet.size() == 0 ? null : DefaultPerformanceRecorderService.this.performanceSet.toArray(new Performance[DefaultPerformanceRecorderService.this.performanceSet.size()]);
            }
        }

        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            Performance[] performances = (Performance[])paramObj;
            Date timestamp = new Date(this.recordStartTime);
            Performance merged = new Performance();
            if (performances != null) {
                for (int i = 0; i < performances.length; ++i) {
                    performances[i].reset(merged);
                }
            }
            if (DefaultPerformanceRecorderService.this.category != null && (DefaultPerformanceRecorderService.this.isOutputNoAccessTime || merged.index != 0)) {
                merged.calculate();
                LinkedHashMap<String, Comparable<Date>> record = new LinkedHashMap<String, Comparable<Date>>();
                if (DefaultPerformanceRecorderService.this.isOutputTimestamp) {
                    record.put("Timestamp", timestamp);
                }
                if (DefaultPerformanceRecorderService.this.isOutputCount) {
                    record.put("Count", new Long(merged.count));
                }
                if (DefaultPerformanceRecorderService.this.isOutputBestPerformance) {
                    record.put("Best", new Long(merged.minPerformance));
                }
                if (DefaultPerformanceRecorderService.this.isOutputWorstPerformance) {
                    record.put("Worst", new Long(merged.maxPerformance));
                }
                if (DefaultPerformanceRecorderService.this.isOutputAveragePerformance) {
                    record.put("Average", new Double(merged.averagePerformance));
                }
                if (DefaultPerformanceRecorderService.this.isOutputMedianPerformance) {
                    record.put("Median", new Long(merged.medianPerformance));
                }
                if (DefaultPerformanceRecorderService.this.isOutputFirstTimestamp) {
                    record.put("FirstTimestamp", merged.firstTime == -1L ? null : new Date(merged.firstTime));
                }
                if (DefaultPerformanceRecorderService.this.isOutputLastTimestamp) {
                    record.put("LastTimestamp", merged.lastTime == -1L ? null : new Date(merged.lastTime));
                }
                try {
                    DefaultPerformanceRecorderService.this.category.write(record);
                }
                catch (MessageWriteException messageWriteException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void garbage() {
            Performance[] performances = null;
            Set set = DefaultPerformanceRecorderService.this.performanceSet;
            synchronized (set) {
                performances = DefaultPerformanceRecorderService.this.performanceSet.size() == 0 ? null : DefaultPerformanceRecorderService.this.performanceSet.toArray(new Performance[DefaultPerformanceRecorderService.this.performanceSet.size()]);
            }
            try {
                this.consume(performances, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

