/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ClusterClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ClusterClientConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.publish.ClusterClientConnectionImpl;
import jp.ossc.nimbus.service.publish.ClusterConnectionFactoryService;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageSendException;

public class ClusterClientConnectionFactoryService
extends ServiceBase
implements ClientConnectionFactory,
ClusterClientConnectionFactoryServiceMBean {
    private static final long serialVersionUID = -3980354944166812867L;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private String clusterOptionKey;
    private String connectErrorMessageId = "PCCF_00001";
    private boolean isFlexibleConnect;

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setClusterOptionKey(String key) {
        this.clusterOptionKey = key;
    }

    @Override
    public String getClusterOptionKey() {
        return this.clusterOptionKey;
    }

    @Override
    public void setFlexibleConnect(boolean isFlexible) {
        this.isFlexibleConnect = isFlexible;
    }

    @Override
    public boolean isFlexibleConnect() {
        return this.isFlexibleConnect;
    }

    @Override
    public void setConnectErrorMessageId(String id) {
        this.connectErrorMessageId = id;
    }

    @Override
    public String getConnectErrorMessageId() {
        return this.connectErrorMessageId;
    }

    @Override
    public void startService() throws Exception {
        if (this.clusterServiceName != null) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
        }
        if (this.cluster == null) {
            throw new IllegalArgumentException("ClusterService is null.");
        }
    }

    @Override
    public void stopService() throws Exception {
    }

    @Override
    public ClientConnection getClientConnection() throws ConnectionCreateException {
        FlexibleClusterClientConnection clientConnection = new FlexibleClusterClientConnection();
        clientConnection.setServiceManagerName(this.getServiceManagerName());
        this.cluster.addClusterListener(clientConnection);
        return clientConnection;
    }

    @Override
    public int getClientCount() throws RemoteException {
        int count = 0;
        List members = this.cluster.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            ClusterService.GlobalUID uid = (ClusterService.GlobalUID)members.get(i);
            ClusterConnectionFactoryService.ClusterOption clusterOption = (ClusterConnectionFactoryService.ClusterOption)(this.clusterOptionKey == null ? uid.getOption() : uid.getOption(this.clusterOptionKey));
            ClusterClientConnectionFactory clientConnectionFactory = clusterOption.clusterClientConnectionFactory;
            count += clientConnectionFactory.getClientCount();
        }
        return count;
    }

    public class FlexibleClusterClientConnection
    implements ClientConnection,
    ClusterListener {
        private String serviceManagerName;
        private ClientConnection connection;
        private Object id;
        private boolean isConnected;
        private Map subjects;
        private boolean isStartReceived;
        private long from = -1L;
        private MessageListener messageListener;

        @Override
        public void setServiceManagerName(String name) {
            this.serviceManagerName = name;
        }

        @Override
        public void connect() throws ConnectException {
            this.connect(null);
        }

        @Override
        public void connect(Object id) throws ConnectException {
            if (this.connection == null) {
                ClusterService.GlobalUID uid;
                List members = ClusterClientConnectionFactoryService.this.cluster.getMembers();
                ClusterService.GlobalUID globalUID = uid = members.size() == 0 ? null : (ClusterService.GlobalUID)members.get(0);
                if (uid == null) {
                    if (!ClusterClientConnectionFactoryService.this.isFlexibleConnect) {
                        throw new ConnectException("No cluster member.");
                    }
                } else {
                    ClusterConnectionFactoryService.ClusterOption clusterOption = (ClusterConnectionFactoryService.ClusterOption)(ClusterClientConnectionFactoryService.this.clusterOptionKey == null ? uid.getOption() : uid.getOption(ClusterClientConnectionFactoryService.this.clusterOptionKey));
                    ClusterClientConnectionFactory clientConnectionFactory = clusterOption.clusterClientConnectionFactory;
                    try {
                        this.connection = clientConnectionFactory.getClientConnection();
                        ((ClusterClientConnectionImpl)this.connection).setCluster(ClusterClientConnectionFactoryService.this.cluster);
                        ((ClusterClientConnectionImpl)this.connection).setClusterOptionKey(ClusterClientConnectionFactoryService.this.clusterOptionKey);
                        ((ClusterClientConnectionImpl)this.connection).setFlexibleConnect(ClusterClientConnectionFactoryService.this.isFlexibleConnect);
                    }
                    catch (RemoteException e) {
                        throw new ConnectException(e);
                    }
                    catch (ConnectionCreateException e) {
                        throw new ConnectException(e);
                    }
                }
            }
            if (this.connection != null) {
                if (!this.connection.isConnected()) {
                    this.connection.setServiceManagerName(this.serviceManagerName);
                    this.connection.connect(id);
                }
                try {
                    if (this.subjects != null) {
                        Object[] subjectArray = this.subjects.keySet().toArray();
                        for (int j = 0; j < subjectArray.length; ++j) {
                            Object subject = subjectArray[j];
                            Set keySet = (Set)this.subjects.get(subject);
                            if (keySet == null) continue;
                            String[] keys = keySet.toArray(new String[keySet.size()]);
                            boolean containsNull = false;
                            ArrayList<String> keyList = new ArrayList<String>();
                            for (int k = 0; k < keys.length; ++k) {
                                if (keys[k] == null) {
                                    containsNull = true;
                                    continue;
                                }
                                keyList.add(keys[k]);
                            }
                            if (containsNull) {
                                this.connection.addSubject((String)subject);
                                keys = keyList.toArray(new String[keyList.size()]);
                            }
                            if (keys == null || keys.length == 0) continue;
                            this.connection.addSubject((String)subject, keys);
                        }
                        this.subjects = null;
                    }
                    this.connection.setMessageListener(this.messageListener);
                    if (this.isStartReceived && !this.connection.isStartReceive()) {
                        this.connection.startReceive(this.from);
                    }
                }
                catch (MessageSendException e) {
                    throw new ConnectException(e);
                }
            }
            this.id = id;
            this.isConnected = true;
        }

        @Override
        public void addSubject(String subject) throws MessageSendException {
            this.addSubject(subject, null);
        }

        @Override
        public void addSubject(String subject, String[] keys) throws MessageSendException {
            if (!this.isConnected) {
                throw new MessageSendException("Not connected.");
            }
            if (this.connection == null) {
                Set<Object> keySet;
                if (this.subjects == null) {
                    this.subjects = Collections.synchronizedMap(new HashMap());
                }
                if ((keySet = (Set<Object>)this.subjects.get(subject)) == null) {
                    keySet = Collections.synchronizedSet(new HashSet());
                    this.subjects.put(subject, keySet);
                }
                if (keys == null) {
                    keySet.add(null);
                } else {
                    for (int i = 0; i < keys.length; ++i) {
                        keySet.add(keys[i]);
                    }
                }
            } else {
                this.connection.addSubject(subject, keys);
            }
        }

        @Override
        public void removeSubject(String subject) throws MessageSendException {
            this.removeSubject(subject, null);
        }

        @Override
        public void removeSubject(String subject, String[] keys) throws MessageSendException {
            if (!this.isConnected) {
                throw new MessageSendException("Not connected.");
            }
            if (this.connection == null) {
                Set keySet;
                if (this.subjects != null && (keySet = (Set)this.subjects.get(subject)) != null) {
                    if (keys == null) {
                        keySet.remove(null);
                    } else {
                        for (int i = 0; i < keys.length; ++i) {
                            keySet.remove(keys[i]);
                        }
                    }
                    if (keySet.size() == 0) {
                        this.subjects.remove(subject);
                    }
                }
            } else {
                this.connection.removeSubject(subject, keys);
            }
        }

        @Override
        public void startReceive() throws MessageSendException {
            this.startReceive(-1L);
        }

        @Override
        public void startReceive(long from) throws MessageSendException {
            if (!this.isConnected) {
                throw new MessageSendException("Not connected.");
            }
            if (this.connection != null) {
                this.connection.startReceive(from);
            }
            this.isStartReceived = true;
            this.from = from;
        }

        @Override
        public void stopReceive() throws MessageSendException {
            if (!this.isConnected) {
                return;
            }
            this.isStartReceived = false;
            this.from = -1L;
            if (this.connection != null) {
                this.connection.stopReceive();
            }
        }

        @Override
        public boolean isStartReceive() {
            return this.isStartReceived;
        }

        @Override
        public Set getSubjects() {
            if (this.connection == null) {
                return this.subjects == null ? new HashSet() : new HashSet(this.subjects.keySet());
            }
            return this.connection.getSubjects();
        }

        @Override
        public Set getKeys(String subject) {
            if (this.connection == null) {
                return this.subjects == null ? new HashSet() : (Set)this.subjects.get(subject);
            }
            return this.connection.getKeys(subject);
        }

        @Override
        public void setMessageListener(MessageListener listener) {
            if (this.connection != null) {
                this.connection.setMessageListener(listener);
            }
            this.messageListener = listener;
        }

        @Override
        public boolean isConnected() {
            if (this.connection != null) {
                return this.connection.isConnected();
            }
            return this.isConnected;
        }

        @Override
        public boolean isServerClosed() {
            if (this.connection != null) {
                return this.connection.isServerClosed();
            }
            return false;
        }

        @Override
        public Object getId() {
            return this.connection == null ? this.id : this.connection.getId();
        }

        @Override
        public void close() {
            ClusterClientConnectionFactoryService.this.cluster.removeClusterListener(this);
            if (this.connection != null) {
                this.connection.close();
            }
            this.isConnected = false;
        }

        @Override
        public void memberInit(Object myId, List members) {
            block3: {
                if (members.size() != 0 && this.connection == null && this.isConnected) {
                    try {
                        this.connect(this.id);
                    }
                    catch (ConnectException e) {
                        if (ClusterClientConnectionFactoryService.this.connectErrorMessageId == null) break block3;
                        ServiceManagerFactory.getLogger().write(ClusterClientConnectionFactoryService.this.connectErrorMessageId, new Object[]{this.connection}, (Throwable)e);
                    }
                }
            }
        }

        @Override
        public void memberChange(List oldMembers, List newMembers) {
            block3: {
                if (newMembers.size() != 0 && this.connection == null && this.isConnected) {
                    try {
                        this.connect(this.id);
                    }
                    catch (ConnectException e) {
                        if (ClusterClientConnectionFactoryService.this.connectErrorMessageId == null) break block3;
                        ServiceManagerFactory.getLogger().write(ClusterClientConnectionFactoryService.this.connectErrorMessageId, new Object[]{this.connection}, (Throwable)e);
                    }
                }
            }
        }

        @Override
        public void changeMain() throws Exception {
        }

        @Override
        public void changeSub() {
        }
    }
}

