/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.util.net.GlobalUID;

public class DistributedClientConnectionImpl
implements ClientConnection,
Serializable {
    private static final long serialVersionUID = -582594445717006869L;
    private List connectionList = new ArrayList();
    private Object id;
    private transient String serviceManagerName;
    private QueueHandlerContainerService parallelRequestQueueHandlerContainer;

    public void addClientConnection(ClientConnection connection) {
        this.connectionList.add(connection);
    }

    @Override
    public void setServiceManagerName(String name) {
        this.serviceManagerName = name;
    }

    @Override
    public void connect() throws ConnectException {
        this.connect(null);
    }

    @Override
    public void connect(Object id) throws ConnectException {
        Object tmpId = null;
        if (id == null) {
            try {
                tmpId = new GlobalUID();
            }
            catch (UnknownHostException e) {
                throw new ConnectException(e);
            }
        } else {
            tmpId = id;
        }
        if (this.connectionList.size() > 1) {
            try {
                this.parallelRequestQueueHandlerContainer = new QueueHandlerContainerService();
                this.parallelRequestQueueHandlerContainer.create();
                this.parallelRequestQueueHandlerContainer.setQueueHandlerSize(this.connectionList.size());
                DefaultQueueService parallelRequestQueue = new DefaultQueueService();
                parallelRequestQueue.create();
                parallelRequestQueue.start();
                this.parallelRequestQueueHandlerContainer.setQueueService(parallelRequestQueue);
                this.parallelRequestQueueHandlerContainer.setQueueHandler(new ParallelRequestQueueHandler());
                this.parallelRequestQueueHandlerContainer.setIgnoreNullElement(true);
                this.parallelRequestQueueHandlerContainer.setWaitTimeout(1000L);
                this.parallelRequestQueueHandlerContainer.start();
            }
            catch (Exception e) {
                throw new ConnectException(e);
            }
        }
        if (this.parallelRequestQueueHandlerContainer == null) {
            int imax = this.connectionList.size();
            for (int i = 0; i < imax; ++i) {
                ClientConnection connection = (ClientConnection)this.connectionList.get(i);
                connection.setServiceManagerName(this.serviceManagerName);
                connection.connect(tmpId);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception imax) {
                // empty catch block
            }
            responseQueue.accept();
            int imax = this.connectionList.size();
            for (i = 0; i < imax; ++i) {
                asynchContext = new AsynchContext(new ConnectParallelRequest((ClientConnection)this.connectionList.get(i), tmpId), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            imax = this.connectionList.size();
            for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (ConnectException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new ConnectException(th);
                }
            }
        }
        this.id = tmpId;
    }

    @Override
    public void addSubject(String subject) throws MessageSendException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            int imax = this.connectionList.size();
            for (int i = 0; i < imax; ++i) {
                ((ClientConnection)this.connectionList.get(i)).addSubject(subject);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception imax) {
                // empty catch block
            }
            responseQueue.accept();
            int imax = this.connectionList.size();
            for (i = 0; i < imax; ++i) {
                asynchContext = new AsynchContext(new AddSubjectParallelRequest((ClientConnection)this.connectionList.get(i), subject), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            imax = this.connectionList.size();
            for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (MessageSendException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new MessageSendException(th);
                }
            }
        }
    }

    @Override
    public void addSubject(String subject, String[] keys) throws MessageSendException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            int imax = this.connectionList.size();
            for (int i = 0; i < imax; ++i) {
                ((ClientConnection)this.connectionList.get(i)).addSubject(subject, keys);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception imax) {
                // empty catch block
            }
            responseQueue.accept();
            int imax = this.connectionList.size();
            for (i = 0; i < imax; ++i) {
                asynchContext = new AsynchContext(new AddSubjectParallelRequest((ClientConnection)this.connectionList.get(i), subject, keys), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            imax = this.connectionList.size();
            for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (MessageSendException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new MessageSendException(th);
                }
            }
        }
    }

    @Override
    public void removeSubject(String subject) throws MessageSendException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            int imax = this.connectionList.size();
            for (int i = 0; i < imax; ++i) {
                ((ClientConnection)this.connectionList.get(i)).removeSubject(subject);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception imax) {
                // empty catch block
            }
            responseQueue.accept();
            int imax = this.connectionList.size();
            for (i = 0; i < imax; ++i) {
                asynchContext = new AsynchContext(new RemoveSubjectParallelRequest((ClientConnection)this.connectionList.get(i), subject), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            imax = this.connectionList.size();
            for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (MessageSendException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new MessageSendException(th);
                }
            }
        }
    }

    @Override
    public void removeSubject(String subject, String[] keys) throws MessageSendException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            int imax = this.connectionList.size();
            for (int i = 0; i < imax; ++i) {
                ((ClientConnection)this.connectionList.get(i)).removeSubject(subject, keys);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception imax) {
                // empty catch block
            }
            responseQueue.accept();
            int imax = this.connectionList.size();
            for (i = 0; i < imax; ++i) {
                asynchContext = new AsynchContext(new RemoveSubjectParallelRequest((ClientConnection)this.connectionList.get(i), subject, keys), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            imax = this.connectionList.size();
            for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (MessageSendException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new MessageSendException(th);
                }
            }
        }
    }

    @Override
    public void startReceive() throws MessageSendException {
        this.startReceive(-1L);
    }

    @Override
    public void startReceive(long from) throws MessageSendException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            int imax = this.connectionList.size();
            for (int i = 0; i < imax; ++i) {
                ((ClientConnection)this.connectionList.get(i)).startReceive(from);
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception imax) {
                // empty catch block
            }
            responseQueue.accept();
            int imax = this.connectionList.size();
            for (i = 0; i < imax; ++i) {
                asynchContext = new AsynchContext(new StartReceiveParallelRequest((ClientConnection)this.connectionList.get(i), from), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            imax = this.connectionList.size();
            for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (MessageSendException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new MessageSendException(th);
                }
            }
        }
    }

    @Override
    public boolean isStartReceive() {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            if (((ClientConnection)this.connectionList.get(i)).isStartReceive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stopReceive() throws MessageSendException {
        if (this.parallelRequestQueueHandlerContainer == null) {
            int imax = this.connectionList.size();
            for (int i = 0; i < imax; ++i) {
                ((ClientConnection)this.connectionList.get(i)).stopReceive();
            }
        } else {
            AsynchContext asynchContext;
            int i;
            DefaultQueueService responseQueue = new DefaultQueueService();
            try {
                responseQueue.create();
                responseQueue.start();
            }
            catch (Exception imax) {
                // empty catch block
            }
            responseQueue.accept();
            int imax = this.connectionList.size();
            for (i = 0; i < imax; ++i) {
                asynchContext = new AsynchContext(new StopReceiveParallelRequest((ClientConnection)this.connectionList.get(i)), responseQueue);
                this.parallelRequestQueueHandlerContainer.push(asynchContext);
            }
            imax = this.connectionList.size();
            for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                try {
                    asynchContext.checkError();
                    continue;
                }
                catch (MessageSendException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw new MessageSendException(th);
                }
            }
        }
    }

    @Override
    public Set getSubjects() {
        HashSet result = new HashSet();
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            result.addAll(((ClientConnection)this.connectionList.get(i)).getSubjects());
        }
        return result;
    }

    @Override
    public Set getKeys(String subject) {
        HashSet result = new HashSet();
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            result.addAll(((ClientConnection)this.connectionList.get(i)).getKeys(subject));
        }
        return result;
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ((ClientConnection)this.connectionList.get(i)).setMessageListener(listener);
        }
    }

    @Override
    public boolean isConnected() {
        return this.id != null;
    }

    @Override
    public boolean isServerClosed() {
        if (this.connectionList == null || this.connectionList.size() == 0) {
            return false;
        }
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            if (((ClientConnection)this.connectionList.get(i)).isServerClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getId() {
        if (this.connectionList == null || this.connectionList.size() == 0) {
            return this.id;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int imax = this.connectionList.size();
        for (int i = 0; i < imax; ++i) {
            ClientConnection connection = (ClientConnection)this.connectionList.get(i);
            if (connection.getId() == null) continue;
            result.add(connection.getId());
        }
        return result.size() == 0 ? this.id : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.parallelRequestQueueHandlerContainer == null) {
                int imax = this.connectionList.size();
                for (int i = 0; i < imax; ++i) {
                    try {
                        ((ClientConnection)this.connectionList.get(i)).close();
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            } else {
                AsynchContext asynchContext;
                int i;
                DefaultQueueService responseQueue = new DefaultQueueService();
                try {
                    responseQueue.create();
                    responseQueue.start();
                }
                catch (Exception imax) {
                    // empty catch block
                }
                responseQueue.accept();
                int imax = this.connectionList.size();
                for (i = 0; i < imax; ++i) {
                    asynchContext = new AsynchContext(new CloseParallelRequest((ClientConnection)this.connectionList.get(i)), responseQueue);
                    this.parallelRequestQueueHandlerContainer.push(asynchContext);
                }
                imax = this.connectionList.size();
                for (i = 0; i < imax && (asynchContext = (AsynchContext)responseQueue.get()) != null; ++i) {
                    try {
                        asynchContext.checkError();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.parallelRequestQueueHandlerContainer != null) {
                this.parallelRequestQueueHandlerContainer.stop();
                this.parallelRequestQueueHandlerContainer.destroy();
                this.parallelRequestQueueHandlerContainer = null;
            }
        }
        finally {
            this.id = null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(", connectionList=").append(this.connectionList);
        buf.append('}');
        return buf.toString();
    }

    protected class ParallelRequestQueueHandler
    implements QueueHandler {
        protected ParallelRequestQueueHandler() {
        }

        @Override
        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            AsynchContext ac = (AsynchContext)obj;
            ac.setOutput(((ParallelRequest)ac.getInput()).execute());
            ac.getResponseQueue().push(ac);
        }

        @Override
        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return false;
        }

        @Override
        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            ac.setThrowable(th);
            ac.getResponseQueue().push(ac);
        }
    }

    protected class CloseParallelRequest
    extends ParallelRequest {
        public CloseParallelRequest(ClientConnection connection) {
            super(connection);
        }

        @Override
        public Object execute() throws Throwable {
            this.connection.close();
            return null;
        }
    }

    protected class StopReceiveParallelRequest
    extends ParallelRequest {
        public StopReceiveParallelRequest(ClientConnection connection) {
            super(connection);
        }

        @Override
        public Object execute() throws Throwable {
            this.connection.stopReceive();
            return null;
        }
    }

    protected class StartReceiveParallelRequest
    extends ParallelRequest {
        protected long from;

        public StartReceiveParallelRequest(ClientConnection connection, long from) {
            super(connection);
            this.from = from;
        }

        @Override
        public Object execute() throws Throwable {
            this.connection.startReceive(this.from);
            return null;
        }
    }

    protected class RemoveSubjectParallelRequest
    extends ParallelRequest {
        protected String subject;
        protected String[] keys;

        public RemoveSubjectParallelRequest(ClientConnection connection, String subject) {
            this(connection, subject, null);
        }

        public RemoveSubjectParallelRequest(ClientConnection connection, String subject, String[] keys) {
            super(connection);
            this.subject = subject;
            this.keys = keys;
        }

        @Override
        public Object execute() throws Throwable {
            if (this.keys == null) {
                this.connection.removeSubject(this.subject);
            } else {
                this.connection.removeSubject(this.subject, this.keys);
            }
            return null;
        }
    }

    protected class AddSubjectParallelRequest
    extends ParallelRequest {
        protected String subject;
        protected String[] keys;

        public AddSubjectParallelRequest(ClientConnection connection, String subject) {
            this(connection, subject, null);
        }

        public AddSubjectParallelRequest(ClientConnection connection, String subject, String[] keys) {
            super(connection);
            this.subject = subject;
            this.keys = keys;
        }

        @Override
        public Object execute() throws Throwable {
            if (this.keys == null) {
                this.connection.addSubject(this.subject);
            } else {
                this.connection.addSubject(this.subject, this.keys);
            }
            return null;
        }
    }

    protected class ConnectParallelRequest
    extends ParallelRequest {
        protected Object id;

        public ConnectParallelRequest(ClientConnection connection, Object id) {
            super(connection);
            this.id = id;
        }

        @Override
        public Object execute() throws Throwable {
            this.connection.setServiceManagerName(DistributedClientConnectionImpl.this.serviceManagerName);
            this.connection.connect(this.id);
            return null;
        }
    }

    protected abstract class ParallelRequest {
        protected ClientConnection connection;

        public ParallelRequest(ClientConnection connection) {
            this.connection = connection;
        }

        public abstract Object execute() throws Throwable;
    }
}

