/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.context.NoConnectServerException;
import jp.ossc.nimbus.service.context.SharedContextSendException;
import jp.ossc.nimbus.service.context.SharedContextService;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.RequestTimeoutException;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.SharedQueueServiceMBean;
import jp.ossc.nimbus.service.sequence.StringSequenceService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class SharedQueueService
extends SharedContextService
implements Queue,
SharedQueueServiceMBean {
    private static final long serialVersionUID = -3323923547429465815L;
    protected static final EmptyElement EMPTY = new EmptyElement();
    protected long sleepTime = 10000L;
    protected int maxThresholdSize = -1;
    protected SynchronizeMonitor pushMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor getMonitor = new WaitSynchronizeMonitor();
    protected SynchronizeMonitor peekMonitor = new WaitSynchronizeMonitor();
    protected final Object lock = "lock";
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;
    protected long maxDepth = 0L;
    protected boolean isSafeGetOrder = false;
    protected Class synchronizeMonitorClass = WaitSynchronizeMonitor.class;
    protected StringSequenceService sequence;
    protected String sequenceTimestampFormat = "yyyyMMddHHmmssSSS";
    protected int sequenceDigit = 5;
    protected int seekDepth = 2;

    @Override
    public void setSynchronizeMonitorClass(Class clazz) {
        this.synchronizeMonitorClass = clazz;
    }

    @Override
    public Class getSynchronizeMonitorClass() {
        return this.synchronizeMonitorClass;
    }

    @Override
    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    @Override
    public long getSleepTime() {
        return this.sleepTime;
    }

    @Override
    public void setMaxThresholdSize(int size) {
        this.maxThresholdSize = size;
    }

    @Override
    public int getMaxThresholdSize() {
        return this.maxThresholdSize;
    }

    @Override
    public boolean isSafeGetOrder() {
        return this.isSafeGetOrder;
    }

    @Override
    public void setSafeGetOrder(boolean isSafe) {
        this.isSafeGetOrder = isSafe;
    }

    @Override
    public void setSequenceTimestampFormat(String format) {
        this.sequenceTimestampFormat = format;
    }

    @Override
    public String getSequenceTimestampFormat() {
        return this.sequenceTimestampFormat;
    }

    @Override
    public void setSequenceDigit(int digit) {
        this.sequenceDigit = digit;
    }

    @Override
    public int getSequenceDigit() {
        return this.sequenceDigit;
    }

    @Override
    public void setSeekDepth(int size) {
        this.seekDepth = size;
    }

    @Override
    public int getSeekDepth() {
        return this.seekDepth;
    }

    @Override
    public void startService() throws Exception {
        this.sequence = new StringSequenceService();
        this.sequence.create();
        this.sequence.setFormat("TIME_SEQ(" + this.sequenceTimestampFormat + "," + this.sequenceDigit + ")");
        this.sequence.start();
        if (!WaitSynchronizeMonitor.class.equals((Object)this.synchronizeMonitorClass)) {
            this.pushMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.getMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
            this.peekMonitor = (SynchronizeMonitor)this.synchronizeMonitorClass.newInstance();
        }
        super.startService();
        this.accept();
    }

    @Override
    public void stopService() throws Exception {
        this.release();
        super.stopService();
    }

    @Override
    protected Map createContext() {
        return Collections.synchronizedSortedMap(new TreeMap());
    }

    @Override
    public void push(Object item) {
        this.push(item, -1L);
    }

    @Override
    public boolean push(Object item, long timeout) {
        return this.pushElement(item, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pushElement(Object element, long timeout) {
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        long startTime = System.currentTimeMillis();
        long processTime = 0L;
        if (this.maxThresholdSize > 0 && (this.pushMonitor.isWait() || this.size() >= this.maxThresholdSize) && !this.fourceEndFlg) {
            while (this.size() >= this.maxThresholdSize && !this.fourceEndFlg) {
                long proc = 0L;
                if (timeout >= 0L) {
                    proc = System.currentTimeMillis();
                }
                try {
                    long curSleepTime;
                    long l = curSleepTime = timeout >= 0L ? timeout - processTime : this.sleepTime;
                    if (timeout == 0L || curSleepTime <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    if (timeout < 0L) {
                        this.pushMonitor.initAndWaitMonitor(curSleepTime);
                        continue;
                    }
                    if (this.pushMonitor.initAndWaitMonitor(curSleepTime) || timeout < 0L || (processTime += (proc = System.currentTimeMillis() - proc)) <= timeout) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (InterruptedException e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.pushMonitor.releaseMonitor();
                }
            }
        }
        if (timeout > 0L && (timeout -= System.currentTimeMillis() - startTime) <= 0L) {
            return false;
        }
        String id = this.sequence.increment() + this.getId();
        this.lock(id);
        try {
            this.put(id, element, timeout);
            this.pushAfter();
        }
        finally {
            this.unlock(id);
        }
        return true;
    }

    protected void pushAfter() {
        if (!this.isClient) {
            int size = this.size();
            if ((long)size > this.maxDepth) {
                this.maxDepth = size;
            }
            ++this.count;
            ++this.countDelta;
            this.lastPushedTime = System.currentTimeMillis();
        }
        this.peekMonitor.notifyAllMonitor();
        if (this.isSafeGetOrder) {
            this.getMonitor.notifyMonitor();
        } else {
            this.getMonitor.notifyAllMonitor();
        }
        if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
            this.pushMonitor.notifyMonitor();
        }
    }

    protected void getAfter() {
        if (this.pushMonitor.isWait() && this.size() < this.maxThresholdSize) {
            this.pushMonitor.notifyMonitor();
        }
    }

    @Override
    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        if (this.isClient) {
            throw new UnsupportedOperationException();
        }
        long processTime = 0L;
        try {
            Object ret;
            if (isRemove) {
                this.getMonitor.initMonitor();
            } else {
                this.peekMonitor.initMonitor();
            }
            while (!this.fourceEndFlg) {
                if (this.size() > 0) {
                    if (!isRemove || !this.isSafeGetOrder || this.getMonitor.isFirst()) {
                        ret = this.getQueueElement(isRemove);
                        if (ret == EMPTY) continue;
                        if (isRemove) {
                            this.getMonitor.releaseMonitor();
                            if (this.size() > 0 && this.getMonitor.isWait()) {
                                if (this.isSafeGetOrder) {
                                    this.getMonitor.notifyMonitor();
                                } else {
                                    this.getMonitor.notifyAllMonitor();
                                }
                            }
                            this.getAfter();
                        }
                        Object object = ret;
                        return object;
                    }
                    if (this.getMonitor.isWait()) {
                        this.getMonitor.notifyMonitor();
                    }
                }
                if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                long proc = 0L;
                if (timeOutMs >= 0L) {
                    proc = System.currentTimeMillis();
                }
                try {
                    long curSleepTime;
                    long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                    if (curSleepTime > 0L && (this.size() == 0 || !isRemove || this.isSafeGetOrder && !this.getMonitor.isFirst())) {
                        if (isRemove) {
                            this.getMonitor.initAndWaitMonitor(curSleepTime);
                        } else {
                            this.peekMonitor.initAndWaitMonitor(curSleepTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Object var9_11 = null;
                    if (isRemove) {
                        this.getMonitor.releaseMonitor();
                    } else {
                        this.peekMonitor.releaseMonitor();
                    }
                    return var9_11;
                }
                if (timeOutMs < 0L) continue;
                proc = System.currentTimeMillis() - proc;
                processTime += proc;
            }
            if (this.fourceEndFlg) {
                ret = this.getQueueElement(isRemove);
                if (ret == EMPTY) {
                    Object var7_9 = null;
                    return var7_9;
                }
                Object object = ret;
                return object;
            }
            if (isRemove && this.size() > 0 && this.getMonitor.isWait()) {
                if (this.isSafeGetOrder) {
                    this.getMonitor.notifyMonitor();
                } else {
                    this.getMonitor.notifyAllMonitor();
                }
            }
            Object var6_4 = null;
            return var6_4;
        }
        finally {
            if (isRemove) {
                this.getMonitor.releaseMonitor();
            } else {
                this.peekMonitor.releaseMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(boolean isRemove) {
        if (this.context == null) {
            return null;
        }
        if (this.isSafeGetOrder) {
            Object object = this.lock;
            synchronized (object) {
                if (this.context == null) {
                    return null;
                }
                if (this.size() == 0) {
                    return EMPTY;
                }
                Object element = null;
                while (true) {
                    String id2 = null;
                    try {
                        id2 = (String)((SortedMap)this.context).firstKey();
                        this.lock(id2);
                        if (!this.containsKey(id2)) continue;
                        if (isRemove) {
                            element = this.remove(id2);
                            break;
                        }
                        element = this.get(id2);
                    }
                    catch (SharedContextTimeoutException e) {
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        EmptyElement emptyElement = EMPTY;
                        return emptyElement;
                    }
                    finally {
                        if (id2 == null) continue;
                        this.unlock(id2);
                        continue;
                    }
                    break;
                }
                if (element != null) return element;
                return null;
            }
        }
        if (this.context == null) {
            return null;
        }
        if (this.size() == 0) {
            return EMPTY;
        }
        Object element = null;
        while (true) {
            String id = null;
            try {
                id = (String)this.lockFirst();
                if (id == null) {
                    if (this.size() != 0) continue;
                    EmptyElement id2 = EMPTY;
                    return id2;
                }
                if (!this.containsKey(id)) continue;
                if (isRemove) {
                    element = this.remove(id);
                    break;
                }
                element = this.get(id);
            }
            catch (SharedContextTimeoutException e) {
                continue;
            }
            catch (NoSuchElementException e) {
                EmptyElement emptyElement = EMPTY;
                return emptyElement;
            }
            finally {
                if (id == null) continue;
                this.unlock(id);
                continue;
            }
            break;
        }
        if (element != null) return element;
        return null;
    }

    protected Object lockFirst() throws SharedContextSendException, SharedContextTimeoutException {
        return this.lockFirst(this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lockFirst(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.isMain()) {
            ArrayList keys = null;
            if (this.context.size() != 0) {
                Map map = this.context;
                synchronized (map) {
                    if (this.context.size() != 0) {
                        Iterator itr = this.context.keySet().iterator();
                        for (int i = 0; i < this.seekDepth && itr.hasNext(); ++i) {
                            if (keys == null) {
                                keys = new ArrayList();
                            }
                            keys.add(itr.next());
                        }
                    }
                }
            }
            if (keys == null || keys.size() == 0) {
                return null;
            }
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                try {
                    if (!this.lock(key, true, true, timeout)) continue;
                    return key;
                }
                catch (SharedContextTimeoutException e) {
                    // empty catch block
                }
            }
            return null;
        }
        Object lockedKey = null;
        long start = System.currentTimeMillis();
        try {
            Object ret;
            String key = this.getId().toString() + Thread.currentThread().getId();
            Message message = this.serverConnection.createMessage(this.subject, key);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedQueueEvent(101, null, new Object[]{new Long(Thread.currentThread().getId()), new Long(timeout)}));
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key, 1, timeout);
                ret = responses[0].getObject();
                responses[0].recycle();
                if (ret instanceof Throwable) {
                    throw new SharedContextSendException((Throwable)ret);
                }
            } else {
                throw new NoConnectServerException("Main server is not found.");
            }
            lockedKey = ret;
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        catch (RequestTimeoutException e) {
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout <= 0L) {
                throw new SharedContextTimeoutException("timeout=" + timeout + ", processTime=" + (System.currentTimeMillis() - start), e);
            }
            return this.lockFirst(timeout);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        if (lockedKey != null) {
            SharedContextService.Lock lock = null;
            Map isNoTimeout = this.keyLockMap;
            synchronized (isNoTimeout) {
                lock = (SharedContextService.Lock)this.keyLockMap.get(lockedKey);
                if (lock == null) {
                    lock = new SharedContextService.Lock(lockedKey);
                    this.keyLockMap.put(lockedKey, lock);
                }
            }
            boolean isNoTimeout2 = timeout <= 0L;
            long l = timeout = isNoTimeout2 ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout2 && timeout <= 0L) {
                this.unlock(lockedKey);
                throw new SharedContextTimeoutException("timeout=" + timeout + ", processTime=" + (System.currentTimeMillis() - start));
            }
            if (!lock.acquire(this.getId(), true, timeout)) {
                this.unlock(lockedKey);
                return null;
            }
        }
        return lockedKey;
    }

    @Override
    public Object get() {
        return this.get(-1L);
    }

    @Override
    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    @Override
    public Object peek() {
        return this.peek(-1L);
    }

    @Override
    public Object remove(Object item) {
        return super.remove(item);
    }

    @Override
    public void accept() {
        this.fourceEndFlg = false;
    }

    @Override
    public void release() {
        this.fourceEndFlg = true;
        while (this.getMonitor.isWait()) {
            this.getMonitor.notifyMonitor();
            Thread.yield();
        }
        this.peekMonitor.notifyAllMonitor();
        Thread.yield();
        while (this.pushMonitor.isWait()) {
            this.pushMonitor.notifyMonitor();
            Thread.yield();
        }
    }

    @Override
    public List elements() {
        if (this.context == null) {
            return new ArrayList();
        }
        return new ArrayList(this.values());
    }

    @Override
    public long getCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWaitCount() {
        int count = 0;
        if (this.context != null) {
            Object object = this.lock;
            synchronized (object) {
                String id = null;
                try {
                    id = (String)((SortedMap)this.context).firstKey();
                    count += this.getLockWaitCount(id);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        return count += this.getMonitor.getWaitCount();
    }

    @Override
    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    @Override
    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    @Override
    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    @Override
    public long getDepth() {
        return this.size();
    }

    @Override
    public long getDepthDelta() {
        long depth = this.size();
        long delta = depth - this.lastDepth;
        this.lastDepth = depth;
        return delta;
    }

    @Override
    public long getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        super.clear(timeout);
        this.getAfter();
    }

    @Override
    public Message onRequestMessage(Object sourceId, int sequence, Message message, String responseSubject, String responseKey) {
        SharedContextService.SharedContextEvent event = null;
        try {
            event = (SharedContextService.SharedContextEvent)message.getObject();
        }
        catch (MessageException e) {
            e.printStackTrace();
            message.recycle();
            return null;
        }
        Message result = null;
        switch (event.type) {
            case 101: {
                message.recycle();
                result = this.onLockFirst(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            default: {
                result = super.onRequestMessage(sourceId, sequence, message, responseSubject, responseKey);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onLockFirst(SharedContextService.SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain(sourceId)) {
            Object[] params = (Object[])event.value;
            long threadId = (Long)params[0];
            long timeout = (Long)params[1];
            Object[] keys = null;
            if (this.context.size() != 0) {
                Map map = this.context;
                synchronized (map) {
                    if (this.context.size() != 0) {
                        keys = this.context.keySet().toArray();
                    }
                }
            }
            if (keys == null || keys.length == 0) {
                return this.createResponseMessage(responseSubject, responseKey, null);
            }
            for (int i = 0; i < keys.length; ++i) {
                final void key = keys[i];
                if (!this.containsKey(key)) continue;
                SharedContextService.Lock lock = null;
                Map map = this.keyLockMap;
                synchronized (map) {
                    lock = (SharedContextService.Lock)this.keyLockMap.get(key);
                    if (lock == null) {
                        lock = new SharedContextService.Lock(key);
                        this.keyLockMap.put(key, lock);
                    }
                }
                long start = System.currentTimeMillis();
                if (!lock.acquireForReply(sourceId, threadId, true, true, timeout, sourceId, sequence, responseSubject, responseKey)) continue;
                if (!this.containsKey(key)) {
                    lock.release(sourceId, false);
                    continue;
                }
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout <= 0L) {
                    lock.release(sourceId, false);
                    return this.createResponseMessage(responseSubject, responseKey, null);
                }
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key.toString());
                    message.setSubject(this.clientSubject, key.toString());
                    final Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    receiveClients.remove(sourceId);
                    if (receiveClients.size() != 0) {
                        message.setDestinationIds(receiveClients);
                        message.setObject(new SharedContextService.SharedContextEvent(13, key, new Object[]{sourceId, new Long(threadId), new Long(timeout)}));
                        SharedContextService.Lock lockedLock = lock;
                        this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout, new RequestServerConnection.ResponseCallBack(){

                            @Override
                            public void onResponse(Object fromId, Message response, boolean isLast) {
                                if (receiveClients.size() == 0) {
                                    return;
                                }
                                try {
                                    if (response == null) {
                                        SharedQueueService.this.unlock(key);
                                        SharedQueueService.this.serverConnection.response(sourceId, sequence, SharedQueueService.this.createResponseMessage(responseSubject, responseKey, null));
                                        receiveClients.clear();
                                        return;
                                    }
                                    receiveClients.remove(fromId);
                                    Object ret = response.getObject();
                                    response.recycle();
                                    if (ret == null || ret instanceof Throwable || !((Boolean)ret).booleanValue()) {
                                        SharedQueueService.this.unlock(key);
                                        SharedQueueService.this.serverConnection.response(sourceId, sequence, SharedQueueService.this.createResponseMessage(responseSubject, responseKey, null));
                                        receiveClients.clear();
                                    } else if (isLast) {
                                        SharedQueueService.this.serverConnection.response(sourceId, sequence, SharedQueueService.this.createResponseMessage(responseSubject, responseKey, key));
                                    }
                                }
                                catch (Throwable th) {
                                    try {
                                        SharedQueueService.this.unlock(key);
                                    }
                                    catch (SharedContextSendException e) {
                                        SharedQueueService.this.getLogger().write("SCS__00007", new Object[]{SharedQueueService.this.isClient ? SharedQueueService.this.clientSubject : SharedQueueService.this.subject, key}, (Throwable)e);
                                    }
                                    try {
                                        SharedQueueService.this.serverConnection.response(sourceId, sequence, SharedQueueService.this.createResponseMessage(responseSubject, responseKey, th));
                                    }
                                    catch (MessageSendException e) {
                                        SharedQueueService.this.getLogger().write("SCS__00006", new Object[]{SharedQueueService.this.isClient ? SharedQueueService.this.clientSubject : SharedQueueService.this.subject, key}, (Throwable)e);
                                    }
                                }
                            }
                        });
                        return null;
                    }
                    return this.createResponseMessage(responseSubject, responseKey, key);
                }
                catch (Throwable th) {
                    try {
                        this.unlock(key);
                    }
                    catch (SharedContextSendException e) {
                        this.getLogger().write("SCS__00007", new Object[]{this.isClient ? this.clientSubject : this.subject, key}, (Throwable)e);
                    }
                    return this.createResponseMessage(responseSubject, responseKey, th);
                }
            }
            return this.createResponseMessage(responseSubject, responseKey, null);
        }
        return null;
    }

    @Override
    protected Message onPut(SharedContextService.SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Message ret = super.onPut(event, sourceId, sequence, responseSubject, responseKey);
        this.pushAfter();
        return ret;
    }

    @Override
    protected Message onRemove(SharedContextService.SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Message ret = super.onRemove(event, sourceId, sequence, responseSubject, responseKey);
        this.getAfter();
        return ret;
    }

    @Override
    protected Message onClear(SharedContextService.SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Message ret = super.onClear(event, sourceId, sequence, responseSubject, responseKey);
        this.getAfter();
        return ret;
    }

    protected static class SharedQueueEvent
    extends SharedContextService.SharedContextEvent {
        private static final long serialVersionUID = -3200724603433621465L;
        public static final byte EVENT_LOCK_FIRST = 101;

        public SharedQueueEvent() {
        }

        public SharedQueueEvent(byte type) {
            super(type, null, null);
        }

        public SharedQueueEvent(byte type, Object key) {
            super(type, key, null);
        }

        public SharedQueueEvent(byte type, Object key, Object value) {
            super(type, key, value);
        }
    }

    protected static class EmptyElement {
        protected EmptyElement() {
        }
    }
}

