/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleDepends;

public class DefaultSchedule
implements Schedule,
Serializable,
Comparable {
    private static final long serialVersionUID = -2668833951199708052L;
    protected String id;
    protected Map groupMap = new HashMap();
    protected String masterId;
    protected String[] masterGroupIds;
    protected Date time;
    protected String taskName;
    protected Object input;
    protected ScheduleDepends[] depends;
    protected Map dependsInGroupMasterMap = new HashMap();
    protected Map dependsInGroupMap = new HashMap();
    protected ScheduleDepends[] dependsOnGroup;
    protected Map groupDependsOnGroupMasterMap = new HashMap();
    protected Map groupDependsOnGroupMap = new HashMap();
    protected Object output;
    protected boolean isRetry;
    protected Date initialTime;
    protected long retryInterval;
    protected Date retryEndTime;
    protected long maxDelayTime;
    protected int state = 1;
    protected int controlState = 1;
    protected int checkState = 1;
    protected String executorKey;
    protected String executorType;
    protected Date executeStartTime;
    protected Date executeEndTime;

    public DefaultSchedule() {
    }

    public DefaultSchedule(String id) {
        this.setId(id);
    }

    public DefaultSchedule(Date time) {
        this.setTime(time);
        this.setInitialTime(time);
    }

    public DefaultSchedule(String masterId, String[] masterGroupIds, Date time, String taskName, Object input, ScheduleDepends[] depends, Map dependsInGroupMap, ScheduleDepends[] dependsOnGroup, Map groupDependsOnGroupMap, String executorKey, String executorType) {
        this(masterId, masterGroupIds, time, taskName, input, depends, dependsInGroupMap, dependsOnGroup, groupDependsOnGroupMap, executorKey, executorType, 0L, null, 0L);
    }

    public DefaultSchedule(String masterId, String[] masterGroupIds, Date time, String taskName, Object input, ScheduleDepends[] depends, Map dependsInGroupMap, ScheduleDepends[] dependsOnGroup, Map groupDependsOnGroupMap, String executorKey, String executorType, long retryInterval, Date retryEndTime, long maxDelayTime) {
        this.setMasterId(masterId);
        this.setMasterGroupIds(masterGroupIds);
        this.setTime(time);
        this.setTaskName(taskName);
        this.setInput(input);
        this.setDepends(depends);
        if (dependsInGroupMap != null) {
            this.getDependsInGroupMasterMap().putAll(dependsInGroupMap);
        }
        this.setDependsOnGroup(dependsOnGroup);
        if (groupDependsOnGroupMap != null) {
            this.getGroupDependsOnGroupMasterMap().putAll(groupDependsOnGroupMap);
        }
        this.setExecutorKey(executorKey);
        this.setExecutorType(executorType);
        this.setInitialTime(time);
        this.setRetryInterval(retryInterval);
        this.setRetryEndTime(retryEndTime);
        this.setMaxDelayTime(maxDelayTime);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getGroupId(String masterGroupId) {
        return (String)this.groupMap.get(masterGroupId);
    }

    @Override
    public void setGroupId(String masterGroupId, String groupId) {
        this.groupMap.put(masterGroupId, groupId);
    }

    @Override
    public Map getGroupIdMap() {
        return this.groupMap;
    }

    @Override
    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String id) {
        this.masterId = id;
    }

    @Override
    public String[] getMasterGroupIds() {
        return this.masterGroupIds;
    }

    public void setMasterGroupIds(String[] id) {
        this.masterGroupIds = id;
    }

    @Override
    public Date getTime() {
        return this.time;
    }

    @Override
    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public Object getInput() {
        return this.input;
    }

    @Override
    public void setInput(Object data) {
        this.input = data;
    }

    @Override
    public ScheduleDepends[] getDepends() {
        return this.depends;
    }

    public void setDepends(ScheduleDepends[] deps) {
        this.depends = deps;
    }

    @Override
    public ScheduleDepends[] getDependsInGroupMaster(String masterGroupId) {
        return (ScheduleDepends[])this.dependsInGroupMasterMap.get(masterGroupId);
    }

    public void setDependsInGroupMaster(String masterGroupId, ScheduleDepends[] depends) {
        this.dependsInGroupMasterMap.put(masterGroupId, depends);
    }

    @Override
    public Map getDependsInGroupMasterMap() {
        return this.dependsInGroupMasterMap;
    }

    @Override
    public ScheduleDepends[] getDependsInGroup(String groupId) {
        return (ScheduleDepends[])this.dependsInGroupMap.get(groupId);
    }

    public void setDependsInGroup(String groupId, ScheduleDepends[] depends) {
        this.dependsInGroupMap.put(groupId, depends);
    }

    @Override
    public Map getDependsInGroupMap() {
        return this.dependsInGroupMap;
    }

    @Override
    public ScheduleDepends[] getDependsOnGroup() {
        return this.dependsOnGroup;
    }

    public void setDependsOnGroup(ScheduleDepends[] deps) {
        this.dependsOnGroup = deps;
    }

    @Override
    public ScheduleDepends[] getGroupDependsOnGroupMaster(String masterGroupId) {
        return (ScheduleDepends[])this.groupDependsOnGroupMasterMap.get(masterGroupId);
    }

    public void setGroupDependsOnGroupMaster(String masterGroupId, ScheduleDepends[] depends) {
        this.groupDependsOnGroupMasterMap.put(masterGroupId, depends);
    }

    @Override
    public Map getGroupDependsOnGroupMasterMap() {
        return this.groupDependsOnGroupMasterMap;
    }

    @Override
    public ScheduleDepends[] getGroupDependsOnGroup(String groupId) {
        return (ScheduleDepends[])this.groupDependsOnGroupMap.get(groupId);
    }

    public void setGroupDependsOnGroup(String groupId, ScheduleDepends[] depends) {
        this.groupDependsOnGroupMap.put(groupId, depends);
    }

    @Override
    public Map getGroupDependsOnGroupMap() {
        return this.groupDependsOnGroupMap;
    }

    @Override
    public Object getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(Object out) {
        this.output = out;
    }

    @Override
    public Date getInitialTime() {
        return this.initialTime == null ? this.time : this.initialTime;
    }

    public void setInitialTime(Date time) {
        this.initialTime = time;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long interval) {
        this.retryInterval = interval;
    }

    @Override
    public Date getRetryEndTime() {
        return this.retryEndTime;
    }

    @Override
    public void setRetryEndTime(Date time) {
        this.retryEndTime = time;
    }

    @Override
    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void setRetry(boolean retry) {
        this.isRetry = retry;
    }

    @Override
    public long getMaxDelayTime() {
        return this.maxDelayTime;
    }

    @Override
    public void setMaxDelayTime(long time) {
        this.maxDelayTime = time;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public int getControlState() {
        return this.controlState;
    }

    @Override
    public void setControlState(int state) {
        this.controlState = state;
    }

    @Override
    public int getCheckState() {
        return this.checkState;
    }

    @Override
    public void setCheckState(int state) {
        this.checkState = state;
    }

    @Override
    public void setExecutorKey(String key) {
        this.executorKey = key;
    }

    @Override
    public String getExecutorKey() {
        return this.executorKey;
    }

    @Override
    public void setExecutorType(String type) {
        this.executorType = type;
    }

    @Override
    public String getExecutorType() {
        return this.executorType;
    }

    @Override
    public Date getExecuteStartTime() {
        return this.executeStartTime;
    }

    @Override
    public void setExecuteStartTime(Date time) {
        this.executeStartTime = time;
    }

    @Override
    public Date getExecuteEndTime() {
        return this.executeEndTime;
    }

    @Override
    public void setExecuteEndTime(Date time) {
        this.executeEndTime = time;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule cmp = (Schedule)obj;
        return this.id == null && cmp.getId() == null || this.id != null && this.id.equals(cmp.getId());
    }

    public int compareTo(Object o) {
        int result;
        if (o == null || !(o instanceof Schedule)) {
            return -1;
        }
        if (o == this) {
            return 0;
        }
        Schedule cmp = (Schedule)o;
        if (this.time != null && cmp.getTime() == null) {
            return -1;
        }
        if (this.time == null && cmp.getTime() != null) {
            return 1;
        }
        if (this.time != null && cmp.getTime() != null && (result = this.time.compareTo(cmp.getTime())) != 0) {
            return result;
        }
        if (this.id == null && cmp.getId() == null) {
            return 0;
        }
        if (this.id != null && cmp.getId() == null) {
            return -1;
        }
        if (this.id == null && cmp.getId() != null) {
            return 1;
        }
        return this.id.compareTo(cmp.getId());
    }

    public String toString() {
        int i;
        ScheduleDepends[] deps;
        Map.Entry entry;
        int i2;
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(",masterId=").append(this.masterId);
        buf.append(",masterGroupIds=");
        if (this.masterGroupIds == null || this.masterGroupIds.length == 0) {
            buf.append((Object)null);
        } else {
            buf.append('[');
            for (i2 = 0; i2 < this.masterGroupIds.length; ++i2) {
                buf.append(this.masterGroupIds[i2]);
                if (i2 == this.masterGroupIds.length - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append(",groupIdMap=").append(this.groupMap);
        buf.append(",time=").append(this.time == null ? null : format.format(this.time));
        buf.append(",taskName=").append(this.taskName);
        buf.append(",input=").append(this.input);
        buf.append(",depends=");
        if (this.depends == null || this.depends.length == 0) {
            buf.append((Object)null);
        } else {
            buf.append('[');
            for (i2 = 0; i2 < this.depends.length; ++i2) {
                buf.append('{');
                buf.append("masterId=").append(this.depends[i2].getMasterId());
                buf.append(",isIgnoreError=").append(this.depends[i2].isIgnoreError());
                buf.append('}');
                if (i2 == this.depends.length - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append(",dependsInGroupMap=");
        if (this.dependsInGroupMap.size() == 0) {
            buf.append((Object)null);
        } else {
            buf.append('{');
            Iterator entries = this.dependsInGroupMap.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                buf.append(entry.getKey()).append('=');
                deps = (ScheduleDepends[])entry.getValue();
                buf.append('[');
                for (i = 0; i < deps.length; ++i) {
                    buf.append('{');
                    buf.append("masterId=").append(deps[i].getMasterId());
                    buf.append(",isIgnoreError=").append(deps[i].isIgnoreError());
                    buf.append('}');
                    if (i == deps.length - 1) continue;
                    buf.append(',');
                }
                buf.append(']');
                if (!entries.hasNext()) continue;
                buf.append(',');
            }
            buf.append('}');
        }
        buf.append(",dependsOnGroup=");
        if (this.dependsOnGroup == null || this.dependsOnGroup.length == 0) {
            buf.append((Object)null);
        } else {
            buf.append('[');
            for (int i3 = 0; i3 < this.dependsOnGroup.length; ++i3) {
                buf.append('{');
                buf.append("masterId=").append(this.dependsOnGroup[i3].getMasterId());
                buf.append(",isIgnoreError=").append(this.dependsOnGroup[i3].isIgnoreError());
                buf.append('}');
                if (i3 == this.dependsOnGroup.length - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append(",groupDependsOnGroupMap=");
        if (this.groupDependsOnGroupMap.size() == 0) {
            buf.append((Object)null);
        } else {
            buf.append('{');
            Iterator entries = this.groupDependsOnGroupMap.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                buf.append(entry.getKey()).append('=');
                deps = (ScheduleDepends[])entry.getValue();
                buf.append('[');
                for (i = 0; i < deps.length; ++i) {
                    buf.append('{');
                    buf.append("masterId=").append(deps[i].getMasterId());
                    buf.append(",isIgnoreError=").append(deps[i].isIgnoreError());
                    buf.append('}');
                    if (i == deps.length - 1) continue;
                    buf.append(',');
                }
                buf.append(']');
                if (!entries.hasNext()) continue;
                buf.append(',');
            }
            buf.append('}');
        }
        buf.append(",output=").append(this.output);
        buf.append(",isRetry=").append(this.isRetry);
        buf.append(",initialTime=").append(this.initialTime == null ? null : format.format(this.initialTime));
        buf.append(",retryInterval=").append(this.retryInterval);
        buf.append(",retryEndTime=").append(this.retryEndTime == null ? null : format.format(this.retryEndTime));
        buf.append(",maxDelayTime=").append(this.maxDelayTime);
        buf.append(",state=").append(this.state);
        buf.append(",controlState=").append(this.controlState);
        buf.append(",checkState=").append(this.checkState);
        buf.append(",executorKey=").append(this.executorKey);
        buf.append(",executorType=").append(this.executorType);
        buf.append(",executeStartTime=").append(this.executeStartTime == null ? null : format.format(this.executeStartTime));
        buf.append(",executeEndTime=").append(this.executeEndTime == null ? null : format.format(this.executeEndTime));
        buf.append('}');
        return buf.toString();
    }
}

