/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SelectionKey;
import jp.ossc.nimbus.service.server.Servant;

public class Response {
    protected Servant servant;
    protected SelectionKey selectionKey;
    protected ResponseOutputStream responseOutputStream;

    public void init(Servant servant, SelectionKey key) {
        this.servant = servant;
        this.selectionKey = key;
    }

    public void response() throws IOException {
        this.response((byte[])null);
    }

    public void response(InputStream is) throws IOException {
        this.servant.writeResponse(this.selectionKey, is);
    }

    public void response(byte[] bytes) throws IOException {
        try (OutputStream os = this.servant.getOutputStream(this.selectionKey);){
            if (bytes != null && bytes.length > 0) {
                os.write(bytes);
            }
            os.flush();
        }
    }

    public OutputStream getOutputStream() {
        if (this.responseOutputStream == null) {
            this.responseOutputStream = new ResponseOutputStream();
        }
        return this.responseOutputStream;
    }

    public void close() {
        this.servant.close(false);
    }

    protected class ResponseOutputStream
    extends ByteArrayOutputStream {
        protected ResponseOutputStream() {
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            Response.this.response(this.toByteArray());
        }
    }
}

