/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.service.soap.JaxRpcServiceException;
import jp.ossc.nimbus.service.soap.JaxRpcServiceFactory;
import jp.ossc.nimbus.service.soap.JaxRpcServiceFactoryServiceMBean;
import jp.ossc.nimbus.service.soap.TypeMapping;

public class JaxRpcServiceFactoryService
extends ServiceBase
implements JaxRpcServiceFactory,
JaxRpcServiceFactoryServiceMBean {
    private static final long serialVersionUID = -8319395042566600989L;
    private String nameSpace;
    private String jaxRpcServiceName;
    private URL wsdlURL;
    private ServiceFactory jaxRpcFactory;
    private Map typeMappings;
    private String serviceFactoryClassName;
    private String wsdlPath;

    @Override
    public URL getWsdlURL() {
        return this.wsdlURL;
    }

    @Override
    public void setWsdlURL(URL url) {
        this.wsdlURL = url;
    }

    @Override
    public String getWsdlPath() {
        return this.wsdlPath;
    }

    @Override
    public void setWsdlPath(String path) {
        this.wsdlPath = path;
    }

    @Override
    public void setJaxRpcServiceName(String jaxRpcServiceName) {
        this.jaxRpcServiceName = jaxRpcServiceName;
    }

    @Override
    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    public void setTypeMapping(String encodingStyleURI, TypeMapping mapping) {
        this.typeMappings.put(encodingStyleURI, mapping);
    }

    @Override
    public TypeMapping getTypeMapping(String encodingStyleURI) {
        return (TypeMapping)this.typeMappings.get(encodingStyleURI);
    }

    @Override
    public void setServiceFactoryClassName(String name) {
        this.serviceFactoryClassName = name;
    }

    @Override
    public String getServiceFactoryClassName() {
        return this.serviceFactoryClassName;
    }

    @Override
    public void createService() throws Exception {
        this.typeMappings = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.nameSpace == null) {
            throw new IllegalArgumentException("nameSpace must be specified.");
        }
        if (this.jaxRpcServiceName == null) {
            throw new IllegalArgumentException("jaxRpcServiceName must be specified.");
        }
        if (this.wsdlPath != null) {
            Object url = null;
            File localFile = new File(this.wsdlPath);
            if (localFile.exists()) {
                if (!localFile.isFile()) {
                    throw new IllegalArgumentException("WsdlPath must be file : " + localFile);
                }
                try {
                    this.wsdlURL = localFile.toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                String filePath;
                ServiceLoader loader;
                ServiceMetaData metaData2;
                File serviceDefDir = null;
                if (this.getServiceNameObject() != null && (metaData2 = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject())) != null && (loader = metaData2.getServiceLoader()) != null && (filePath = loader.getServiceURL().getFile()) != null) {
                    serviceDefDir = new File(filePath).getParentFile();
                }
                if ((localFile = new File(serviceDefDir, this.wsdlPath)).exists()) {
                    if (!localFile.isFile()) {
                        throw new IllegalArgumentException("WsdlPath must be file : " + localFile);
                    }
                    try {
                        this.wsdlURL = localFile.toURL();
                    }
                    catch (MalformedURLException metaData2) {}
                } else {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    URL resource = classLoader.getResource(this.wsdlPath);
                    if (resource != null) {
                        this.wsdlURL = resource;
                    }
                }
            }
            if (this.wsdlURL == null) {
                throw new IllegalArgumentException("WsdlPath could not find. path=" + this.wsdlURL);
            }
        }
        if (this.wsdlURL == null) {
            throw new IllegalArgumentException("wsdlURL must be specified.");
        }
        if (this.serviceFactoryClassName != null) {
            System.setProperty("javax.xml.rpc.ServiceFactory", this.serviceFactoryClassName);
        }
        this.jaxRpcFactory = ServiceFactory.newInstance();
        this.getService();
    }

    @Override
    public void stopService() throws Exception {
    }

    @Override
    public void destroyService() throws Exception {
        this.jaxRpcFactory = null;
        this.typeMappings = null;
    }

    @Override
    public Service getService() throws JaxRpcServiceException {
        QName serviceQN = new QName(this.nameSpace, this.jaxRpcServiceName);
        Service jaxRpcService = null;
        try {
            jaxRpcService = this.jaxRpcFactory.createService(this.wsdlURL, serviceQN);
        }
        catch (ServiceException e) {
            throw new JaxRpcServiceException(e);
        }
        if (this.typeMappings.size() != 0) {
            TypeMappingRegistry registry = jaxRpcService.getTypeMappingRegistry();
            for (String encodingStyleURI : this.typeMappings.keySet()) {
                TypeMapping mapping = (TypeMapping)this.typeMappings.get(encodingStyleURI);
                registry.register(encodingStyleURI, mapping.cloneTypeMapping(registry, encodingStyleURI));
            }
        }
        return jaxRpcService;
    }

    @Override
    public String getJaxRpcServiceName() {
        return this.jaxRpcServiceName;
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }
}

