/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.HandlerInfo;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.soap.JaxRpcServiceFactory;
import jp.ossc.nimbus.service.soap.PortException;
import jp.ossc.nimbus.service.soap.PortFactory;
import jp.ossc.nimbus.service.soap.PortFactoryServiceMBean;

public class PortFactoryService
extends ServiceBase
implements PortFactory,
PortFactoryServiceMBean {
    private static final long serialVersionUID = 7074638390846720787L;
    private static final String SEPARATOR = ",";
    private static final int PORT_NAME = 0;
    private static final int ENDPOINT_INTERFACE_NAME = 1;
    private ServiceName jaxRpcServiceFactoryName;
    private String nameSpace;
    private Service jaxRpcService;
    private List handlerInfos;
    private Map stubProperties;
    private Properties portAliasProp;

    @Override
    public void createService() throws Exception {
        this.handlerInfos = new ArrayList();
        this.stubProperties = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.jaxRpcServiceFactoryName == null) {
            throw new IllegalArgumentException("jaxRpcServiceFactoryName must be specified.");
        }
        if (this.portAliasProp == null) {
            throw new IllegalArgumentException("portAliasProp must be specified.");
        }
        JaxRpcServiceFactory jaxRpcServiceFactory = (JaxRpcServiceFactory)ServiceManagerFactory.getServiceObject(this.jaxRpcServiceFactoryName);
        this.nameSpace = jaxRpcServiceFactory.getNameSpace();
        this.jaxRpcService = jaxRpcServiceFactory.getService();
    }

    @Override
    public void stopService() throws Exception {
    }

    @Override
    public void destroyService() throws Exception {
        this.nameSpace = null;
        this.jaxRpcService = null;
        this.handlerInfos = null;
        this.stubProperties = null;
    }

    @Override
    public Object getPort(String portAlias) throws PortException {
        String portNameClassName = this.portAliasProp.getProperty(portAlias);
        String[] names = portNameClassName.split(SEPARATOR);
        if (names.length < 2) {
            return new PortException("port name or endpoint interface name is illegal : " + portNameClassName);
        }
        try {
            Class<?> endpointInterface = Class.forName(names[1]);
            QName portQN = new QName(this.nameSpace, names[0]);
            if (this.handlerInfos != null && this.handlerInfos.size() != 0) {
                this.jaxRpcService.getHandlerRegistry().setHandlerChain(portQN, this.handlerInfos);
            }
            Remote port = this.jaxRpcService.getPort(portQN, endpointInterface);
            if (this.stubProperties != null && this.stubProperties.size() != 0 && port instanceof Stub) {
                Stub stub = (Stub)port;
                for (Map.Entry entry : this.stubProperties.entrySet()) {
                    stub._setProperty((String)entry.getKey(), entry.getValue());
                }
            }
            return port;
        }
        catch (Exception e) {
            throw new PortException(e);
        }
    }

    @Override
    public void setHandlerInfos(List infos) {
        this.handlerInfos = infos;
    }

    @Override
    public void addHandlerInfo(HandlerInfo info) {
        if (this.handlerInfos != null) {
            this.handlerInfos.add(info);
        }
    }

    @Override
    public List getHandlerInfos() {
        return this.handlerInfos;
    }

    @Override
    public void clearHandlerInfos() {
        if (this.handlerInfos != null) {
            this.handlerInfos.clear();
        }
    }

    @Override
    public Properties getPortAliasProp() {
        return this.portAliasProp;
    }

    @Override
    public void setPortAliasProp(Properties prop) {
        this.portAliasProp = prop;
    }

    @Override
    public ServiceName getJaxRpcServiceFactoryName() {
        return this.jaxRpcServiceFactoryName;
    }

    @Override
    public void setJaxRpcServiceFactoryName(ServiceName serviceName) {
        this.jaxRpcServiceFactoryName = serviceName;
    }

    @Override
    public void setStubProperty(String name, Object value) {
        this.stubProperties.put(name, value);
    }

    @Override
    public Object getStubProperty(String name) {
        return this.stubProperties == null ? null : this.stubProperties.get(name);
    }

    @Override
    public Map getStubPropertyMap() {
        return this.stubProperties;
    }
}

