/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap.handler;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.soap.handler.WsServiceJournalHandlerServiceMBean;

public class WsServiceJournalHandlerService
extends ServiceBase
implements SOAPHandler<SOAPMessageContext>,
WsServiceJournalHandlerServiceMBean {
    protected ServiceName journalServiceName;
    protected ServiceName sequenceServiceName;
    protected ServiceName threadContextServiceName;
    protected ServiceName accessEditorFinderServiceName;
    protected ServiceName requestEditorFinderServiceName;
    protected ServiceName responseEditorFinderServiceName;
    protected String accessJournalKey = "Access";
    protected String requestJournalKey = "Request";
    protected String responseJournalKey = "Response";
    protected String requestSoapMessageContextJournalKey = "RequestSoapMessageContext";
    protected String requestPartJournalKey = "RequestPart";
    protected String responseSoapMessageContextJournalKey = "RequestSoapMessageContext";
    protected String responsePartJournalKey = "ResponsePart";
    protected String faultJournalKey = "Fault";
    protected String requestIdKey = "REQUEST_ID";
    protected Journal journal;
    protected Sequence sequence;
    protected Context threadContext;
    protected EditorFinder accessEditorFinder;
    protected EditorFinder requestEditorFinder;
    protected EditorFinder responseEditorFinder;

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getAccessEditorFinderServiceName() {
        return this.accessEditorFinderServiceName;
    }

    public void setAccessEditorFinderServiceName(ServiceName name) {
        this.accessEditorFinderServiceName = name;
    }

    public ServiceName getRequestEditorFinderServiceName() {
        return this.requestEditorFinderServiceName;
    }

    public void setRequestEditorFinderServiceName(ServiceName name) {
        this.requestEditorFinderServiceName = name;
    }

    public ServiceName getResponseEditorFinderServiceName() {
        return this.responseEditorFinderServiceName;
    }

    public void setResponseEditorFinderServiceName(ServiceName name) {
        this.responseEditorFinderServiceName = name;
    }

    public String getAccessJournalKey() {
        return this.accessJournalKey;
    }

    public void setAccessJournalKey(String key) {
        this.accessJournalKey = key;
    }

    public String getRequestJournalKey() {
        return this.requestJournalKey;
    }

    public void setRequestJournalKey(String key) {
        this.requestJournalKey = key;
    }

    public String getResponseJournalKey() {
        return this.responseJournalKey;
    }

    public void setResponseJournalKey(String key) {
        this.responseJournalKey = key;
    }

    public String getRequestSoapMessageContextJournalKey() {
        return this.requestSoapMessageContextJournalKey;
    }

    public void setRequestSoapMessageContextJournalKey(String key) {
        this.requestSoapMessageContextJournalKey = key;
    }

    public String getResponseSoapMessageContextJournalKey() {
        return this.responseSoapMessageContextJournalKey;
    }

    public void setResponseSoapMessageContextJournalKey(String key) {
        this.responseSoapMessageContextJournalKey = key;
    }

    public String getFaultJournalKey() {
        return this.faultJournalKey;
    }

    public void setFaultJournalKey(String key) {
        this.faultJournalKey = key;
    }

    public String getRequestIdKey() {
        return this.requestIdKey;
    }

    public void setRequestIdKey(String key) {
        this.requestIdKey = key;
    }

    @Override
    public void startService() throws Exception {
        if (this.journalServiceName == null) {
            throw new IllegalArgumentException("JournalServiceName must be specified.");
        }
        this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        if (this.accessEditorFinderServiceName != null) {
            this.accessEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.accessEditorFinderServiceName);
        }
        if (this.requestEditorFinderServiceName != null) {
            this.requestEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestEditorFinderServiceName);
        }
        if (this.responseEditorFinderServiceName != null) {
            this.responseEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.responseEditorFinderServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
    }

    public boolean handleMessage(SOAPMessageContext context) {
        Boolean outboundProperty = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            this.startJournal(context);
        } else {
            this.endJournal(context);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.endJournal(context);
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return null;
    }

    protected void startJournal(SOAPMessageContext context) {
        try {
            this.journal.startJournal(this.accessJournalKey, this.accessEditorFinder);
            if (this.sequence != null) {
                this.journal.setRequestId(this.sequence.increment());
            } else if (this.threadContext != null) {
                this.journal.setRequestId((String)this.threadContext.get(this.requestIdKey));
            }
            this.journal.addStartStep(this.requestJournalKey, this.requestEditorFinder);
            this.journal.addInfo(this.requestSoapMessageContextJournalKey, context);
            this.journal.addInfo(this.requestPartJournalKey, context.getMessage().getSOAPPart());
        }
        finally {
            if (this.journal.isStartJournal()) {
                this.journal.addEndStep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endJournal(SOAPMessageContext context) {
        if (this.journal.isStartJournal()) {
            try {
                try {
                    this.journal.addStartStep(this.responseJournalKey, this.responseEditorFinder);
                    this.journal.addInfo(this.responseSoapMessageContextJournalKey, context);
                    this.journal.addInfo(this.responsePartJournalKey, context.getMessage().getSOAPPart());
                    try {
                        if (context.getMessage().getSOAPBody().hasFault()) {
                            this.journal.addInfo(this.faultJournalKey, context.getMessage().getSOAPBody().getFault());
                        }
                    }
                    catch (SOAPException sOAPException) {
                        // empty catch block
                    }
                }
                finally {
                    this.journal.addEndStep();
                }
            }
            finally {
                this.journal.endJournal();
            }
        }
    }
}

