/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.system;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.system.DatabaseHostResolverServiceMBean;
import jp.ossc.nimbus.service.system.HostResolver;

public class DatabaseHostResolverService
extends ServiceBase
implements HostResolver,
DatabaseHostResolverServiceMBean {
    private static final long serialVersionUID = -2159903335103754963L;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected ServiceName persistentManagerServiceName;
    protected PersistentManager persistentManager;
    protected String selectSql;
    protected Map hostMap;

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public void setSelectSql(String sql) {
        this.selectSql = sql;
    }

    @Override
    public Map getHostMap() {
        return this.hostMap;
    }

    @Override
    public void createService() throws Exception {
        this.hostMap = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.selectSql == null || "".equals(this.selectSql)) {
            throw new IllegalArgumentException("SelectSql must be specified.");
        }
        if (this.connectionFactoryServiceName == null) {
            throw new IllegalArgumentException("DbConnectionFactoryServiceName must be specified.");
        }
        this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        if (this.persistentManagerServiceName == null) {
            throw new IllegalArgumentException("PersistentManagerServiceName must be specified.");
        }
        this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
        this.reloadHostMap();
    }

    public void reloadHostMap() throws Exception {
        this.hostMap.clear();
        RecordList result = (RecordList)this.persistentManager.loadQuery(this.connectionFactory.getConnection(), this.selectSql, null, new RecordList());
        for (int i = 0; i < result.size(); ++i) {
            Record record = (Record)result.get(i);
            try {
                InetAddress inetAddress = InetAddress.getByName(record.getStringProperty(1));
                this.hostMap.put(record.getStringProperty(0), inetAddress);
                continue;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override
    public InetAddress getLocalHost() {
        InetAddress result;
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
        InetAddress inetAddress = result = this.getHost(localhost.getHostName()) != null ? this.getHost(localhost.getHostName()) : this.getHost(localhost.getHostAddress());
        if (result == null) {
            result = localhost;
        }
        return result;
    }

    @Override
    public InetAddress getHost(String hostName) {
        return (InetAddress)this.hostMap.get(hostName);
    }
}

