/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.http.HttpException;
import jp.ossc.nimbus.service.http.HttpRequest;
import jp.ossc.nimbus.service.http.HttpResponse;
import jp.ossc.nimbus.service.test.HttpTestControllerClientServiceMBean;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestCaseImpl;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.TestScenarioGroupImpl;
import jp.ossc.nimbus.service.test.TestScenarioImpl;

public class HttpTestControllerClientService
extends ServiceBase
implements TestController,
HttpTestControllerClientServiceMBean {
    private ServiceName httpClientFactoryServiceName;
    private HttpClientFactory httpClientFactory;
    private String templateAction = "template";
    private String urlEncodeCharacterEncoding = "UTF-8";

    @Override
    public void setHttpClientFactoryServiceName(ServiceName name) {
        this.httpClientFactoryServiceName = name;
    }

    @Override
    public ServiceName getHttpClientFactoryServiceName() {
        return this.httpClientFactoryServiceName;
    }

    @Override
    public void setTemplateAction(String action) {
        this.templateAction = action;
    }

    @Override
    public String getTemplateAction() {
        return this.templateAction;
    }

    @Override
    public void setURLEncodeCharacterEncoding(String encoding) {
        this.urlEncodeCharacterEncoding = encoding;
    }

    @Override
    public String getURLEncodeCharacterEncoding() {
        return this.urlEncodeCharacterEncoding;
    }

    @Override
    public void startService() throws Exception {
        if (this.httpClientFactoryServiceName != null) {
            this.httpClientFactory = (HttpClientFactory)ServiceManagerFactory.getServiceObject(this.httpClientFactoryServiceName);
        }
        if (this.httpClientFactory == null) {
            throw new IllegalArgumentException("HttpClientFactory is null.");
        }
        this.httpClientFactory.createRequest(this.templateAction);
    }

    private Object request(String action, Map params) throws HttpException, Exception {
        HttpResponse response;
        HttpClient client = this.httpClientFactory.createHttpClient();
        HttpRequest request = this.httpClientFactory.createRequest(this.templateAction);
        String accept = request.getHeader("Accept");
        if (accept == null) {
            request.setHeader("Accept", "application/octet-stream");
        }
        String url = request.getURL();
        request.setURL(url + (url.endsWith("/") ? "" : "/") + action);
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                Object value = entry.getValue();
                if (value != null && value.getClass().isArray()) {
                    String[] values = (String[])value;
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = URLEncoder.encode(values[i], this.urlEncodeCharacterEncoding);
                    }
                    request.setParameters((String)entry.getKey(), values);
                    continue;
                }
                request.setParameter((String)entry.getKey(), URLEncoder.encode((String)entry.getValue(), this.urlEncodeCharacterEncoding));
            }
        }
        if ((response = client.executeRequest(request)).getStatusCode() != 200) {
            throw new HttpException("Illegal http status : " + response.getStatusCode());
        }
        String contentLengthStr = response.getHeader("Content-Length");
        int contentLength = 0;
        if (contentLengthStr != null) {
            contentLength = Integer.parseInt(contentLengthStr);
        }
        if (contentLength == 0) {
            return null;
        }
        String contentTypeStr = response.getHeader("Content-Type");
        if (contentTypeStr == null) {
            throw new HttpException("Content-Type is null.");
        }
        MediaType mediaType = new MediaType(contentTypeStr);
        InputStream is = response.getInputStream();
        if ("application/octet-stream".equals(mediaType.getMediaType())) {
            ObjectInputStream ois = new ObjectInputStream(is);
            Object responseObj = ois.readObject();
            if (responseObj instanceof Exception) {
                throw (Exception)responseObj;
            }
            return responseObj;
        }
        if ("application/zip".equals(mediaType.getMediaType())) {
            return new Object[]{mediaType.getParameter("name"), is};
        }
        throw new HttpException("Unsupported Content-Type : " + mediaType.getMediaType());
    }

    @Override
    public void setTestPhase(String phase) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phase", phase);
        try {
            this.request("setTestPhase", params);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public String getTestPhase() {
        try {
            return (String)this.request("getTestPhase", null);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void startScenarioGroup(String userId, String scenarioGroupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        params.put("scenarioGroupId", scenarioGroupId);
        this.request("startScenarioGroup", params);
    }

    @Override
    public void endScenarioGroup() throws Exception {
        this.request("endScenarioGroup", null);
    }

    @Override
    public void startScenario(String userId, String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        params.put("scenarioId", scenarioId);
        this.request("startScenario", params);
    }

    @Override
    public void cancelScenario(String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioId", scenarioId);
        this.request("cancelScenario", params);
    }

    @Override
    public void endScenario(String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioId", scenarioId);
        this.request("endScenario", params);
    }

    @Override
    public void startTestCase(String userId, String scenarioId, String testcaseId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        params.put("scenarioId", scenarioId);
        params.put("testcaseId", testcaseId);
        this.request("startTestCase", params);
    }

    @Override
    public void cancelTestCase(String scenarioId, String testcaseId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioId", scenarioId);
        params.put("testcaseId", testcaseId);
        this.request("cancelTestCase", params);
    }

    @Override
    public void endTestCase(String scenarioId, String testcaseId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioId", scenarioId);
        params.put("testcaseId", testcaseId);
        this.request("endTestCase", params);
    }

    @Override
    public TestScenarioGroup[] getScenarioGroups() throws Exception {
        TestScenarioGroup[] groups = (TestScenarioGroup[])this.request("getScenarioGroups", null);
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                ((TestScenarioGroupImpl)groups[i]).setController(this);
            }
        }
        return groups;
    }

    @Override
    public String[] getScenarioGroupIds() throws Exception {
        return (String[])this.request("getScenarioGroupIds", null);
    }

    @Override
    public TestScenarioGroup getScenarioGroup(String scenarioGroupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        TestScenarioGroup group = (TestScenarioGroup)this.request("getScenarioGroup", params);
        if (group != null) {
            ((TestScenarioGroupImpl)group).setController(this);
        }
        return group;
    }

    @Override
    public TestScenarioGroup getCurrentScenarioGroup() throws Exception {
        TestScenarioGroup group = (TestScenarioGroup)this.request("getCurrentScenarioGroup", null);
        if (group != null) {
            ((TestScenarioGroupImpl)group).setController(this);
        }
        return group;
    }

    @Override
    public TestScenarioGroup.TestScenarioGroupResource getTestScenarioGroupResource(String scenarioGroupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        return (TestScenarioGroup.TestScenarioGroupResource)this.request("getTestScenarioGroupResource", params);
    }

    @Override
    public TestScenarioGroup.Status getTestScenarioGroupStatus(String scenarioGroupId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        try {
            return (TestScenarioGroup.Status)this.request("getTestScenarioGroupStatus", params);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public TestScenario[] getScenarios(String scenarioGroupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        TestScenario[] scenarios = (TestScenario[])this.request("getScenarios", params);
        if (scenarios != null) {
            for (int i = 0; i < scenarios.length; ++i) {
                ((TestScenarioImpl)scenarios[i]).setController(this);
            }
        }
        return scenarios;
    }

    @Override
    public String[] getScenarioIds(String scenarioGroupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        return (String[])this.request("getScenarioIds", params);
    }

    @Override
    public TestScenario getScenario(String scenarioGroupId, String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        TestScenario scenario = (TestScenario)this.request("getScenario", params);
        if (scenario != null) {
            ((TestScenarioImpl)scenario).setController(this);
        }
        return scenario;
    }

    @Override
    public TestScenario getCurrentScenario() throws Exception {
        TestScenario scenario = (TestScenario)this.request("getCurrentScenario", null);
        if (scenario != null) {
            ((TestScenarioImpl)scenario).setController(this);
        }
        return scenario;
    }

    @Override
    public TestScenario.TestScenarioResource getTestScenarioResource(String scenarioGroupId, String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        return (TestScenario.TestScenarioResource)this.request("getTestScenarioResource", params);
    }

    @Override
    public TestScenario.Status getTestScenarioStatus(String scenarioGroupId, String scenarioId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        try {
            return (TestScenario.Status)this.request("getTestScenarioStatus", params);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public TestCase[] getTestCases(String scenarioGroupId, String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        TestCase[] testcases = (TestCase[])this.request("getTestCases", params);
        if (testcases != null) {
            for (int i = 0; i < testcases.length; ++i) {
                ((TestCaseImpl)testcases[i]).setController(this);
            }
        }
        return testcases;
    }

    @Override
    public String[] getTestCaseIds(String scenarioGroupId, String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        return (String[])this.request("getTestCaseIds", params);
    }

    @Override
    public TestCase getTestCase(String scenarioGroupId, String scenarioId, String testcaseId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        params.put("testcaseId", testcaseId);
        TestCase testcase = (TestCase)this.request("getTestCase", params);
        if (testcase != null) {
            ((TestCaseImpl)testcase).setController(this);
        }
        return testcase;
    }

    @Override
    public TestCase getCurrentTestCase() throws Exception {
        TestCase testCase = (TestCase)this.request("getCurrentTestCase", null);
        if (testCase != null) {
            ((TestCaseImpl)testCase).setController(this);
        }
        return testCase;
    }

    @Override
    public TestCase.TestCaseResource getTestCaseResource(String scenarioGroupId, String scenarioId, String testcaseId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        params.put("testcaseId", testcaseId);
        return (TestCase.TestCaseResource)this.request("getTestCaseResource", params);
    }

    @Override
    public TestCase.Status getTestCaseStatus(String scenarioGroupId, String scenarioId, String testcaseId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        params.put("testcaseId", testcaseId);
        try {
            return (TestCase.Status)this.request("getTestCaseStatus", params);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public File downloadScenarioResult(File dir, String scenarioGroupId, String scenarioId, int responseFileType) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        Object[] ret = (Object[])this.request("downloadScenarioResult", params);
        String fileName = (String)ret[0];
        InputStream is = (InputStream)ret[1];
        return this.downloadResult(dir, responseFileType, fileName, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadResult(File dir, int responseFileType, String fileName, InputStream is) throws Exception {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File result = new File(dir, fileName);
        FileOutputStream fos = null;
        switch (responseFileType) {
            case 1: {
                fos = new FileOutputStream(result);
                try {
                    byte[] bytes = new byte[1024];
                    int len = 0;
                    while ((len = is.read(bytes)) > 0) {
                        fos.write(bytes, 0, len);
                    }
                    fos.flush();
                    break;
                }
                finally {
                    fos.close();
                }
            }
            default: {
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    File entryFile = new File(dir, entry.getName());
                    if (!entryFile.getParentFile().exists()) {
                        entryFile.getParentFile().mkdirs();
                    }
                    fos = new FileOutputStream(entryFile);
                    try {
                        byte[] bytes = new byte[1024];
                        int len = 0;
                        while ((len = zis.read(bytes)) > 0) {
                            fos.write(bytes, 0, len);
                        }
                        fos.flush();
                    }
                    finally {
                        fos.close();
                    }
                    zis.closeEntry();
                }
                break block2;
            }
        }
        return result;
    }

    @Override
    public File downloadTestCaseResult(File dir, String scenarioGroupId, String scenarioId, String testcaseId, int responseFileType) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        params.put("testcaseId", testcaseId);
        Object[] ret = (Object[])this.request("downloadTestCaseResult", params);
        String fileName = (String)ret[0];
        InputStream is = (InputStream)ret[1];
        return this.downloadResult(dir, responseFileType, fileName, is);
    }

    @Override
    public void downloadTestScenarioGroupResource(String scenarioGroupId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        this.request("downloadTestScenarioGroupResource", params);
    }

    @Override
    public void downloadTestScenarioResource(String scenarioGroupId, String scenarioId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scenarioGroupId", scenarioGroupId);
        params.put("scenarioId", scenarioId);
        this.request("downloadTestScenarioResource", params);
    }

    @Override
    public void reset() throws Exception {
        this.request("reset", null);
    }

    protected static class MediaType
    extends HeaderValue {
        public MediaType() {
        }

        public MediaType(String header) {
            super(header);
        }

        public String getMediaType() {
            return this.getValue();
        }

        public void setMediaType(String type) {
            this.setValue(type);
        }
    }

    protected static class HeaderValue {
        protected String value;
        protected Map parameters;
        protected int hashCode;

        public HeaderValue() {
        }

        public HeaderValue(String header) {
            String[] types = header.split(";");
            this.value = types[0].trim();
            this.hashCode = this.value.hashCode();
            if (types.length > 1) {
                this.parameters = new HashMap();
                for (int i = 1; i < types.length; ++i) {
                    String parameter = types[i].trim();
                    int index = parameter.indexOf(61);
                    if (index != -1) {
                        this.parameters.put(parameter.substring(0, index).toLowerCase(), parameter.substring(index + 1).toLowerCase());
                        continue;
                    }
                    this.parameters.put(parameter.toLowerCase(), null);
                }
                this.hashCode += this.parameters.hashCode();
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String val) {
            this.value = val;
        }

        public String getParameter(String name) {
            return this.parameters == null ? null : (String)this.parameters.get(name);
        }

        public void setParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            this.parameters.put(name, value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.value);
            if (this.parameters != null) {
                for (Map.Entry entry : this.parameters.entrySet()) {
                    buf.append(';').append(entry.getKey()).append('=').append(entry.getValue());
                }
            }
            return buf.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeaderValue)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            HeaderValue cmp = (HeaderValue)obj;
            if (!this.value.equals(cmp.value)) {
                return false;
            }
            return !(this.parameters == null && cmp.parameters != null || this.parameters != null && cmp.parameters == null) && (this.parameters == null || this.parameters.equals(cmp.parameters));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

