/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.service.test.ScheduledTestResource;
import jp.ossc.nimbus.service.test.TestResourceBaseImpl;

public class ScheduledTestResourceImpl
extends TestResourceBaseImpl
implements ScheduledTestResource,
Serializable {
    private static final long serialVersionUID = 2440747536475034151L;
    private String creator;
    private Date scheduledCreateStartDate;
    private Date scheduledCreateEndDate;
    private double expectedCost = 0.0;
    private Date createStartDate;
    private Date createEndDate;
    private double cost = 0.0;
    private double progress;
    private Map actionExpectedCostMap = new LinkedHashMap();
    private Map actionCostMap = new LinkedHashMap();

    @Override
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public Date getScheduledCreateStartDate() {
        return this.scheduledCreateStartDate;
    }

    public void setScheduledCreateStartDate(Date date) {
        this.scheduledCreateStartDate = date;
    }

    @Override
    public Date getScheduledCreateEndDate() {
        return this.scheduledCreateEndDate;
    }

    public void setScheduledCreateEndDate(Date date) {
        this.scheduledCreateEndDate = date;
    }

    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        if (this.actionExpectedCostMap.isEmpty()) {
            return this.expectedCost;
        }
        Iterator itr = this.actionExpectedCostMap.values().iterator();
        double result = 0.0;
        while (itr.hasNext()) {
            double val = (Double)itr.next();
            if (Double.isNaN(val)) continue;
            result += val;
        }
        return result;
    }

    @Override
    public Date getCreateStartDate() {
        return this.createStartDate;
    }

    public void setCreateStartDate(Date date) {
        this.createStartDate = date;
    }

    @Override
    public Date getCreateEndDate() {
        return this.createEndDate;
    }

    public void setCreateEndDate(Date date) {
        this.createEndDate = date;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    @Override
    public double getCost() {
        if (this.actionCostMap.isEmpty()) {
            return this.cost;
        }
        Iterator itr = this.actionCostMap.values().iterator();
        double result = 0.0;
        while (itr.hasNext()) {
            double val = (Double)itr.next();
            if (Double.isNaN(val)) continue;
            result += val;
        }
        return result;
    }

    @Override
    public double getActionExpectedCost(String actionId) {
        return (Double)this.actionExpectedCostMap.get(actionId);
    }

    public void setActionExpectedCost(String actionId, double cost) {
        this.actionExpectedCostMap.put(actionId, new Double(cost));
    }

    public Map getActionExpectedCostMap() {
        return this.actionExpectedCostMap;
    }

    @Override
    public double getActionCost(String actionId) {
        return (Double)this.actionCostMap.get(actionId);
    }

    public void setActionCost(String actionId, double cost) {
        if (!Double.isNaN(cost)) {
            this.actionCostMap.put(actionId, new Double(cost));
        }
    }

    public Map getActionCostMap() {
        return this.actionCostMap;
    }
}

