/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.CommandExecuteActionServiceMBean;

public class CommandExecuteActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
CommandExecuteActionServiceMBean {
    private static final long serialVersionUID = -5250176082027977563L;
    protected String[] environments;
    protected double expectedCost = 0.0;
    protected long checkInterval = 1000L;

    @Override
    public String[] getEnvironments() {
        return this.environments;
    }

    @Override
    public void setEnvironments(String[] envs) {
        for (int i = 0; i < envs.length; ++i) {
            int index = envs[i].indexOf(61);
            if (index != -1) continue;
            throw new IllegalArgumentException("Illegal format : " + envs[i]);
        }
        this.environments = envs;
    }

    @Override
    public void setCheckInterval(long interval) {
        this.checkInterval = interval;
    }

    @Override
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        File dir = null;
        String command = null;
        String[] cmdarray = null;
        String[] envp = null;
        long waitTime = 0L;
        File logFile = null;
        String fileEncoding = null;
        Pattern waitPattern = null;
        try {
            int index;
            String str = br.readLine();
            if (str == null || str.length() == 0) {
                throw new Exception("\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u60f3\u5b9a\u5916\u3067\u3059\u3002");
            }
            command = str;
            cmdarray = CSVReader.toArray(this.replaceProperty(str), ' ', '\\', '\"', null, null, false, false, true, true);
            LinkedHashMap<String, String> tmpEnv = new LinkedHashMap<String, String>();
            tmpEnv.putAll(System.getenv());
            if (this.environments != null) {
                for (int i = 0; i < this.environments.length; ++i) {
                    index = this.environments[i].indexOf(61);
                    tmpEnv.put(this.environments[i].substring(0, index), this.environments[i].substring(index + 1));
                }
            }
            while ((str = br.readLine()) != null && str.length() != 0) {
                int index2 = str.indexOf(61);
                if (index2 == -1) {
                    throw new IllegalArgumentException("Illegal format : " + str);
                }
                tmpEnv.put(str.substring(0, index2), str.substring(index2 + 1));
            }
            if (tmpEnv.size() != 0) {
                envp = new String[tmpEnv.size()];
                Iterator entries = tmpEnv.entrySet().iterator();
                index = 0;
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    envp[index++] = (String)entry.getKey() + '=' + (String)entry.getValue();
                }
            }
            if ((str = br.readLine()) != null && str.length() != 0) {
                String workDirStr = this.replaceProperty(str);
                dir = ".".equals(workDirStr) ? context.getCurrentDirectory() : new File(workDirStr);
            }
            if ((str = br.readLine()) != null && str.length() != 0) {
                waitTime = Long.parseLong(str);
            }
            if ((str = br.readLine()) != null && str.length() != 0) {
                String logFilePath = this.replaceProperty(str);
                index = logFilePath.indexOf(44);
                if (index != -1) {
                    fileEncoding = logFilePath.substring(index + 1);
                    logFilePath = logFilePath.substring(0, index);
                }
                logFile = new File(logFilePath);
            }
            if ((str = br.readLine()) != null && str.length() != 0) {
                waitPattern = Pattern.compile(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
        Runtime r = Runtime.getRuntime();
        Process process = r.exec(cmdarray, envp, dir);
        Integer ret = null;
        boolean isTimeout = false;
        if (waitTime > 0L) {
            ProcessStreamReadRunnable stdReadRunnable = new ProcessStreamReadRunnable(process.getInputStream());
            ProcessStreamReadRunnable errReadRunnable = new ProcessStreamReadRunnable(process.getErrorStream());
            Thread stdReadThread = new Thread(stdReadRunnable);
            Thread errReadThread = new Thread(errReadRunnable);
            stdReadThread.start();
            errReadThread.start();
            if (logFile == null) {
                ProcessWaitRunnable waitRunnable = new ProcessWaitRunnable(process);
                Thread processWaitThread = new Thread(waitRunnable);
                processWaitThread.setDaemon(true);
                processWaitThread.start();
                processWaitThread.join(waitTime);
                if (waitRunnable.exitCode == null) {
                    processWaitThread.interrupt();
                    stdReadThread.interrupt();
                    errReadThread.interrupt();
                    isTimeout = true;
                } else {
                    stdReadThread.join();
                    errReadThread.join();
                    ret = waitRunnable.exitCode;
                }
            } else {
                isTimeout = true;
                do {
                    long sleepTime = Math.min(this.checkInterval, waitTime);
                    Thread.sleep(sleepTime);
                    waitTime -= sleepTime;
                    if (!logFile.exists()) continue;
                    if (waitPattern == null) {
                        isTimeout = false;
                        break;
                    }
                    StringWriter sw = new StringWriter();
                    InputStreamReader isr = fileEncoding == null ? new InputStreamReader(new FileInputStream(logFile)) : new InputStreamReader((InputStream)new FileInputStream(logFile), fileEncoding);
                    char[] buf = new char[1024];
                    int len = 0;
                    String fileContent = null;
                    try {
                        while ((len = isr.read(buf, 0, buf.length)) > 0) {
                            sw.write(buf, 0, len);
                        }
                        fileContent = sw.toString();
                        sw.close();
                        sw = null;
                    }
                    finally {
                        isr.close();
                        isr = null;
                    }
                    if (!waitPattern.matcher(fileContent).find()) continue;
                    isTimeout = false;
                    break;
                } while (waitTime > 0L);
                stdReadThread.interrupt();
                errReadThread.interrupt();
            }
            BufferedReader brOut = null;
            BufferedReader brErrer = null;
            PrintWriter pw = null;
            try {
                File outFile = new File(context.getCurrentDirectory(), actionId + ".txt");
                FileWriter filewriter = new FileWriter(outFile);
                BufferedWriter bw = new BufferedWriter(filewriter);
                pw = new PrintWriter(bw);
                pw.println("\u6a19\u6e96\u51fa\u529b\uff1a");
                pw.println(stdReadRunnable.getResult() == null ? stdReadRunnable.getCurrentResult() : stdReadRunnable.getResult());
                pw.println();
                pw.println("\u30a8\u30e9\u30fc\u51fa\u529b\uff1a");
                pw.println(errReadRunnable.getResult() == null ? errReadRunnable.getCurrentResult() : errReadRunnable.getResult());
                pw.println();
                pw.println("\u623b\u308a\u5024\uff1a");
                pw.println(ret);
                pw.flush();
            }
            finally {
                if (brOut != null) {
                    brOut.close();
                }
                if (brErrer != null) {
                    brErrer.close();
                }
                if (pw != null) {
                    pw.close();
                }
            }
            if (isTimeout) {
                throw new Exception("Comannd execute timeout : command=" + command);
            }
        }
        return ret;
    }

    protected String replaceProperty(String textValue) {
        textValue = Utility.replaceSystemProperty(textValue);
        if (this.getServiceLoader() != null) {
            textValue = Utility.replaceServiceLoderConfig(textValue, this.getServiceLoader().getConfig());
        }
        if (this.getServiceManager() != null) {
            textValue = Utility.replaceManagerProperty(this.getServiceManager(), textValue);
        }
        textValue = Utility.replaceServerProperty(textValue);
        return textValue;
    }

    protected class ProcessStreamReadRunnable
    implements Runnable {
        private BufferedReader br;
        private String result;
        private StringWriter sw = new StringWriter();
        private PrintWriter pw = new PrintWriter(this.sw);

        public ProcessStreamReadRunnable(InputStream is) {
            this.br = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.br.readLine()) != null) {
                    this.pw.println(line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.pw.flush();
                this.result = this.sw.toString();
                try {
                    this.br.close();
                    this.br = null;
                }
                catch (IOException iOException) {}
            }
        }

        public String getCurrentResult() {
            this.pw.flush();
            return this.sw.toString();
        }

        public String getResult() {
            return this.result;
        }
    }

    protected class ProcessWaitRunnable
    implements Runnable {
        private final Process process;
        public Integer exitCode = null;

        public ProcessWaitRunnable(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.exitCode = new Integer(this.process.waitFor());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

