/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Connection;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.DatabaseSearchActionServiceMBean;

public class DatabaseSearchActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
DatabaseSearchActionServiceMBean {
    private static final long serialVersionUID = 8193135412984495251L;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected ServiceName persistentManagerServiceName;
    protected PersistentManager persistentManager;
    protected double expectedCost = 0.0;

    @Override
    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    @Override
    public void setPersistentManagerServiceName(ServiceName name) {
        this.persistentManagerServiceName = name;
    }

    @Override
    public ServiceName getPersistentManagerServiceName() {
        return this.persistentManagerServiceName;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setPersistentManager(PersistentManager manager) {
        this.persistentManager = manager;
    }

    @Override
    public void startService() throws Exception {
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.persistentManagerServiceName != null) {
            this.persistentManager = (PersistentManager)ServiceManagerFactory.getServiceObject(this.persistentManagerServiceName);
        }
        if (this.persistentManager == null) {
            throw new IllegalArgumentException("PersistentManager is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        String searchQuery = null;
        Object input = null;
        Object output = null;
        try {
            String line;
            String outputId;
            String inputId = br.readLine();
            if (inputId == null) {
                throw new Exception("Unexpected EOF on inputId");
            }
            if (inputId.length() != 0) {
                Object actionResult = null;
                if (inputId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(inputId);
                } else {
                    String[] ids = inputId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal inputId format. id=" + inputId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + inputId);
                }
                input = actionResult;
            }
            if ((outputId = br.readLine()) == null) {
                throw new Exception("Unexpected EOF on outputId");
            }
            if (outputId.length() != 0) {
                Object actionResult = null;
                if (outputId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(outputId);
                } else {
                    String[] ids = outputId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal outputId format. id=" + outputId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + outputId);
                }
                output = actionResult;
            }
            if ((line = br.readLine()) == null) {
                throw new Exception("Unexpected EOF on searchQuery");
            }
            StringBuffer buf = new StringBuffer();
            do {
                if ((line = line.trim()).length() == 0) continue;
                if (buf.length() != 0) {
                    buf.append(' ');
                }
                buf.append(line);
            } while ((line = br.readLine()) != null);
            if (buf.length() != 0) {
                searchQuery = buf.toString().trim();
                buf.setLength(0);
            }
            if (searchQuery == null || searchQuery.length() == 0) {
                throw new Exception("Unexpected EOF on searchQuery");
            }
        }
        finally {
            br.close();
            br = null;
        }
        Object result = null;
        try (Connection con = this.connectionFactory.getConnection();){
            result = this.persistentManager.loadQuery(con, searchQuery, input, output);
        }
        return result;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

