/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.FileOperateActionServiceMBean;

public class FileOperateActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
FileOperateActionServiceMBean {
    private static final long serialVersionUID = -7746000195947141887L;
    protected double expectedCost = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        List result = null;
        try {
            String operateType = br.readLine();
            if ("MOVE".equals(operateType)) {
                String srcPath = br.readLine();
                if (srcPath == null || srcPath.length() == 0) {
                    throw new Exception("Unexpected EOF on srcPath");
                }
                do {
                    List srcFiles;
                    if ((srcFiles = this.toFiles(srcPath)) != null) {
                        String dstPath = br.readLine();
                        File dstDir = null;
                        if (dstPath == null || dstPath.length() == 0) {
                            dstDir = context.getCurrentDirectory();
                        } else {
                            dstDir = new File(this.replaceProperty(dstPath));
                            if (!dstDir.isAbsolute()) {
                                dstDir = new File(context.getCurrentDirectory(), dstDir.getPath());
                            }
                        }
                        if (dstDir.exists()) {
                            if (!dstDir.isDirectory()) throw new Exception("Not directory. path=" + dstDir.getPath());
                            this.move(srcFiles, dstDir);
                        } else {
                            if (!dstDir.mkdirs()) throw new Exception("Can' not create directory. path=" + dstDir.getPath());
                            this.move(srcFiles, dstDir);
                        }
                    }
                    if ((srcPath = br.readLine()) == null) return result;
                } while (srcPath.length() != 0);
                return result;
            } else if ("COPY".equals(operateType)) {
                String srcPath = br.readLine();
                if (srcPath == null || srcPath.length() == 0) {
                    throw new Exception("Unexpected EOF on srcPath");
                }
                do {
                    List srcFiles;
                    if ((srcFiles = this.toFiles(srcPath)) != null) {
                        String dstPath = br.readLine();
                        File dstDir = null;
                        if (dstPath == null || dstPath.length() == 0) {
                            dstDir = context.getCurrentDirectory();
                        } else {
                            dstDir = new File(this.replaceProperty(dstPath));
                            if (!dstDir.isAbsolute()) {
                                dstDir = new File(context.getCurrentDirectory(), dstDir.getPath());
                            }
                        }
                        if (dstDir.exists()) {
                            if (!dstDir.isDirectory()) throw new Exception("Not directory. path=" + dstDir.getPath());
                            this.copy(srcFiles, dstDir);
                        } else {
                            if (!dstDir.mkdirs()) throw new Exception("Can' not create directory. path=" + dstDir.getPath());
                            this.copy(srcFiles, dstDir);
                        }
                    }
                    if ((srcPath = br.readLine()) == null) return result;
                } while (srcPath.length() != 0);
                return result;
            } else if ("DELETE".equals(operateType)) {
                String filePath = br.readLine();
                if (filePath == null || filePath.length() == 0) {
                    throw new Exception("Unexpected EOF on filePath");
                }
                do {
                    List files;
                    if ((files = this.toFiles(filePath)) != null) {
                        this.delete(files);
                    }
                    if ((filePath = br.readLine()) == null) return result;
                } while (filePath.length() != 0);
                return result;
            } else if ("CLEAR".equals(operateType)) {
                String filePath = br.readLine();
                if (filePath == null || filePath.length() == 0) {
                    throw new Exception("Unexpected EOF on filePath");
                }
                do {
                    List files;
                    if ((files = this.toFiles(filePath)) != null) {
                        this.clear(files);
                    }
                    if ((filePath = br.readLine()) == null) return result;
                } while (filePath.length() != 0);
                return result;
            } else {
                if (!"LS".equals(operateType)) throw new Exception("Illegal operateType : " + operateType);
                String filePath = br.readLine();
                if (filePath == null || filePath.length() == 0) {
                    throw new Exception("Unexpected EOF on filePath");
                }
                List fileList = null;
                do {
                    List files;
                    if ((files = this.toFiles(filePath)) == null) continue;
                    fileList = this.ls(files, fileList);
                } while ((filePath = br.readLine()) != null && filePath.length() != 0);
                result = fileList;
            }
            return result;
        }
        finally {
            br.close();
            br = null;
        }
    }

    protected void move(List files, File dir) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            if (file.isDirectory()) {
                File destDir = new File(dir, file.getName());
                if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                RecurciveSearchFile.copyAllTree(file, destDir);
                RecurciveSearchFile.deleteAllTree(file);
                continue;
            }
            RecurciveSearchFile.dataCopy(file, new File(dir, file.getName()));
            file.delete();
        }
    }

    protected void copy(List files, File dir) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            if (file.isDirectory()) {
                File destDir = new File(dir, file.getName());
                if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                RecurciveSearchFile.copyAllTree(file, destDir);
                continue;
            }
            RecurciveSearchFile.dataCopy(file, new File(dir, file.getName()));
        }
    }

    protected void delete(List files) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            if (!(file.isDirectory() ? !RecurciveSearchFile.deleteAllTree(file) : !file.delete())) continue;
            throw new IOException("Can not delete files. path=" + file);
        }
    }

    protected void clear(List files) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            if (file.isDirectory()) continue;
            FileOutputStream fos = new FileOutputStream(file);
            fos.close();
        }
    }

    protected List ls(List files, List fileList) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            if (!file.exists()) continue;
            if (fileList == null) {
                fileList = new ArrayList<File>();
            }
            if (file.isDirectory()) {
                File[] childlen = file.listFiles();
                for (int j = 0; j < childlen.length; ++j) {
                    fileList.add(childlen[j]);
                }
                continue;
            }
            fileList.add(file);
        }
        return fileList;
    }

    protected List toFiles(String path) throws IOException {
        ArrayList<File> result = null;
        File file = new File(path = this.replaceProperty(path));
        if (file.exists()) {
            result = new ArrayList<File>();
            result.add(file);
        } else {
            File parentFile = file;
            while ((parentFile = parentFile.getParentFile()) != null && !parentFile.exists()) {
            }
            if (parentFile == null) {
                parentFile = new File(".");
            } else {
                path = path.substring(parentFile.getPath().length() + 1);
            }
            try {
                RecurciveSearchFile rsf = new RecurciveSearchFile(parentFile);
                File[] files = rsf.listAllTreeFiles(path, 2);
                if (files != null && files.length != 0) {
                    result = new ArrayList();
                    for (int i = 0; i < files.length; ++i) {
                        result.add(files[i]);
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    protected String replaceProperty(String textValue) {
        textValue = Utility.replaceSystemProperty(textValue);
        if (this.getServiceLoader() != null) {
            textValue = Utility.replaceServiceLoderConfig(textValue, this.getServiceLoader().getConfig());
        }
        if (this.getServiceManager() != null) {
            textValue = Utility.replaceManagerProperty(this.getServiceManager(), textValue);
        }
        textValue = Utility.replaceServerProperty(textValue);
        return textValue;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

