/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.FileToObjectConvertActionServiceMBean;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.FormatConverter;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class FileToObjectConvertActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
ChainTestAction.TestActionProcess,
FileToObjectConvertActionServiceMBean {
    private static final long serialVersionUID = 6119833930392428119L;
    protected double expectedCost = 0.0;
    protected String fileEncoding;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected ServiceName streamConverterServiceName;
    protected StreamConverter streamConverter;
    protected ServiceName formatConverterServiceName;
    protected FormatConverter formatConverter;

    @Override
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    @Override
    public void setStreamConverterServiceName(ServiceName name) {
        this.streamConverterServiceName = name;
    }

    @Override
    public ServiceName getStreamConverterServiceName() {
        return this.streamConverterServiceName;
    }

    @Override
    public void setFormatConverterServiceName(ServiceName name) {
        this.formatConverterServiceName = name;
    }

    @Override
    public ServiceName getFormatConverterServiceName() {
        return this.formatConverterServiceName;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void setStreamConverter(StreamConverter converter) {
        this.streamConverter = converter;
    }

    public void setFormatConverter(FormatConverter converter) {
        this.formatConverter = converter;
    }

    @Override
    public void startService() throws Exception {
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
        if (this.streamConverterServiceName != null) {
            this.streamConverter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.streamConverterServiceName);
        }
        if (this.formatConverterServiceName != null) {
            this.formatConverter = (FormatConverter)ServiceManagerFactory.getServiceObject(this.formatConverterServiceName);
        }
        if (this.streamConverter == null && this.formatConverter == null) {
            throw new IllegalArgumentException("Converter is null.");
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        Object pw;
        BufferedReader br = new BufferedReader(resource);
        File file = null;
        String bindingObjectScript = null;
        String format = null;
        try {
            String filePath = br.readLine();
            if (filePath == null) {
                throw new Exception("Unexpected EOF on filePath");
            }
            file = new File(filePath);
            if (!file.exists()) {
                file = new File(context.getCurrentDirectory(), filePath);
            }
            if (!file.exists()) {
                throw new Exception("File not found. filePath=" + filePath);
            }
            String line = null;
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            try {
                while ((line = br.readLine()) != null) {
                    ((PrintWriter)pw).println(line);
                }
                ((PrintWriter)pw).flush();
                if (this.streamConverter != null) {
                    bindingObjectScript = sw.toString();
                    if (bindingObjectScript.length() == 0) {
                        bindingObjectScript = null;
                    }
                } else {
                    format = sw.toString();
                    if (format.length() == 0) {
                        format = null;
                    }
                }
            }
            finally {
                sw.close();
                ((PrintWriter)pw).close();
            }
            if (bindingObjectScript != null) {
                if (this.streamConverter == null) {
                    throw new UnsupportedOperationException("StreamConverter is null.");
                }
                if (this.interpreter == null) {
                    throw new UnsupportedOperationException("Interpreter is null.");
                }
                if (!(this.streamConverter instanceof BindingStreamConverter)) {
                    throw new Exception("StreamConverter is not BindingStreamConverter. streamConverter=" + this.streamConverter.getClass());
                }
            }
        }
        finally {
            br.close();
            br = null;
        }
        if (this.streamConverter != null) {
            Object bindingObject = null;
            if (bindingObjectScript != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("context", context);
                params.put("preResult", preResult);
                bindingObject = this.interpreter.evaluate(bindingObjectScript, params);
            } else {
                bindingObject = preResult;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                StreamConverter sc = this.streamConverter;
                if (this.fileEncoding != null && sc instanceof StreamStringConverter && !this.fileEncoding.equals(((StreamStringConverter)sc).getCharacterEncodingToObject())) {
                    sc = ((StreamStringConverter)sc).cloneCharacterEncodingToObject(this.fileEncoding);
                }
                if (bindingObject != null && sc instanceof BindingStreamConverter) {
                    pw = ((BindingStreamConverter)sc).convertToObject(fis, bindingObject);
                    return pw;
                }
                pw = sc.convertToObject(fis);
                return pw;
            }
        }
        InputStreamReader isr = this.fileEncoding == null ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), this.fileEncoding);
        StringWriter sw = new StringWriter();
        String str = null;
        try {
            int len = 0;
            char[] buf = new char[1024];
            while ((len = isr.read(buf, 0, buf.length)) > 0) {
                sw.write(buf, 0, len);
            }
            str = sw.toString();
        }
        finally {
            isr.close();
            sw.close();
        }
        FormatConverter fc = this.formatConverter;
        if (this.formatConverterServiceName != null) {
            fc = (FormatConverter)ServiceManagerFactory.getServiceObject(this.formatConverterServiceName);
        }
        if (format != null) {
            fc.setFormat(format);
        }
        return fc.convert(str);
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

