/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.jmx.MBeanServerConnectionFactory;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.MBeanCallActionServiceMBean;

public class MBeanCallActionService
extends ServiceBase
implements TestAction,
ChainTestAction.TestActionProcess,
TestActionEstimation,
MBeanCallActionServiceMBean {
    private static final long serialVersionUID = 5048024056628750415L;
    protected static final String SETTER_PREFIX = "set";
    protected static final int SETTER_PREFIX_LENGTH = 3;
    protected static final String GETTER_PREFIX = "get";
    protected static final int GETTER_PREFIX_LENGTH = 3;
    protected double expectedCost = 0.0;
    protected ServiceName mbeanServerConnectionFactoryServiceName;
    protected MBeanServerConnectionFactory mbeanServerConnectionFactory;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;

    @Override
    public void setMBeanServerConnectionFactoryServiceName(ServiceName name) {
        this.mbeanServerConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getMBeanServerConnectionFactoryServiceName() {
        return this.mbeanServerConnectionFactoryServiceName;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setMBeanServerConnectionFactory(MBeanServerConnectionFactory factory) {
        this.mbeanServerConnectionFactory = factory;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void startService() throws Exception {
        if (this.mbeanServerConnectionFactoryServiceName != null) {
            this.mbeanServerConnectionFactory = (MBeanServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.mbeanServerConnectionFactoryServiceName);
        }
        if (this.mbeanServerConnectionFactory == null) {
            throw new IllegalArgumentException("MBeanServerConnectionFactory is null.");
        }
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        JMXConnector connector = this.mbeanServerConnectionFactory.getJMXConnector();
        connector.connect();
        BufferedReader br = new BufferedReader(resource);
        ArrayList<Object> result = null;
        try {
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            String targetType = br.readLine();
            if (targetType == null) {
                throw new Exception("Unexpected EOF on targetType");
            }
            String target = null;
            ArrayList<Object> objectNames = new ArrayList<Object>();
            if (targetType.equals("objectName")) {
                target = br.readLine();
                if (target == null) {
                    throw new Exception("Unexpected EOF on target");
                }
                ObjectName objectName = new ObjectName(target);
                objectNames.add(objectName);
            } else if (targetType.equals("objectNameQuery")) {
                target = br.readLine();
                if (target == null) {
                    throw new Exception("Unexpected EOF on target");
                }
                Set<ObjectName> objectNameSet = connection.queryNames(new ObjectName(target), null);
                objectNames.addAll(objectNameSet);
            } else {
                if (!targetType.equals("interpreter")) throw new Exception("Unknown targetType : " + targetType);
                if (this.interpreter == null) {
                    throw new UnsupportedOperationException("Interpreter is null.");
                }
                StringWriter sw = new StringWriter();
                String line = null;
                try (PrintWriter pw = new PrintWriter(sw);){
                    while ((line = br.readLine()) != null && line.length() != 0) {
                        pw.println(line);
                    }
                    pw.flush();
                    target = sw.toString();
                }
                if (line == null) {
                    throw new Exception("Unexpected EOF on target");
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("connection", connection);
                params.put("context", context);
                Object ret = this.interpreter.evaluate(target, params);
                if (ret == null) {
                    throw new Exception("Illegal target : " + ret);
                }
                if (ret instanceof ObjectName) {
                    objectNames.add(ret);
                } else {
                    if (!(ret instanceof Collection)) throw new Exception("Illegal target : " + ret);
                    for (Object obj : (Collection)ret) {
                        if (obj == null) continue;
                        if (!(obj instanceof ObjectName)) {
                            throw new Exception("Illegal target : " + obj.getClass());
                        }
                        objectNames.add(obj);
                    }
                }
            }
            if (objectNames.size() == 0) {
                throw new Exception("MBean not found. target=" + target);
            }
            String methodSigniture = br.readLine();
            if (methodSigniture == null) {
                throw new Exception("Unexpected EOF on methodSigniture");
            }
            String methodName = null;
            String[] paramTypeNames = null;
            Class[] paramTypes = null;
            int index = methodSigniture.indexOf("(");
            if (index == -1) {
                methodName = methodSigniture;
            } else {
                if (methodSigniture.charAt(methodSigniture.length() - 1) != ')') {
                    throw new Exception("Illegal methodSigniture : " + methodSigniture);
                }
                methodName = methodSigniture.substring(0, index);
                String args = methodSigniture.substring(index + 1, methodSigniture.length() - 1).trim();
                if (args.length() != 0) {
                    paramTypeNames = args.split(",");
                    paramTypes = new Class[paramTypeNames.length];
                    for (int i = 0; i < paramTypeNames.length; ++i) {
                        paramTypeNames[i] = paramTypeNames[i].trim();
                        paramTypes[i] = Utility.convertStringToClass(paramTypeNames[i], false);
                    }
                }
            }
            Object[] arguments = null;
            if (paramTypes != null && paramTypes.length != 0) {
                arguments = paramTypes == null || paramTypes.length == 0 ? null : new Object[paramTypes.length];
                String argumentType = null;
                index = 0;
                while ((argumentType = br.readLine()) != null) {
                    String line;
                    if (argumentType.length() == 0) continue;
                    if (index >= paramTypes.length) {
                        throw new Exception("Unmatch argument length. signitureParamLength=" + paramTypes.length + ", argumentLength>" + index);
                    }
                    if ("chain".equals(argumentType)) {
                        arguments[index] = preResult;
                    } else if ("id".equals(argumentType)) {
                        line = br.readLine();
                        if (line == null) {
                            throw new Exception("Unexpected EOF on argument");
                        }
                        if (line != null && line.length() != 0) {
                            if (line.indexOf(",") == -1) {
                                arguments[index] = context.getTestActionResult(line);
                            } else {
                                String[] ids = line.split(",");
                                if (ids.length != 2) {
                                    throw new Exception("Illegal argument id format. id=" + line);
                                }
                                arguments[index] = context.getTestActionResult(ids[0], ids[1]);
                            }
                        }
                    } else {
                        if ("value".equals(argumentType)) {
                            line = br.readLine();
                            if (line == null) {
                                throw new Exception("Unexpected EOF on argument");
                            }
                            PropertyEditor editor = NimbusPropertyEditorManager.findEditor(paramTypes[index]);
                            if (editor == null) {
                                throw new Exception("PropertyEditor not found. type=" + paramTypes[index]);
                            }
                            try {
                                editor.setAsText(line);
                                arguments[index] = editor.getValue();
                            }
                            catch (Exception e) {
                                throw new Exception("PropertyEditor can not edit. editor=" + editor + ", value=" + line, e);
                            }
                        }
                        if (!"interpreter".equals(argumentType)) throw new Exception("Unknown argumentType : " + argumentType);
                        if (this.interpreter == null) {
                            throw new UnsupportedOperationException("Interpreter is null.");
                        }
                        String script = null;
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        String line2 = br.readLine();
                        if (line2 == null) {
                            throw new Exception("Unexpected EOF on argument");
                        }
                        try {
                            do {
                                pw.println(line2);
                            } while ((line2 = br.readLine()) != null && line2.length() != 0);
                            pw.flush();
                            script = sw.toString();
                        }
                        finally {
                            pw.close();
                        }
                        if (paramTypes != null) {
                            HashMap<String, TestContext> params = new HashMap<String, TestContext>();
                            params.put("context", context);
                            arguments[index] = this.interpreter.evaluate(script, params);
                        }
                    }
                    ++index;
                }
            }
            if (methodName.length() > 3 && methodName.startsWith(SETTER_PREFIX) && arguments != null && arguments.length == 1) {
                for (int i = 0; i < objectNames.size(); ++i) {
                    Attribute attr = new Attribute(methodName.substring(3), arguments[0]);
                    connection.setAttribute((ObjectName)objectNames.get(i), attr);
                }
                return result;
            } else if (methodName.length() > 3 && methodName.startsWith(GETTER_PREFIX) && (arguments == null || arguments.length == 0)) {
                ArrayList<Object> resultList = new ArrayList<Object>(objectNames.size());
                for (int i = 0; i < objectNames.size(); ++i) {
                    resultList.add(connection.getAttribute((ObjectName)objectNames.get(i), methodName.substring(3)));
                }
                result = resultList.size() == 1 ? resultList.get(0) : resultList;
                return result;
            } else {
                ArrayList<Object> resultList = new ArrayList<Object>(objectNames.size());
                for (int i = 0; i < objectNames.size(); ++i) {
                    resultList.add(connection.invoke((ObjectName)objectNames.get(i), methodName, arguments, paramTypeNames));
                }
                result = resultList.size() == 1 ? resultList.get(0) : resultList;
            }
            return result;
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
            try {
                connector.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

