/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.MessageReceiverGetActionServiceMBean;
import jp.ossc.nimbus.service.test.action.MessageReceiverListenActionService;

public class MessageReceiverGetActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
MessageReceiverGetActionServiceMBean {
    private static final long serialVersionUID = 6779163909892607718L;
    protected double expectedCost = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        MessageReceiverListenActionService.MessageListener listener = null;
        String getType = null;
        long timeout = 0L;
        boolean isClose = true;
        try {
            String listenerId = br.readLine();
            if (listenerId == null || listenerId.length() == 0) {
                throw new Exception("Unexpected EOF on listenerId");
            }
            Object actionResult = null;
            if (listenerId.indexOf(",") == -1) {
                actionResult = context.getTestActionResult(listenerId);
            } else {
                String[] ids = listenerId.split(",");
                if (ids.length != 2) {
                    throw new Exception("Illegal listenerId format. id=" + listenerId);
                }
                actionResult = context.getTestActionResult(ids[0], ids[1]);
            }
            if (actionResult == null) {
                throw new Exception("TestActionResult not found. id=" + listenerId);
            }
            if (!(actionResult instanceof MessageReceiverListenActionService.MessageListener)) {
                throw new Exception("TestActionResult is not MessageReceiverListenActionService.MessageListener. type=" + actionResult.getClass());
            }
            listener = (MessageReceiverListenActionService.MessageListener)actionResult;
            getType = br.readLine();
            if (getType == null || getType.length() == 0) {
                throw new Exception("Unexpected EOF on getType");
            }
            if (!"message".equals(getType) && !"object".equals(getType)) {
                throw new Exception("Illegal getType : " + getType);
            }
            String timeoutStr = br.readLine();
            if (timeoutStr == null || timeoutStr.length() == 0) {
                throw new Exception("Unexpected EOF on timeout");
            }
            try {
                timeout = Long.parseLong(timeoutStr);
            }
            catch (NumberFormatException e) {
                throw new Exception("Illegal timeout format. timeout=" + timeoutStr);
            }
            String close = br.readLine();
            if (close != null && close.length() != 0) {
                isClose = Boolean.valueOf(close);
            }
        }
        finally {
            br.close();
            br = null;
        }
        List result = null;
        try {
            if (listener.waitMessage(timeout)) {
                result = "message".equals(getType) ? listener.getReceiveMessageList() : listener.getReceiveMessageObjectList();
            }
        }
        finally {
            if (isClose) {
                listener.close();
            }
        }
        return result;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

