/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.MessageReceiverListenActionServiceMBean;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class MessageReceiverListenActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
MessageReceiverListenActionServiceMBean {
    private static final long serialVersionUID = -165396344130216716L;
    protected ServiceName messageReceiverServiceName;
    protected MessageReceiver messageReceiver;
    protected double expectedCost = 0.0;

    @Override
    public void setMessageReceiverServiceName(ServiceName name) {
        this.messageReceiverServiceName = name;
    }

    @Override
    public ServiceName getMessageReceiverServiceName() {
        return this.messageReceiverServiceName;
    }

    public void setMessageReceiver(MessageReceiver receiver) {
        this.messageReceiver = receiver;
    }

    @Override
    public void startService() throws Exception {
        if (this.messageReceiverServiceName != null) {
            this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.messageReceiverServiceName);
        }
        if (this.messageReceiver == null) {
            throw new IllegalArgumentException("MessageReceiver is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        MessageListener messageListener = new MessageListener();
        try {
            String subjectAndKey = br.readLine();
            if (subjectAndKey == null || subjectAndKey.length() == 0) {
                throw new Exception("Unexpected EOF on subject and key");
            }
            do {
                String[] subjectAndKeyArray;
                if ((subjectAndKeyArray = CSVReader.toArray(subjectAndKey, ',', '\\', null, null, true, false, true, true)) == null || subjectAndKeyArray.length == 0) {
                    throw new Exception("Illegal subject and key format. subjectAndKey=" + subjectAndKey);
                }
                if (subjectAndKeyArray.length == 1) {
                    this.messageReceiver.addSubject(messageListener, subjectAndKeyArray[0]);
                    continue;
                }
                String subject = subjectAndKeyArray[0];
                String[] keys = new String[subjectAndKeyArray.length - 1];
                System.arraycopy(subjectAndKeyArray, 1, keys, 0, keys.length);
                this.messageReceiver.addSubject(messageListener, subject, keys);
            } while ((subjectAndKey = br.readLine()) != null && subjectAndKey.length() != 0);
        }
        finally {
            br.close();
            br = null;
        }
        return messageListener;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    public class MessageListener
    implements jp.ossc.nimbus.service.publish.MessageListener {
        protected List receiveMessageList = new ArrayList();
        protected SynchronizeMonitor waitMonitor = new WaitSynchronizeMonitor();
        protected int waitCount = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(Message message) {
            List list = this.receiveMessageList;
            synchronized (list) {
                this.receiveMessageList.add(message);
                if (this.waitMonitor.isWait() && this.waitCount <= this.receiveMessageList.size()) {
                    this.waitMonitor.notifyAllMonitor();
                }
            }
        }

        public boolean waitMessage(long timeout) throws InterruptedException {
            return this.waitMessage(1, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitMessage(int count, long timeout) throws InterruptedException {
            List list = this.receiveMessageList;
            synchronized (list) {
                if (count <= this.receiveMessageList.size()) {
                    return true;
                }
                this.waitCount = count;
                this.waitMonitor.initMonitor();
            }
            return this.waitMonitor.waitMonitor(timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getReceiveMessageList() {
            ArrayList result = new ArrayList();
            List list = this.receiveMessageList;
            synchronized (list) {
                for (int i = 0; i < this.receiveMessageList.size(); ++i) {
                    result.add(this.receiveMessageList.get(i));
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getReceiveMessageObjectList() throws Exception {
            ArrayList<Object> result = new ArrayList<Object>();
            List list = this.receiveMessageList;
            synchronized (list) {
                for (int i = 0; i < this.receiveMessageList.size(); ++i) {
                    result.add(((Message)this.receiveMessageList.get(i)).getObject());
                }
            }
            return result;
        }

        public void close() {
            if (MessageReceiverListenActionService.this.messageReceiver != null) {
                try {
                    MessageReceiverListenActionService.this.messageReceiver.removeMessageListener(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

