/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.ScheduleMakeActionServiceMBean;

public class ScheduleMakeActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
ScheduleMakeActionServiceMBean {
    private static final long serialVersionUID = 7719682717347172076L;
    protected ServiceName scheduleManagerServiceName;
    protected ScheduleManager scheduleManager;
    protected double expectedCost = 0.0;

    @Override
    public void setScheduleManagerServiceName(ServiceName name) {
        this.scheduleManagerServiceName = name;
    }

    @Override
    public ServiceName getScheduleManagerServiceName() {
        return this.scheduleManagerServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.scheduleManagerServiceName != null) {
            this.scheduleManager = (ScheduleManager)ServiceManagerFactory.getServiceObject(this.scheduleManagerServiceName);
        }
        if (this.scheduleManager == null) {
            throw new IllegalArgumentException("ScheduleManager is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        Date retryEndTime;
        BufferedReader br = new BufferedReader(resource);
        String masterId = null;
        try {
            masterId = br.readLine();
            if (masterId == null) {
                throw new Exception("Unexpected EOF on masterId");
            }
        }
        finally {
            br.close();
            br = null;
        }
        Date now = new Date();
        DefaultScheduleMaster master = (DefaultScheduleMaster)this.scheduleManager.findScheduleMaster(masterId);
        if (master == null) {
            throw new Exception("ScheduleMaster not found. masterId=" + masterId);
        }
        Calendar cal = Calendar.getInstance();
        Date startTime = master.getStartTime();
        long offset = 0L;
        if (startTime != null) {
            cal.setTime(now);
            int year = cal.get(1);
            int day = cal.get(6);
            cal.clear();
            cal.setTime(startTime);
            cal.set(1, year);
            cal.set(6, day + (cal.get(6) - 1));
            offset = now.getTime() - cal.getTimeInMillis();
            cal.clear();
            cal.setTime(now);
            cal.set(6, 1);
            startTime = cal.getTime();
        }
        master.setStartTime(startTime);
        Date endTime = master.getEndTime();
        if (endTime != null) {
            master.setEndTime(new Date(endTime.getTime() + offset));
        }
        if ((retryEndTime = master.getRetryEndTime()) != null) {
            master.setRetryEndTime(new Date(retryEndTime.getTime() + offset));
        }
        return this.scheduleManager.makeSchedule(now, master);
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

