/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import jp.ossc.nimbus.beans.MethodEditor;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.ServiceCallActionServiceMBean;

public class ServiceCallActionService
extends ServiceBase
implements TestAction,
ChainTestAction.TestActionProcess,
TestActionEstimation,
ServiceCallActionServiceMBean {
    private static final long serialVersionUID = 9132878277934081894L;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected ServiceName invokerServiceName;
    protected Invoker invoker;
    protected double expectedCost = 0.0;

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    @Override
    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    @Override
    public ServiceName getInvokerServiceName() {
        return this.invokerServiceName;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public void startService() throws Exception {
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
        if (this.invokerServiceName != null) {
            this.invoker = (Invoker)ServiceManagerFactory.getServiceObject(this.invokerServiceName);
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        Object[] arguments;
        Method method;
        ServiceName targetServiceName;
        block34: {
            BufferedReader br = new BufferedReader(resource);
            targetServiceName = null;
            method = null;
            arguments = null;
            try {
                String serviceNameStr = br.readLine();
                if (serviceNameStr == null || serviceNameStr.length() == 0) {
                    throw new Exception("Unexpected EOF on serviceName");
                }
                ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
                serviceNameEditor.setAsText(serviceNameStr);
                targetServiceName = (ServiceName)serviceNameEditor.getValue();
                String methodSigniture = br.readLine();
                if (methodSigniture == null || methodSigniture.length() == 0) {
                    throw new Exception("Unexpected EOF on methodSigniture");
                }
                MethodEditor methodEditor = new MethodEditor();
                methodEditor.setAsText(methodSigniture);
                method = (Method)methodEditor.getValue();
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes.length == 0) break block34;
                arguments = paramTypes == null || paramTypes.length == 0 ? null : new Object[paramTypes.length];
                String argumentType = null;
                int index = 0;
                while ((argumentType = br.readLine()) != null) {
                    String line;
                    if (argumentType.length() == 0) continue;
                    if (index >= paramTypes.length) {
                        throw new Exception("Unmatch argument length. signitureParamLength=" + paramTypes.length + ", argumentLength>" + index);
                    }
                    if ("chain".equals(argumentType)) {
                        arguments[index] = preResult;
                    } else if ("id".equals(argumentType)) {
                        line = br.readLine();
                        if (line == null) {
                            throw new Exception("Unexpected EOF on argument");
                        }
                        if (line != null && line.length() != 0) {
                            if (line.indexOf(",") == -1) {
                                arguments[index] = context.getTestActionResult(line);
                            } else {
                                String[] ids = line.split(",");
                                if (ids.length != 2) {
                                    throw new Exception("Illegal argument id format. id=" + line);
                                }
                                arguments[index] = context.getTestActionResult(ids[0], ids[1]);
                            }
                        }
                    } else {
                        if ("value".equals(argumentType)) {
                            line = br.readLine();
                            if (line == null) {
                                throw new Exception("Unexpected EOF on argument");
                            }
                            PropertyEditor editor = NimbusPropertyEditorManager.findEditor(paramTypes[index]);
                            if (editor == null) {
                                throw new Exception("PropertyEditor not found. type=" + paramTypes[index]);
                            }
                            try {
                                editor.setAsText(line);
                                arguments[index] = editor.getValue();
                            }
                            catch (Exception e) {
                                throw new Exception("PropertyEditor can not edit. editor=" + editor + ", value=" + line, e);
                            }
                        }
                        if ("interpreter".equals(argumentType)) {
                            if (this.interpreter == null) {
                                throw new UnsupportedOperationException("Interpreter is null.");
                            }
                            String script = null;
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            String line2 = br.readLine();
                            if (line2 == null) {
                                throw new Exception("Unexpected EOF on argument");
                            }
                            try {
                                do {
                                    pw.println(line2);
                                } while ((line2 = br.readLine()) != null && line2.length() != 0);
                                pw.flush();
                                script = sw.toString();
                            }
                            finally {
                                pw.close();
                            }
                            if (paramTypes != null) {
                                HashMap<String, TestContext> params = new HashMap<String, TestContext>();
                                params.put("context", context);
                                arguments[index] = this.interpreter.evaluate(script, params);
                            }
                        } else {
                            throw new Exception("Unknown argumentType : " + argumentType);
                        }
                    }
                    ++index;
                }
            }
            finally {
                br.close();
                br = null;
            }
        }
        if (this.invoker == null) {
            return method.invoke(ServiceManagerFactory.getServiceObject(targetServiceName), arguments);
        }
        try {
            return this.invoker.invoke(new DefaultMethodInvocationContext(targetServiceName, method, arguments));
        }
        catch (Throwable th) {
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw (Error)th;
        }
    }
}

