/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.TcpNetProxyControlActionServiceMBean;
import jp.ossc.nimbus.service.test.proxy.TcpNetProxy;

public class TcpNetProxyControlActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
TcpNetProxyControlActionServiceMBean {
    private static final long serialVersionUID = 7754526857203225703L;
    protected ServiceName tcpNetProxyServiceName;
    protected TcpNetProxy proxy;
    protected double expectedCost = 0.0;

    @Override
    public ServiceName getTcpNetProxyServiceName() {
        return this.tcpNetProxyServiceName;
    }

    @Override
    public void setTcpNetProxyServiceName(ServiceName serviceName) {
        this.tcpNetProxyServiceName = serviceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.tcpNetProxyServiceName != null) {
            this.proxy = (TcpNetProxy)ServiceManagerFactory.getServiceObject(this.tcpNetProxyServiceName);
        }
        if (this.proxy == null) {
            throw new IllegalArgumentException("TcpNetProxy is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        String operation = null;
        try {
            operation = br.readLine();
            if (operation == null) {
                throw new Exception("Unexpected EOF on operation");
            }
        }
        finally {
            br.close();
            br = null;
        }
        if (operation.equals("open")) {
            this.proxy.open();
        } else if (operation.equals("close")) {
            this.proxy.close();
        } else if (operation.equals("reopen")) {
            this.proxy.reopen();
        } else if (operation.equals("freeze")) {
            this.proxy.freeze();
        } else if (operation.equals("unfreeze")) {
            this.proxy.unfreeze();
        } else if (operation.equals("closeAllPairs")) {
            this.proxy.closeAllPairs();
        } else if (operation.equals("freezeAllPairs")) {
            this.proxy.freezeAllPairs();
        } else if (operation.equals("unfreezeAllPairs")) {
            this.proxy.unfreezeAllPairs();
        } else {
            throw new Exception("No supported operation. operation=" + operation);
        }
        return null;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

