/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.evaluate;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.test.ChainEvaluateTestAction;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.evaluate.ScheduleWaitActionServiceMBean;

public class ScheduleWaitActionService
extends ServiceBase
implements EvaluateTestAction,
TestActionEstimation,
ChainEvaluateTestAction.EvaluateTestActionProcess,
ScheduleWaitActionServiceMBean {
    private static final long serialVersionUID = -6269182775651897011L;
    protected ServiceName scheduleManagerServiceName;
    protected ScheduleManager scheduleManager;
    protected long waitInterval = 1000L;
    protected double expectedCost = 0.0;

    @Override
    public void setScheduleManagerServiceName(ServiceName name) {
        this.scheduleManagerServiceName = name;
    }

    @Override
    public ServiceName getScheduleManagerServiceName() {
        return this.scheduleManagerServiceName;
    }

    @Override
    public void setWaitInterval(long interval) {
        this.waitInterval = interval;
    }

    @Override
    public long getWaitInterval() {
        return this.waitInterval;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    @Override
    public void startService() throws Exception {
        if (this.scheduleManagerServiceName != null) {
            this.scheduleManager = (ScheduleManager)ServiceManagerFactory.getServiceObject(this.scheduleManagerServiceName);
        }
        if (this.scheduleManager == null) {
            throw new IllegalArgumentException("ScheduleManager is null.");
        }
    }

    @Override
    public boolean execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        ArrayList waitSchedules = new ArrayList();
        long timeout = 0L;
        int[] waitStates = new int[]{4, 5};
        int[] successStates = new int[]{4};
        try {
            String successStatesStr;
            String waitScheduleId = br.readLine();
            if (waitScheduleId == null || waitScheduleId.length() == 0) {
                throw new Exception("Unexpected EOF on waitScheduleId");
            }
            if (preResult == null && (waitScheduleId == null || waitScheduleId.length() == 0)) {
                throw new Exception("Unexpected EOF on waitScheduleId");
            }
            if (waitScheduleId != null && waitScheduleId.length() != 0) {
                Object actionResult = null;
                if (waitScheduleId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(waitScheduleId);
                } else {
                    String[] ids = waitScheduleId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal waitScheduleId format. id=" + waitScheduleId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + waitScheduleId);
                }
                if (!(actionResult instanceof List) || ((List)actionResult).size() != 0 && !(((List)actionResult).get(0) instanceof Schedule)) {
                    throw new Exception("TestActionResult not instance of Schedule List. result=" + actionResult);
                }
                waitSchedules.addAll((List)actionResult);
            } else {
                if (preResult == null) {
                    throw new Exception("preResult is null.");
                }
                if (!(preResult instanceof List) || ((List)preResult).size() != 0 && !(((List)preResult).get(0) instanceof Schedule)) {
                    throw new Exception("preResult not instance of Schedule List. result=" + preResult);
                }
                waitSchedules.addAll((List)preResult);
            }
            if (waitSchedules.size() == 0) {
                throw new Exception("Wait Schedule not found.");
            }
            String timeoutStr = br.readLine();
            if (timeoutStr == null || timeoutStr.length() == 0) {
                throw new Exception("Unexpected EOF on timeout");
            }
            try {
                timeout = Long.parseLong(timeoutStr);
            }
            catch (NumberFormatException e) {
                throw new Exception("Illegal timeout format. timeout=" + timeoutStr);
            }
            String waitStatesStr = br.readLine();
            if (waitStatesStr != null && waitStatesStr.length() != 0) {
                String[] waitStatesArray = waitStatesStr.split(",");
                waitStates = new int[waitStatesArray.length];
                for (int i = 0; i < waitStatesArray.length; ++i) {
                    if ("END".equals(waitStatesArray[i])) {
                        waitStates[i] = 4;
                        continue;
                    }
                    if ("FAILED".equals(waitStatesArray[i])) {
                        waitStates[i] = 5;
                        continue;
                    }
                    if ("RETRY".equals(waitStatesArray[i])) {
                        waitStates[i] = 8;
                        continue;
                    }
                    if ("DISABLE".equals(waitStatesArray[i])) {
                        waitStates[i] = 9;
                        continue;
                    }
                    throw new Exception("Illegal waitState format. waitState=" + waitStatesArray[i]);
                }
            }
            if ((successStatesStr = br.readLine()) != null && successStatesStr.length() != 0) {
                String[] successStatesArray = successStatesStr.split(",");
                successStates = new int[successStatesArray.length];
                for (int i = 0; i < successStatesArray.length; ++i) {
                    if ("END".equals(successStatesArray[i])) {
                        successStates[i] = 4;
                        continue;
                    }
                    if ("FAILED".equals(successStatesArray[i])) {
                        successStates[i] = 5;
                        continue;
                    }
                    if ("RETRY".equals(successStatesArray[i])) {
                        successStates[i] = 8;
                        continue;
                    }
                    if ("DISABLE".equals(successStatesArray[i])) {
                        successStates[i] = 9;
                        continue;
                    }
                    throw new Exception("Illegal successState format. successState=" + successStatesArray[i]);
                }
            }
        }
        finally {
            br.close();
            br = null;
        }
        long waitEndTime = System.currentTimeMillis() + timeout;
        long interval = Math.min(this.waitInterval, timeout);
        boolean result = true;
        do {
            String id;
            Schedule schedule;
            if ((schedule = this.scheduleManager.findSchedule(id = ((Schedule)waitSchedules.get(0)).getId())) == null) {
                throw new Exception("Schedule not found. id=" + id);
            }
            boolean isNotify = false;
            for (int i = 0; i < waitStates.length; ++i) {
                if (schedule.getState() != waitStates[i]) continue;
                boolean isSuccess = false;
                for (int j = 0; j < successStates.length; ++j) {
                    if (schedule.getState() != successStates[j]) continue;
                    isSuccess = true;
                    break;
                }
                result &= isSuccess;
                waitSchedules.remove(0);
                isNotify = true;
                break;
            }
            if (isNotify) continue;
            if (System.currentTimeMillis() >= waitEndTime) {
                List dependsSchedules = this.scheduleManager.findDependsSchedules(id);
                throw new Exception("The timeout has been reached due to waiting for the schedule. schedule=" + schedule + ", dependsSchedules=" + dependsSchedules);
            }
            Thread.sleep(interval);
        } while (waitSchedules.size() != 0);
        return result;
    }
}

