/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.proxy.netcrusher;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.test.proxy.netcrusher.TcpNetProxyServiceMBean;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.tcp.TcpCrusher;
import org.netcrusher.tcp.TcpCrusherBuilder;

public class TcpNetProxyService
extends ServiceBase
implements TcpNetProxyServiceMBean {
    private static final long serialVersionUID = -4869670081081516724L;
    protected String bindAddress;
    protected int bindPort = -1;
    protected String connectAddress;
    protected int connectPort = -1;
    protected boolean isOpenOnStart = true;
    protected NioReactor reactor;
    protected TcpCrusher crusher;

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void setBindAddress(String address) {
        this.bindAddress = address;
    }

    @Override
    public int getBindPort() {
        return this.bindPort;
    }

    @Override
    public void setBindPort(int port) {
        this.bindPort = port;
    }

    @Override
    public String getConnectAddress() {
        return this.connectAddress;
    }

    @Override
    public void setConnectAddress(String address) {
        this.connectAddress = address;
    }

    @Override
    public int getConnectPort() {
        return this.connectPort;
    }

    @Override
    public void setConnectPort(int port) {
        this.connectPort = port;
    }

    @Override
    public boolean isOpenOnStart() {
        return this.isOpenOnStart;
    }

    @Override
    public void setOpenOnStart(boolean isOpenOnStart) {
        this.isOpenOnStart = isOpenOnStart;
    }

    @Override
    public void createService() throws Exception {
        this.reactor = new NioReactor();
    }

    @Override
    public void startService() throws Exception {
        if (this.bindAddress == null) {
            this.bindAddress = InetAddress.getLocalHost().getHostAddress();
        }
        if (this.bindPort == -1) {
            throw new IllegalArgumentException("BindPort must be specified.");
        }
        if (this.connectPort == -1) {
            throw new IllegalArgumentException("ConnectPort must be specified.");
        }
        if (this.connectAddress == null || "".equals(this.connectAddress)) {
            throw new IllegalArgumentException("ConnectAddress must be specified.");
        }
        this.crusher = TcpCrusherBuilder.builder().withReactor(this.reactor).withBindAddress(this.bindAddress, this.bindPort).withConnectAddress(this.connectAddress, this.connectPort).build();
        if (this.isOpenOnStart) {
            this.open();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.crusher != null) {
            this.crusher.close();
        }
        if (this.reactor != null) {
            this.reactor.close();
        }
    }

    @Override
    public void open() {
        this.crusher.open();
    }

    @Override
    public void close() {
        this.crusher.close();
    }

    @Override
    public boolean isOpen() {
        return this.crusher.isOpen();
    }

    @Override
    public void closeAllPairs() {
        this.crusher.closeAllPairs();
    }

    @Override
    public void reopen() {
        this.crusher.reopen();
    }

    @Override
    public void freeze() {
        this.crusher.freeze();
    }

    @Override
    public void freezeAllPairs() {
        this.crusher.freezeAllPairs();
    }

    @Override
    public void unfreeze() {
        this.crusher.unfreeze();
    }

    @Override
    public void unfreezeAllPairs() {
        this.crusher.unfreezeAllPairs();
    }

    @Override
    public boolean isFrozen() {
        return this.crusher.isFrozen();
    }

    @Override
    public Set getClientAddresses() {
        HashSet<String> result = new HashSet<String>();
        Collection collect = this.crusher.getClientAddresses();
        if (collect != null) {
            Iterator itr = collect.iterator();
            while (itr.hasNext()) {
                result.add(itr.next().toString());
            }
        }
        return result;
    }
}

