/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.io.CSVWriter;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.report.CSVTestReporterServiceMBean;

public class CSVTestReporterService
extends ServiceBase
implements CSVTestReporterServiceMBean,
TestReporter {
    private static final long serialVersionUID = 8893610143514239762L;
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final String MSG_CAUSE = "Caused by: ";
    protected File outputFile;
    protected String encoding;
    protected String dateFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    protected CSVWriter csvWriter;

    @Override
    public void setOutputFile(File file) throws IOException {
        this.outputFile = file == null ? null : file.getCanonicalFile();
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setCSVWriter(CSVWriter writer) {
        this.csvWriter = writer;
    }

    @Override
    public void startService() throws Exception {
        if (this.outputFile == null) {
            throw new IllegalArgumentException("OutputFile is null.");
        }
        if (this.outputFile.getParentFile() != null && !this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Output dir can not make. path=" + this.outputFile.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(TestController controller) {
        CSVWriter writer;
        CSVWriter cSVWriter = writer = this.csvWriter == null ? new CSVWriter() : this.csvWriter.cloneWriter();
        if (writer.getNullValue() == null) {
            writer.setNullValue("");
        }
        ArrayList<String> csv = new ArrayList<String>();
        try {
            BufferedWriter bw = new BufferedWriter(this.encoding == null ? new FileWriter(this.outputFile) : new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.encoding));
            writer.setWriter(bw);
            TreeSet scenarioGroupCategorySet = new TreeSet();
            TreeSet scenarioCategorySet = new TreeSet();
            TreeSet testcaseCategorySet = new TreeSet();
            TestScenarioGroup[] groups = controller.getScenarioGroups();
            for (int i = 0; i < groups.length; ++i) {
                Map categoryMap;
                TestScenarioGroup.TestScenarioGroupResource sgr = groups[i].getTestScenarioGroupResource();
                if (sgr != null && (categoryMap = sgr.getCategoryMap()).size() != 0) {
                    scenarioGroupCategorySet.addAll(categoryMap.keySet());
                }
                TestScenario[] scenarios = controller.getScenarios(groups[i].getScenarioGroupId());
                for (int j = 0; j < scenarios.length; ++j) {
                    Map categoryMap2;
                    TestScenario.TestScenarioResource sr = scenarios[j].getTestScenarioResource();
                    if (sr != null && (categoryMap2 = sr.getCategoryMap()).size() != 0) {
                        scenarioCategorySet.addAll(categoryMap2.keySet());
                    }
                    TestCase[] testcases = controller.getTestCases(groups[i].getScenarioGroupId(), scenarios[j].getScenarioId());
                    for (int k = 0; k < testcases.length; ++k) {
                        Map categoryMap3;
                        TestCase.TestCaseResource tr = testcases[k].getTestCaseResource();
                        if (tr == null || (categoryMap3 = tr.getCategoryMap()).size() == 0) continue;
                        testcaseCategorySet.addAll(categoryMap3.keySet());
                    }
                }
            }
            csv.add("ScenarioGroupId");
            for (String categoryName : scenarioGroupCategorySet) {
                csv.add(categoryName);
            }
            csv.add("Title");
            csv.add("Description");
            csv.add("UserId");
            csv.add("StartTime");
            csv.add("EndTime");
            csv.add("State");
            csv.add("Result");
            csv.add("Exception");
            csv.add("ActionId");
            csv.add("Title");
            csv.add("Description");
            csv.add("ActionType");
            csv.add("Result");
            csv.add("Exception");
            csv.add("ScenarioId");
            for (String categoryName : scenarioCategorySet) {
                csv.add(categoryName);
            }
            csv.add("Title");
            csv.add("Description");
            csv.add("UserId");
            csv.add("StartTime");
            csv.add("EndTime");
            csv.add("State");
            csv.add("Result");
            csv.add("Exception");
            csv.add("ActionId");
            csv.add("Title");
            csv.add("Description");
            csv.add("ActionType");
            csv.add("Result");
            csv.add("Exception");
            csv.add("TestcaseId");
            for (String categoryName : testcaseCategorySet) {
                csv.add(categoryName);
            }
            csv.add("Title");
            csv.add("Description");
            csv.add("UserId");
            csv.add("StartTime");
            csv.add("EndTime");
            csv.add("State");
            csv.add("Result");
            csv.add("Exception");
            csv.add("ActionId");
            csv.add("Title");
            csv.add("Description");
            csv.add("ActionType");
            csv.add("Result");
            csv.add("Exception");
            writer.writeCSV(csv);
            for (int i = 0; i < groups.length; ++i) {
                int j;
                TestScenarioGroup.TestScenarioGroupResource sgr = groups[i].getTestScenarioGroupResource();
                csv.clear();
                this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, true);
                this.addScenarioElements(csv, null, null, scenarioCategorySet, null, null, false);
                this.addTestCaseElements(csv, null, null, testcaseCategorySet, null, null, false);
                writer.writeCSV(csv);
                if (sgr != null) {
                    String[] actionIds = sgr.getBeforeActionIds();
                    if (actionIds != null) {
                        for (j = 0; j < actionIds.length; ++j) {
                            csv.clear();
                            this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, actionIds[j], "before", false);
                            this.addScenarioElements(csv, null, null, scenarioCategorySet, null, null, false);
                            this.addTestCaseElements(csv, null, null, testcaseCategorySet, null, null, false);
                            writer.writeCSV(csv);
                        }
                    }
                    if ((actionIds = sgr.getFinallyActionIds()) != null) {
                        for (j = 0; j < actionIds.length; ++j) {
                            csv.clear();
                            this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, actionIds[j], "finally", false);
                            this.addScenarioElements(csv, null, null, scenarioCategorySet, null, null, false);
                            this.addTestCaseElements(csv, null, null, testcaseCategorySet, null, null, false);
                            writer.writeCSV(csv);
                        }
                    }
                }
                TestScenario[] scenarios = controller.getScenarios(groups[i].getScenarioGroupId());
                for (j = 0; j < scenarios.length; ++j) {
                    int k;
                    TestScenario.TestScenarioResource sr = scenarios[j].getTestScenarioResource();
                    csv.clear();
                    this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                    this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, null, null, true);
                    this.addTestCaseElements(csv, null, null, testcaseCategorySet, null, null, false);
                    writer.writeCSV(csv);
                    if (sr != null) {
                        String[] actionIds = sr.getBeforeActionIds();
                        if (actionIds != null) {
                            for (k = 0; k < actionIds.length; ++k) {
                                csv.clear();
                                this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                                this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, actionIds[k], "before", false);
                                this.addTestCaseElements(csv, null, null, testcaseCategorySet, null, null, false);
                                writer.writeCSV(csv);
                            }
                        }
                        if ((actionIds = sr.getAfterActionIds()) != null) {
                            for (k = 0; k < actionIds.length; ++k) {
                                csv.clear();
                                this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                                this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, actionIds[k], "after", false);
                                this.addTestCaseElements(csv, null, null, testcaseCategorySet, null, null, false);
                                writer.writeCSV(csv);
                            }
                        }
                        if ((actionIds = sr.getFinallyActionIds()) != null) {
                            for (k = 0; k < actionIds.length; ++k) {
                                csv.clear();
                                this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                                this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, actionIds[k], "finally", false);
                                this.addTestCaseElements(csv, null, null, testcaseCategorySet, null, null, false);
                                writer.writeCSV(csv);
                            }
                        }
                    }
                    TestCase[] testcases = controller.getTestCases(groups[i].getScenarioGroupId(), scenarios[j].getScenarioId());
                    for (k = 0; k < testcases.length; ++k) {
                        int l;
                        TestCase.TestCaseResource tr = testcases[k].getTestCaseResource();
                        csv.clear();
                        this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                        this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, null, null, false);
                        this.addTestCaseElements(csv, testcases[k], tr, testcaseCategorySet, null, null, true);
                        writer.writeCSV(csv);
                        if (tr == null) continue;
                        String[] actionIds = tr.getBeforeActionIds();
                        if (actionIds != null) {
                            for (l = 0; l < actionIds.length; ++l) {
                                csv.clear();
                                this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                                this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, null, null, false);
                                this.addTestCaseElements(csv, testcases[k], tr, testcaseCategorySet, actionIds[l], "before", false);
                                writer.writeCSV(csv);
                            }
                        }
                        if ((actionIds = tr.getActionIds()) != null) {
                            for (l = 0; l < actionIds.length; ++l) {
                                csv.clear();
                                this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                                this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, null, null, false);
                                this.addTestCaseElements(csv, testcases[k], tr, testcaseCategorySet, actionIds[l], "action", false);
                                writer.writeCSV(csv);
                            }
                        }
                        if ((actionIds = tr.getAfterActionIds()) != null) {
                            for (l = 0; l < actionIds.length; ++l) {
                                csv.clear();
                                this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                                this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, null, null, false);
                                this.addTestCaseElements(csv, testcases[k], tr, testcaseCategorySet, actionIds[l], "after", false);
                                writer.writeCSV(csv);
                            }
                        }
                        if ((actionIds = tr.getFinallyActionIds()) == null) continue;
                        for (l = 0; l < actionIds.length; ++l) {
                            csv.clear();
                            this.addScenarioGroupElements(csv, groups[i], sgr, scenarioGroupCategorySet, null, null, false);
                            this.addScenarioElements(csv, scenarios[j], sr, scenarioCategorySet, null, null, false);
                            this.addTestCaseElements(csv, testcases[k], tr, testcaseCategorySet, actionIds[l], "finally", false);
                            writer.writeCSV(csv);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("CTR__00001", e);
            return;
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException iOException) {}
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void addScenarioGroupElements(List csv, TestScenarioGroup group, TestScenarioGroup.TestScenarioGroupResource resource, Set categoryNameSet, String actionId, String actionType, boolean isOutputStatus) throws Exception {
        boolean isNotRun;
        Map categoryMap;
        csv.add(group.getScenarioGroupId());
        Iterator categories = categoryNameSet.iterator();
        Map map = categoryMap = resource == null ? null : resource.getCategoryMap();
        while (categories.hasNext()) {
            String categoryName = (String)categories.next();
            csv.add(categoryMap == null ? null : (Object)categoryMap.get(categoryName));
        }
        if (resource != null) {
            csv.add(resource.getTitle());
            csv.add(resource.getDescription());
        } else {
            csv.add(null);
            csv.add(null);
        }
        TestScenarioGroup.Status status = group.getStatus();
        boolean bl = isNotRun = status == null || status.getState() == 0;
        if (status == null || !isOutputStatus) {
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
        } else {
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            csv.add(status.getUserId());
            csv.add(status.getStartTime() == null ? null : format.format(status.getStartTime()));
            csv.add(status.getEndTime() == null ? null : format.format(status.getEndTime()));
            csv.add(status.getStateString());
            if (isNotRun) {
                csv.add(null);
                csv.add(null);
            } else {
                boolean result = status.getResult();
                if (result) {
                    csv.add("OK");
                    csv.add(null);
                } else if (status.getThrowable() == null) {
                    csv.add("NG");
                    csv.add(null);
                } else {
                    csv.add("ERROR");
                    csv.add(this.toStackTraceString(status.getThrowable()));
                }
            }
        }
        csv.add(actionId);
        if (actionId == null) {
            csv.add(null);
            csv.add(null);
        } else {
            csv.add(resource.getActionTitle(actionId));
            csv.add(resource.getActionDescription(actionId));
        }
        csv.add(actionType);
        if (status == null || isNotRun) {
            csv.add(null);
            csv.add(null);
        } else if (actionId == null) {
            csv.add(null);
            csv.add(this.toStackTraceString(status.getThrowable()));
        } else {
            boolean actionResult = status.getActionResult(actionId);
            if (actionResult) {
                csv.add("OK");
                csv.add(null);
            } else if (status.getThrowable() == null) {
                csv.add("NG");
                csv.add(null);
            } else if (actionId.equals(status.getCurrentActionId())) {
                csv.add("ERROR");
                csv.add(this.toStackTraceString(status.getThrowable()));
            } else {
                csv.add(null);
                csv.add(null);
            }
        }
    }

    protected void addScenarioElements(List csv, TestScenario scenario, TestScenario.TestScenarioResource resource, Set categoryNameSet, String actionId, String actionType, boolean isOutputStatus) throws Exception {
        boolean isNotRun;
        Map categoryMap;
        if (scenario == null) {
            csv.add(null);
        } else {
            csv.add(scenario.getScenarioId());
        }
        Iterator categories = categoryNameSet.iterator();
        Map map = categoryMap = resource == null ? null : resource.getCategoryMap();
        while (categories.hasNext()) {
            String categoryName = (String)categories.next();
            csv.add(categoryMap == null ? null : (Object)categoryMap.get(categoryName));
        }
        if (resource != null) {
            csv.add(resource.getTitle());
            csv.add(resource.getDescription());
        } else {
            csv.add(null);
            csv.add(null);
        }
        TestScenario.Status status = resource == null ? null : scenario.getStatus();
        boolean bl = isNotRun = status == null || status.getState() == 0;
        if (status == null || !isOutputStatus) {
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
        } else {
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            csv.add(status.getUserId());
            csv.add(status.getStartTime() == null ? null : format.format(status.getStartTime()));
            csv.add(status.getEndTime() == null ? null : format.format(status.getEndTime()));
            csv.add(status.getStateString());
            if (isNotRun) {
                csv.add(null);
                csv.add(null);
            } else {
                boolean result = status.getResult();
                if (result) {
                    csv.add("OK");
                    csv.add(null);
                } else if (status.getThrowable() == null) {
                    csv.add("NG");
                    csv.add(null);
                } else {
                    csv.add("ERROR");
                    csv.add(this.toStackTraceString(status.getThrowable()));
                }
            }
        }
        csv.add(actionId);
        if (resource == null || actionId == null) {
            csv.add(null);
            csv.add(null);
        } else {
            csv.add(resource.getActionTitle(actionId));
            csv.add(resource.getActionDescription(actionId));
        }
        csv.add(actionType);
        if (status == null || isNotRun) {
            csv.add(null);
            csv.add(null);
        } else if (actionId == null) {
            csv.add(null);
            csv.add(this.toStackTraceString(status.getThrowable()));
        } else {
            boolean actionResult = status.getActionResult(actionId);
            if (actionResult) {
                csv.add("OK");
                csv.add(null);
            } else if (status.getThrowable() == null) {
                csv.add("NG");
                csv.add(null);
            } else if (actionId.equals(status.getCurrentActionId())) {
                csv.add("ERROR");
                csv.add(this.toStackTraceString(status.getThrowable()));
            } else {
                csv.add(null);
                csv.add(null);
            }
        }
    }

    protected void addTestCaseElements(List csv, TestCase testCase, TestCase.TestCaseResource resource, Set categoryNameSet, String actionId, String actionType, boolean isOutputStatus) throws Exception {
        boolean isNotRun;
        Map categoryMap;
        if (testCase == null) {
            csv.add(null);
        } else {
            csv.add(testCase.getTestCaseId());
        }
        Iterator categories = categoryNameSet.iterator();
        Map map = categoryMap = resource == null ? null : resource.getCategoryMap();
        while (categories.hasNext()) {
            String categoryName = (String)categories.next();
            csv.add(categoryMap == null ? null : (Object)categoryMap.get(categoryName));
        }
        if (resource != null) {
            csv.add(resource.getTitle());
            csv.add(resource.getDescription());
        } else {
            csv.add(null);
            csv.add(null);
        }
        TestCase.Status status = resource == null ? null : testCase.getStatus();
        boolean bl = isNotRun = status == null || status.getState() == 0;
        if (status == null || !isOutputStatus) {
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
            csv.add(null);
        } else {
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            csv.add(status.getUserId());
            csv.add(status.getStartTime() == null ? null : format.format(status.getStartTime()));
            csv.add(status.getEndTime() == null ? null : format.format(status.getEndTime()));
            csv.add(status.getStateString());
            if (isNotRun) {
                csv.add(null);
                csv.add(null);
            } else {
                boolean result = status.getResult();
                if (result) {
                    csv.add("OK");
                    csv.add(null);
                } else if (status.getThrowable() == null) {
                    csv.add("NG");
                    csv.add(null);
                } else {
                    csv.add("ERROR");
                    csv.add(this.toStackTraceString(status.getThrowable()));
                }
            }
        }
        csv.add(actionId);
        if (resource == null || actionId == null) {
            csv.add(null);
            csv.add(null);
        } else {
            csv.add(resource.getActionTitle(actionId));
            csv.add(resource.getActionDescription(actionId));
        }
        csv.add(actionType);
        if (status == null || isNotRun) {
            csv.add(null);
            csv.add(null);
        } else if (actionId == null) {
            csv.add(null);
            csv.add(this.toStackTraceString(status.getThrowable()));
        } else {
            boolean actionResult = status.getActionResult(actionId);
            if (actionResult) {
                csv.add("OK");
                csv.add(null);
            } else if (status.getThrowable() == null) {
                csv.add("NG");
                csv.add(null);
            } else if (actionId.equals(status.getCurrentActionId())) {
                csv.add("ERROR");
                csv.add(this.toStackTraceString(status.getThrowable()));
            } else {
                csv.add(null);
                csv.add(null);
            }
        }
    }

    protected String toStackTraceString(Throwable th) {
        if (th == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(th).append(LINE_SEP);
        StackTraceElement[] elements = th.getStackTrace();
        if (elements != null) {
            int max = elements.length;
            for (int i = 0; i < max; ++i) {
                buf.append('\t');
                buf.append(elements[i]);
                if (i == max - 1) continue;
                buf.append(LINE_SEP);
            }
        }
        for (Throwable cause = th.getCause(); cause != null; cause = cause.getCause()) {
            buf.append(LINE_SEP).append(MSG_CAUSE).append(cause).append(LINE_SEP);
            StackTraceElement[] elems = cause.getStackTrace();
            if (elems == null) continue;
            int max = elems.length;
            for (int i = 0; i < max; ++i) {
                buf.append('\t');
                buf.append(elems[i]);
                if (i == max - 1) continue;
                buf.append(LINE_SEP);
            }
        }
        return buf.toString();
    }
}

