/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.report.ConsoleTestReporterServiceMBean;

public class ConsoleTestReporterService
extends ServiceBase
implements ConsoleTestReporterServiceMBean,
TestReporter {
    private static final long serialVersionUID = -4424650003483721058L;

    @Override
    public void report(TestController controller) {
        TestResult result = new TestResult();
        try {
            TestScenarioGroup[] groups = controller.getScenarioGroups();
            for (int i = 0; i < groups.length; ++i) {
                Date startTime;
                TestScenarioGroup.Status groupStatus = groups[i].getStatus();
                if (groupStatus == null || (startTime = groupStatus.getStartTime()) == null) continue;
                ScenarioGroupResult scenarioGroupResult = new ScenarioGroupResult(groups[i]);
                result.add(scenarioGroupResult);
                TestScenario[] scenarios = controller.getScenarios(groups[i].getScenarioGroupId());
                for (int j = 0; j < scenarios.length; ++j) {
                    TestScenario.Status scenarioStatus = scenarios[j].getStatus();
                    if (scenarioStatus == null || (startTime = scenarioStatus.getStartTime()) == null) continue;
                    ScenarioResult scenarioResult = new ScenarioResult(scenarios[j]);
                    scenarioGroupResult.add(scenarioResult);
                    TestCase[] testcases = controller.getTestCases(groups[i].getScenarioGroupId(), scenarios[j].getScenarioId());
                    for (int k = 0; k < testcases.length; ++k) {
                        TestCase.Status testcaseStatus = testcases[k].getStatus();
                        if (testcaseStatus == null || (startTime = testcaseStatus.getStartTime()) == null) continue;
                        TestCaseResult testCaseResult = new TestCaseResult(testcases[k]);
                        scenarioResult.add(testCaseResult);
                    }
                }
            }
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("CTR__00001", e);
            return;
        }
        System.out.println(result);
        for (ScenarioGroupResult group : result.scenarioGroupResultMap.values()) {
            System.out.println();
            System.out.println(group.toString());
            System.out.println(group.toSummuryString());
            for (ScenarioResult scenario : group.scenarioResultMap.values()) {
                System.out.println();
                System.out.println("\t" + scenario.toString());
                System.out.println("\t" + scenario.toSummuryString());
                for (TestCaseResult testcase : scenario.testcaseResultMap.values()) {
                    System.out.println();
                    System.out.println("\t\t" + testcase.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getStackTraceString(Throwable th) {
        String result = null;
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            pw.println(th);
            StackTraceElement[] elemss = th.getStackTrace();
            if (elemss != null) {
                int max = elemss.length;
                for (int i = 0; i < max; ++i) {
                    pw.print('\t');
                    pw.print(elemss[i]);
                    if (i == max - 1) continue;
                    pw.println();
                }
            }
            for (Throwable ee = th.getCause(); ee != null; ee = ee.getCause()) {
                pw.println();
                pw.print("Caused by: ");
                pw.print(ee);
                pw.println();
                StackTraceElement[] elems = ee.getStackTrace();
                if (elems == null) continue;
                int max = elems.length;
                for (int i = 0; i < max; ++i) {
                    pw.print('\t');
                    pw.print(elems[i]);
                    if (i == max - 1) continue;
                    pw.println();
                }
            }
            pw.flush();
            result = sw.toString();
        }
        return result;
    }

    private class TestCaseResult {
        public final String testcaseId;
        public final String title;
        public final boolean result;
        public final Throwable throwable;
        public final String cuurentActionId;
        public final List ngList = new ArrayList();

        public TestCaseResult(TestCase testcase) throws Exception {
            this.testcaseId = testcase.getTestCaseId();
            this.title = testcase.getTestCaseResource().getTitle();
            TestCase.Status status = testcase.getStatus();
            this.result = status.getResult();
            this.throwable = status.getThrowable();
            this.cuurentActionId = status.getCurrentActionId();
            if (!this.result) {
                int i;
                TestCase.TestCaseResource caseResource = testcase.getTestCaseResource();
                String[] actionIds = caseResource.getBeforeActionIds();
                for (i = 0; i < actionIds.length; ++i) {
                    if (!status.getActionResultMap().containsKey(actionIds[i]) || status.getActionResult(actionIds[i])) continue;
                    this.ngList.add(actionIds[i]);
                }
                actionIds = caseResource.getActionIds();
                for (i = 0; i < actionIds.length; ++i) {
                    if (!status.getActionResultMap().containsKey(actionIds[i]) || status.getActionResult(actionIds[i])) continue;
                    this.ngList.add(actionIds[i]);
                }
                actionIds = caseResource.getAfterActionIds();
                for (i = 0; i < actionIds.length; ++i) {
                    if (!status.getActionResultMap().containsKey(actionIds[i]) || status.getActionResult(actionIds[i])) continue;
                    this.ngList.add(actionIds[i]);
                }
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.testcaseId);
            if (this.title != null && this.title.length() != 0) {
                buf.append(':').append(this.title);
            }
            buf.append('=');
            if (this.throwable == null) {
                if (this.result) {
                    buf.append("OK");
                } else {
                    buf.append("NG").append(" : errorActionId=").append(this.ngList);
                }
            } else {
                buf.append("ERROR").append(" : errorAction=").append(this.cuurentActionId).append(", cause=").append(ConsoleTestReporterService.getStackTraceString(this.throwable));
            }
            return buf.toString();
        }
    }

    private class ScenarioResult {
        public final String scenarioId;
        public final String title;
        public final boolean result;
        public final Throwable throwable;
        public final String cuurentActionId;
        public final Map testcaseResultMap = new LinkedHashMap();
        public final List okList = new ArrayList();
        public final List ngList = new ArrayList();
        public final List errorList = new ArrayList();

        public ScenarioResult(TestScenario scenario) throws Exception {
            this.scenarioId = scenario.getScenarioId();
            this.title = scenario.getTestScenarioResource().getTitle();
            TestScenario.Status status = scenario.getStatus();
            this.result = status.getResult();
            this.throwable = status.getThrowable();
            this.cuurentActionId = status.getCurrentActionId();
        }

        public void add(TestCaseResult result) {
            this.testcaseResultMap.put(result.testcaseId, result);
            if (result.throwable == null) {
                if (result.result) {
                    this.okList.add(result.testcaseId);
                } else {
                    this.ngList.add(result.testcaseId);
                }
            } else {
                this.errorList.add(result.testcaseId);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.scenarioId);
            if (this.title != null && this.title.length() != 0) {
                buf.append(':').append(this.title);
            }
            buf.append('=');
            if (this.throwable == null) {
                if (this.result) {
                    buf.append("OK");
                } else {
                    buf.append("NG").append(" : errorActionId=").append(this.ngList);
                }
            } else {
                buf.append("ERROR").append(" : errorAction=").append(this.cuurentActionId).append(", cause=").append(ConsoleTestReporterService.getStackTraceString(this.throwable));
            }
            return buf.toString();
        }

        public String toSummuryString() {
            StringBuffer buf = new StringBuffer();
            buf.append("testcase:").append(this.testcaseResultMap.size());
            buf.append(", OK:").append(this.okList.size());
            buf.append(", NG:").append(this.ngList.size());
            buf.append(", ERROR:").append(this.errorList.size());
            return buf.toString();
        }
    }

    private class ScenarioGroupResult {
        public final String scenarioGroupId;
        public final String title;
        public final boolean result;
        public final Throwable throwable;
        public final String cuurentActionId;
        public final Map scenarioResultMap = new LinkedHashMap();
        public final List okList = new ArrayList();
        public final List ngList = new ArrayList();
        public final List errorList = new ArrayList();

        public ScenarioGroupResult(TestScenarioGroup scenarioGroup) throws Exception {
            this.scenarioGroupId = scenarioGroup.getScenarioGroupId();
            this.title = scenarioGroup.getTestScenarioGroupResource().getTitle();
            TestScenarioGroup.Status status = scenarioGroup.getStatus();
            this.result = status.getResult();
            this.throwable = status.getThrowable();
            this.cuurentActionId = status.getCurrentActionId();
        }

        public void add(ScenarioResult result) {
            this.scenarioResultMap.put(result.scenarioId, result);
            if (result.throwable == null) {
                if (result.result) {
                    this.okList.add(result.scenarioId);
                } else {
                    this.ngList.add(result.scenarioId);
                }
            } else {
                this.errorList.add(result.scenarioId);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.scenarioGroupId);
            if (this.title != null && this.title.length() != 0) {
                buf.append(':').append(this.title);
            }
            buf.append('=');
            if (this.throwable == null) {
                if (this.result) {
                    buf.append("OK");
                } else {
                    buf.append("NG");
                }
            } else {
                buf.append("ERROR").append(" : errorAction=").append(this.cuurentActionId).append(", cause=").append(ConsoleTestReporterService.getStackTraceString(this.throwable));
            }
            return buf.toString();
        }

        public String toSummuryString() {
            StringBuffer buf = new StringBuffer();
            buf.append("scenario:").append(this.scenarioResultMap.size());
            buf.append(", OK:").append(this.okList.size());
            buf.append(", NG:").append(this.ngList.size());
            buf.append(", ERROR:").append(this.errorList.size());
            return buf.toString();
        }
    }

    private class TestResult {
        public final Map scenarioGroupResultMap = new LinkedHashMap();
        public final List okList = new ArrayList();
        public final List ngList = new ArrayList();
        public final List errorList = new ArrayList();

        private TestResult() {
        }

        public void add(ScenarioGroupResult result) {
            this.scenarioGroupResultMap.put(result.scenarioGroupId, result);
            if (result.throwable == null) {
                if (result.result) {
                    this.okList.add(result.scenarioGroupId);
                } else {
                    this.ngList.add(result.scenarioGroupId);
                }
            } else {
                this.errorList.add(result.scenarioGroupId);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("scenario group:").append(this.scenarioGroupResultMap.size());
            buf.append(", OK:").append(this.okList.size());
            buf.append(", NG:").append(this.ngList.size());
            buf.append(", ERROR:").append(this.errorList.size());
            return buf.toString();
        }
    }
}

