/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.test.ScheduledTestResource;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.report.HtmlTestCaseProgressReporterServiceMBean;

public class HtmlTestCaseProgressReporterService
extends ServiceBase
implements HtmlTestCaseProgressReporterServiceMBean,
TestReporter {
    private static final long serialVersionUID = 8999894352277844390L;
    private File outputPath;

    @Override
    public File getOutputPath() {
        return this.outputPath;
    }

    @Override
    public void setOutputPath(File outputPath) throws IOException {
        this.outputPath = outputPath == null ? null : outputPath.getCanonicalFile();
    }

    @Override
    public void startService() throws Exception {
        if (this.outputPath == null) {
            throw new IllegalArgumentException("OutputPath is null.");
        }
        if (!this.outputPath.exists() && !this.outputPath.mkdirs()) {
            throw new IllegalArgumentException("Output dir can not make. path=" + this.outputPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(TestController controller) {
        try (PrintWriter pw = null;){
            TestScenarioGroup[] groups = controller.getScenarioGroups();
            pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.outputPath, "index.html"))));
            pw.println("<html>");
            pw.println("<head><title>TestCase Create Progress</title></head>");
            pw.println("<body>");
            pw.println("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">");
            pw.println("<tr bgcolor=\"#cccccc\">");
            pw.println("<th colspan=\"8\" scope=\"colgroup\">ScenarioGroup</th>");
            pw.println("<th colspan=\"8\" scope=\"colgroup\">Scenario</th>");
            pw.println("<th colspan=\"8\" scope=\"colgroup\">TestCase</th>");
            pw.println("</tr>");
            pw.println("<tr bgcolor=\"#cccccc\">");
            pw.println("<th scope=\"col\">ID</th>");
            pw.println("<th scope=\"col\">\u8aac\u660e</th>");
            pw.println("<th scope=\"col\">\u4f5c\u6210\u62c5\u5f53\u8005</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u4e88\u5b9a\u65e5</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u65e5</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u4e88\u5b9a\u65e5</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u65e5</th>");
            pw.println("<th scope=\"col\">\u9032\u6357</th>");
            pw.println("<th scope=\"col\">ID</th>");
            pw.println("<th scope=\"col\">\u8aac\u660e</th>");
            pw.println("<th scope=\"col\">\u4f5c\u6210\u62c5\u5f53\u8005</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u4e88\u5b9a\u65e5</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u65e5</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u4e88\u5b9a\u65e5</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u65e5</th>");
            pw.println("<th scope=\"col\">\u9032\u6357</th>");
            pw.println("<th scope=\"col\">ID</th>");
            pw.println("<th scope=\"col\">\u8aac\u660e</th>");
            pw.println("<th scope=\"col\">\u4f5c\u6210\u62c5\u5f53\u8005</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u4e88\u5b9a\u65e5</th>");
            pw.println("<th scope=\"col\">\u958b\u59cb\u65e5</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u4e88\u5b9a\u65e5</th>");
            pw.println("<th scope=\"col\">\u7d42\u4e86\u65e5</th>");
            pw.println("<th scope=\"col\">\u9032\u6357</th>");
            pw.println("</tr>");
            for (int index = 0; index < groups.length; ++index) {
                TestScenarioGroup.TestScenarioGroupResource resource = groups[index].getTestScenarioGroupResource();
                if (resource == null) continue;
                this.reportScenarioGroup(pw, controller, groups[index]);
            }
            pw.println("</body>");
            pw.println("</html>");
            pw.flush();
        }
    }

    private void reportScenarioGroup(PrintWriter pw, TestController controller, TestScenarioGroup group) throws Exception {
        TestScenario[] scenarios = controller.getScenarios(group.getScenarioGroupId());
        TreeMap<String, TestCase[]> scenarioTestcaseMap = new TreeMap<String, TestCase[]>();
        int testCaseCount = 0;
        for (int index = 0; index < scenarios.length; ++index) {
            TestCase[] cases = controller.getTestCases(group.getScenarioGroupId(), scenarios[index].getScenarioId());
            testCaseCount = cases.length == 0 ? ++testCaseCount : (testCaseCount += cases.length);
            scenarioTestcaseMap.put(scenarios[index].getScenarioId(), cases);
        }
        TestScenarioGroup.TestScenarioGroupResource groupResource = group.getTestScenarioGroupResource();
        pw.println("<tr>");
        this.printResource(pw, groupResource, group.getScenarioGroupId(), "rowgroup", testCaseCount);
        Iterator ite = scenarioTestcaseMap.keySet().iterator();
        boolean isFirst = true;
        while (ite.hasNext()) {
            String scenarioId = (String)ite.next();
            TestScenario testScenario = controller.getScenario(group.getScenarioGroupId(), scenarioId);
            TestScenario.TestScenarioResource testScenarioResource = testScenario.getTestScenarioResource();
            if (testScenarioResource == null) continue;
            TestCase[] cases = (TestCase[])scenarioTestcaseMap.get(scenarioId);
            int count = cases.length;
            if (count == 0) {
                count = 1;
            }
            if (!isFirst) {
                pw.println("<tr>");
            }
            isFirst = false;
            this.printResource(pw, testScenarioResource, scenarioId, "rowgroup", count);
            if (cases.length == 0) {
                pw.println("</tr>");
                continue;
            }
            this.printResource(pw, cases[0].getTestCaseResource(), cases[0].getTestCaseId(), "row", 0);
            pw.println("</tr>");
            for (int index = 1; index < cases.length; ++index) {
                pw.println("<tr>");
                this.printResource(pw, cases[index].getTestCaseResource(), cases[index].getTestCaseId(), "row", 0);
                pw.println("</tr>");
            }
        }
    }

    private String format(Date date) {
        return date != null ? new SimpleDateFormat("yyyy/MM/dd HH:mm").format(date) : "";
    }

    private String format(String str) {
        return str == null ? "" : str;
    }

    private String getBackGroundColor(Date scheduledDate, Date date) {
        if (scheduledDate != null && (date != null ? date.after(scheduledDate) : new Date().after(scheduledDate))) {
            return " bgcolor=\"#ff4500\"";
        }
        return "";
    }

    private void printResource(PrintWriter pw, ScheduledTestResource resource, String id, String scope, int rowspan) {
        String span = "";
        if (rowspan > 0) {
            span = "rowspan=\"" + rowspan + "\" ";
        }
        pw.println("<td " + span + "scope=\"" + scope + "\">" + id + "</td>");
        pw.println("<td " + span + "scope=\"" + scope + "\" title=\"" + this.format(resource.getDescription()) + "\">" + this.format(resource.getTitle()) + "</td>");
        pw.println("<td " + span + "scope=\"" + scope + "\">" + this.format(resource.getCreator()) + "</td>");
        Date scheduledCreateStartDate = resource.getScheduledCreateStartDate();
        Date createStartDate = resource.getCreateStartDate();
        Date scheduledCreateEndDate = resource.getScheduledCreateEndDate();
        Date createEndDate = resource.getCreateEndDate();
        pw.println("<td " + span + "scope=\"" + scope + "\" align=\"center\">" + this.format(scheduledCreateStartDate) + "</td>");
        pw.println("<td " + span + "scope=\"" + scope + "\" align=\"center\"" + this.getBackGroundColor(scheduledCreateStartDate, createStartDate) + ">" + this.format(createStartDate) + "</td>");
        pw.println("<td " + span + "scope=\"" + scope + "\" align=\"center\">" + this.format(scheduledCreateEndDate) + "</td>");
        pw.println("<td " + span + "scope=\"" + scope + "\" align=\"center\"" + this.getBackGroundColor(scheduledCreateEndDate, createEndDate) + ">" + this.format(createEndDate) + "</td>");
        pw.println("<td " + span + "scope=\"" + scope + "\">" + resource.getProgress() + "</td>");
    }
}

