/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.report.MSProjectTestReporterServiceMBean;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.writer.ProjectWriter;

public class MSProjectTestReporterService
extends ServiceBase
implements MSProjectTestReporterServiceMBean,
TestReporter {
    private static final long serialVersionUID = -8405883932573172092L;
    protected File outputFile;
    protected ProjectWriter projectWriter;

    @Override
    public void setOutputFile(File file) throws IOException {
        this.outputFile = file == null ? null : file.getCanonicalFile();
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setProjectWriter(ProjectWriter pw) {
        this.projectWriter = pw;
    }

    @Override
    public void startService() throws Exception {
        if (this.outputFile == null) {
            throw new IllegalArgumentException("OutputFile is null.");
        }
        if (this.outputFile.getParentFile() != null && !this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Output dir can not make. path=" + this.outputFile.getParentFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(TestController controller) {
        try {
            ProjectFile pf = new ProjectFile();
            ProjectCalendar cal = pf.getDefaultCalendar();
            TestScenarioGroup[] groups = controller.getScenarioGroups();
            HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
            for (int i = 0; i < groups.length; ++i) {
                TestScenarioGroup.TestScenarioGroupResource sgr = groups[i].getTestScenarioGroupResource();
                if (sgr == null) continue;
                Task groupTask = pf.addTask();
                String title = sgr.getTitle();
                if (title == null || title.length() == 0) {
                    groupTask.setName(groups[i].getScenarioGroupId());
                } else {
                    groupTask.setName(groups[i].getScenarioGroupId() + ':' + title);
                }
                groupTask.setCalendar(cal);
                if (sgr.getCreator() != null) {
                    Resource resource = null;
                    if (!resourceMap.containsKey(sgr.getCreator())) {
                        resource = pf.addResource();
                        resource.setName(sgr.getCreator());
                        resourceMap.put(sgr.getCreator(), resource);
                    } else {
                        resource = (Resource)resourceMap.get(sgr.getCreator());
                    }
                    ResourceAssignment ra = pf.newResourceAssignment(groupTask);
                    ra.setResourceUniqueID(resource.getUniqueID());
                    if (sgr.getScheduledCreateStartDate() != null) {
                        ra.setStart(sgr.getScheduledCreateStartDate());
                    }
                    if (sgr.getScheduledCreateEndDate() != null) {
                        ra.setFinish(sgr.getScheduledCreateEndDate());
                    }
                    if (sgr.getCreateStartDate() != null) {
                        ra.setActualStart(sgr.getCreateStartDate());
                    }
                    if (sgr.getCreateEndDate() != null) {
                        ra.setActualFinish(sgr.getCreateEndDate());
                    }
                    resource.addResourceAssignment(ra);
                    groupTask.addResourceAssignment(ra);
                    groupTask.setResourceNames(sgr.getCreator());
                }
                if (sgr.getScheduledCreateStartDate() != null) {
                    groupTask.setStart(sgr.getScheduledCreateStartDate());
                }
                if (sgr.getScheduledCreateEndDate() != null) {
                    groupTask.setFinish(sgr.getScheduledCreateEndDate());
                }
                if (sgr.getCreateStartDate() != null) {
                    groupTask.setActualStart(sgr.getCreateStartDate());
                }
                if (sgr.getCreateEndDate() != null) {
                    groupTask.setActualFinish(sgr.getCreateEndDate());
                }
                if (sgr.getScheduledCreateStartDate() != null) {
                    if (sgr.getExpectedCost() > 0.0) {
                        groupTask.setManualDuration(Duration.getInstance((double)sgr.getExpectedCost(), (TimeUnit)TimeUnit.MINUTES));
                        groupTask.setDuration(Duration.getInstance((double)sgr.getExpectedCost(), (TimeUnit)TimeUnit.MINUTES));
                    }
                    if (sgr.getCreateStartDate() != null && sgr.getCreateEndDate() == null) {
                        if (sgr.getProgress() != 0.0) {
                            groupTask.setPercentageComplete((Number)new Double(sgr.getProgress()));
                        }
                    } else if (sgr.getCreateStartDate() != null && sgr.getCreateEndDate() != null) {
                        if (sgr.getCost() > 0.0) {
                            groupTask.setActualDuration(Duration.getInstance((double)sgr.getCost(), (TimeUnit)TimeUnit.MINUTES));
                        }
                        groupTask.setPercentageComplete((Number)new Double(100.0));
                        groupTask.setTaskMode(TaskMode.AUTO_SCHEDULED);
                    }
                }
                Task groupSummuryTask = pf.addTask();
                if (title == null) {
                    groupSummuryTask.setName(groups[i].getScenarioGroupId());
                } else {
                    groupSummuryTask.setName(groups[i].getScenarioGroupId() + ':' + title);
                }
                groupSummuryTask.setCalendar(cal);
                TestScenario[] scenarios = controller.getScenarios(groups[i].getScenarioGroupId());
                for (int j = 0; j < scenarios.length; ++j) {
                    TestScenario.TestScenarioResource sr = scenarios[j].getTestScenarioResource();
                    if (sr == null) continue;
                    Task scenarioTask = pf.addTask();
                    title = sr.getTitle();
                    if (title == null || title.length() == 0) {
                        scenarioTask.setName(scenarios[j].getScenarioId());
                    } else {
                        scenarioTask.setName(scenarios[j].getScenarioId() + ':' + title);
                    }
                    scenarioTask.setCalendar(cal);
                    scenarioTask.setTaskMode(TaskMode.MANUALLY_SCHEDULED);
                    if (sr.getCreator() != null) {
                        Resource resource = null;
                        if (!resourceMap.containsKey(sr.getCreator())) {
                            resource = pf.addResource();
                            resource.setName(sr.getCreator());
                            resourceMap.put(sr.getCreator(), resource);
                        } else {
                            resource = (Resource)resourceMap.get(sr.getCreator());
                        }
                        ResourceAssignment ra = pf.newResourceAssignment(scenarioTask);
                        ra.setResourceUniqueID(resource.getUniqueID());
                        if (sr.getScheduledCreateStartDate() != null) {
                            ra.setStart(sr.getScheduledCreateStartDate());
                        }
                        if (sr.getScheduledCreateEndDate() != null) {
                            ra.setFinish(sr.getScheduledCreateEndDate());
                        }
                        if (sr.getCreateStartDate() != null) {
                            ra.setActualStart(sr.getCreateStartDate());
                        }
                        if (sr.getCreateEndDate() != null) {
                            ra.setActualFinish(sr.getCreateEndDate());
                        }
                        resource.addResourceAssignment(ra);
                        scenarioTask.addResourceAssignment(ra);
                        scenarioTask.setResourceNames(sr.getCreator());
                    }
                    if (sr.getScheduledCreateStartDate() != null) {
                        scenarioTask.setStart(sr.getScheduledCreateStartDate());
                    }
                    if (sr.getScheduledCreateEndDate() != null) {
                        scenarioTask.setFinish(sr.getScheduledCreateEndDate());
                    }
                    if (sr.getCreateStartDate() != null) {
                        scenarioTask.setActualStart(sr.getCreateStartDate());
                    }
                    if (sr.getCreateEndDate() != null) {
                        scenarioTask.setActualFinish(sr.getCreateEndDate());
                    }
                    if (sr.getScheduledCreateStartDate() != null) {
                        if (sr.getExpectedCost() > 0.0) {
                            scenarioTask.setManualDuration(Duration.getInstance((double)sr.getExpectedCost(), (TimeUnit)TimeUnit.MINUTES));
                            scenarioTask.setDuration(Duration.getInstance((double)sr.getExpectedCost(), (TimeUnit)TimeUnit.MINUTES));
                        }
                        if (sr.getCreateStartDate() != null && sr.getCreateEndDate() == null) {
                            if (sr.getProgress() != 0.0) {
                                scenarioTask.setPercentageComplete((Number)new Double(sr.getProgress()));
                            }
                        } else if (sr.getCreateStartDate() != null && sr.getCreateEndDate() != null) {
                            if (sr.getCost() > 0.0) {
                                scenarioTask.setActualDuration(Duration.getInstance((double)sr.getCost(), (TimeUnit)TimeUnit.MINUTES));
                            }
                            scenarioTask.setPercentageComplete((Number)new Double(100.0));
                            scenarioTask.setTaskMode(TaskMode.AUTO_SCHEDULED);
                        }
                    }
                    groupSummuryTask.addChildTask(scenarioTask);
                    TestCase[] testcases = controller.getTestCases(groups[i].getScenarioGroupId(), scenarios[j].getScenarioId());
                    for (int k = 0; k < testcases.length; ++k) {
                        TestCase.TestCaseResource tcr = testcases[k].getTestCaseResource();
                        if (tcr == null || tcr.getCreator() == null && tcr.getScheduledCreateStartDate() == null && tcr.getCreateStartDate() == null) continue;
                        Task testcaseTask = pf.addTask();
                        title = tcr.getTitle();
                        if (title == null || title.length() == 0) {
                            testcaseTask.setName(testcases[k].getTestCaseId());
                        } else {
                            testcaseTask.setName(testcases[k].getTestCaseId() + ':' + title);
                        }
                        testcaseTask.setName(testcases[k].getTestCaseId());
                        testcaseTask.setCalendar(cal);
                        if (tcr.getCreator() != null) {
                            Resource resource = null;
                            if (!resourceMap.containsKey(tcr.getCreator())) {
                                resource = pf.addResource();
                                resource.setName(tcr.getCreator());
                                resourceMap.put(tcr.getCreator(), resource);
                            } else {
                                resource = (Resource)resourceMap.get(tcr.getCreator());
                            }
                            ResourceAssignment ra = pf.newResourceAssignment(testcaseTask);
                            ra.setResourceUniqueID(resource.getUniqueID());
                            if (tcr.getScheduledCreateStartDate() != null) {
                                ra.setStart(tcr.getScheduledCreateStartDate());
                            }
                            if (tcr.getScheduledCreateEndDate() != null) {
                                ra.setFinish(tcr.getScheduledCreateEndDate());
                            }
                            if (tcr.getCreateStartDate() != null) {
                                ra.setActualStart(tcr.getCreateStartDate());
                            }
                            if (tcr.getCreateEndDate() != null) {
                                ra.setActualFinish(tcr.getCreateEndDate());
                            }
                            resource.addResourceAssignment(ra);
                            testcaseTask.addResourceAssignment(ra);
                            testcaseTask.setResourceNames(tcr.getCreator());
                        }
                        if (tcr.getScheduledCreateStartDate() != null) {
                            testcaseTask.setStart(tcr.getScheduledCreateStartDate());
                        }
                        if (tcr.getScheduledCreateEndDate() != null) {
                            testcaseTask.setFinish(tcr.getScheduledCreateEndDate());
                        }
                        if (tcr.getCreateStartDate() != null) {
                            testcaseTask.setActualStart(tcr.getCreateStartDate());
                        }
                        if (tcr.getCreateEndDate() != null) {
                            testcaseTask.setActualFinish(tcr.getCreateEndDate());
                        }
                        if (tcr.getScheduledCreateStartDate() != null) {
                            if (tcr.getExpectedCost() > 0.0) {
                                testcaseTask.setManualDuration(Duration.getInstance((double)tcr.getExpectedCost(), (TimeUnit)TimeUnit.MINUTES));
                                testcaseTask.setDuration(Duration.getInstance((double)tcr.getExpectedCost(), (TimeUnit)TimeUnit.MINUTES));
                            }
                            if (tcr.getCreateStartDate() != null && tcr.getCreateEndDate() == null) {
                                if (tcr.getProgress() != 0.0) {
                                    testcaseTask.setPercentageComplete((Number)new Double(tcr.getProgress()));
                                }
                            } else if (tcr.getCreateStartDate() != null && tcr.getCreateEndDate() != null) {
                                if (tcr.getCost() > 0.0) {
                                    testcaseTask.setActualDuration(Duration.getInstance((double)tcr.getCost(), (TimeUnit)TimeUnit.MINUTES));
                                }
                                testcaseTask.setPercentageComplete((Number)new Double(100.0));
                                testcaseTask.setTaskMode(TaskMode.AUTO_SCHEDULED);
                            }
                        }
                        scenarioTask.addChildTask(testcaseTask);
                    }
                }
            }
            try (FileOutputStream fos = new FileOutputStream(this.outputFile);){
                MSPDIWriter pw = this.projectWriter == null ? new MSPDIWriter() : this.projectWriter;
                pw.write(pf, (OutputStream)fos);
            }
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("CTR__00001", e);
            return;
        }
    }
}

