/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.resource;

import java.io.File;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.test.TestResourceManager;
import jp.ossc.nimbus.service.test.resource.CVSTestResourceManagerServiceMBean;
import jp.ossc.nimbus.service.test.resource.LocalTestResourceManagerService;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.cvslib.cvsjava.CvsJavaScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class CVSTestResourceManagerService
extends LocalTestResourceManagerService
implements TestResourceManager,
CVSTestResourceManagerServiceMBean {
    private static final long serialVersionUID = -1903951590151650735L;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected String method;
    protected String userName;
    protected String password;
    protected String serverName;
    protected int port = -1;
    protected String repositoryPath;
    protected String modulePath;
    protected File cvsCheckOutDirectory;
    protected String targetBranch;
    protected String targetTag;
    protected ScmManager manager;
    protected ScmProvider provider;
    protected ScmRepository repository;
    protected ScmVersion branch;
    protected ScmVersion tag;
    protected boolean isDebugEnabled = false;
    protected boolean isInfoEnabled = true;
    protected boolean isWarnEnabled = true;
    protected boolean isErrorEnabled = true;

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String user) {
        this.userName = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String str) {
        this.password = str;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String server) {
        this.serverName = server;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    @Override
    public void setRepositoryPath(String path) {
        this.repositoryPath = path;
    }

    @Override
    public String getModulePath() {
        return this.modulePath;
    }

    @Override
    public void setModulePath(String module) {
        this.modulePath = module;
    }

    @Override
    public File getCvsCheckOutDirectory() {
        return this.cvsCheckOutDirectory;
    }

    @Override
    public void setCvsCheckOutDirectory(File directory) {
        this.cvsCheckOutDirectory = directory;
    }

    @Override
    public String getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    public void setTargetBranch(String branch) {
        this.targetBranch = branch;
    }

    @Override
    public String getTargetTag() {
        return this.targetTag;
    }

    @Override
    public void setTargetTag(String tag) {
        this.targetTag = tag;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        this.isDebugEnabled = enabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    @Override
    public void setInfoEnabled(boolean enabled) {
        this.isInfoEnabled = enabled;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    @Override
    public void setWarnEnabled(boolean enabled) {
        this.isWarnEnabled = enabled;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    @Override
    public void setErrorEnabled(boolean enabled) {
        this.isErrorEnabled = enabled;
    }

    @Override
    public void createService() throws Exception {
        this.manager = new CustomScmManager();
        this.provider = new CvsJavaScmProvider();
        this.manager.setScmProvider("cvs", this.provider);
    }

    @Override
    public void startService() throws Exception {
        super.startService();
        if (this.repositoryPath == null) {
            throw new IllegalArgumentException("RepositoryPath must be specified.");
        }
        if (this.modulePath == null) {
            throw new IllegalArgumentException("ModulePath must be specified.");
        }
        if (!("ext".equals(this.method) || "lserver".equals(this.method) || "local".equals(this.method) || "pserver".equals(this.method) || "sspi".equals(this.method))) {
            throw new IllegalArgumentException("Method is illegal value. method=" + this.method);
        }
        if (this.targetBranch != null && this.targetTag != null) {
            throw new IllegalArgumentException("TargetBranch and TargetTag can not be specified at the same time.");
        }
        if (this.cvsCheckOutDirectory == null) {
            throw new IllegalArgumentException("CvsCheckOutDirectory must be specified.");
        }
        if (this.targetBranch != null) {
            this.branch = new ScmBranch(this.targetBranch);
        }
        if (this.targetTag != null) {
            this.tag = new ScmTag(this.targetTag);
        }
    }

    @Override
    public void checkOut() throws Exception {
        if (this.cvsCheckOutDirectory.exists()) {
            RecurciveSearchFile.deleteAllTree(this.cvsCheckOutDirectory, false);
        } else {
            this.cvsCheckOutDirectory.mkdirs();
        }
        this.checkOutInternal(this.getRepository(null, null, null), this.cvsCheckOutDirectory, true);
    }

    @Override
    public String[] getScenarioGroupIds() throws Exception {
        this.update(this.getRepository(null, null, null), this.testResourceDirectory);
        return super.getScenarioGroupIds();
    }

    @Override
    public String[] getScenarioIds(String groupId) throws Exception {
        this.update(this.getRepository(groupId, null, null), new File(this.testResourceDirectory, groupId));
        return super.getScenarioIds(groupId);
    }

    @Override
    public String[] getTestCaseIds(String groupId, String scenarioId) throws Exception {
        this.update(this.getRepository(groupId, scenarioId, null), new File(this.testResourceDirectory, groupId + FILE_SEPARATOR + scenarioId));
        return super.getTestCaseIds(groupId, scenarioId);
    }

    @Override
    public String[] getStubIds(String groupId, String scenarioId, String testcaseId) throws Exception {
        this.update(this.getRepository(groupId, scenarioId, testcaseId), new File(this.testResourceDirectory, groupId + FILE_SEPARATOR + scenarioId + FILE_SEPARATOR + testcaseId));
        return super.getStubIds(groupId, scenarioId, testcaseId);
    }

    @Override
    public void downloadScenarioGroupResource(File dir, String groupId) throws Exception {
        this.update(this.getRepository(groupId, null, null), new File(this.testResourceDirectory, groupId));
        super.downloadScenarioGroupResource(dir, groupId);
    }

    @Override
    public void downloadScenarioResource(File dir, String groupId, String scenarioId) throws Exception {
        this.update(this.getRepository(groupId, scenarioId, null), new File(this.testResourceDirectory, groupId + FILE_SEPARATOR + scenarioId));
        super.downloadScenarioResource(dir, groupId, scenarioId);
    }

    protected ScmRepository getRepository(String scenarioGroupId, String scenarioId, String testcaseId) throws ScmRepositoryException, NoSuchScmProviderException {
        StringBuffer scmUrlBuff = new StringBuffer();
        scmUrlBuff.append("scm:cvs:");
        if ("ext".equals(this.method) || "lserver".equals(this.method)) {
            if (this.serverName == null) {
                throw new IllegalArgumentException("ServerName must be specified.");
            }
            scmUrlBuff.append(this.method + ":");
            if (this.userName != null) {
                scmUrlBuff.append(this.userName + "@");
            }
            scmUrlBuff.append(this.serverName);
            if (this.port != -1) {
                scmUrlBuff.append(":" + this.port);
            }
            scmUrlBuff.append(":" + this.repositoryPath + ":" + this.modulePath);
        } else if ("local".equals(this.method)) {
            scmUrlBuff.append(this.method + ":" + this.repositoryPath + ":" + this.modulePath);
        } else if ("pserver".equals(this.method)) {
            if (this.serverName == null) {
                throw new IllegalArgumentException("ServerName must be specified.");
            }
            scmUrlBuff.append(this.method + ":");
            if (this.userName != null) {
                scmUrlBuff.append(this.userName);
                if (this.password != null) {
                    scmUrlBuff.append(":" + this.userName);
                }
                scmUrlBuff.append("@");
            }
            scmUrlBuff.append(this.serverName);
            if (this.port != -1) {
                scmUrlBuff.append(":" + this.port);
            }
            scmUrlBuff.append(":" + this.repositoryPath + ":" + this.modulePath);
        } else if ("sspi".equals(this.method)) {
            if (this.serverName == null) {
                throw new IllegalArgumentException("ServerName must be specified.");
            }
            scmUrlBuff.append(this.method + ":");
            if (this.userName != null) {
                scmUrlBuff.append(this.userName + "@");
            }
            scmUrlBuff.append(this.serverName + ":" + this.repositoryPath + ":" + this.modulePath);
        }
        if (scenarioGroupId != null) {
            scmUrlBuff.append("/" + scenarioGroupId);
            if (scenarioId != null) {
                scmUrlBuff.append("/" + scenarioId);
                if (testcaseId != null) {
                    scmUrlBuff.append("/" + testcaseId);
                }
            }
        }
        return this.manager.makeScmRepository(scmUrlBuff.toString());
    }

    protected void update(ScmRepository repository, File updateDir) throws Exception {
        UpdateScmResult result = null;
        result = this.branch != null ? this.manager.update(repository, new ScmFileSet(updateDir), this.branch) : (this.tag != null ? this.manager.update(repository, new ScmFileSet(updateDir), this.tag) : this.manager.update(repository, new ScmFileSet(updateDir)));
        if (result == null) {
            throw new Exception("CVS UpdateScmResult is null.");
        }
        if (!result.isSuccess()) {
            throw new Exception("CVS UpdateScmResult is failed. CommandOutput=" + result.getCommandOutput() + " ProviderMessage=" + result.getProviderMessage());
        }
    }

    protected void checkOutInternal(ScmRepository repository, File checkOutDir, boolean isRecursive) throws Exception {
        CheckOutScmResult result = null;
        result = this.branch != null ? this.manager.checkOut(repository, new ScmFileSet(checkOutDir), this.branch, isRecursive) : (this.tag != null ? this.manager.checkOut(repository, new ScmFileSet(checkOutDir), this.tag, isRecursive) : this.manager.checkOut(repository, new ScmFileSet(checkOutDir), isRecursive));
        if (result == null) {
            throw new Exception("CVS CheckOutScmResult is null.");
        }
        if (!result.isSuccess()) {
            throw new Exception("CVS CheckOutScmResult is failed. CommandOutput=" + result.getCommandOutput() + " ProviderMessage=" + result.getProviderMessage());
        }
    }

    public class CustomLog
    extends DefaultLog {
        public boolean isDebugEnabled() {
            return CVSTestResourceManagerService.this.isDebugEnabled;
        }

        public boolean isInfoEnabled() {
            return CVSTestResourceManagerService.this.isInfoEnabled;
        }

        public boolean isWarnEnabled() {
            return CVSTestResourceManagerService.this.isWarnEnabled;
        }

        public boolean isErrorEnabled() {
            return CVSTestResourceManagerService.this.isErrorEnabled;
        }
    }

    public class CustomScmManager
    extends BasicScmManager {
        protected ScmLogger getScmLogger() {
            return new CustomLog();
        }
    }
}

