/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import jp.ossc.nimbus.service.test.swing.StatusDialogView;
import jp.ossc.nimbus.service.test.swing.TestCaseControlListener;
import jp.ossc.nimbus.service.test.swing.TestCaseListPanel;
import jp.ossc.nimbus.service.test.swing.TestErrorStatusDispButton;

public class ScenarioTestView
extends JFrame
implements ActionListener,
ComponentListener {
    private Dimension MINIMUM_SIZE = new Dimension(1150, 700);
    private String userId = null;
    private JButton updateButton = null;
    private JButton resetButton = null;
    private JComboBox scenarioGroupCombobox = null;
    private JButton scenarioGroupStartButton = null;
    private JButton scenarioGroupEndButton = null;
    private JLabel statusLabel = null;
    private JLabel statusLabel2 = null;
    private JComboBox scenarioCombobox = null;
    private JButton scenarioStartButton = null;
    private JButton scenarioEndButton = null;
    private JButton scenarioCancelButton = null;
    private JButton scenarioDownloadButton = null;
    private TestCaseListPanel testCasePanel = null;
    private JScrollPane testCaseScrollPanel = null;
    private TestController testController = null;
    private File cashDlDir = null;
    private TestErrorStatusDispButton scenarioGroupStatusButton = null;
    private TestErrorStatusDispButton scenarioStatusButton = null;

    public ScenarioTestView(TestController testController, String userId) throws Exception {
        this.testController = testController;
        this.userId = userId;
        this.initialize();
    }

    private void initialize() throws Exception {
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, this.MINIMUM_SIZE.width, this.MINIMUM_SIZE.height);
        Font font = new Font("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 1, 16);
        JPanel p = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        p.setLayout(layout);
        this.getContentPane().add((Component)p, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JLabel label1 = new JLabel("\u30e6\u30fc\u30b6ID \uff1a " + this.userId);
        label1.setFont(font);
        label1.setHorizontalTextPosition(2);
        label1.setVerticalTextPosition(1);
        layout.setConstraints(label1, constraints);
        p.add(label1);
        constraints.gridx = 5;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.updateButton = new JButton("\u30b9\u30c6\u30fc\u30bf\u30b9\u66f4\u65b0");
        this.updateButton.setFont(font);
        this.updateButton.addActionListener(this);
        this.updateButton.setSize(150, 25);
        layout.setConstraints(this.updateButton, constraints);
        p.add(this.updateButton);
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.resetButton = new JButton("\u30ea\u30bd\u30fc\u30b9\u6700\u65b0\u5316");
        this.resetButton.setFont(font);
        this.resetButton.addActionListener(this);
        this.resetButton.setSize(150, 25);
        layout.setConstraints(this.resetButton, constraints);
        p.add(this.resetButton);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 5, 5, 5);
        this.statusLabel = new JLabel("\u5b9f\u884c\u72b6\u614b");
        this.statusLabel.setFont(font);
        layout.setConstraints(this.statusLabel, constraints);
        p.add(this.statusLabel);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 5;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 5, 5, 5);
        this.statusLabel2 = new JLabel();
        this.statusLabel2.setFont(font);
        layout.setConstraints(this.statusLabel2, constraints);
        p.add(this.statusLabel2);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JLabel label2 = new JLabel("\u30b7\u30ca\u30ea\u30aa\u30b0\u30eb\u30fc\u30d7");
        label2.setFont(font);
        label2.setHorizontalTextPosition(2);
        label2.setVerticalTextPosition(1);
        layout.setConstraints(label2, constraints);
        p.add(label2);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioGroupCombobox = new JComboBox();
        this.scenarioGroupCombobox.setFont(font);
        this.scenarioGroupCombobox.addActionListener(this);
        layout.setConstraints(this.scenarioGroupCombobox, constraints);
        p.add(this.scenarioGroupCombobox);
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 5, 5, 5);
        this.scenarioGroupStatusButton = new TestErrorStatusDispButton(this);
        layout.setConstraints(this.scenarioGroupStatusButton, constraints);
        p.add(this.scenarioGroupStatusButton);
        constraints.gridx = 3;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioGroupStartButton = new JButton("\u958b\u59cb");
        this.scenarioGroupStartButton.setFont(font);
        this.scenarioGroupStartButton.addActionListener(this);
        this.scenarioGroupStartButton.setSize(150, 25);
        layout.setConstraints(this.scenarioGroupStartButton, constraints);
        p.add(this.scenarioGroupStartButton);
        constraints.gridx = 4;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioGroupEndButton = new JButton("\u7d42\u4e86");
        this.scenarioGroupEndButton.setFont(font);
        this.scenarioGroupEndButton.addActionListener(this);
        this.scenarioGroupEndButton.setSize(150, 25);
        layout.setConstraints(this.scenarioGroupEndButton, constraints);
        p.add(this.scenarioGroupEndButton);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JLabel label3 = new JLabel("\u30b7\u30ca\u30ea\u30aa");
        label3.setFont(font);
        label3.setHorizontalTextPosition(2);
        label3.setVerticalTextPosition(1);
        layout.setConstraints(label3, constraints);
        p.add(label3);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioCombobox = new JComboBox();
        this.scenarioCombobox.setFont(font);
        this.scenarioCombobox.addActionListener(this);
        layout.setConstraints(this.scenarioCombobox, constraints);
        p.add(this.scenarioCombobox);
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 5, 5, 5);
        this.scenarioStatusButton = new TestErrorStatusDispButton(this);
        layout.setConstraints(this.scenarioStatusButton, constraints);
        p.add(this.scenarioStatusButton);
        constraints.gridx = 3;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioStartButton = new JButton("\u958b\u59cb");
        this.scenarioStartButton.setFont(font);
        this.scenarioStartButton.addActionListener(this);
        layout.setConstraints(this.scenarioStartButton, constraints);
        p.add(this.scenarioStartButton);
        constraints.gridx = 4;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioEndButton = new JButton("\u7d42\u4e86");
        this.scenarioEndButton.setFont(font);
        this.scenarioEndButton.addActionListener(this);
        layout.setConstraints(this.scenarioEndButton, constraints);
        p.add(this.scenarioEndButton);
        constraints.gridx = 5;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioCancelButton = new JButton("\uff77\uff6c\uff9d\uff7e\uff99");
        this.scenarioCancelButton.setFont(font);
        this.scenarioCancelButton.addActionListener(this);
        layout.setConstraints(this.scenarioCancelButton, constraints);
        p.add(this.scenarioCancelButton);
        constraints.gridx = 6;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.scenarioDownloadButton = new JButton("\u7d50\u679cDL");
        this.scenarioDownloadButton.setFont(font);
        this.scenarioDownloadButton.addActionListener(this);
        layout.setConstraints(this.scenarioDownloadButton, constraints);
        p.add(this.scenarioDownloadButton);
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        JLabel label4 = new JLabel("\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9");
        label4.setFont(font);
        label4.setHorizontalTextPosition(2);
        label4.setVerticalTextPosition(1);
        label4.setHorizontalAlignment(2);
        label4.setVerticalAlignment(1);
        layout.setConstraints(label4, constraints);
        p.add(label4);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 6;
        constraints.gridheight = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.testCasePanel = new TestCaseListPanel(this);
        this.testCasePanel.setTestController(this.testController);
        JScrollPane scrollpane = new JScrollPane(this.testCasePanel, 22, 31);
        layout.setConstraints(scrollpane, constraints);
        p.add(scrollpane);
        this.testCaseScrollPanel = scrollpane;
        this.setupStatusLabel();
        this.updatehState();
        this.addComponentListener(this);
    }

    private void updatehState() throws Exception {
        TestScenarioGroup currentScenarioGroup = this.testController.getCurrentScenarioGroup();
        this.setupScenarioGroupCombobox(null);
        this.scenarioGroupCombobox.setEditable(true);
        this.scenarioCombobox.setEditable(true);
        if (currentScenarioGroup != null) {
            this.scenarioGroupCombobox.setSelectedItem(currentScenarioGroup.getScenarioGroupId());
            this.scenarioCombobox.setEnabled(true);
            this.scenarioStartButton.setEnabled(true);
            this.scenarioEndButton.setEnabled(false);
            this.scenarioCancelButton.setEnabled(false);
            this.scenarioDownloadButton.setEnabled(false);
            this.setupScenarioCombobox(null);
        }
        this.setupScenarioComponents();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block31: {
            try {
                if (e.getSource() == this.scenarioGroupStartButton) {
                    this.scenarioGroupStartAction();
                    break block31;
                }
                if (e.getSource() == this.scenarioGroupEndButton) {
                    this.scenarioGroupEndAction();
                    break block31;
                }
                if (e.getSource() == this.scenarioStartButton) {
                    try {
                        this.scenarioStartAction();
                        break block31;
                    }
                    catch (Exception eStart) {
                        try {
                            this.scenarioCancelAction();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        throw eStart;
                    }
                }
                if (e.getSource() == this.scenarioEndButton) {
                    try {
                        this.scenarioEndAction();
                        break block31;
                    }
                    catch (Exception eStart) {
                        try {
                            this.scenarioCancelAction();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        throw eStart;
                    }
                }
                if (e.getSource() == this.scenarioCancelButton) {
                    this.scenarioCancelAction();
                } else if (e.getSource() == this.scenarioDownloadButton) {
                    this.scenarioDownloadAction();
                } else if (e.getSource() == this.scenarioGroupCombobox) {
                    if ("comboBoxEdited".equals(e.getActionCommand())) {
                        this.scenarioGroupComboboxAction();
                    } else if ("comboBoxChanged".equals(e.getActionCommand())) {
                        // empty if block
                    }
                } else if (e.getSource() == this.scenarioCombobox) {
                    if ("comboBoxEdited".equals(e.getActionCommand())) {
                        this.scenarioComboboxEditedAction();
                    } else if ("comboBoxChanged".equals(e.getActionCommand())) {
                        this.scenarioComboboxChangeAction();
                    }
                } else if (e.getSource() == this.resetButton) {
                    this.testController.reset();
                } else if (e.getSource() == this.updateButton) {
                    this.setupStatusLabel();
                    this.updatehState();
                }
            }
            catch (Exception e1) {
                StatusDialogView dialog = new StatusDialogView((JFrame)this, "\u4f8b\u5916", e1);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
        }
    }

    private void scenarioGroupStartAction() throws Exception {
        int result;
        String selectScenarioGroupId = this.scenarioGroupCombobox.getSelectedItem().toString();
        TestScenarioGroup obj = this.testController.getCurrentScenarioGroup();
        if (obj != null && obj.getStatus() != null && obj.getStatus().getUserId() != null && 0 != (result = JOptionPane.showConfirmDialog(this, "\u30b7\u30ca\u30ea\u30aa\u30b0\u30eb\u30fc\u30d7\u306f\u65e2\u306b\u958b\u59cb\u3055\u308c\u3066\u3044\u307e\u3059\u304c\u3001\u30ea\u30bb\u30c3\u30c8\u3057\u3066\u518d\u5ea6\u958b\u59cb\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", 2))) {
            return;
        }
        this.testController.startScenarioGroup(this.userId, selectScenarioGroupId);
        this.scenarioCombobox.setEnabled(true);
        this.setupScenarioCombobox(null);
        this.setupScenarioComponents();
        this.testCasePanel.initialize();
    }

    private void scenarioGroupEndAction() throws Exception {
        this.testController.endScenarioGroup();
        this.scenarioCombobox.setEnabled(false);
        this.setupScenarioCombobox(null);
        this.setupScenarioComponents();
    }

    private void scenarioStartAction() throws Exception {
        String selectScenarioGroupId = this.scenarioGroupCombobox.getSelectedItem().toString();
        String selectScenarioId = this.scenarioCombobox.getSelectedItem().toString();
        this.testController.startScenario(this.userId, selectScenarioId);
        TestCase[] testCaseArray = this.testController.getTestCases(selectScenarioGroupId, selectScenarioId);
        ArrayList<TestCase> testCaseList = new ArrayList<TestCase>();
        for (int i = 0; i < testCaseArray.length; ++i) {
            testCaseList.add(testCaseArray[i]);
        }
        this.testCasePanel.initialize();
        this.testCasePanel.setScenarioGroupId(selectScenarioGroupId);
        this.testCasePanel.setScenarioId(selectScenarioId);
        this.testCasePanel.setTestCaseList(testCaseList);
        this.testCasePanel.addTestCaseControlListener(new TestCaseControlListenerImpl());
        this.testCasePanel.setUserId(this.userId);
        this.setupScenarioComponents();
    }

    private void scenarioEndAction() throws Exception {
        String selectScenarioId = this.scenarioCombobox.getSelectedItem().toString();
        this.testController.endScenario(selectScenarioId);
        this.testCasePanel.initialize();
        this.setupScenarioComponents();
    }

    private void scenarioCancelAction() throws Exception {
        String selectScenarioId = this.scenarioCombobox.getSelectedItem().toString();
        this.testController.cancelScenario(selectScenarioId);
        this.testCasePanel.initialize();
        this.setupScenarioComponents();
    }

    private void scenarioDownloadAction() throws Exception {
        File dlDir = this.showDownloadFileSaveDialog(this.cashDlDir);
        if (dlDir != null) {
            String scenarioGroup = this.testController.getCurrentScenarioGroup().getScenarioGroupId();
            String selectScenarioId = this.scenarioCombobox.getSelectedItem().toString();
            this.testController.downloadScenarioResult(dlDir, scenarioGroup, selectScenarioId, 1);
            JOptionPane.showMessageDialog(this, "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u300c" + dlDir + "\u300d\u306b\r\n\u6b63\u5e38\u306b\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
        }
        this.cashDlDir = dlDir;
        this.testCasePanel.initialize();
        this.setupScenarioComponents();
    }

    private File showDownloadFileSaveDialog(File cashDlDir) {
        JFileChooser filechooser = new JFileChooser(cashDlDir);
        filechooser.setFileSelectionMode(1);
        int selected = filechooser.showSaveDialog(this);
        if (selected == 0) {
            return filechooser.getSelectedFile();
        }
        return null;
    }

    private void scenarioGroupComboboxAction() throws Exception {
        Object selectObject = this.scenarioGroupCombobox.getSelectedItem();
        if (selectObject != null) {
            String tmpEditText = selectObject.toString();
            this.setupScenarioGroupCombobox(tmpEditText);
        }
    }

    private void scenarioComboboxEditedAction() throws Exception {
        Object selectObject = this.scenarioCombobox.getSelectedItem();
        if (selectObject != null) {
            String tmpEditText = selectObject.toString();
            this.setupScenarioCombobox(tmpEditText);
        }
        this.setupScenarioComponents();
    }

    private void scenarioComboboxChangeAction() throws Exception {
        this.setupScenarioComponents();
    }

    private void setupScenarioGroupCombobox(String keyword) throws Exception {
        this.scenarioGroupCombobox.removeAllItems();
        TestScenarioGroup[] testScenarioGroupArray = this.testController.getScenarioGroups();
        if (testScenarioGroupArray != null) {
            for (int i = 0; i < testScenarioGroupArray.length; ++i) {
                String scenarioGroupId = testScenarioGroupArray[i].getScenarioGroupId();
                if (keyword != null && keyword.length() != 0 && scenarioGroupId.indexOf(keyword) < 0) continue;
                this.scenarioGroupCombobox.addItem(scenarioGroupId);
            }
        }
    }

    private void setupScenarioCombobox(String keyword) throws Exception {
        this.scenarioCombobox.removeAllItems();
        TestScenarioGroup currentScenarioGroup = this.testController.getCurrentScenarioGroup();
        if (currentScenarioGroup == null) {
            this.scenarioCombobox.setEnabled(false);
            return;
        }
        this.scenarioCombobox.setEnabled(true);
        TestScenario[] testScenarioArray = this.testController.getScenarios(currentScenarioGroup.getScenarioGroupId());
        if (testScenarioArray != null) {
            for (int i = 0; i < testScenarioArray.length; ++i) {
                String scenarioId = testScenarioArray[i].getScenarioId();
                if (keyword == null || keyword.length() == 0 || scenarioId.indexOf(keyword) >= 0) {
                    this.scenarioCombobox.addItem(scenarioId);
                }
                if (testScenarioArray[i] == null || testScenarioArray[i].getStatus() == null || testScenarioArray[i].getStatus().getState() != 1) continue;
                String selectScenarioGroupId = currentScenarioGroup.getScenarioGroupId();
                String selectScenarioId = testScenarioArray[i].getScenarioId();
                TestCase[] testCaseArray = this.testController.getTestCases(selectScenarioGroupId, selectScenarioId);
                ArrayList<TestCase> testCaseList = new ArrayList<TestCase>();
                for (int t = 0; t < testCaseArray.length; ++t) {
                    testCaseList.add(testCaseArray[t]);
                }
                this.testCasePanel.initialize();
                this.testCasePanel.setScenarioGroupId(selectScenarioGroupId);
                this.testCasePanel.setScenarioId(selectScenarioId);
                this.testCasePanel.setTestCaseList(testCaseList);
                this.testCasePanel.addTestCaseControlListener(new TestCaseControlListenerImpl());
                this.testCasePanel.setUserId(this.userId);
            }
        }
    }

    private void setupStatusLabel() throws Exception {
        TestScenarioGroup group = this.testController.getCurrentScenarioGroup();
        TestScenario scenario = this.testController.getCurrentScenario();
        TestCase testcase = this.testController.getCurrentTestCase();
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
        if (group != null) {
            sb.append("ScenarioGroup=" + group.getScenarioGroupId());
            if (group.getStatus() != null) {
                sb.append("(" + group.getStatus().getUserId());
                if (group.getStatus().getStartTime() != null) {
                    sb.append(" " + sdf.format(group.getStatus().getStartTime()));
                }
                sb.append(")");
            }
            if (scenario != null) {
                sb.append(", Scenario=" + scenario.getScenarioId());
                if (scenario.getStatus() != null) {
                    sb.append("(" + scenario.getStatus().getUserId());
                    if (scenario.getStatus().getStartTime() != null) {
                        sb.append(" " + sdf.format(scenario.getStatus().getStartTime()));
                    }
                    sb.append(")");
                }
                if (testcase != null) {
                    sb.append(", Testcase=" + testcase.getTestCaseId());
                    if (testcase.getStatus() != null) {
                        sb.append("(" + testcase.getStatus().getUserId());
                        if (testcase.getStatus().getStartTime() != null) {
                            sb.append(" " + sdf.format(testcase.getStatus().getStartTime()));
                        }
                        sb.append(")");
                    }
                }
            }
        } else {
            sb.append("\u7121\u3057");
        }
        this.statusLabel2.setText(sb.toString());
        this.statusLabel2.setToolTipText(sb.toString());
    }

    private void setupScenarioComponents() throws Exception {
        TestScenarioGroup currentScenarioGroup = this.testController.getCurrentScenarioGroup();
        if (currentScenarioGroup == null) {
            this.scenarioGroupStartButton.setEnabled(true);
            this.scenarioGroupEndButton.setEnabled(false);
            this.scenarioCombobox.setEnabled(false);
            this.scenarioStartButton.setEnabled(false);
            this.scenarioEndButton.setEnabled(false);
            this.scenarioCancelButton.setEnabled(false);
            this.scenarioDownloadButton.setEnabled(false);
            return;
        }
        this.scenarioGroupStartButton.setEnabled(false);
        this.scenarioGroupEndButton.setEnabled(true);
        String currentScenarioGroupId = currentScenarioGroup.getScenarioGroupId();
        if (this.scenarioCombobox.getSelectedItem() == null) {
            return;
        }
        String selectScenarioId = this.scenarioCombobox.getSelectedItem().toString();
        TestScenario selectSenario = null;
        if (currentScenarioGroupId != null && selectScenarioId != null) {
            selectSenario = this.testController.getScenario(currentScenarioGroupId, selectScenarioId);
        }
        if (selectSenario == null) {
            return;
        }
        TestScenario.Status status = selectSenario.getStatus();
        this.scenarioStatusButton.change(status);
        if (status != null && status.getState() == 1) {
            this.scenarioCombobox.setEnabled(true);
            this.scenarioStartButton.setEnabled(false);
            this.scenarioEndButton.setEnabled(true);
            this.scenarioCancelButton.setEnabled(true);
            this.scenarioDownloadButton.setEnabled(false);
        } else if (status != null && status.getState() == 2) {
            this.scenarioCombobox.setEnabled(true);
            this.scenarioStartButton.setEnabled(true);
            this.scenarioEndButton.setEnabled(false);
            this.scenarioCancelButton.setEnabled(false);
            this.scenarioDownloadButton.setEnabled(true);
        } else if (status == null || status != null && (status.getState() == 0 || status.getState() == 3 || status.getState() == 4)) {
            this.scenarioCombobox.setEnabled(true);
            this.scenarioStartButton.setEnabled(true);
            this.scenarioEndButton.setEnabled(false);
            this.scenarioCancelButton.setEnabled(false);
            this.scenarioDownloadButton.setEnabled(false);
        } else {
            if (this.scenarioCombobox.getItemCount() == 0) {
                this.scenarioCombobox.setEnabled(false);
            } else {
                this.scenarioCombobox.setEnabled(true);
            }
            this.scenarioStartButton.setEnabled(false);
            this.scenarioEndButton.setEnabled(false);
            this.scenarioCancelButton.setEnabled(false);
            this.scenarioDownloadButton.setEnabled(false);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.MINIMUM_SIZE.width > this.getWidth() || this.MINIMUM_SIZE.height > this.getHeight()) {
            this.setSize(this.MINIMUM_SIZE);
            return;
        }
        if (this.testCasePanel.getWidth() > this.testCaseScrollPanel.getViewport().getWidth()) {
            int width = this.testCaseScrollPanel.getViewport().getWidth();
            int height = this.testCasePanel.getHeight();
            this.testCasePanel.setSize(width, height);
        }
        try {
            this.testCasePanel.resetup();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private class TestCaseControlListenerImpl
    implements TestCaseControlListener {
        private TestCaseControlListenerImpl() {
        }

        @Override
        public void startTestCase(TestCase testcase) throws Exception {
            ScenarioTestView.this.setupScenarioComponents();
        }

        @Override
        public void endTestCase(TestCase testcase) throws Exception {
            ScenarioTestView.this.setupScenarioComponents();
        }
    }
}

