/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.swing;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.swing.StatusDialogView;
import jp.ossc.nimbus.service.test.swing.TestCaseControlListener;
import jp.ossc.nimbus.service.test.swing.TestErrorStatusDispButton;

public class TestCaseListPanel
extends JPanel {
    private final int MARGIN = 8;
    private final int HEIGHT = 30;
    private final int NO_WIDTH = 50;
    private int ID_WIDTH = 150;
    private int TITLE_WIDTH = 150;
    private final int START_DATE_WIDTH = 150;
    private final int END_DATE_WIDTH = 150;
    private final int STATE_WIDTH = 65;
    private final int START_BUTTON_WIDTH = 70;
    private final int END_BUTTON_WIDTH = 70;
    private final int DOWNLOAD_BUTTON_WIDTH = 90;
    private String userId = null;
    private TestController testController = null;
    private String scenarioGroupId = null;
    private String scenarioId = null;
    private List testCaseList = new ArrayList();
    private File cashDlDir = null;
    private List testCaseControlListenerList = null;
    private JFrame ownerFrame = null;
    private List lineList = null;

    public TestCaseListPanel(JFrame ownerFrame) throws Exception {
        this.ownerFrame = ownerFrame;
        this.initialize();
    }

    public void initialize() throws Exception {
        this.testCaseList = null;
        this.setupTestCaseCompornents();
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTestController(TestController testController) {
        this.testController = testController;
    }

    public void setScenarioGroupId(String scenarioGroupId) {
        this.scenarioGroupId = scenarioGroupId;
    }

    public void setScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
    }

    public void setTestCaseList(List testCaseList) throws Exception {
        this.testCaseList = testCaseList;
        this.setupTestCaseCompornents();
        this.testCaseControlListenerList = new ArrayList();
    }

    public void resetup() throws Exception {
        this.setupTestCaseCompornents();
    }

    public void addTestCaseControlListener(TestCaseControlListener testCaseControlListener) {
        this.testCaseControlListenerList.add(testCaseControlListener);
    }

    private void setupTestCaseCompornents() throws Exception {
        int ROW_SPACE = 10;
        Font font = new Font("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 1, 16);
        int tmpX = 0;
        int tmpY = 0;
        String DATE_PATTERN = "yyyy/MM/dd HH:mm";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
        this.removeAll();
        this.setLayout(null);
        int winWidth = this.getWidth();
        this.ID_WIDTH = ROW_SPACE = (winWidth - 726) / 2;
        this.TITLE_WIDTH = ROW_SPACE;
        JLabel label1 = new JLabel("No");
        JLabel label2 = new JLabel("\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9ID");
        JLabel label3 = new JLabel("\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u540d");
        JLabel label4 = new JLabel("\u958b\u59cb\u65e5\u6642");
        JLabel label5 = new JLabel("\u7d42\u4e86\u65e5\u6642");
        JLabel label6 = new JLabel("\uff74\uff97\uff70\u72b6\u614b");
        JLabel label7 = new JLabel("\u72b6\u614b");
        JLabel label8 = new JLabel("\u3000");
        JLabel label9 = new JLabel("\u3000");
        JLabel label10 = new JLabel("\u3000");
        label1.setFont(font);
        label2.setFont(font);
        label3.setFont(font);
        label4.setFont(font);
        label5.setFont(font);
        label6.setFont(font);
        label7.setFont(font);
        label8.setFont(font);
        label9.setFont(font);
        label10.setFont(font);
        label1.setBounds(tmpX += 8, tmpY += 8, 50, 30);
        label2.setBounds(tmpX += 50, tmpY, this.ID_WIDTH, 30);
        label3.setBounds(tmpX += this.ID_WIDTH, tmpY, this.TITLE_WIDTH, 30);
        label4.setBounds(tmpX += this.TITLE_WIDTH, tmpY, 150, 30);
        label5.setBounds(tmpX += 150, tmpY, 150, 30);
        label6.setBounds(tmpX += 150, tmpY, 65, 30);
        label7.setBounds(tmpX += 65, tmpY, 65, 30);
        label8.setBounds(tmpX += 65, tmpY, 70, 30);
        label9.setBounds(tmpX += 70, tmpY, 70, 30);
        label10.setBounds(tmpX += 70, tmpY, 90, 30);
        this.add(label1);
        this.add(label2);
        this.add(label3);
        this.add(label4);
        this.add(label5);
        this.add(label6);
        this.add(label7);
        this.add(label8);
        this.add(label9);
        if (this.testCaseList != null) {
            boolean startTestCaseFlg = false;
            this.lineList = new ArrayList();
            for (int i = 0; i < this.testCaseList.size(); ++i) {
                tmpX = 8;
                tmpY += 38;
                TestCase testCase = (TestCase)this.testCaseList.get(i);
                label1 = new JLabel(new Integer(i + 1).toString());
                label2 = new JLabel(testCase.getTestCaseId());
                label2.setToolTipText(testCase.getTestCaseId());
                label3 = new JLabel(testCase.getTestCaseResource().getTitle());
                label3.setToolTipText(testCase.getTestCaseResource().getTitle());
                label4 = new JLabel("");
                label5 = new JLabel("");
                label6 = new JLabel("");
                TestErrorStatusDispButton tmpErrorStatusButton = new TestErrorStatusDispButton(this.ownerFrame);
                TestCase.Status status = null;
                try {
                    status = testCase.getStatus();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                label1.setFont(font);
                label2.setFont(font);
                label3.setFont(font);
                label4.setFont(font);
                label5.setFont(font);
                label6.setFont(font);
                Point xLinePoint = new Point(tmpX, tmpY - 4);
                label1.setBounds(tmpX, tmpY, 50, 30);
                label2.setBounds(tmpX += 50, tmpY, this.ID_WIDTH, 30);
                label3.setBounds(tmpX += this.ID_WIDTH, tmpY, this.TITLE_WIDTH, 30);
                label4.setBounds(tmpX += this.TITLE_WIDTH, tmpY, 150, 30);
                label5.setBounds(tmpX += 150, tmpY, 150, 30);
                tmpErrorStatusButton.setBounds(tmpX += 150, tmpY, 65, 30);
                label6.setBounds(tmpX += 65, tmpY, 65, 30);
                Point yLinePoint = new Point(tmpX += 65, tmpY - 4);
                this.lineList.add(new Line(xLinePoint, yLinePoint));
                if (status != null) {
                    if (status.getStartTime() != null) {
                        label4.setText(dateFormat.format(status.getStartTime()));
                    }
                    if (status.getEndTime() != null) {
                        label5.setText(dateFormat.format(status.getEndTime()));
                    }
                    label6.setText(status.getStateString());
                }
                tmpErrorStatusButton.change(status);
                JButton tmpButton1 = new JButton("\u958b\u59cb");
                tmpButton1.addActionListener(new StartButtonActionListener(testCase));
                JButton tmpButton2 = new JButton("\u7d42\u4e86");
                tmpButton2.addActionListener(new EndButtonActionListener(testCase));
                JButton tmpButton3 = new JButton("\u7d50\u679cDL");
                tmpButton3.addActionListener(new DownloadButtonActionListener(testCase));
                if (status != null && status.getState() == 1) {
                    tmpButton1.setEnabled(false);
                    tmpButton2.setEnabled(true);
                    tmpButton3.setEnabled(false);
                    startTestCaseFlg = true;
                } else if (!(status == null || status.getState() != 4 && status.getResult())) {
                    try {
                        this.testController.cancelTestCase(this.scenarioId, testCase.getTestCaseId());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    tmpButton1.setEnabled(true);
                    tmpButton2.setEnabled(false);
                    tmpButton3.setEnabled(true);
                } else {
                    if (!startTestCaseFlg) {
                        tmpButton1.setEnabled(true);
                    } else {
                        tmpButton1.setEnabled(false);
                    }
                    tmpButton2.setEnabled(false);
                    tmpButton3.setEnabled(false);
                }
                tmpButton1.setFont(font);
                tmpButton2.setFont(font);
                tmpButton3.setFont(font);
                tmpButton1.setBounds(tmpX, tmpY, 70, 30);
                tmpButton2.setBounds(tmpX += 70, tmpY, 70, 30);
                tmpButton3.setBounds(tmpX += 70, tmpY, 90, 30);
                this.add(label1);
                this.add(label2);
                this.add(label3);
                this.add(label4);
                this.add(label5);
                this.add(tmpErrorStatusButton);
                this.add(label6);
                this.add(tmpButton1);
                this.add(tmpButton2);
                this.add(tmpButton3);
            }
        }
        int tmpW = winWidth;
        int tmpH = tmpY + 30 + 8;
        this.setPreferredSize(new Dimension(tmpW, tmpH));
        this.repaint();
    }

    private File showDownloadFileSaveDialog(File cashDlDir) {
        JFileChooser filechooser = new JFileChooser(cashDlDir);
        filechooser.setFileSelectionMode(1);
        int selected = filechooser.showSaveDialog(this);
        if (selected == 0) {
            return filechooser.getSelectedFile();
        }
        return null;
    }

    private void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        float[] dash = new float[]{1.0f, 1.0f};
        BasicStroke dsahStroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
        ((Graphics2D)g).setStroke(dsahStroke);
        if (this.lineList != null) {
            for (int i = 0; i < this.lineList.size(); ++i) {
                Line tmpLine = (Line)this.lineList.get(i);
                if (tmpLine == null || tmpLine.getStartPoint() == null || tmpLine.getEndPoint() == null) continue;
                g.drawLine((int)tmpLine.getStartPoint().getX(), (int)tmpLine.getStartPoint().getY(), (int)tmpLine.getEndPoint().getX(), (int)tmpLine.getEndPoint().getY());
            }
        }
    }

    private class Line {
        private Point startPoint = null;
        private Point endPoint = null;

        public Line(Point startPoint, Point endPoint) {
            this.startPoint = startPoint;
            this.endPoint = endPoint;
        }

        public Point getStartPoint() {
            return this.startPoint;
        }

        public void setStartPoint(Point startPoint) {
            this.startPoint = startPoint;
        }

        public Point getEndPoint() {
            return this.endPoint;
        }

        public void setEndPoint(Point endPoint) {
            this.endPoint = endPoint;
        }
    }

    private class DownloadButtonActionListener
    implements ActionListener {
        private TestCase testCase = null;

        public DownloadButtonActionListener(TestCase testCase) {
            this.testCase = testCase;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File dlDir = TestCaseListPanel.this.showDownloadFileSaveDialog(TestCaseListPanel.this.cashDlDir);
                if (dlDir != null) {
                    TestCaseListPanel.this.testController.downloadTestCaseResult(dlDir, TestCaseListPanel.this.scenarioGroupId, TestCaseListPanel.this.scenarioId, this.testCase.getTestCaseId(), 1);
                    TestCaseListPanel.this.showMessageDialog("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u300c" + dlDir + "\u300d\u306b\r\n\u6b63\u5e38\u306b\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                }
                TestCaseListPanel.this.cashDlDir = dlDir;
                TestCaseListPanel.this.setupTestCaseCompornents();
            }
            catch (Exception e1) {
                StatusDialogView dialog = new StatusDialogView(TestCaseListPanel.this.ownerFrame, "Exception", e1);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
        }
    }

    private class EndButtonActionListener
    implements ActionListener {
        private TestCase testCase = null;

        public EndButtonActionListener(TestCase testCase) {
            this.testCase = testCase;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TestCaseListPanel.this.testController.endTestCase(TestCaseListPanel.this.scenarioId, this.testCase.getTestCaseId());
                for (int i = 0; i < TestCaseListPanel.this.testCaseControlListenerList.size(); ++i) {
                    ((TestCaseControlListener)TestCaseListPanel.this.testCaseControlListenerList.get(i)).endTestCase(this.testCase);
                }
            }
            catch (Exception e1) {
                try {
                    TestCaseListPanel.this.testController.cancelTestCase(TestCaseListPanel.this.scenarioId, this.testCase.getTestCaseId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StatusDialogView dialog = new StatusDialogView(TestCaseListPanel.this.ownerFrame, "Exception", e1);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
            try {
                TestCaseListPanel.this.setupTestCaseCompornents();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private class StartButtonActionListener
    implements ActionListener {
        private TestCase testCase = null;

        public StartButtonActionListener(TestCase testCase) {
            this.testCase = testCase;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TestCaseListPanel.this.testController.startTestCase(TestCaseListPanel.this.userId, TestCaseListPanel.this.scenarioId, this.testCase.getTestCaseId());
                TestCase.Status state = TestCaseListPanel.this.testController.getTestCase(TestCaseListPanel.this.scenarioGroupId, TestCaseListPanel.this.scenarioId, this.testCase.getTestCaseId()).getStatus();
                if (!state.getResult()) {
                    TestCaseListPanel.this.testController.cancelTestCase(TestCaseListPanel.this.scenarioId, this.testCase.getTestCaseId());
                }
                for (int i = 0; i < TestCaseListPanel.this.testCaseControlListenerList.size(); ++i) {
                    ((TestCaseControlListener)TestCaseListPanel.this.testCaseControlListenerList.get(i)).startTestCase(this.testCase);
                }
            }
            catch (Exception e1) {
                try {
                    TestCaseListPanel.this.testController.cancelTestCase(TestCaseListPanel.this.scenarioId, this.testCase.getTestCaseId());
                }
                catch (Exception i) {
                    // empty catch block
                }
                StatusDialogView dialog = new StatusDialogView(TestCaseListPanel.this.ownerFrame, "Exception", e1);
                dialog.setModal(true);
                dialog.setVisible(true);
            }
            try {
                TestCaseListPanel.this.setupTestCaseCompornents();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

