/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.swing.ScenarioTestView;
import jp.ossc.nimbus.service.test.swing.StatusDialogView;

public class UserIdInputView
extends JFrame
implements ActionListener,
KeyListener {
    private JTextField textBox = null;
    private JButton okButton = null;
    private boolean isWindowClosed;
    private List servicePaths;
    private TestController testController = null;

    public void setTestController(TestController testController) {
        this.testController = testController;
    }

    public UserIdInputView(List servicePaths) throws Exception {
        this.servicePaths = servicePaths;
        this.initialize();
    }

    public boolean isWindowClosed() {
        return this.isWindowClosed;
    }

    public synchronized void setWindowClosed(boolean isClosed) {
        this.isWindowClosed = isClosed;
        if (this.isWindowClosed) {
            if (this.servicePaths != null) {
                int i = this.servicePaths.size();
                while (--i >= 0) {
                    ServiceManagerFactory.unloadManager((String)this.servicePaths.get(i));
                }
            }
            this.notifyAll();
        }
    }

    private void initialize() throws Exception {
        Font font = new Font("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 1, 16);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        this.textBox = new JTextField(15);
        this.textBox.addKeyListener(this);
        String user = System.getProperty("user.name");
        if (user != null) {
            this.textBox.setText(user);
        }
        this.okButton = new JButton("OK");
        this.okButton.setFont(font);
        this.okButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UserIdInputView.this.setWindowClosed(true);
            }
        });
        JLabel label = new JLabel("\u30e6\u30fc\u30b6ID\uff1a");
        label.setFont(font);
        p.add(label);
        p.add(this.textBox);
        p.add(this.okButton);
        this.setTitle("\u30e6\u30fc\u30b6ID\u306e\u5165\u529b\u753b\u9762");
        this.setBounds(100, 100, 400, 200);
        this.setDefaultCloseOperation(3);
        this.getContentPane().add(Box.createVerticalStrut(50), "North");
        this.getContentPane().add((Component)p, "Center");
    }

    public static void main(String[] args) throws Exception {
        UserIdInputView view = new UserIdInputView(null);
        view.setVisible(true);
    }

    private void mainViewStartup() {
        this.setVisible(false);
        try {
            ScenarioTestView view = new ScenarioTestView(this.testController, this.textBox.getText());
            view.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    UserIdInputView.this.setWindowClosed(true);
                }
            });
            view.setVisible(true);
        }
        catch (Exception e1) {
            StatusDialogView dialog = new StatusDialogView((JFrame)this, "Exception", e1);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mainViewStartup();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.mainViewStartup();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

