/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.servlet.BeanFlowSelector;
import jp.ossc.nimbus.servlet.BeanFlowServletContext;
import jp.ossc.nimbus.servlet.DefaultBeanFlowSelectorService;

public class BeanFlowServlet
extends HttpServlet {
    private static final long serialVersionUID = -5548272719656324613L;
    public static final String INIT_PARAM_NAME_BEAN_FLOW_SELECTOR_SERVICE_NAME = "BeanFlowSelectorServiceName";
    public static final String INIT_PARAM_NAME_BEAN_FLOW_INVOKER_FACTORY_SERVICE_NAME = "BeanFlowInvokerFactoryServiceName";
    public static final String INIT_PARAM_NAME_JOURNAL_SERVICE_NAME = "JournalServiceName";
    public static final String INIT_PARAM_NAME_EDITOR_FINDER_SERVICE_NAME = "EditorFinderServiceName";
    public static final String INIT_PARAM_NAME_VALIDATE_EDITOR_FINDER_SERVICE_NAME = "ValidateEditorFinderServiceName";
    public static final String INIT_PARAM_NAME_ACTION_EDITOR_FINDER_SERVICE_NAME = "ActionEditorFinderServiceName";
    public static final String INIT_PARAM_NAME_CONTEXT_SERVICE_NAME = "ContextServiceName";
    public static final String INIT_PARAM_NAME_VALIDATE = "Validate";
    public static final String INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX = "ValidateFlowPrefix";
    public static final String INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME = "InputAttributeName";
    public static final String INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME = "OutputAttributeName";
    public static final String DEFAULT_VALIDATE_FLOW_PREFIX = "validate";
    public static final String JOURNAL_KEY_PROCESS = "Process";
    public static final String JOURNAL_KEY_FLOW_NAME = "FlowName";
    public static final String JOURNAL_KEY_VALIDATE = "Validate";
    public static final String JOURNAL_KEY_ACTION = "Action";
    public static final String JOURNAL_KEY_INPUT = "Input";
    public static final String JOURNAL_KEY_OUTPUT = "Output";
    public static final String JOURNAL_KEY_EXCEPTION = "Exception";
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected ServiceName beanFlowSelectorServiceName;
    protected ServiceName journalServiceName;
    protected ServiceName editorFinderServiceName;
    protected ServiceName validateEditorFinderServiceName;
    protected ServiceName actionEditorFinderServiceName;
    protected ServiceName contextServiceName;
    protected DefaultBeanFlowSelectorService defaultBeanFlowSelector;
    protected boolean isValidate;
    protected String validateFlowPrefix = "validate";
    protected String inputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String outputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;

    public void init() throws ServletException {
        String outputName;
        String inputName;
        this.beanFlowInvokerFactoryServiceName = this.getBeanFlowInvokerFactoryServiceName();
        if (this.beanFlowInvokerFactoryServiceName == null) {
            throw new ServletException("BeanFlowInvokerFactoryServiceName is null.");
        }
        this.beanFlowSelectorServiceName = this.getBeanFlowSelectorServiceName();
        if (this.beanFlowSelectorServiceName == null) {
            this.defaultBeanFlowSelector = new DefaultBeanFlowSelectorService();
            try {
                this.defaultBeanFlowSelector.create();
                this.defaultBeanFlowSelector.start();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        this.journalServiceName = this.getJournalServiceName();
        this.editorFinderServiceName = this.getEditorFinderServiceName();
        this.validateEditorFinderServiceName = this.getValidateEditorFinderServiceName();
        this.actionEditorFinderServiceName = this.getActionEditorFinderServiceName();
        this.contextServiceName = this.getContextServiceName();
        this.isValidate = this.isValidate();
        String prefix = this.getValidateFlowPrefix();
        if (prefix != null && prefix.length() != 0) {
            this.validateFlowPrefix = prefix;
        }
        if ((inputName = this.getInputAttributeName()) != null) {
            this.inputAttributeName = inputName;
        }
        if ((outputName = this.getOutputAttributeName()) != null) {
            this.outputAttributeName = outputName;
        }
    }

    protected ServiceName getBeanFlowSelectorServiceName() {
        return this.getServiceName(INIT_PARAM_NAME_BEAN_FLOW_SELECTOR_SERVICE_NAME);
    }

    protected ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.getServiceName(INIT_PARAM_NAME_BEAN_FLOW_INVOKER_FACTORY_SERVICE_NAME);
    }

    protected ServiceName getJournalServiceName() {
        return this.getServiceName(INIT_PARAM_NAME_JOURNAL_SERVICE_NAME);
    }

    protected ServiceName getEditorFinderServiceName() {
        return this.getServiceName(INIT_PARAM_NAME_EDITOR_FINDER_SERVICE_NAME);
    }

    protected ServiceName getValidateEditorFinderServiceName() {
        return this.getServiceName(INIT_PARAM_NAME_VALIDATE_EDITOR_FINDER_SERVICE_NAME);
    }

    protected ServiceName getActionEditorFinderServiceName() {
        return this.getServiceName(INIT_PARAM_NAME_ACTION_EDITOR_FINDER_SERVICE_NAME);
    }

    protected ServiceName getContextServiceName() {
        return this.getServiceName(INIT_PARAM_NAME_CONTEXT_SERVICE_NAME);
    }

    protected ServiceName getServiceName(String paramName) {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(paramName);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    protected boolean isValidate() {
        ServletConfig config = this.getServletConfig();
        String isValidateStr = config.getInitParameter("Validate");
        return isValidateStr == null ? false : Boolean.valueOf(isValidateStr);
    }

    protected String getValidateFlowPrefix() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX);
    }

    protected String getInputAttributeName() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME);
    }

    protected String getOutputAttributeName() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object context;
        String flowName = this.processSelectBeanFlow(req, resp);
        if (flowName == null || flowName.length() == 0) {
            this.handleNotFound(req, resp, flowName);
            return;
        }
        BeanFlowInvokerFactory beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        if (!beanFlowInvokerFactory.containsFlow(flowName)) {
            this.handleNotFound(req, resp, flowName);
            return;
        }
        Journal journal = null;
        EditorFinder editorFinder = null;
        EditorFinder validateEditorFinder = null;
        EditorFinder actionEditorFinder = null;
        String requestId = null;
        if (this.journalServiceName != null) {
            journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
            if (this.editorFinderServiceName != null) {
                editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
            }
            if (this.validateEditorFinderServiceName != null) {
                validateEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.validateEditorFinderServiceName);
            }
            if (this.actionEditorFinderServiceName != null) {
                actionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.actionEditorFinderServiceName);
            }
            if (this.contextServiceName != null) {
                context = (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
                requestId = (String)context.get("REQUEST_ID");
            }
        }
        try {
            String validateFlowName;
            if (journal != null) {
                journal.startJournal(JOURNAL_KEY_PROCESS, editorFinder);
                if (requestId != null) {
                    journal.setRequestId(requestId);
                }
            }
            context = new BeanFlowServletContext(req, resp, req.getAttribute(this.inputAttributeName));
            if (this.validateFlowPrefix != null && this.isValidate && beanFlowInvokerFactory.containsFlow(validateFlowName = this.validateFlowPrefix + flowName)) {
                BeanFlowInvoker validateFlow = beanFlowInvokerFactory.createFlow(validateFlowName);
                try {
                    if (journal != null) {
                        journal.addStartStep("Validate", validateEditorFinder);
                        journal.addInfo(JOURNAL_KEY_FLOW_NAME, validateFlowName);
                    }
                    if (!this.processValidate(req, resp, (BeanFlowServletContext)context, validateFlow, journal) && !this.handleValidateError(req, resp, (BeanFlowServletContext)context, journal)) {
                        return;
                    }
                }
                finally {
                    if (journal != null) {
                        journal.addEndStep();
                    }
                }
            }
            BeanFlowInvoker flow = beanFlowInvokerFactory.createFlow(flowName);
            try {
                if (journal != null) {
                    journal.addStartStep(JOURNAL_KEY_ACTION, actionEditorFinder);
                    journal.addInfo(JOURNAL_KEY_FLOW_NAME, flowName);
                }
                this.processAction(req, resp, (BeanFlowServletContext)context, flow, journal);
            }
            finally {
                if (journal != null) {
                    journal.addEndStep();
                }
            }
        }
        finally {
            if (journal != null) {
                journal.endJournal();
            }
        }
    }

    protected String processSelectBeanFlow(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BeanFlowSelector beanFlowSelector = this.defaultBeanFlowSelector;
        if (this.beanFlowSelectorServiceName != null) {
            beanFlowSelector = (BeanFlowSelector)ServiceManagerFactory.getServiceObject(this.beanFlowSelectorServiceName);
        }
        return beanFlowSelector.selectBeanFlow(req);
    }

    protected void handleNotFound(HttpServletRequest req, HttpServletResponse resp, String flowName) throws ServletException, IOException {
        resp.sendError(404, "Flow '" + flowName + "' is not found.");
    }

    protected boolean processValidate(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, BeanFlowInvoker validateFlow, Journal journal) throws ServletException, IOException {
        try {
            if (journal != null) {
                journal.addInfo(JOURNAL_KEY_INPUT, context);
            }
            Object ret = validateFlow.invokeFlow(context);
            if (journal != null) {
                journal.addInfo(JOURNAL_KEY_OUTPUT, ret);
            }
            boolean result = false;
            if (ret != null && ret instanceof Boolean) {
                result = (Boolean)ret;
            }
            if (!result && context.getOutput() != null) {
                req.setAttribute(this.outputAttributeName, context.getOutput());
            }
            return result;
        }
        catch (Exception e) {
            return this.handleValidateException(req, resp, context, journal, e);
        }
    }

    protected boolean handleValidateException(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, Journal journal, Exception e) throws ServletException, IOException {
        if (journal != null) {
            journal.addInfo(JOURNAL_KEY_EXCEPTION, e);
        }
        throw new ServletException("Validate error.", (Throwable)e);
    }

    protected boolean handleValidateError(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, Journal journal) throws ServletException, IOException {
        return false;
    }

    protected void processAction(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, BeanFlowInvoker flow, Journal journal) throws ServletException, IOException {
        try {
            if (journal != null) {
                journal.addInfo(JOURNAL_KEY_INPUT, context);
            }
            Object ret = flow.invokeFlow(context);
            if (journal != null) {
                journal.addInfo(JOURNAL_KEY_OUTPUT, ret);
            }
            if (context.getOutput() == null) {
                if (ret != null) {
                    req.setAttribute(this.outputAttributeName, ret);
                }
            } else {
                req.setAttribute(this.outputAttributeName, context.getOutput());
            }
        }
        catch (Exception e) {
            this.handleActionException(req, resp, context, journal, e);
        }
    }

    protected boolean handleActionException(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, Journal journal, Exception e) throws ServletException, IOException {
        if (journal != null) {
            journal.addInfo(JOURNAL_KEY_EXCEPTION, e);
        }
        throw new ServletException("Flow error.", (Throwable)e);
    }
}

