/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import jp.ossc.nimbus.util.converter.CharacterConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public abstract class AbstractCharacterConverter
implements CharacterConverter,
StringConverter,
ReversibleConverter,
Serializable {
    private static final long serialVersionUID = -4403134705436532180L;
    protected int convertType;
    protected int from;
    protected int to;

    public AbstractCharacterConverter() {
        this(1);
    }

    public AbstractCharacterConverter(int type) {
        this.setConvertType(type);
    }

    @Override
    public void setConvertType(int type) {
        this.convertType = type;
        switch (this.convertType) {
            case 1: {
                this.from = 0;
                this.to = 1;
                break;
            }
            case 2: {
                this.from = 1;
                this.to = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid convert type : " + type);
            }
        }
    }

    public int getConvertType() {
        return this.convertType;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Character) {
            return this.convert((Character)obj);
        }
        if (obj instanceof String) {
            return this.convert((String)obj);
        }
        return obj;
    }

    @Override
    public String convert(String str) throws ConvertException {
        char[] chars = str.toCharArray();
        char[] result = null;
        boolean isConvert = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = this.convert(chars[i]);
            if (c != chars[i] && !isConvert) {
                result = new char[chars.length];
                System.arraycopy(chars, 0, result, 0, i);
                isConvert = true;
            }
            if (!isConvert) continue;
            result[i] = c;
        }
        return isConvert ? new String(result) : str;
    }

    @Override
    public Character convert(Character c) throws ConvertException {
        Character result = c;
        result = this.convertChars(result);
        return result;
    }

    @Override
    public char convert(char c) throws ConvertException {
        char result = c;
        result = this.convertChars(result);
        return result;
    }

    protected Character convertChars(Character c) throws ConvertException {
        char result = this.convertChars(c.charValue());
        if (result == c.charValue()) {
            return c;
        }
        return new Character(result);
    }

    protected char convertChars(char c) throws ConvertException {
        char result = c;
        char[][] convertChars = this.getConvertChars();
        if (convertChars != null) {
            for (int i = 0; i < convertChars.length; ++i) {
                if (c != convertChars[i][this.from]) continue;
                result = convertChars[i][this.to];
            }
        }
        return result;
    }

    protected abstract char[][] getConvertChars();
}

