/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.util.ClassMappingTree;
import jp.ossc.nimbus.util.converter.BindingConverter;
import jp.ossc.nimbus.util.converter.ConvertException;

public class BeanExchangeConverter
implements BindingConverter {
    private Object output;
    private Map propertyMapping;
    private PropertyAccess propertyAccess = new PropertyAccess();
    private boolean isCloneOutput = false;
    private boolean isFieldOnly = false;
    private boolean isAccessorOnly = true;
    private ClassMappingTree propertyAccessTypeMap;
    private boolean isMakeSchema;

    public BeanExchangeConverter() {
    }

    public BeanExchangeConverter(Map mapping) {
        this.setPropertyMappings(mapping);
    }

    public BeanExchangeConverter(Map mapping, Object output) {
        this.setPropertyMappings(mapping);
        this.setOutputObject(output);
    }

    public void setOutputObject(Object obj) {
        this.output = obj;
    }

    public Object getOutputObject() {
        return this.output;
    }

    public void setPropertyMapping(String inputProperty, String outputProperty) {
        Object outProp;
        if (this.propertyMapping == null) {
            this.propertyMapping = new HashMap();
        }
        if ((outProp = this.propertyMapping.get(inputProperty)) == null) {
            this.propertyMapping.put(inputProperty, outputProperty);
        } else {
            ArrayList<Object> outProps = null;
            if (outProp instanceof String) {
                outProps = new ArrayList<Object>();
                outProps.add(outProp);
            } else {
                outProps = (ArrayList<Object>)outProp;
            }
            outProps.add(outputProperty);
        }
    }

    public Object getPropertyMapping(String inputProperty) {
        if (this.propertyMapping == null) {
            return null;
        }
        return this.propertyMapping.get(inputProperty);
    }

    public void setPropertyMappings(Map mapping) {
        this.propertyMapping = mapping;
    }

    public Map getPropertyMappings() {
        return this.propertyMapping;
    }

    public void setCloneOutput(boolean isClone) {
        this.isCloneOutput = isClone;
    }

    public boolean isCloneOutput() {
        return this.isCloneOutput;
    }

    public boolean isFieldOnly() {
        return this.isFieldOnly;
    }

    public void setFieldOnly(boolean isFieldOnly) {
        this.isFieldOnly = isFieldOnly;
    }

    public boolean isFieldOnly(Class type) {
        PropertyAccessType pat = this.propertyAccessTypeMap == null ? null : (PropertyAccessType)this.propertyAccessTypeMap.getValue(type);
        return pat == null ? this.isFieldOnly : pat.isFieldOnly;
    }

    public void setFieldOnly(Class type, boolean isFieldOnly) {
        PropertyAccessType pat;
        if (this.propertyAccessTypeMap == null) {
            this.propertyAccessTypeMap = new ClassMappingTree();
        }
        if ((pat = (PropertyAccessType)this.propertyAccessTypeMap.getValueOf(type)) == null) {
            pat = new PropertyAccessType();
            this.propertyAccessTypeMap.add(type, pat);
        }
        pat.isFieldOnly = isFieldOnly;
    }

    public void setDisabledPropertyNames(Class type, String[] names) {
        PropertyAccessType pat;
        if (this.propertyAccessTypeMap == null) {
            this.propertyAccessTypeMap = new ClassMappingTree();
        }
        if ((pat = (PropertyAccessType)this.propertyAccessTypeMap.getValueOf(type)) == null) {
            pat = new PropertyAccessType();
            this.propertyAccessTypeMap.add(type, pat);
        }
        if (names == null || names.length == 0) {
            pat.disabledPropertyNames = null;
        } else {
            if (pat.disabledPropertyNames == null) {
                pat.disabledPropertyNames = new HashSet();
            } else {
                pat.disabledPropertyNames.clear();
            }
            for (int i = 0; i < names.length; ++i) {
                pat.disabledPropertyNames.add(names[i]);
            }
        }
    }

    public void setEnabledPropertyNames(Class type, String[] names) {
        PropertyAccessType pat;
        if (this.propertyAccessTypeMap == null) {
            this.propertyAccessTypeMap = new ClassMappingTree();
        }
        if ((pat = (PropertyAccessType)this.propertyAccessTypeMap.getValueOf(type)) == null) {
            pat = new PropertyAccessType();
            this.propertyAccessTypeMap.add(type, pat);
        }
        if (names == null || names.length == 0) {
            pat.enabledPropertyNames = null;
        } else {
            if (pat.enabledPropertyNames == null) {
                pat.enabledPropertyNames = new HashSet();
            } else {
                pat.enabledPropertyNames.clear();
            }
            for (int i = 0; i < names.length; ++i) {
                pat.enabledPropertyNames.add(names[i]);
            }
        }
    }

    public boolean isEnabledPropertyName(Class type, String name) {
        PropertyAccessType pat;
        PropertyAccessType propertyAccessType = pat = this.propertyAccessTypeMap == null ? null : (PropertyAccessType)this.propertyAccessTypeMap.getValue(type);
        if (pat == null) {
            return true;
        }
        if (pat.disabledPropertyNames != null && pat.disabledPropertyNames.contains(name)) {
            return false;
        }
        if (pat.enabledPropertyNames != null) {
            return pat.enabledPropertyNames.contains(name);
        }
        return true;
    }

    public boolean isAccessorOnly() {
        return this.isAccessorOnly;
    }

    public void setAccessorOnly(boolean isAccessorOnly) {
        this.isAccessorOnly = isAccessorOnly;
    }

    public boolean isAccessorOnly(Class type) {
        PropertyAccessType pat = this.propertyAccessTypeMap == null ? null : (PropertyAccessType)this.propertyAccessTypeMap.getValue(type);
        return pat == null ? this.isAccessorOnly : pat.isAccessorOnly;
    }

    public void setAccessorOnly(Class type, boolean isAccessorOnly) {
        PropertyAccessType pat;
        if (this.propertyAccessTypeMap == null) {
            this.propertyAccessTypeMap = new ClassMappingTree();
        }
        if ((pat = (PropertyAccessType)this.propertyAccessTypeMap.getValueOf(type)) == null) {
            pat = new PropertyAccessType();
            this.propertyAccessTypeMap.add(type, pat);
        }
        pat.isAccessorOnly = isAccessorOnly;
    }

    public boolean isMakeSchema() {
        return this.isMakeSchema;
    }

    public void setMakeSchema(boolean isMake) {
        this.isMakeSchema = isMake;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        return this.convert(obj, this.output);
    }

    @Override
    public Object convert(Object input, Object output) throws ConvertException {
        return this.convert(input, output, this.isCloneOutput);
    }

    private Object convert(Object input, Object output, boolean isClone) throws ConvertException {
        Object outputProp;
        if (output == null) {
            throw new ConvertException("Output is null.");
        }
        if (isClone) {
            if (!(output instanceof Cloneable)) {
                throw new ConvertException("Output is not cloneable.");
            }
            if (output instanceof DataSet) {
                output = ((DataSet)output).cloneSchema();
            } else if (output instanceof RecordList) {
                output = ((RecordList)output).cloneSchema();
            } else if (output instanceof Record) {
                output = ((Record)output).cloneSchema();
            } else {
                try {
                    output = output.getClass().getMethod("clone", null).invoke(output, (Object[])null);
                }
                catch (NoSuchMethodException e) {
                    throw new ConvertException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ConvertException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ConvertException(e);
                }
            }
        }
        if (input == null) {
            return output;
        }
        Object[] inputs = null;
        if (input instanceof Collection) {
            inputs = ((Collection)input).toArray();
        } else if (input.getClass().isArray()) {
            inputs = (Object[])input;
        }
        if (inputs != null) {
            if (inputs.length == 0) {
                return output;
            }
            if (output instanceof RecordList) {
                RecordList list = (RecordList)output;
                for (int i = 0; i < inputs.length; ++i) {
                    Record record = list.createRecord();
                    list.add(this.convert(inputs[i], record, false));
                }
                return list;
            }
            if (output instanceof Collection) {
                Object[] outputs = ((Collection)output).toArray();
                if (outputs.length == 0) {
                    throw new ConvertException("Size of collection is 0.");
                }
                int imax = Math.min(inputs.length, outputs.length);
                for (int i = 0; i < imax; ++i) {
                    outputs[i] = this.convert(inputs[i], outputs[i], false);
                }
                return outputs;
            }
            if (output.getClass().isArray()) {
                int i;
                Object[] outputs = (Object[])output;
                Class<?> componentType = output.getClass().getComponentType();
                if (outputs.length == 0) {
                    if (componentType.isInterface() || componentType.isPrimitive()) {
                        throw new ConvertException("Length of array is 0.");
                    }
                    outputs = (Object[])Array.newInstance(componentType, inputs.length);
                    try {
                        for (i = 0; i < outputs.length; ++i) {
                            outputs[i] = componentType.newInstance();
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new ConvertException("Length of array is 0.", e);
                    }
                    catch (InstantiationException e) {
                        throw new ConvertException("Length of array is 0.", e);
                    }
                }
                int imax = Math.min(inputs.length, outputs.length);
                for (i = 0; i < imax; ++i) {
                    if (outputs[i] == null) {
                        if (componentType.isInterface() || componentType.isPrimitive()) {
                            throw new ConvertException("Element of array is null.");
                        }
                        try {
                            outputs[i] = componentType.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            throw new ConvertException("Element of array is null.", e);
                        }
                        catch (InstantiationException e) {
                            throw new ConvertException("Element of array is null.", e);
                        }
                    }
                    outputs[i] = this.convert(inputs[i], outputs[i], false);
                }
                return outputs;
            }
        }
        HashMap<String, String> propMapping = this.propertyMapping;
        boolean isOutputAutoMapping = false;
        boolean isInputAutoMapping = false;
        if (propMapping == null || propMapping.size() == 0) {
            SimpleProperty[] props;
            int i;
            int imax;
            Record record;
            if (propMapping == null) {
                propMapping = new HashMap<String, String>();
            }
            if (output instanceof Record) {
                record = (Record)output;
                RecordSchema schema = record.getRecordSchema();
                if (schema != null) {
                    imax = schema.getPropertySize();
                    for (i = 0; i < imax; ++i) {
                        propMapping.put(schema.getPropertyName(i), schema.getPropertyName(i));
                    }
                }
                if (propMapping.size() != 0) {
                    isOutputAutoMapping = true;
                }
            } else {
                props = this.isFieldOnly(output.getClass()) ? SimpleProperty.getFieldProperties(output) : SimpleProperty.getProperties(output, !this.isAccessorOnly(output.getClass()));
                for (int i2 = 0; i2 < props.length; ++i2) {
                    if (!this.isEnabledPropertyName(output.getClass(), props[i2].getPropertyName()) || !props[i2].isWritable(output.getClass())) continue;
                    propMapping.put(props[i2].getPropertyName(), props[i2].getPropertyName());
                }
                if (propMapping.size() != 0) {
                    isOutputAutoMapping = true;
                }
            }
            if (!isOutputAutoMapping) {
                if (input instanceof Record) {
                    record = (Record)input;
                    RecordSchema schema = record.getRecordSchema();
                    if (schema != null) {
                        imax = schema.getPropertySize();
                        for (i = 0; i < imax; ++i) {
                            propMapping.put(schema.getPropertyName(i), schema.getPropertyName(i));
                        }
                    }
                    if (propMapping.size() != 0) {
                        isInputAutoMapping = true;
                    }
                } else {
                    props = this.isFieldOnly(output.getClass()) ? SimpleProperty.getFieldProperties(input) : SimpleProperty.getProperties(input, !this.isAccessorOnly(output.getClass()));
                    for (int i3 = 0; i3 < props.length; ++i3) {
                        if (!this.isEnabledPropertyName(output.getClass(), props[i3].getPropertyName()) || !props[i3].isReadable(input.getClass())) continue;
                        propMapping.put(props[i3].getPropertyName(), props[i3].getPropertyName());
                    }
                    if (propMapping.size() != 0) {
                        isInputAutoMapping = true;
                    }
                }
            }
            if (propMapping.size() == 0) {
                throw new ConvertException("PropertyMapping is null.");
            }
        }
        if (this.isMakeSchema && output instanceof Record && ((Record)output).getRecordSchema() == null) {
            StringBuffer buf = new StringBuffer();
            for (Map.Entry entry : propMapping.entrySet()) {
                String inputProp = (String)entry.getKey();
                outputProp = entry.getValue();
                try {
                    Property prop = this.propertyAccess.getProperty(inputProp);
                    Class propType = prop.getPropertyType(input);
                    if (outputProp instanceof String) {
                        buf.append(':').append(outputProp);
                        buf.append(',').append(propType.getName()).append('\n');
                        continue;
                    }
                    List outputProps = (List)outputProp;
                    int imax = outputProps.size();
                    for (int i = 0; i < imax; ++i) {
                        buf.append(':').append((String)outputProps.get(i));
                        buf.append(',').append(propType.getName()).append('\n');
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ConvertException("Input property parse error. property=" + inputProp, e);
                }
                catch (NoSuchPropertyException e) {
                    if (isOutputAutoMapping) continue;
                    throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
                }
                catch (InvocationTargetException e) {
                    throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
                }
            }
            if (buf.length() != 0) {
                try {
                    ((Record)output).setSchema(buf.toString());
                }
                catch (PropertySchemaDefineException entry) {
                    // empty catch block
                }
            }
        }
        for (Map.Entry entry : propMapping.entrySet()) {
            String inputProp = (String)entry.getKey();
            Object value = null;
            try {
                value = this.propertyAccess.get(input, inputProp);
            }
            catch (IllegalArgumentException e) {
                throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
            }
            catch (NoSuchPropertyException e) {
                if (isOutputAutoMapping) continue;
                throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
            }
            catch (InvocationTargetException e) {
                throw new ConvertException("Input property get error. input=" + input + ", property=" + inputProp, e);
            }
            outputProp = entry.getValue();
            if (outputProp instanceof String) {
                try {
                    this.propertyAccess.set(output, (String)outputProp, value);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
                }
                catch (NoSuchPropertyException e) {
                    if (isInputAutoMapping) continue;
                    throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
                }
                catch (InvocationTargetException e) {
                    throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
                }
            }
            List outputProps = (List)outputProp;
            try {
                int imax = outputProps.size();
                for (int i = 0; i < imax; ++i) {
                    this.propertyAccess.set(output, (String)outputProps.get(i), value);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
            }
            catch (NoSuchPropertyException e) {
                if (isInputAutoMapping) continue;
                throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
            }
            catch (InvocationTargetException e) {
                throw new ConvertException("Output property set error. output=" + output + ", property=" + outputProp + ", value=" + value, e);
            }
        }
        return output;
    }

    private class PropertyAccessType {
        public boolean isFieldOnly = false;
        public boolean isAccessorOnly = true;
        public Set disabledPropertyNames;
        public Set enabledPropertyNames;

        private PropertyAccessType() {
        }
    }
}

