﻿////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//
//	danmaq Nineball-Library
//		Copyright (c) 2008-2013 danmaq all rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

using System.Collections.Generic;
using danmaq.nineball.data.input;
using danmaq.nineball.entity.input;
using Microsoft.Xna.Framework;

namespace danmaq.nineball.state.input
{

	//* ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ *
	/// <summary>高位入力制御・管理クラス コレクションの状態。</summary>
	public sealed class CStateAdapterInput
		: CState<CInputAdapterAdapter, CInputAdapterAdapter.CPrivateMembers>
	{

		//* ─────＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿_*
		//* constants ──────────────────────────────-*

		/// <summary>クラス オブジェクト。</summary>
		public static readonly
			IState<CInputAdapterAdapter, CInputAdapterAdapter.CPrivateMembers> instance =
				new CStateAdapterInput();

		//* ────────────-＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿*
		//* constructor & destructor ───────────────────────*

		//* -----------------------------------------------------------------------*
		/// <summary>コンストラクタ。</summary>
		private CStateAdapterInput()
		{
		}

		//* ────＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿_*
		//* methods ───────────────────────────────-*

		//* -----------------------------------------------------------------------*
		/// <summary>
		/// <para>状態が開始された時に呼び出されます。</para>
		/// <para>このメソッドは、遷移元の<c>teardown</c>よりも後に呼び出されます。</para>
		/// </summary>
		/// 
		/// <param name="entity">この状態を適用されたオブジェクト。</param>
		/// <param name="privateMembers">
		/// オブジェクトと状態クラスのみがアクセス可能なフィールド。
		/// </param>
		public override void setup(
			CInputAdapterAdapter entity, CInputAdapterAdapter.CPrivateMembers privateMembers)
		{
		}

		//* -----------------------------------------------------------------------*
		/// <summary>1フレーム分の更新処理を実行します。</summary>
		/// 
		/// <param name="entity">この状態を適用されているオブジェクト。</param>
		/// <param name="privateMembers">
		/// オブジェクトと状態クラスのみがアクセス可能なフィールド。
		/// </param>
		/// <param name="gameTime">前フレームが開始してからの経過時間。</param>
		public override void update(CInputAdapterAdapter entity,
			CInputAdapterAdapter.CPrivateMembers privateMembers, GameTime gameTime)
		{
			IList<IInputAdapter> lower = entity.lowerInput;
			IList<int> assigns = entity.assignList;
			List<SInputInfo> btns = privateMembers.buttonList;
			int lLength = lower.Count;
			for (int j = lLength; --j >= 0; lower[j].update(gameTime))
				;
			for (int i = assigns.Count; --i >= 0; )
			{
				int id = assigns[i];
				Vector3 velocity = Vector3.Zero;
				float vm = 0;
				for (int j = lLength; --j >= 0; )
				{
					SInputInfo src = lower[j].buttonList[id];
					velocity += src.velocity;
					vm = MathHelper.Max(vm, src.velocity.Length());
				}
				if (vm > 0)
				{
					velocity.Normalize();
				}
				btns[id] = btns[id].updateVelocity(velocity * vm);
			}
		}

		//* -----------------------------------------------------------------------*
		/// <summary>1フレーム分の描画処理を実行します。</summary>
		/// 
		/// <param name="entity">この状態を適用されているオブジェクト。</param>
		/// <param name="privateMembers">
		/// オブジェクトと状態クラスのみがアクセス可能なフィールド。
		/// </param>
		/// <param name="gameTime">前フレームが開始してからの経過時間。</param>
		public override void draw(CInputAdapterAdapter entity,
			CInputAdapterAdapter.CPrivateMembers privateMembers, GameTime gameTime)
		{
		}

		//* -----------------------------------------------------------------------*
		/// <summary>
		/// <para>オブジェクトが別の状態へ移行する時に呼び出されます。</para>
		/// <para>このメソッドは、遷移先の<c>setup</c>よりも先に呼び出されます。</para>
		/// </summary>
		/// 
		/// <param name="entity">この状態を終了したオブジェクト。</param>
		/// <param name="privateMembers">
		/// オブジェクトと状態クラスのみがアクセス可能なフィールド。
		/// </param>
		/// <param name="nextState">オブジェクトが次に適用する状態。</param>
		public override void teardown(CInputAdapterAdapter entity,
			CInputAdapterAdapter.CPrivateMembers privateMembers, IState nextState)
		{
		}
	}
}
