#include <QFile>
#include <QTextStream>
#include <QDateTime>
#include "a2BCfavoriteParser.h"
#include "a2BcConstants.h"

/*!
 *  RXgN^
 * 
 */
a2BCfavoriteParser::a2BCfavoriteParser(QWidget *parent) : QWidget(parent)
{

}

/*!
 *  fXgN^
 * 
 */
a2BCfavoriteParser::~a2BCfavoriteParser()
{

}

/*!
 *  t@C͂
 * 
 * 
 */
int a2BCfavoriteParser::parseIndexFile(const QString &arFileName)
{
    int count = 0;
    if (QFile::exists(arFileName) != true)
    {
        // t@C݂ȂꍇAȂ
        return (count);
    }

    QFile indexFile(arFileName);
    if (!indexFile.open(QIODevice::ReadOnly | QIODevice::Text))
    {
        return (count);
    }
    
    QTextStream in(&indexFile);
    while (!in.atEnd())
    {
        QString line = in.readLine();
        if (process_line(arFileName, line) == true)
        {
            count++;
        }
    }
    indexFile.close();

    return (count);
}

/*!
 * 
 * 
 */
bool a2BCfavoriteParser::process_line(const QString &arFileName, QString &arLineData)
{
    if (arLineData.isEmpty() == true)
    {
        return (false);
    }
 
    QString datFileName = arLineData.section(",", 0, 0);
    QString maxNumStr   = arLineData.section(",", 1, 1);
    QString curNumStr   = arLineData.section(",", 2, 2);
    QString statusStr   = arLineData.section(",", 3, 3);
    QString levelStr    = arLineData.section(",", 4, 4);
    QString dateTimeStr = arLineData.section(",", 5, 5);
    QString dummy2Str   = arLineData.section(",", 6, 6);
    QString dummy3Str   = arLineData.section(",", 7, 7);
    QString urlStr      = arLineData.section(",", 8, 8);
    QString nickStr     = arLineData.section(",", 9, 9);
    QString optionStr   = arLineData.section(",", 10);
    
    if (datFileName.contains(".dat") == false)
    {
        return (false);
    }

    mIndexFileName.append(arFileName);
    mDatFileName.append(datFileName);
    mNofMessage.append(maxNumStr.toInt());
    mCurrentMessage.append(curNumStr.toInt());
    mDatFileStatus.append(statusStr.toInt());
    mFavoriteLevel.append(levelStr.toInt());
    mLastUpdate.append(dateTimeStr.toULongLong());
    mDummy2.append(dummy2Str.toInt());
    mDummy3.append(dummy3Str.toInt());
    mUrlData.append(urlStr);
    mNickData.append(nickStr);
    mOptionData.append(optionStr);      
    mUsable.append(0);

    return (true);
}

/*!
 *
 * 
 */
void a2BCfavoriteParser::outputIndexFile(bool aRemoveError)
{
    QTextStream *out = 0;
    QFile *indexFile = 0;
    QString fileName = "";
    int limit = mIndexFileName.size();
    for (int index = 0; index < limit; index++)
    {
        quint64 updateTime = mLastUpdate[index];
        if (mIndexFileName[index] != fileName)
        {
            // t@CI[v...
            fileName = mIndexFileName[index];
            
            if (out != 0)
            {
                *out << ";[EOF]" << endl;
                out->flush();
                delete out;
                out = 0;
            }
            
            if (indexFile != 0)
            {
                indexFile->close();
                delete indexFile;
                indexFile = 0;
            }

            // Ât@CꍇAl[
            if (QFile::exists(fileName) == true)
            {
                QFile::remove(fileName + ".bak");
                QFile::rename(fileName, fileName + ".bak");
                QFile::remove(fileName);
            }
            indexFile = new QFile(fileName);
            if (!indexFile->open(QIODevice::WriteOnly | QIODevice::Text))
            {
                delete indexFile;
                indexFile = 0;
                fileName = "";
                continue;
            }
            out = new QTextStream(indexFile);
            if (out == 0)
            {
                delete indexFile;
                indexFile = 0;
                fileName = "";
                continue;
            }
            *out << "; FileName, Max, Current, Status, Level, lastAccess, 0, 0, Url, Nick, (Title)" << endl;
            if (aRemoveError == false)
            {
                (*out) << mDatFileName[index] << "," << mNofMessage[index] << "," << mCurrentMessage[index] << "," << mDatFileStatus[index] << "," << mFavoriteLevel[index] << "," << updateTime << "," << mDummy2[index] << "," << mDummy3[index] << "," << mUrlData[index] << "," << mNickData[index] << "," << mOptionData[index] << endl;
            }
            else
            {
                if ((mDatFileStatus[index] != A2BCSTATUS_GETERROR)&&(mUsable[index] > 0))
                {
                    (*out) << mDatFileName[index] << "," << mNofMessage[index] << "," << mCurrentMessage[index] << "," << mDatFileStatus[index] << "," << mFavoriteLevel[index] << "," << updateTime << "," << mDummy2[index] << "," << mDummy3[index] << "," << mUrlData[index] << "," << mNickData[index] << "," << mOptionData[index] << endl;
                }
            }
        }
        else
        {
            if (out != 0)
            {
                if (aRemoveError == false)
                {
                    (*out) << mDatFileName[index] << "," << mNofMessage[index] << "," << mCurrentMessage[index] << "," << mDatFileStatus[index] << "," << mFavoriteLevel[index] << "," << updateTime << "," << mDummy2[index] << "," << mDummy3[index] << "," << mUrlData[index] << "," << mNickData[index] << "," << mOptionData[index] << endl;
                }
                else
                {
                    if ((mDatFileStatus[index] != A2BCSTATUS_GETERROR)&&(mUsable[index] > 0))
                    {
                        (*out) << mDatFileName[index] << "," << mNofMessage[index] << "," << mCurrentMessage[index] << "," << mDatFileStatus[index] << "," << mFavoriteLevel[index] << "," << updateTime << "," << mDummy2[index] << "," << mDummy3[index] << "," << mUrlData[index] << "," << mNickData[index] << "," << mOptionData[index] << endl;
                    }
                }
            }
        }
    }
    if (out != 0)
    {
        *out << ";[EOF]" << endl;
        out->flush();
        delete out;
        out = 0;
    }
    if (indexFile != 0)
    {
           indexFile->close();
           delete indexFile;
           indexFile = 0;
    }
    clear();
    return;
}


/*!
 * 
 * 
 */
void a2BCfavoriteParser::clear()
{
    mIndexFileName.clear();
    mDatFileName.clear();
    mUrlData.clear();
    mNickData.clear();
    mOptionData.clear();
    
    mDatFileStatus.clear();
    mNofMessage.clear();
    mCurrentMessage.clear();
    mFavoriteLevel.clear();
    mLastUpdate.clear();
    mDummy2.clear();
    mDummy3.clear();
    mUsable.clear();
    return;
}

/*!
 * 
 * 
 * 
 */
QString a2BCfavoriteParser::getIndexFileName(int index)
{
    if ((index >= mIndexFileName.size())||(index < 0))
    {
        return ("");
    }
    return (mIndexFileName[index]);
}

/*!
 * 
 * 
 * 
 */
QString a2BCfavoriteParser::getFileName(int index)
{
    if ((index >= mDatFileName.size())||(index < 0))
    {
        return ("");
    }
    return (mDatFileName[index]);
}

/*!
 * 
 * 
 * 
 */
QString a2BCfavoriteParser::getOptionData(int index)
{
    if ((index >= mOptionData.size())||(index < 0))
    {
        return ("");
    }
    return (mOptionData[index]);
}

/*!
 * 
 * 
 * 
 */
int a2BCfavoriteParser::getNofMessage(int index)
{
    if ((index >= mNofMessage.size())||(index < 0))
    {
        return (0);
    }
    return (mNofMessage[index]);
}

/*!
 * 
 * 
 * 
 */
int a2BCfavoriteParser::getCurrentMessage(int index)
{
    if ((index >= mCurrentMessage.size())||(index < 0))
    {
        return (0);
    }
    return (mCurrentMessage[index]);
}

/*!
 * 
 * 
 * 
 */
quint64 a2BCfavoriteParser::getLastUpdate(int index)
{
    if ((index >= mLastUpdate.size())||(index < 0))
    {
        return (0);
    }
    return (mLastUpdate[index]);
}

/*!
 * 
 * 
 * 
 */
void a2BCfavoriteParser::setLastUpdate(int index)
{
    if ((index >= mLastUpdate.size())||(index < 0))
    {
        return;
    }
    QDateTime datetime = QDateTime::currentDateTime();
    quint64 currentTime = (quint64) datetime.toTime_t();
    currentTime = currentTime * 1000;
    mLastUpdate[index] = currentTime;
    return;
}


/*!
 * 
 * 
 * 
 */
int a2BCfavoriteParser::getFileStatus(int index)
{
    if ((index >= mDatFileStatus.size())||(index < 0))
    {
        return (0);
    }
    return (mDatFileStatus[index]);
}

/*!
 * 
 * 
 * 
 */
void a2BCfavoriteParser::setFileStatus(int index, int status)
{
    if ((index >= mDatFileStatus.size())||(index < 0))
    {
        return;
    }
    if (status == A2BCSTATUS_UNKNOWN)
    {
        if ((mDatFileStatus[index] != A2BCSTATUS_GETERROR)&&
            (mDatFileStatus[index] != A2BCSTATUS_NOTYET)&&
            (mDatFileStatus[index] != A2BCSTATUS_RESERVE))
        {
            // G[ȊO̎ɂ͏ԂXVȂ
            return;
        }
        status = A2BCSTATUS_NEW;
    }
    
    mDatFileStatus[index] = status;

    setLastUpdate(index);
    return;
}

/*!
 * 
 * 
 * 
 */
void a2BCfavoriteParser::setNofMessage(int index, int number)
{
    if ((index >= mNofMessage.size())||(index < 0))
    {
        return;
    }
    if (number <= 0)
    {
        number = 1;
    }
    if (number > 1000)
    {
        number = 1001;
    }    
    mNofMessage[index] = number;

    return;
}

/*!
 * 
 * 
 * 
 */
void a2BCfavoriteParser::setCurrentMessage(int index, int number)
{
    if ((index >= mCurrentMessage.size())||(index < 0))
    {
        return;
    }
    if (number <= 0)
    {
        number = 1;
    }
    if (number > 1000)
    {
        number = 1001;
    }    
    mCurrentMessage[index] = number;

    return;
}

/*!
 * 
 * 
 */
int a2BCfavoriteParser::exists(QString &arNick, QString &arDatFileName)
{
    int limit = mDatFileName.size();
    for (int index = 0; index < limit; index++)
    {
        if ((mDatFileName[index] == arDatFileName)&&(mNickData[index].contains(arNick) == true))
        {
            if (mUsable[index] < 0)
            {
                return (-10);
            }
            return (index);
        }
    }
    return (-1);
}

/*!
 * 
 * 
 */
void  a2BCfavoriteParser::updateUrl(const QString &arBoardNick, const QString &arBoardUrl)
{
    int limit = mNickData.size();
    for (int index = 0; index < limit; index++)
    {
        if (mNickData[index].contains(arBoardNick) == true)
        {
            mUrlData[index] = arBoardUrl;
        }
    }
    return;    
}

/*!
 * 
 * 
 * 
 */
void a2BCfavoriteParser::remove(int index)
{
    if ((index >= mUsable.size())||(index < 0))
    {
        return;
    }
    mUsable[index] = -1;

    return;
}

/*!
 * 
 * 
 * 
 */
void a2BCfavoriteParser::markIt(int index)
{
    if ((index >= mUsable.size())||(index < 0))
    {
        return;
    }
    mUsable[index] = 1;

    return;
}

/*!
 * 
 * 
 */
int a2BCfavoriteParser::count(void)
{
    return (mUsable.size());
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
